/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Person;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.changeanalysis.ComparisonResultsException;
import com.sas.wadmin.changeanalysis.ComparisonResultsModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ComparisonResultsTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(ComparisonResultsTableModel.class);
    private static final int VISIBLE_COLUMNS = 5;
    private static final int HIDDEN_COLUMNS = 1;
    public static final int NAME_COLUMN = 0;
    public static final int DATE_COLUMN = 1;
    public static final int OWNER_COLUMN = 2;
    public static final int RESULTS_COLUMN = 3;
    public static final int TARGET_COLUMN = 4;
    public static final int MODEL_COLUMN = 5;
    private static final int NAME_WIDTH = 100;
    private static final int DATE_WIDTH = 75;
    private static final int OWNER_WIDTH = 90;
    private static final int RESULTS_WIDTH = 90;
    private static final int TARGET_WIDTH = 90;
    private MdObjectStore m_store;

    public ComparisonResultsTableModel() {
        this.createColumnDefinitions();
    }

    private void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("ComparisonResultsTableModel.Name.txt"), 100, 32);
        this.m_aColumns[1] = new WsDateTableColumn(1, bundle.getString("ComparisonResultsTableModel.Date.txt"), 75);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("ComparisonResultsTableModel.Owner.txt"), 90);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("ComparisonResultsTableModel.Results.txt"), 90);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("ComparisonResultsTableModel.Target.txt"), 90);
        this.m_aColumns[5] = new WsMetadataTableColumn();
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.clear();
        try {
            if (this.m_store == null) {
                this.m_store = Workspace.getMdFactory().createObjectStore(null, "ComparisonResultsTreeModel");
            }
            try {
                String sCheckinRepositoryFQID = Workspace.getWorkspace().getCheckinRepository().getFQID();
                String sDefaultRepositoryFQID = Workspace.getWorkspace().getDefaultRepository().getFQID();
                ArrayList<String> lRepositoryFQIDs = new ArrayList<String>(2);
                lRepositoryFQIDs.add(sCheckinRepositoryFQID);
                if (!sCheckinRepositoryFQID.equals(sDefaultRepositoryFQID)) {
                    lRepositoryFQIDs.add(sDefaultRepositoryFQID);
                }
                StringBuffer sbOptions = new StringBuffer();
                sbOptions.append("<XMLSELECT Search=\"*[@TreeType='");
                sbOptions.append("ComparisonResult");
                sbOptions.append("']\"/>");
                int fFlags = 67109256;
                for (int iRepository = 0; iRepository < lRepositoryFQIDs.size(); ++iRepository) {
                    String sRepositoryFQID = (String)lRepositoryFQIDs.get(iRepository);
                    List lResults = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.m_store, sRepositoryFQID, "Tree", fFlags, sbOptions.toString());
                    for (int iResult = 0; iResult < lResults.size(); ++iResult) {
                        Tree mdoResult = (Tree)lResults.get(iResult);
                        List lValues = this.createRowValues(mdoResult, this.m_store);
                        this.insertRow(iResult - 1, lValues);
                    }
                }
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private List createRowValues(Tree mdoResult, MdObjectStore store) throws RemoteException {
        ArrayList<Object> lValues = new ArrayList<Object>();
        try {
            StringBuffer sbTemplate = new StringBuffer();
            sbTemplate.append("<Templates>");
            sbTemplate.append("<Tree><TimeStamps/><Members/><SubTrees/><ResponsibleParties/></Tree>");
            sbTemplate.append("<ResponsibleParty><Persons/></ResponsibleParty>");
            sbTemplate.append("</Templates>");
            int fFlags = 67109132;
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdoResult, null, null, sbTemplate.toString(), fFlags);
            lValues.add(mdoResult.getName());
            lValues.add(ComparisonResultsTableModel.createDate(mdoResult.getMetadataCreated()));
            String sOwner = "";
            AssociationList lParties = mdoResult.getResponsibleParties();
            for (int iParty = 0; iParty < lParties.size(); ++iParty) {
                AssociationList lPersons;
                ResponsibleParty mdoParty = (ResponsibleParty)lParties.get(iParty);
                String role = mdoParty.getRole();
                if (role == null || !role.equals("OWNER") || (lPersons = mdoParty.getPersons()).isEmpty()) continue;
                Person mdoPerson = (Person)lPersons.get(0);
                sOwner = mdoPerson.getName();
                break;
            }
            lValues.add(sOwner);
            String sResultsLibrary = "";
            String sTargetLibrary = "";
            AssociationList lSubTrees = mdoResult.getSubTrees();
            for (int iSubTree = 0; iSubTree < lSubTrees.size(); ++iSubTree) {
                Tree mdoTree = (Tree)lSubTrees.get(iSubTree);
                String sTreeType = mdoTree.getTreeType();
                AssociationList lMembers = mdoTree.getMembers();
                for (int iMember = 0; iMember < lMembers.size(); ++iMember) {
                    Root mdoMember = (Root)lMembers.get(iMember);
                    String sMemberType = mdoMember.getCMetadataType();
                    if (!sMemberType.equals("SASLibrary")) continue;
                    if (sTreeType.equals("CompResultLibrary")) {
                        sResultsLibrary = mdoMember.getName();
                    }
                    if (!sTreeType.equals("CompResultTarget")) continue;
                    sTargetLibrary = mdoMember.getName();
                }
            }
            lValues.add(sResultsLibrary);
            lValues.add(sTargetLibrary);
            ComparisonResultsModel mdl = new ComparisonResultsModel(mdoResult);
            lValues.add(mdl);
            mdl.populateStore();
            mdl.moveDataToModel();
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (ComparisonResultsException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        return lValues;
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public int getColumnCount() {
        return 5;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void dispose() throws RemoteException {
        for (int i = 0; i < this.getRowCount(); ++i) {
            ComparisonResultsModel mdl = (ComparisonResultsModel)this.getValueAt(i, 5);
            if (mdl == null) continue;
            if (mdl.getStore() != null) {
                mdl.getStore().dispose();
            }
            mdl.dispose();
        }
        if (this.m_store != null) {
            this.m_store.dispose();
        }
    }

    public MdObjectStore getStore() {
        return this.m_store;
    }

    private static Date createDate(String sSecondsSince1Jan1960) {
        return ComparisonResultsTableModel.createDate(Double.parseDouble(sSecondsSince1Jan1960));
    }

    private static Date createDate(double secondsSince1Jan1960) {
        double secondsSince1Jan1970 = secondsSince1Jan1960 - 3.156192E8;
        long millisecondsSince1Jan1970 = (long)(secondsSince1Jan1970 * 1000.0);
        return new Date(millisecondsSince1Jan1970);
    }
}

