/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.changeanalysis;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.impl.DatabaseSchemaImpl;
import com.sas.wadmin.changeanalysis.ComparisonResultsException;
import com.sas.wadmin.changeanalysis.ComparisonResultsModel;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServerCodeException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ComparisonResultsCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(ComparisonResultsModel.class);
    private SASCodeGeneration m_code = new SASCodeGeneration();
    private ComparisonResultsModel m_model;
    private String m_libref;
    private String m_libraryPath;
    private String m_guid;
    private StringBuffer m_qualifiedControlName;
    private StringBuffer m_qualifiedActivityName;
    protected static String ACTIVITY_LOG_TBL = "etls_activity_log";
    protected static String CONTROL_TBL = "etls_control";

    public ComparisonResultsCodegen(ComparisonResultsModel model) {
        this.m_model = model;
        this.m_libref = this.m_model.getLibraryReference();
        this.m_guid = this.m_model.getGUID();
        this.m_libraryPath = this.m_model.getLibraryPath();
        this.m_qualifiedControlName = new StringBuffer();
        this.m_qualifiedControlName.append(this.m_libref).append(".").append(CONTROL_TBL);
        this.m_qualifiedActivityName = new StringBuffer();
        this.m_qualifiedActivityName.append(this.m_libref).append(".").append(ACTIVITY_LOG_TBL);
    }

    protected String getMITableComparisonCode(boolean isRecompare) throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        this.m_code.clearSourceBuffer();
        this.genMacroVariables();
        this.genCreateControlTables();
        this.genControlMacroVariables(isRecompare);
        this.genInsertIntoControlTable();
        if (isRecompare) {
            this.genUpdateControlTable();
        }
        this.m_code.addSourceCode(this.getSetMacroVariables());
        this.genSourceXMLtoDatasets();
        this.genTargetToDatasets();
        this.m_code.addSourceCode(this.getComparisonCode());
        return this.m_code.getSource();
    }

    protected String getHouseKeepingCode(boolean isRecompare) throws MdException, RemoteException {
        this.m_code.clearSourceBuffer();
        this.genMacroVariables();
        this.genCreateControlTables();
        this.genControlMacroVariables(isRecompare);
        this.genInsertIntoControlTable();
        if (isRecompare) {
            this.genUpdateControlTable();
        }
        this.m_code.addSourceCode(this.getSetMacroVariables());
        return this.m_code.getSource();
    }

    protected String getSourceExtractCode() {
        this.m_code.clearSourceBuffer();
        this.genSourceXMLtoDatasets();
        return this.m_code.getSource();
    }

    protected String getTargetExtractCode() throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        this.m_code.clearSourceBuffer();
        this.genTargetToDatasets();
        return this.m_code.getSource();
    }

    protected void genMacroVariables() throws MdException, RemoteException {
        this.m_code.addSourceCode("\n\n").addSourceCode("Options replace mprint;\n\n").addSourceCode("%global etls_tblid;\n").addSourceCode("%let etls_tblid = -1;\n").addSourceCode("%global etls_vers;\n").addSourceCode("%let etls_vers = -1;\n").addSourceCode("%global etls_actKey;\n").addSourceCode("%let etls_actKey = -1;\n\n");
    }

    protected void genBegMacro() throws MdException, RemoteException {
        this.m_code.addSourceCode("%macro etls_ca;\n\n").indent();
    }

    protected void genEndMacro() {
        this.m_code.unIndent().addSourceCode("%mend etls_ca;\n\n").addSourceCode("%etls_ca;");
    }

    protected void genCreateControlTables() {
        this.m_code.addSourceCode("%macro createCtrlTbls();\n").indent().addSourceCode("%let etls_tableExist = -1;\n\n").addCommentLine(bundle.getString("ComparisonResultsCodegen.CreateTbls.txt")).addSourceCode("%let etls_tableExist = %sysfunc(exist(").addSourceCode(this.m_qualifiedControlName).addSourceCode(", DATA));\n\n").addSourceCode("%if &etls_tableExist = 0 %then\n").addSourceCode("%do;\n\n").indent().addSourceCode("data ").addSourceCode(this.m_qualifiedControlName).addSourceCode(";\n").indent().addSourceCode("attrib GUID length = $40 format = $40. informat = $40.;\n").addSourceCode("attrib Version length = 8;\n").addSourceCode("attrib TableId length = 8;\n").addSourceCode("attrib CurrInd length = 8;\n").addSourceCode("attrib Created length = 8 format = NLDATM30.;\n").addSourceCode("attrib LastUpdated length = 8 format = NLDATM30.;\n").addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n").genPercentPutStatement(bundle.getString("ComparisonResultsCodegen.CreateIndxs.sasmacro.notrans")).addSourceCode("\n\n").addSourceCode("proc datasets lib = ").addSourceCode(this.m_libref).addSourceCode(" nolist;\n").indent().addSourceCode("modify ").addSourceCode(CONTROL_TBL).addSourceCode(";\n").indent().addSourceCode("index create _PK0001_ = (GUID Version)\n").indent().addSourceCode(" / unique;\n").unIndent().unIndent().unIndent().addSourceCode("quit;\n\n").unIndent().addSourceCode("%end;\n\n").addSourceCode("%let etls_tableExist = %sysfunc(exist(").addSourceCode(this.m_qualifiedActivityName).addSourceCode(", DATA));\n\n").addSourceCode("%if &etls_tableExist = 0 %then\n").addSourceCode("%do;\n\n").indent().addSourceCode("data ").addSourceCode(this.m_qualifiedActivityName).addSourceCode(";\n").indent().addSourceCode("attrib Key length = 8;\n").addSourceCode("attrib GUID label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.GUID.Label.sasmacro.notrans")).addSourceCode("\" length = $40 format = $40. informat = $40.;\n").addSourceCode("attrib Activity label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.Activity.Label.sasmacro.notrans")).addSourceCode("\" length = $15 format = $15. informat = $15.;\n").addSourceCode("attrib Identifier label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.Identifier.Label.sasmacro.notrans")).addSourceCode("\" length = $17 format = $17. informat = $17.;\n ").addSourceCode("attrib Type label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.Type.Label.sasmacro.notrans")).addSourceCode("\" length = $18 format=$18. informat = $18.;\n").addSourceCode("attrib Name label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.Name.Label.sasmacro.notrans")).addSourceCode("\" length = $60 format=$60. informat = $60.;\n").addSourceCode("attrib Desc label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.Desc.Label.sasmacro.notrans")).addSourceCode("\" length = $60 format = $60. informat = $60.;\n").addSourceCode("attrib Parent_Id label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.Parent_Id.Label.sasmacro.notrans")).addSourceCode("\" length = $17 format = $17. informat = $17.;\n").addSourceCode("attrib Parent_Type label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.Parent_Type.Label.sasmacro.notrans")).addSourceCode("\" length = $18 format = $18. informat = $18.;\n").addSourceCode("attrib Parent_Name label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.Parent_Name.Label.sasmacro.notrans")).addSourceCode("\" length = $60 format=$60. informat=$60.;\n").addSourceCode("attrib PersonName label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.PersonName.Label.sasmacro.notrans")).addSourceCode("\" length = $60 format = $60. informat = $60.;\n").addSourceCode("attrib DateTimeStamp label = \"").addSourceCode(bundle.getString("ComparisonResultsCodegen.DateTimeStamp.Label.sasmacro.notrans")).addSourceCode("\" length = 8 format = NLDATM30.;\n").addSourceCode("stop;\n").unIndent().addSourceCode("run;\n\n").genPercentPutStatement(bundle.getString("ComparisonResultsCodegen.CreateIndxs.sasmacro.notrans")).addSourceCode("\n\n").addSourceCode("proc datasets lib = ").addSourceCode(this.m_libref).addSourceCode(" nolist;\n").indent().addSourceCode("modify ").addSourceCode(ACTIVITY_LOG_TBL).addSourceCode(";\n").indent().addSourceCode("index create Key / unique;\n").addSourceCode("index create GUID;\n").unIndent().unIndent().addSourceCode("quit;\n\n").unIndent().addSourceCode("%end;\n\n").unIndent().addSourceCode("%mend createCtrlTbls;\n").addSourceCode("%createCtrlTbls;\n\n");
    }

    protected void genControlMacroVariables(boolean isRecompare) {
        this.m_code.addCommentLine(bundle.getString("ComparisonResultsCodegen.GetNewTableIdentifier.txt")).addSourceCode("%macro initCtrlMacroVars();\n").indent().addSourceCode("proc sql noprint;\n").indent().addSourceCode("select value into :etls_tblid from\n ").indent();
        if (isRecompare && this.m_model.isRecompareOverwriteData()) {
            this.m_code.addSourceCode("(select tableid as value format=32.\n").indent().addSourceCode("from ").addSourceCode(this.m_qualifiedControlName).addSourceCode("\n").addSourceCode("where GUID = \"").addSourceCode(this.m_guid).addSourceCode("\"\n and CurrInd = 1);").unIndent();
        } else {
            this.m_code.addSourceCode("(select case\n ").indent().addSourceCode("when max(TableId) = . then 1\n").addSourceCode("else max(TableId)+1\n").unIndent().addSourceCode("end\n").addSourceCode("as value format=32.\n").addSourceCode("from ").addSourceCode(this.m_qualifiedControlName).addSourceCode(");\n");
        }
        this.m_code.unIndent().unIndent().addSourceCode("quit;\n\n").addSourceCode("%let etls_tblid = &etls_tblid;\n\n");
        this.m_code.unIndent().addCommentLine(bundle.getString("ComparisonResultsCodegen.GenNewVersIdentifier.txt")).addSourceCode("proc sql noprint;\n").indent().addSourceCode("select value into :etls_vers from\n").indent().addSourceCode("(select case \n").indent().addSourceCode("when max(Version) = . then 1\n").addSourceCode("else max(Version)+1\n").unIndent().addSourceCode("end as value format=32. from ").addSourceCode(this.m_qualifiedControlName).addSourceCode("\n").addSourceCode("where GUID = \"").addSourceCode(this.m_guid).addSourceCode("\");\n").unIndent().unIndent().addSourceCode("quit;\n\n").addSourceCode("%let etls_vers = &etls_vers;\n\n").unIndent().addSourceCode("%mend initCtrlMacroVars;\n").addSourceCode("%initCtrlMacroVars;\n\n");
    }

    protected void genInsertIntoControlTable() {
        this.m_code.addCommentLine(bundle.getString("ComparisonResultsCodegen.ContrlTblInsert.txt")).addSourceCode("%macro insertIntoCtrlTable();\n").indent().addSourceCode("proc sql;\n").indent().addSourceCode("insert into ").addSourceCode(this.m_qualifiedControlName).addSourceCode("\n").indent().addSourceCode("set GUID = \"").addSourceCode(this.m_guid).addSourceCode("\",\n").indent().addSourceCode("Version = &etls_vers,\n").addSourceCode("TableId = &etls_tblid,\n").addSourceCode("CurrInd = 1,\n").addSourceCode("Created = DATETIME(),\n").addSourceCode("LastUpdated = DATETIME();\n").unIndent().unIndent().unIndent().addSourceCode("quit;\n\n").unIndent().addSourceCode("%mend insertIntoCtrlTable;\n").addSourceCode("%insertIntoCtrlTable;\n\n");
    }

    protected void genUpdateControlTable() {
        this.m_code.addCommentLine(bundle.getString("ComparisonResultsCodegen.ContrlTblUpdate.txt")).addSourceCode("%macro updateCtrlTable();\n").addSourceCode("%let etls_oldvers = %eval(&etls_vers - 1);\n\n").addSourceCode("proc sql;\n").indent().addSourceCode("update ").addSourceCode(this.m_qualifiedControlName).addSourceCode("\n").indent().addSourceCode("set CurrInd = 0\n").addSourceCode("where GUID = \"").addSourceCode(this.m_guid).addSourceCode("\"\n").indent().addSourceCode(" and Version = &etls_oldvers").addSourceCode(";\n").unIndent().unIndent().addSourceCode("quit;\n\n").unIndent().addSourceCode("%mend updateCtrlTable;\n").addSourceCode("%updateCtrlTable;\n");
    }

    protected void genSourceXMLtoDatasets() {
        this.m_code.addCommentLine(bundle.getString("ComparisonResultsCodegen.DeleteTables.txt")).addSourceCode("proc datasets library = ").addSourceCode(this.m_libref).addSourceCode(" nolist nowarn memtype=(data view);\n ").indent().addSourceCode("delete  \n").indent().addSourceCode("&ETLS&src&column&etls_tblid\n").addSourceCode("&ETLS&src&index&etls_tblid\n").addSourceCode("&ETLS&src&indexcolumns&etls_tblid\n").addSourceCode("&ETLS&src&keyassociation&etls_tblid\n").addSourceCode("&ETLS&src&table&etls_tblid\n").addSourceCode("&ETLS&src&uniquekey&etls_tblid\n").addSourceCode("&ETLS&src&uniquekeycolumns&etls_tblid\n").addSourceCode("&ETLS&src&foreignkey&etls_tblid\n").addSourceCode("&ETLS&src&foreignkeycolumns&etls_tblid\n").addSourceCode("&ETLS&src&tree&etls_tblid\n").addSourceCode("&ETLS&src&schema&etls_tblid;\n").unIndent().unIndent().addSourceCode("quit;\n\n");
        StringBuffer fqMapFile = new StringBuffer(this.m_libraryPath);
        fqMapFile.append("SourceOMItoCAMap.xml");
        String fqSourceFile = this.m_model.getSourceOMIXMLFileName();
        this.m_code.addCommentLine(bundle.getString("ComparisonResultsCodegen.ApplyXSLSource.txt")).addSourceCode("filename map1 ").addSourceCode("'").addSourceCode(fqMapFile).addSourceCode("';\n").addSourceCode("filename srcfile '").addSourceCode(fqSourceFile).addSourceCode("' lrecl=1024;\n").addSourceCode("libname srcfile xml xmlmap=map1;\n\n");
        this.genProcCopyCode(true);
        this.genProcAppendCode("&src", true);
    }

    protected void genProcCopyCode(boolean isSource) {
        this.m_code.addCommentLine(bundle.getString("ComparisonResultsCodegen.CopyCode.txt")).addSourceCode("proc copy in=srcfile out=work").addSourceCode(";\n").indent().addSourceCode("select PhysicalTable;\n").addSourceCode("select Column;\n").addSourceCode("select Indexes;\n").addSourceCode("select Index_Columns;\n").addSourceCode("select KeyAssociation;\n").addSourceCode("select Tree;\n").addSourceCode("select Unique_Key;\n").addSourceCode("select Unique_Key_Columns;\n").addSourceCode("select Foreign_Key;\n").addSourceCode("select Foreign_Key_Columns;\n").addSourceCode("select DatabaseSchema;\n").addSourceCode("select Extension;\n");
        this.m_code.unIndent().addSourceCode("run;\n\n").addSourceCode("data PhysicalTable ( drop=Schema_ID);\n").indent().addSourceCode("set PhysicalTable;\n").addSourceCode("if SASLibrary_ID = '' then SASLibrary_ID = Schema_ID;\n");
        this.m_code.addSourceCode("data Extension (drop=obj_ref2);\n").addSourceCode("set Extension;\n").addSourceCode("if obj_ref =\"\" then do;\n").addSourceCode("  obj_ref = obj_ref2;\n").addSourceCode("  ObjectType=\"PhysicalTable\";\n").addSourceCode("end;\n").addSourceCode("else ObjectType=\"Column\";\n").addSourceCode("run;\n");
        this.m_code.unIndent().addSourceCode("run;\n\n").addSourceCode("filename map1;\n").addSourceCode("filename srcfile;\n\n");
    }

    protected void genProcAppendCode(String sSrcTgt, boolean isSource) {
        this.m_code.addCommentLine(bundle.getString("ComparisonResultsCodegen.AppendTables.txt")).addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&column&etls_tblid\n").indent().addSourceCode("data = column;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&index&etls_tblid\n").indent().addSourceCode("data = indexes;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&indexcolumns&etls_tblid\n").indent().addSourceCode("data = index_columns;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&keyassociation&etls_tblid\n").indent().addSourceCode("data = keyassociation;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&table&etls_tblid\n").indent().addSourceCode("data = physicaltable;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&uniquekey&etls_tblid\n").indent().addSourceCode("data = unique_key;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&uniquekeycolumns&etls_tblid\n").indent().addSourceCode("data = unique_key_columns;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&foreignkey&etls_tblid\n").indent().addSourceCode("data = foreign_key;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&foreignkeycolumns&etls_tblid\n").indent().addSourceCode("data = foreign_key_columns;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&tree&etls_tblid\n").indent().addSourceCode("data = tree;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode("&schema&etls_tblid\n").indent().addSourceCode("data = databaseschema;").unIndent().addSourceCode("run;\n\n").addSourceCode("proc append base = ").addSourceCode(this.m_libref).addSourceCode(".&ETLS.").addSourceCode(sSrcTgt).addSourceCode(".Extension&etls_tblid\n").indent().addSourceCode("data = extension;").unIndent().addSourceCode("run;\n\n");
        this.m_code.addCommentLine(bundle.getString("ComparisonResultsCodegen.DeleteWorkTbls.txt")).addSourceCode("proc datasets library = work").addSourceCode(" nolist nowarn memtype=(data view);\n").unIndent().addSourceCode("delete \n").indent().addSourceCode("column indexes index_columns keyassociation \n").addSourceCode("physicaltable unique_key unique_key_columns \n").addSourceCode("foreign_key foreign_key_columns tree databaseschema extension;\n").unIndent().unIndent().addSourceCode("quit;\n\n");
    }

    protected void genTargetToDatasets() throws WsAppServerCodeException, MdException, RemoteException, ComparisonResultsException {
        int i;
        String requestFileName = this.m_model.getXMLFilename("RequestTarget");
        String fQRequestName = this.m_libraryPath + requestFileName;
        String targetName = this.m_model.getXMLFilename("TargetOMI");
        String fQName = this.m_libraryPath + targetName;
        String fQMapFile = "";
        List targetObjects = new ArrayList<Root>();
        if (this.m_model.isSASLibraryTargetLocation()) {
            targetObjects.add(this.m_model.getTargetLocation());
            fQMapFile = this.m_libraryPath + "TargetOMItoCAMap.xml";
        } else {
            targetObjects = this.m_model.getDatabaseSchemaObjects();
            fQMapFile = this.m_libraryPath + "DBTargetOMItoCAMap.xml";
        }
        String reposID = this.m_model.getComparisonRepositoryId();
        this.m_code.addCommentLine(bundle.getString("ComparisonResultsCodegen.DeleteTables.txt")).addSourceCode("proc datasets library = ").addSourceCode(this.m_libref).addSourceCode(" nolist nowarn memtype=(data view);\n ").indent().addSourceCode("delete  \n").indent().addSourceCode("&ETLS&tgt&column&etls_tblid\n").addSourceCode("&ETLS&tgt&index&etls_tblid\n").addSourceCode("&ETLS&tgt&indexcolumns&etls_tblid\n").addSourceCode("&ETLS&tgt&keyassociation&etls_tblid\n").addSourceCode("&ETLS&tgt&table&etls_tblid\n").addSourceCode("&ETLS&tgt&uniquekey&etls_tblid\n").addSourceCode("&ETLS&tgt&uniquekeycolumns&etls_tblid\n").addSourceCode("&ETLS&tgt&foreignkey&etls_tblid\n").addSourceCode("&ETLS&tgt&foreignkeycolumns&etls_tblid\n").addSourceCode("&ETLS&tgt&tree&etls_tblid;\n").unIndent().unIndent().addSourceCode("quit;\n\n");
        for (i = 0; i < targetObjects.size(); ++i) {
            SASLibrary library;
            AssociationList list;
            Root location = (Root)targetObjects.get(i);
            if (location instanceof SASLibrary && (list = (library = (SASLibrary)location).getUsingPackages()).size() > 0 && list.get(0) instanceof DatabaseSchemaImpl) {
                location = (Root)list.get(0);
            }
            this.m_code.addSourceCode("filename request '").addSourceCode(fQRequestName).addSourceCode("';\n\n").addCommentLine(bundle.getString("ComparisonResultsCodegen.CreateXMLRequest.txt")).addSourceCode("data _null_;\n").indent().addSourceCode("file request;\n").addSourceCode("infile cards4;\n").addSourceCode("length long $256;\n").addSourceCode("input;\n").addSourceCode("long=_infile_;\n").addSourceCode("put long ' ';\n").addSourceCode("cards4;\n").indent().addSourceCode("<GetMetadataObjects>\n").addSourceCode("   <ReposId>").addSourceCode(reposID).addSourceCode("</ReposId>\n").addSourceCode("  <Type>PhysicalTable</Type>\n").addSourceCode("   <Objects/>\n").addSourceCode("        <ns>SAS</ns>\n").addSourceCode("        <Flags>396</Flags>\n").addSourceCode("        <Options>\n").addSourceCode("        <Templates>\n").addSourceCode("         <PhysicalTable>\n").addSourceCode("            <Indexes/>\n").addSourceCode("            <TablePackage/>\n").addSourceCode("            <Columns/>\n").addSourceCode("            <UniqueKeys/>\n").addSourceCode("            <ForeignKeys/>\n").addSourceCode("            <Trees/>\n").addSourceCode("         </PhysicalTable>\n").addSourceCode("\n").addSourceCode("         <ForeignKey>  \n").addSourceCode("            <PartnerUniqueKey/>  \n").addSourceCode("            <KeyedColumns/>  \n").addSourceCode("            <KeyAssociations/>  \n").addSourceCode("            <Table/>\n").addSourceCode("         </ForeignKey>  \n").addSourceCode("\n").addSourceCode("         <Index>\n").addSourceCode("            <Columns>\n").addSourceCode("            <Column/>\n").addSourceCode("            </Columns>\n").addSourceCode("         </Index>\n").addSourceCode("\n").addSourceCode("         <UniqueKey>\n").addSourceCode("            <KeyedColumns/>\n").addSourceCode("         </UniqueKey>\n").addSourceCode("\n").addSourceCode("         <KeyAssociation>\n").addSourceCode("            <UniqueKeyColumn/>\n").addSourceCode("            <ForeignKeyColumn/>\n").addSourceCode("         </KeyAssociation>\n").addSourceCode("\n").addSourceCode("      </Templates>\n").addSourceCode("      <XMLSelect search=\"*[TablePackage/*[@Id='").addSourceCode(location.getFQID()).addSourceCode("']]\"/>\n").addSourceCode("        </Options>\n").addSourceCode("        </GetMetadataObjects>\n").unIndent().unIndent().unIndent().unIndent().unIndent().unIndent().unIndent().addSourceCode(";;;;\n").indent().addSourceCode("run;\n\n").addSourceCode("filename response '").addSourceCode(fQName).addSourceCode("' lrecl=1024;\n\n").addSourceCode("proc metadata \n").indent().addSourceCode("in=request \n").addSourceCode("out=response;\n").unIndent().addSourceCode("run;\n\n").addSourceCode("filename request;\n").addSourceCode("filename response;\n").addSourceCode("filename map1 '").addSourceCode(fQMapFile).addSourceCode("';\n").addSourceCode("filename srcfile '").addSourceCode(fQName).addSourceCode("' lrecl=1024;\n").addSourceCode("libname srcfile xml xmlmap=map1;\n\n");
            this.genProcCopyCode(false);
            this.genProcAppendCode("&tgt", false);
            this.genDeleteFileCode(fQRequestName);
        }
        if (!this.m_model.isSASLibraryTargetLocation()) {
            this.m_code.addSourceCode("%macro updateSrcTable;\n\n").indent().addSourceCode("%let etls_tschmcnt = 0;\n\n").addSourceCode("proc contents data =").addSourceCode(this.m_libref).addSourceCode(".&ETLS&tgt&schema&etls_tblid\n").indent().addSourceCode("out = work.etls_contents(keep = nobs) noprint;\n\n").unIndent().addSourceCode("run;\n\n").addSourceCode("data _null_;\n").indent().addSourceCode("set work.etls_contents (obs = 1);\n").addSourceCode("call symput(\"etls_tschmcnt\", left(put(nobs,32.)));\n").unIndent().addSourceCode("run;\n\n").addSourceCode("%if (&etls_tschmcnt eq 0) %then\n").indent().addSourceCode("%do;\n\n").indent().addSourceCode("data ").addSourceCode(this.m_libref).addSourceCode(".&ETLS&tgt&schema&etls_tblid (keep=Table_Id schema_Id Name schemaName);\n").indent().addSourceCode("set ").addSourceCode(this.m_libref).addSourceCode(".&ETLS&src&schema&etls_tblid;\n\n");
            for (i = 0; i < targetObjects.size(); ++i) {
                DatabaseSchema schema = (DatabaseSchema)targetObjects.get(i);
                this.m_code.addSourceCode("if schemaname = \"").addSourceCode(schema.getSchemaName()).addSourceCode("\"\n").indent().addSourceCode("then schema_id = \"").addSourceCode(schema.getFQID()).addSourceCode("\";\n\n").unIndent();
            }
            this.m_code.unIndent().addSourceCode("run;\n\n").unIndent().addSourceCode("%end;\n\n").addSourceCode("proc sql;\n").indent().addSourceCode("create table etls_mschema as\n").addSourceCode("select unique &ETLS&src&schema&etls_tblid..table_id,\n").indent().addSourceCode("&ETLS&tgt&schema&etls_tblid..schema_id,\n").addSourceCode("&ETLS&tgt&schema&etls_tblid..schemaname\n").unIndent().addSourceCode("from ").addSourceCode(this.m_libref).addSourceCode(".&ETLS&src&schema&etls_tblid left join ").addSourceCode(this.m_libref).addSourceCode(".&ETLS&tgt&schema&etls_tblid\n").addSourceCode("on &ETLS&src&schema&etls_tblid..schemaname = &ETLS&tgt&schema&etls_tblid..schemaname;\n\n").addSourceCode("update ").addSourceCode(this.m_libref).addSourceCode(".&ETLS&src&table&etls_tblid\n").indent().addSourceCode("set SASLibrary_id = \n").indent().addSourceCode("(Select schema_id from etls_mschema\n").indent().addSourceCode("where &ETLS&src&table&etls_tblid..table_id = etls_mschema.table_id);\n").unIndent().unIndent().unIndent().unIndent().addSourceCode("quit;\n\n").unIndent().addSourceCode("%mend;\n\n").addSourceCode("%updateSrcTable;\n\n");
        }
    }

    protected String getLastUpdatedDateCode() {
        StringBuffer code = new StringBuffer();
        code.append("Select LastUpdated from ").append(this.m_qualifiedControlName).append(" where GUID = \"").append(this.m_guid).append("\" and CurrInd = 1");
        return code.toString();
    }

    protected String getIdentifierSelectCode() {
        StringBuffer code = new StringBuffer();
        code.append("Select TableId from ").append(this.m_qualifiedControlName).append(" where GUID = \"").append(this.m_guid).append("\" and CurrInd = 1");
        return code.toString();
    }

    protected String getAllIndentifersSelectCode() {
        StringBuffer code = new StringBuffer();
        code.append("Select TableId from ").append(this.m_qualifiedControlName).append(" where GUID = \"").append(this.m_guid).append("\" ");
        return code.toString();
    }

    protected String getInsertIntoActivityTableMacro() {
        StringBuffer code = new StringBuffer();
        code.append("/*").append(bundle.getString("ComparisonResultsCodegen.ContrlTblInsert.txt")).append("*/\n").append("%macro instActvtyTbl(etls_guid, etls_code, etls_id,\n").append("      etls_type, etls_name, etls_desc, etls_prntId,\n").append("      etls_prnttype, etls_prntName, etls_person);\n\n").append("proc sql noprint;\n").append("   select compress(put(max(Key), best32.))\n").append("      into :etls_actKey from ").append(this.m_qualifiedActivityName).append(";\n").append("quit;\n\n").append("%if (&etls_actKey eq .)\n").append("   %then %let etls_actKey = 1;\n").append("   %else %let etls_actKey = %eval(&etls_actKey + 1);\n\n").append("   proc sql;\n").append("      insert into ").append(this.m_qualifiedActivityName).append("\n").append("         set Key = &etls_actKey,\n").append("           GUID = \"%quote(&etls_guid)\",\n").append("           Activity = \"%quote(&etls_code)\",\n").append("           identifier = \"%quote(&etls_id)\",\n").append("           type = \"%quote(&etls_type)\",\n").append("           name = \"%quote(&etls_name)\",\n").append("           desc = %quote(&etls_desc),\n").append("           parent_id = \"%quote(&etls_prntId)\",\n").append("           parent_type = \"%quote(&etls_prnttype)\",\n").append("           parent_name = \"%quote(&etls_prntName)\",\n").append("           personname = \"%quote(&etls_person)\",\n").append("           datetimestamp = DATETIME() ;\n").append("   quit;\n\n").append("%mend instActvtyTbl;\n\n");
        return code.toString();
    }

    protected String getInsertIntoActivityTableMacroCall(String guid, String activity, String identifier, String type, String name, String desc, String parent_id, String parent_type, String parent_name, String person) {
        StringBuffer code = new StringBuffer();
        code.append("%instActvtyTbl(").append(guid).append(",\n").append(activity).append(",\n ").append(identifier).append(",\n ").append(type).append(",\n ").append(name).append(",\n\"").append(desc).append("\",\n ").append(parent_id).append(",\n ").append(parent_type).append(",\n ").append(parent_name).append(",\n ").append(person).append(");\n\n");
        return code.toString();
    }

    protected String getViewActivityCode() {
        try {
            StringBuffer code = new StringBuffer();
            code.append("proc sort data = ").append(this.m_qualifiedActivityName).append("\n   out=etls_sortedact;\n").append("   by parent_name parent_type;\n").append("run;\n\n").append("ods html file=\"ComparisonResultsActivity.html\";\n\n").append("proc report data = etls_sortedact\n").append("   ls=256 spacing=1 center;\n").append("   column activity name type identifier desc personname datetimestamp;\n").append("   by parent_name parent_type;\n").append("   where guid = \"").append(this.m_guid).append("\";\n").append("   title \"").append(bundle.formatString("ComparisonResultsCodegen.ActivityViewTitle.txt", (Object)this.m_model.getTree().getName())).append("\";\n").append("run;\n\n").append("ods html close;\n");
            return code.toString();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    protected String getCurrentTableIdentifier() {
        StringBuffer code = new StringBuffer();
        code.append("%let etls_tblid = -1;\n").append("proc sql noprint;\n").append("   select compress(put(TableId, best32.))\n").append("      into :etls_tblid from ").append(this.m_qualifiedControlName).append("\n").append("where GUID = \"").append(this.m_guid).append("\" and\n").append("CurrInd = 1;\n").append("quit;\n\n");
        return code.toString();
    }

    protected String getDiffViewerSASMacros() {
        StringBuffer code = new StringBuffer();
        code.append(this.getCurrentTableIdentifier()).append(this.getSetMacroVariables()).append(this.getMacrosForComparisonResultsModel()).append(this.getInsertIntoActivityTableMacro()).append("%getAllAttributes;\n");
        return code.toString();
    }

    protected String getDeleteSASMacros() {
        StringBuffer code = new StringBuffer();
        code.append(this.getCurrentTableIdentifier()).append(this.getSetMacroVariables()).append(this.getInsertIntoActivityTableMacro()).append(this.getMacroToDeleteAllTables()).append(this.getDeleteControlTableEntries());
        return code.toString();
    }

    protected void genDeleteFileCode(String filename) {
        this.m_code.addCommentLine(bundle.getString("ComparisonResultsCodegen.DeleteFile.txt")).addSourceCode("data _null_;\n\n").addSourceCode("  length fref $8;\n").addSourceCode("  fref = \"\";\n\n").addSourceCode("  rc = filename(fref, '").addSourceCode(filename).addSourceCode("');\n\n").addSourceCode("  if (rc=0) and (fexist(fref))\n").addSourceCode("     then rc = fdelete(fref);\n\n").addSourceCode("  rc = filename(fref, '');\n\n").addSourceCode("run;\n\n");
    }

    protected String getSetMacroVariables() {
        StringBuffer code = new StringBuffer();
        if (this.m_model.isIgnoreCaseSensitive()) {
            code.append("%let caseSensitive =F;\n");
        } else {
            code.append("%let caseSensitive =T;\n");
        }
        code.append("/*\n");
        code.append("ASSOCIATIONS\n");
        code.append("PHYSICALTABLE - Columns, Indexes\", \"UniqueKeys\", \"ForeignKeys\" \n");
        code.append("UNIQUEKEY - KeyedColumns\n");
        code.append("FOREIGNKEY - KeyedColumns, PartnerUniqueKey\n");
        code.append("INDEX - Columns\n");
        code.append("COLUMN - NONE\n");
        code.append("*/\n");
        code.append("\n");
        code.append("/* Tablenames that are output from applying XSL Template */\n");
        code.append("%let mt_physicaltable=");
        code.append("PhysicalTable");
        code.append(";\n");
        code.append("%let mt_column=");
        code.append("Column");
        code.append(";\n");
        code.append("%let mt_index=");
        code.append("Index");
        code.append(";\n");
        code.append("%let mt_uniquekeys=");
        code.append("UniqueKey");
        code.append(";\n");
        code.append("%let mt_foreignkeys=");
        code.append("ForeignKey");
        code.append(";\n");
        code.append("%let mt_foreignkeycolumn=ForeignKeyColumn;\n");
        code.append("%let mt_uniquekeycolumn=UniqueKeyColumn;\n");
        code.append("%let mt_indexColumn=IndexColumn;\n");
        code.append("%let mt_keyassociation=KeyAssociation;\n");
        code.append("\n");
        code.append("\n");
        code.append("%let assn_Table=Table;\n");
        code.append("%let assn_Columns=Columns;\n");
        code.append("%let assn_Indexes=Indexes;\n");
        code.append("%let assn_UniqueKeys=UniqueKeys;\n");
        code.append("%let assn_ForeignKeys=ForeignKeys;\n");
        code.append("%let assn_KeyedColumns=KeyedColumns;\n");
        code.append("%let assn_PartnerUniqueKey=PartnerUniqueKey;\n");
        code.append("%let assn_KeyAssociation=KeyAssociations;\n");
        code.append("\n");
        code.append("%let CALibrary=");
        code.append(this.m_libref);
        code.append(";\n");
        code.append("%let ETLS=etls_; /* Prefix for ETLS Generated Datasets */\n");
        code.append("%let src=S; /* Source */\n");
        code.append("%let tgt=T; /* Target */\n");
        code.append("%let dif=D;\n");
        code.append("%let chg=C; /* Changes */\n");
        code.append("%let mdl=M; /* Tables For Model to Query */\n");
        code.append("%let Loc=L; /* Location: Source, Target Both */\n");
        code.append("%let ATC=A; /* Attribute Changes */\n");
        code.append("\n");
        code.append("\n");
        code.append("%let table            =TABL;\n");
        code.append("%let column           =COLM;\n");
        code.append("%let index            =INDX;\n");
        code.append("%let indexcolumns     =IDXC;\n");
        code.append("%let foreignkey       =FOKY;\n");
        code.append("%let foreignkeycolumns   =FKYC;\n");
        code.append("%let uniquekey        =UQKY;\n");
        code.append("%let uniquekeycolumns =UKYC;\n");
        code.append("%let keyassociation      =KASN;\n");
        code.append("%let tree          =TREE;\n");
        code.append("%let foreignunique      =FKUK;\n");
        code.append("%let schema = SCHM;\n");
        code.append("\n");
        code.append("%let colatts          =COLA;\n");
        code.append("%let atts             =ATTS;\n");
        code.append("%let foreignkeyatts   =FOKA;\n");
        code.append("%let indexatts        =INDA;\n");
        code.append("%let tableatts        =TABA;\n");
        code.append("%let uniquekeyatts    =UQKA;\n");
        code.append("\n");
        code.append("/*  Codes */\n");
        code.append("%let both    = ").append("B").append(";\n");
        code.append("%let source  = ").append("S").append(";\n");
        code.append("%let target  = ").append("T").append(";\n");
        code.append("\n");
        code.append("\n");
        code.append("\n");
        code.append("%let colatts         =COLA;\n");
        code.append("%let atts            =ATTS;\n");
        code.append("%let foreignkeyatts  =FOKA;\n");
        code.append("%let indexatts       =INDA;\n");
        code.append("%let tableatts       =TABA;\n");
        code.append("%let uniquekeyatts   =UQKA;\n");
        code.append("\n");
        code.append("\n");
        code.append("%let dsAssociationChanged       \t=work.etls_asnchg&etls_tblid;\n");
        code.append("%let dsAssociations             \t=work.etls_assns&etls_tblid;\n");
        code.append("%let dsMetaAttributes           \t=&CALibrary..etls_metaAttr;\n");
        code.append("%let sourceColumns              \t=&CALibrary..&ETLS&src&column&etls_tblid;\n");
        code.append("%let sourceForeignKeyColumns    \t=&CALibrary..&ETLS&src&foreignkeycolumns&etls_tblid;\n");
        code.append("%let sourceForeignKeys          \t=&CALibrary..&ETLS&src&foreignkey&etls_tblid;\n");
        code.append("%let sourceIndexColumns         \t=&CALibrary..&ETLS&src&indexcolumns&etls_tblid;\n");
        code.append("%let sourceIndexes              \t=&CALibrary..&ETLS&src&index&etls_tblid;\n");
        code.append("%let sourceTables               \t=&CALibrary..&ETLS&src&table&etls_tblid;\n");
        code.append("%let sourceUniqueKeyColumns     \t=&CALibrary..&ETLS&src&uniquekeycolumns&etls_tblid;\n");
        code.append("%let sourceUniqueKeys           \t=&CALibrary..&ETLS&src&uniquekey&etls_tblid;\n");
        code.append("%let sourceForeignUnique        \t=&CALibrary..&ETLS&src&foreignunique&etls_tblid;\n");
        code.append("%let sourceKeyAssociation\t   \t=&CALibrary..&ETLS&src&keyassociation&etls_tblid;\n");
        code.append("\n");
        code.append("%let targetColumns          \t\t=&CALibrary..&ETLS&tgt&column&etls_tblid;\n");
        code.append("%let targetForeignKeyColumns   \t=&CALibrary..&ETLS&tgt&foreignkeycolumns&etls_tblid; \n");
        code.append("%let targetForeignKeys      \t\t=&CALibrary..&ETLS&tgt&foreignkey&etls_tblid; \n");
        code.append("%let targetIndexColumns        \t=&CALibrary..&ETLS&tgt&indexcolumns&etls_tblid; \n");
        code.append("%let targetIndexes          \t\t=&CALibrary..&ETLS&tgt&index&etls_tblid; \n");
        code.append("%let targetTables           \t\t=&CALibrary..&ETLS&tgt&table&etls_tblid;\n");
        code.append("%let targetUniqueKeyColumns    \t=&CALibrary..&ETLS&tgt&uniquekeycolumns&etls_tblid; \n");
        code.append("%let targetUniqueKeys          \t=&CALibrary..&ETLS&tgt&uniquekey&etls_tblid; \n");
        code.append("%let targetForeignUnique      \t=&CALibrary..&ETLS&tgt&foreignunique&etls_tblid;\n");
        code.append("%let targetKeyAssociation\t \t=&CALibrary..&ETLS&tgt&keyassociation&etls_tblid;\n");
        code.append("\n");
        code.append("%let locnTables             \t\t=&CALibrary..&ETLS&loc&table&etls_tblid;\n");
        code.append("%let locnColumns            \t\t=&CALibrary..&ETLS&loc&column&etls_tblid;\n");
        code.append("%let locnIndexes            \t\t=&CALibrary..&ETLS&loc&index&etls_tblid;\n");
        code.append("%let locnIndexColumns          \t=&CALibrary..&ETLS&loc&indexcolumns&etls_tblid;\n");
        code.append("%let locnForeignKeys           \t=&CALibrary..&ETLS&loc&foreignkey&etls_tblid;\n");
        code.append("%let locnForeignKeyColumns     \t=&CALibrary..&ETLS&loc&foreignkeycolumns&etls_tblid;\n");
        code.append("%let locnUniqueKeys            \t=&CALibrary..&ETLS&loc&uniquekey&etls_tblid;\n");
        code.append("%let locnUniqueKeyColumns      \t=&CALibrary..&ETLS&loc&uniquekeycolumns&etls_tblid;\n");
        code.append("%let locnForeignUnique      \t\t=&CALibrary..&ETLS&loc&foreignunique&etls_tblid;\n");
        code.append("%let locnKeyAssociation\t   \t\t=&CALibrary..&ETLS&loc&keyassociation&etls_tblid;\n");
        code.append("\n");
        code.append("%let attrTables             \t\t=&CALibrary..&ETLS&ATC&table&etls_tblid;\n");
        code.append("%let attrColumns            \t\t=&CALibrary..&ETLS&ATC&column&etls_tblid;\n");
        code.append("%let attrIndexes            \t\t=&CALibrary..&ETLS&ATC&index&etls_tblid;\n");
        code.append("%let attrUniqueKeys         \t\t=&CALibrary..&ETLS&ATC&uniquekey&etls_tblid;\n");
        code.append("%let attrForeignKeys        \t\t=&CALibrary..&ETLS&ATC&foreignkey&etls_tblid;\n");
        code.append("%let attrKeyAssociation \t\t\t=&CALibrary..&ETLS&ATC&keyassociation&etls_tblid;\n");
        code.append("\n");
        code.append("%let chngTables             \t\t=&CALibrary..&ETLS&chg&table&etls_tblid;\n");
        code.append("%let chngColumns            \t\t=&CALibrary..&ETLS&chg&column&etls_tblid;\n");
        code.append("%let chngIndexes            \t\t=&CALibrary..&ETLS&chg&index&etls_tblid;\n");
        code.append("%let chngUniqueKeys          \t=&CALibrary..&ETLS&chg&uniquekey&etls_tblid;\n");
        code.append("%let chngForeignKeys         \t=&CALibrary..&ETLS&chg&foreignkey&etls_tblid;\n");
        code.append("%let chngIndexColumns    \t\t=&CALibrary..&ETLS&chg&indexcolumns&etls_tblid;\n");
        code.append("%let chngUniqueKeyColumns    \t=&CALibrary..&ETLS&chg&uniquekeycolumns&etls_tblid;\n");
        code.append("%let chngForeignKeyColumns   \t=&CALibrary..&ETLS&chg&foreignkeycolumns&etls_tblid;\n");
        code.append("%let chngKeyAssociation\t\t\t=&CALibrary..&ETLS&chg&keyassociation&etls_tblid;\n");
        code.append("\n");
        code.append("\n");
        code.append("%let modlTables             \t\t=&CALibrary..&ETLS&mdl&table&etls_tblid;\n");
        code.append("%let modlColumns               \t=&CALibrary..&ETLS&mdl&column&etls_tblid;\n");
        code.append("%let modlIndexes               \t=&CALibrary..&ETLS&mdl&index&etls_tblid;\n");
        code.append("%let modlUniqueKeys         \t\t=&CALibrary..&ETLS&mdl&uniquekey&etls_tblid;\n");
        code.append("%let modlForeignKeys        \t\t=&CALibrary..&ETLS&mdl&foreignkey&etls_tblid;\n");
        code.append("%let modlKeyAssociation     \t\t=&CALibrary..&ETLS&mdl&keyassociation&etls_tblid;\n");
        code.append("\n");
        code.append("%let modlAllObjects         \t\t=&CALibrary..&ETLS.ComparedObjects&etls_tblid;\n");
        code.append("%let modlAttributes         \t\t=").append("etls_atts").append("&etls_tblid;\n");
        code.append("%let dsDuplicates                =&CALibrary..&ETLS.Duplicates&etls_tblid;\n");
        code.append("\n");
        code.append("%let tempCols                  \t=etls_tmp1;\n");
        code.append("*%let wrkColAtts            \t\t=etls_dcatt;\n");
        code.append("*%let wrkColumns            \t\t=etls_dcols;\n");
        code.append("*%let wrkTEMP1              \t\t=etls_temp1;\n");
        code.append("*%let wrkTEMP2              \t\t=etls_temp2;\n");
        code.append("\n");
        code.append("\n");
        code.append("\n");
        return code.toString();
    }

    protected String getMacroToDeleteAllTables() {
        StringBuffer code = new StringBuffer();
        code.append("%macro deleteCADatasets(etls_tblid);\n").append("proc datasets library=&CALibrary nolist;\n").append("    DELETE\n").append("    &ETLS&src&column&etls_tblid\n").append("    &ETLS&src&foreignkeycolumns&etls_tblid\n").append("    &ETLS&src&foreignkey&etls_tblid\n").append("    &ETLS&src&indexcolumns&etls_tblid\n").append("    &ETLS&src&index&etls_tblid\n").append("    &ETLS&src&table&etls_tblid\n").append("    &ETLS&src&uniquekeycolumns&etls_tblid\n").append("    &ETLS&src&uniquekey&etls_tblid\n").append("    &ETLS&src&tree&etls_tblid\n").append("    &ETLS&src&keyassociation&etls_tblid\n").append("    &ETLS&src&foreignunique&etls_tblid\n").append("    &ETLS&src&schema&etls_tblid\n\n").append("    &ETLS&tgt&column&etls_tblid\n").append("    &ETLS&tgt&foreignkeycolumns&etls_tblid\n").append("    &ETLS&tgt&foreignkey&etls_tblid\n").append("    &ETLS&tgt&indexcolumns&etls_tblid\n").append("    &ETLS&tgt&index&etls_tblid\n").append("    &ETLS&tgt&table&etls_tblid\n").append("    &ETLS&tgt&uniquekeycolumns&etls_tblid\n").append("    &ETLS&tgt&uniquekey&etls_tblid\n").append("    &ETLS&tgt&tree&etls_tblid\n").append("    &ETLS&tgt&keyassociation&etls_tblid\n").append("    &ETLS&tgt&foreignunique&etls_tblid\n").append("    &ETLS&tgt&schema&etls_tblid\n\n").append("    &ETLS&loc&table&etls_tblid\n").append("    &ETLS&loc&column&etls_tblid\n").append("    &ETLS&loc&index&etls_tblid\n").append("    &ETLS&loc&indexcolumns&etls_tblid\n").append("    &ETLS&loc&foreignkey&etls_tblid\n").append("    &ETLS&loc&foreignkeycolumns&etls_tblid\n").append("    &ETLS&loc&uniquekey&etls_tblid\n").append("    &ETLS&loc&uniquekeycolumns&etls_tblid\n").append("    &ETLS&loc&foreignunique&etls_tblid\n\n").append("    &ETLS&loc&keyassociation&etls_tblid\n\n").append("    &ETLS&ATC&table&etls_tblid\n").append("    &ETLS&ATC&column&etls_tblid\n").append("    &ETLS&ATC&index&etls_tblid\n").append("    &ETLS&ATC&uniquekey&etls_tblid\n").append("    &ETLS&ATC&uniquekeycolumns&etls_tblid\n").append("    &ETLS&ATC&foreignkey&etls_tblid\n").append("    &ETLS&ATC&foreignkeycolumns&etls_tblid\n\n").append("    &ETLS&ATC&keyassociation&etls_tblid\n\n").append("    &ETLS&chg&table&etls_tblid\n").append("    &ETLS&chg&column&etls_tblid\n").append("    &ETLS&chg&index&etls_tblid\n").append("    &ETLS&chg&uniquekey&etls_tblid\n").append("    &ETLS&chg&foreignkey&etls_tblid\n\n").append("    &ETLS&chg&indexcolumns&etls_tblid\n\n").append("    &ETLS&chg&uniquekeycolumns&etls_tblid\n\n").append("    &ETLS&chg&foreignkeycolumns&etls_tblid\n\n").append("    &ETLS&chg&keyassociation&etls_tblid\n\n").append("    &ETLS&mdl&table&etls_tblid\n").append("    &ETLS&mdl&column&etls_tblid\n").append("    &ETLS&mdl&index&etls_tblid\n").append("    &ETLS&mdl&uniquekey&etls_tblid\n").append("    &ETLS&mdl&foreignkey&etls_tblid\n\n").append("    &ETLS&mdl&keyassociation&etls_tblid\n\n").append("    &ETLS.ComparedObjects&etls_tblid\n").append("\t   &ETLS.Duplicates&etls_tblid;\n").append(" ;\n").append("quit;\n").append("\n").append("%mend deleteCADatasets;\n\n");
        return code.toString();
    }

    protected String getDeleteAllTableMacroCall(int identifier) {
        StringBuffer code = new StringBuffer();
        code.append("%deleteCADatasets(").append(identifier).append(");\n").append("\n");
        return code.toString();
    }

    protected String getDeleteControlTableEntries() {
        StringBuffer code = new StringBuffer();
        code.append("Proc sql;\n").append("   delete from ").append(this.m_qualifiedControlName).append("\n").append("   where GUID = \"").append(this.m_guid).append("\";\n").append("quit;\n\n");
        return code.toString();
    }

    protected String getComparisonCode() {
        StringBuffer sb = new StringBuffer();
        sb.append("/*****************************************************************************\n");
        sb.append("*  Macro to create a dataset consisting of Source, Target and Both Objects  *\n");
        sb.append("*  _byvars_   = Variables on which tables are merged                        *\n");
        sb.append("*  _metadata_ = metadata type, e.g., physicaltable, column,              *\n");
        sb.append("*  _source_   = dataset consisting of source objects                  *\n");
        sb.append("*  _target_   = dataset consisting of target objects                  *\n");
        sb.append("*  _keepvars_ = variables to keep in resultant dataset                *\n");
        sb.append("*  _case_     = CaseSensitive=T, F is Case Insensitive                *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("\n");
        sb.append("%macro differences(_byvars_, _metadata_, _source_, _target_, _dout_, _keepvars_ , _case_ );\n");
        sb.append("\n");
        sb.append(" %LOCAL _J_ _BYVARCOUNT_;\n");
        sb.append("\n");
        sb.append(" /*** determine number of SAS variables in _byvars_ ***/\n");
        sb.append(" %let _BYVARCOUNT_ = %eval( 1 + (%length(%sysfunc(compbl(&_byvars_)))  -\n");
        sb.append("                          %length(%sysfunc(compress(&_byvars_)))));\n");
        sb.append("\n");
        sb.append("    /* Create additional fields and populate with upcase values */\n");
        sb.append(" %if &_case_ =F %then\n");
        sb.append("    %DO;\n");
        sb.append("    data &_source_;\n");
        sb.append("       set &_source_;\n");
        sb.append("          %DO _J_=1 %TO &_BYVARCOUNT_;\n");
        sb.append("             UC_%scan(&_byvars_, &_J_) = upcase(%scan(&_byvars_, &_J_));\n");
        sb.append("          %END;\n");
        sb.append("    run;\n");
        sb.append("\n");
        sb.append("    data &_target_;\n");
        sb.append("       set &_target_;\n");
        sb.append("          %DO _J_=1 %TO &_BYVARCOUNT_;\n");
        sb.append("             UC_%scan(&_byvars_, &_J_) = upcase(%scan(&_byvars_, &_J_));\n");
        sb.append("          %END;\n");
        sb.append("    run;\n");
        sb.append("    %END;\n");
        sb.append(" \n");
        sb.append(" proc sort data=&_source_;\n");
        sb.append("    by \n");
        sb.append("       %DO _J_=1 %TO &_BYVARCOUNT_;\n");
        sb.append("          %if &_case_ =F %then\n");
        sb.append("                %do;\n");
        sb.append("                   UC_%scan(&_byvars_, &_J_)\n");
        sb.append("             %end;\n");
        sb.append("          %else\n");
        sb.append("             %do;\n");
        sb.append("                   %scan(&_byvars_, &_J_)\n");
        sb.append("             %end;\n");
        sb.append("       %END;\n");
        sb.append("    ;\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" proc sort data=&_target_;\n");
        sb.append("    by \n");
        sb.append("       %DO _J_=1 %TO &_BYVARCOUNT_;\n");
        sb.append("          %if &_case_ =F %then\n");
        sb.append("                %do;\n");
        sb.append("                   UC_%scan(&_byvars_, &_J_)\n");
        sb.append("             %end;\n");
        sb.append("          %else\n");
        sb.append("             %do;\n");
        sb.append("                   %scan(&_byvars_, &_J_)\n");
        sb.append("             %end;\n");
        sb.append("       %END;\n");
        sb.append("    ;\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" /* Add Number */\n");
        sb.append(" data &_source_;\n");
        sb.append("    set &_source_;\n");
        sb.append("    SourceRow=_N_;\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" data &_target_;\n");
        sb.append("    set &_target_;\n");
        sb.append("    TargetRow=_N_;\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append("%if &_case_ =F %then \n");
        sb.append(" %do;\n");
        sb.append("    data &_dout_ (keep=Code MetadataType SourceRow TargetRow &_keepvars_\n");
        sb.append("    %DO _J_=1 %TO &_BYVARCOUNT_;\n");
        sb.append("       UC_%scan(&_byvars_, &_J_)\n");
        sb.append("     %END;\n");
        sb.append("        );\n");
        sb.append("    %end;\n");
        sb.append("%else\n");
        sb.append(" %do;\n");
        sb.append("    data &_dout_ (keep=Code MetadataType SourceRow TargetRow &_keepvars_);\n");
        sb.append(" %end;\n");
        sb.append("\n");
        sb.append("    attrib Code          length=$1   label ='Code';\n");
        sb.append("    attrib MetadataType  length=$60  label ='Metadata Type';\n");
        sb.append("    attrib SourceRow     length=8    label ='Row Number in Source Table';\n");
        sb.append("    attrib TargetRow     length=8    label ='Row Number in Target Table';\n");
        sb.append("\n");
        sb.append("    merge &_source_ (in=InSource)\n");
        sb.append("            &_target_ (in=InTarget)\n");
        sb.append("    ;\n");
        sb.append("\n");
        sb.append("    by \n");
        sb.append("       %DO _J_=1 %TO &_BYVARCOUNT_;\n");
        sb.append("          %if &_case_ =F %then\n");
        sb.append("                %do;\n");
        sb.append("                   UC_%scan(&_byvars_, &_J_)\n");
        sb.append("             %end;\n");
        sb.append("          %else\n");
        sb.append("             %do;\n");
        sb.append("                   %scan(&_byvars_, &_J_)\n");
        sb.append("             %end;\n");
        sb.append("        %END;\n");
        sb.append("    ;\n");
        sb.append("\n");
        sb.append("       retain metadataType \"&_metadata_\";\n");
        sb.append("       if InSource and InTarget then code=\"&both\";\n");
        sb.append("       else if InSource then code=\"&source\";\n");
        sb.append("       else code=\"&target\";\n");
        sb.append("   run;\n");
        sb.append("%mend differences;\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("%macro getIdFromTarget(_target_, _locn_, _byVars_, _case_, _idvar_);\n");
        sb.append("\t%LOCAL _J_ _BYVARCOUNT_;\n");
        sb.append("\n");
        sb.append("\t%let _BYVARCOUNT_ = %eval( 1 + (%length(%sysfunc(compbl(&_byvars_)))  -\n");
        sb.append("\t                         %length(%sysfunc(compress(&_byvars_)))));\n");
        sb.append("\n");
        sb.append(" proc sort data=&_locn_;\n");
        sb.append("    by \n");
        sb.append("       %DO _J_=1 %TO &_BYVARCOUNT_;\n");
        sb.append("          %if &_case_ =F %then\n");
        sb.append("                %do;\n");
        sb.append("                   UC_%scan(&_byvars_, &_J_)\n");
        sb.append("             %end;\n");
        sb.append("          %else\n");
        sb.append("             %do;\n");
        sb.append("                   %scan(&_byvars_, &_J_)\n");
        sb.append("             %end;\n");
        sb.append("       %END;\n");
        sb.append("    ;\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" proc sort data=&_target_;\n");
        sb.append("    by \n");
        sb.append("       %DO _J_=1 %TO &_BYVARCOUNT_;\n");
        sb.append("          %if &_case_ =F %then\n");
        sb.append("                %do;\n");
        sb.append("                   UC_%scan(&_byvars_, &_J_)\n");
        sb.append("             %end;\n");
        sb.append("          %else\n");
        sb.append("             %do;\n");
        sb.append("                   %scan(&_byvars_, &_J_)\n");
        sb.append("             %end;\n");
        sb.append("       %END;\n");
        sb.append("    ;\n");
        sb.append(" run;\n");
        sb.append("\tData &_locn_;\n");
        sb.append("\n");
        sb.append("\t\t%if &_case_ =F %then\n");
        sb.append("\t\t  \t%DO;\n");
        sb.append("\t\t\t   merge &_locn_   (in=one) \n");
        sb.append("\t\t\t         &_target_ (keep= \n");
        sb.append("\t\t\t\t%DO _J_=1 %TO &_BYVARCOUNT_;\n");
        sb.append("\t      \t\t\tUC_%scan(&_byvars_, &_J_)\n");
        sb.append("\t\t    \t%END;\n");
        sb.append("\n");
        sb.append("  \t\t\t  &_idvar_ RENAME=(&_idvar_=tgt&_idvar_));\n");
        sb.append("\t\t\t   by \t\t  \t\n");
        sb.append("\t\t\t\t%DO _J_=1 %TO &_BYVARCOUNT_;\n");
        sb.append("\t\t\t\t\t%if &_case_ =F %then\n");
        sb.append("                        %do;\n");
        sb.append("\t      \t\t\t\t\tUC_%scan(&_byvars_, &_J_)\n");
        sb.append("\t\t\t\t\t\t%end;\n");
        sb.append("\t\t\t\t\t%else\n");
        sb.append("\t\t\t\t\t    %do;\n");
        sb.append("\t      \t\t\t\t\t%scan(&_byvars_, &_J_)\n");
        sb.append("\t\t\t\t\t    %end;\n");
        sb.append("\t\t    \t%END;\n");
        sb.append("\t\t\t\t;\n");
        sb.append("\n");
        sb.append("\t\t\t   if (ktrim(tgt&_idvar_) ~='') then\n");
        sb.append("\t\t\t      &_idvar_=tgt&_idvar_;\n");
        sb.append("\t\t\t   drop tgt&_idvar_;\n");
        sb.append("\t\t  \t%END;\n");
        sb.append("\t\t%else\n");
        sb.append("\t\t  \t%DO;\n");
        sb.append("\t\t\t   merge &_locn_   (in=one) \n");
        sb.append("\t\t\t         &_target_ (keep=&_byVars_ &_idvar_ RENAME=(&_idvar_=tgt&_idvar_));\n");
        sb.append("\t\t\t   by &_byVars_; \n");
        sb.append("\t\t\t   if (ktrim(tgt&_idvar_) ~='') then\n");
        sb.append("\t\t\t      &_idvar_=tgt&_idvar_;\n");
        sb.append("\t\t\t   drop tgt&_idvar_;\n");
        sb.append("\t\t  \t%END;\n");
        sb.append("\n");
        sb.append("\t     if one;\n");
        sb.append("\trun;\n");
        sb.append("%mend getIdFromTarget;\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("*  Macro to create attributes for each metadata type                        *\n");
        sb.append("*  _byvars_   = Variables on which tables are merged                        *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("%macro createAttributes();\n");
        sb.append("%if %sysfunc(exist(&dsMetaAttributes)) eq 0 %then\n");
        sb.append("%do;\n");
        sb.append("    data &dsMetaAttributes;\n");
        sb.append("     length metadatatype $60.;\n");
        sb.append("     length attributename $60.;\n");
        sb.append("    metadatatype=\"&mt_physicaltable\";\n");
        sb.append("    attributename='Name';            output;\n");
        sb.append("    attributename='Desc';            output;\n");
        sb.append("    attributename='SASTableName';    output;\n");
        sb.append("    attributename='TableName';       output;\n");
        sb.append("    attributename='DBMSType';        output;\n");
        sb.append("\n");
        sb.append("    metadatatype=\"&mt_column\";\n");
        sb.append("    attributename='Name';            output;\n");
        sb.append("    attributename='Desc';            output;\n");
        sb.append("    attributename='SASColumnName';   output;\n");
        sb.append("    attributename='SASColumnLength'; output;\n");
        sb.append("    attributename='SASColumnType';   output;\n");
        sb.append("    attributename='SASFormat' ;      output;\n");
        sb.append("    attributename='SASInformat';     output;\n");
        sb.append("    attributename='IsNullable';      output;\n");
        sb.append("    attributename='ColOrder';        output;\n");
        sb.append("\n");
        sb.append("    metadatatype=\"&mt_index\";\n");
        sb.append("    attributename='Name';            output;\n");
        sb.append("    attributename='Desc';            output;\n");
        sb.append("    attributename='IsClustered';     output;\n");
        sb.append("    attributename='IndexName';       output;\n");
        sb.append("    attributename='IsNoMiss';        output;\n");
        sb.append("    attributename='IsUnique';        output;\n");
        sb.append("\n");
        sb.append("    metadatatype=\"&mt_uniquekeys\";\n");
        sb.append("    attributename='Name';            output;\n");
        sb.append("    attributename='Desc';            output;\n");
        sb.append("    attributename='IsPrimary';       output;\n");
        sb.append("\n");
        sb.append("    metadatatype=\"&mt_foreignkeys\";\n");
        sb.append("    attributename='Name';            output;\n");
        sb.append("    attributename='Desc';            output;\n");
        sb.append("\n");
        sb.append("    metadatatype=\"&mt_keyassociation\";\n");
        sb.append("    attributename='Name';            output;\n");
        sb.append("    attributename='Desc';            output;\n");
        sb.append(" ;\n");
        sb.append(" run;\n");
        sb.append(" %end;\n");
        sb.append("%mend createAttributes;\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("*  Read attributes and store into a macro variable for each metadata type   *\n");
        sb.append("*  _type_   = Metadata type                                                 *\n");
        sb.append("*  _var_    = macro variable to store attributes into                       *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("%macro readAttributes(_type_, _var_);\n");
        sb.append(" %let list=;\n");
        sb.append("    data _null_;\n");
        sb.append(" %global &_var_;\n");
        sb.append("    length allvars $1000;\n");
        sb.append("    retain allvars ' ';\n");
        sb.append("    set &dsMetaAttributes(where=(metadatatype=\"&_type_\")) end=LastRecord ;\n");
        sb.append("        allvars = trim(left(allvars)) || ' ' || left(attributename);\n");
        sb.append("    if lastrecord then call symput(\"&_var_\", allvars);\n");
        sb.append("    run;\n");
        sb.append("%mend readAttributes;\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("*  Create and read attributes                                               *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("%macro attributes();\n");
        sb.append(" %createAttributes;\n");
        sb.append(" %readAttributes(&mt_physicaltable, &mt_physicaltable.list);\n");
        sb.append(" %readAttributes(&mt_column, &mt_column.list);\n");
        sb.append(" %readAttributes(&mt_index, &mt_index.list);\n");
        sb.append(" %readAttributes(&mt_uniquekeys, &mt_uniquekeys.list);\n");
        sb.append(" %readAttributes(&mt_foreignkeys, &mt_foreignkeys.list);\n");
        sb.append(" %readAttributes(&mt_keyassociation, &mt_keyassociation.list);\n");
        sb.append("%mend attributes;\n");
        sb.append("\n");
        sb.append("%attributes;\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("*  Macro to create differences in attributes                                *\n");
        sb.append("*  _attributes_  = Attributes on which to check differences                 *\n");
        sb.append("*  _source_   = dataset consisting of source objects                  *\n");
        sb.append("*  _target_   = dataset consisting of target objects                  *\n");
        sb.append("*  _diffs_    = dataset identifying differences in Objects S, T, B          *\n");
        sb.append("*  _dout_     = dataset output as a result of comparison              *\n");
        sb.append("*  _keepvars_ = variables to keep in resultant dataset                *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("%macro DifferencesInAttributes(_attributes_, _source_, _target_, _diffs_, _dout_, _keepvars_, _case_=&caseSensitive );\n");
        sb.append("\n");
        sb.append(" %LOCAL _J_ _ATTRCOUNT_;\n");
        sb.append("\n");
        sb.append(" /*** determine number of SAS variables in _attributes_ ***/\n");
        sb.append(" %let _ATTRCOUNT_ = %eval( 1 + (%length(%sysfunc(compbl(&_attributes_)))  -\n");
        sb.append("                          %length(%sysfunc(compress(&_attributes_)))));\n");
        sb.append("\n");
        sb.append("\n");
        sb.append(" /* Must be sorted in this order or else Row order is different from field */\n");
        sb.append(" proc sort data=&_source_;\n");
        sb.append("       by sourcerow;\n");
        sb.append("    run;\n");
        sb.append("\n");
        sb.append(" /* Must be sorted in this order or else Row order is different from field */\n");
        sb.append(" proc sort data=&_target_;\n");
        sb.append("       by targetrow;\n");
        sb.append("    run;\n");
        sb.append("\n");
        sb.append("\n");
        sb.append(" data &_dout_ (keep=attribute SourceRow TargetRow &_keepvars_);\n");
        sb.append(" Length attribute $32.;\n");
        sb.append("\n");
        sb.append(" set &_diffs_ (keep=code sourceRow targetRow );\n");
        sb.append("\n");
        sb.append(" pointSrcRow=sourceRow;\n");
        sb.append(" pointTgtRow=targetRow;\n");
        sb.append("\n");
        sb.append(" /* Get attributes from source and target.  Compare each attribute and output as a separate row */\n");
        sb.append(" if code=\"&both\";\n");
        sb.append("       set &_source_ point=pointSrcRow;\n");
        sb.append("\n");
        sb.append("       %DO _J_=1 %TO &_ATTRCOUNT_;\n");
        sb.append("        %scan(&_attributes_, &_J_)s=%scan(&_attributes_, &_J_);\n");
        sb.append("    %END;\n");
        sb.append("\n");
        sb.append("    set &_target_ point=pointTgtRow;\n");
        sb.append("\n");
        sb.append("       %DO _J_=1 %TO &_ATTRCOUNT_;\n");
        sb.append("             %scan(&_attributes_, &_J_)t=%scan(&_attributes_, &_J_);\n");
        sb.append("    %END;\n");
        sb.append("\n");
        sb.append("       %DO _J_=1 %TO &_ATTRCOUNT_;\n");
        sb.append("        %if &_case_ =F %then\n");
        sb.append("                 if upcase(%scan(&_attributes_, &_J_)s) ne upcase(%scan(&_attributes_, &_J_)t) then;\n");
        sb.append("       %else\n");
        sb.append("                 if (%scan(&_attributes_, &_J_)s) ne (%scan(&_attributes_, &_J_)t) then;\n");
        sb.append("\n");
        sb.append("          do;\n");
        sb.append("          attribute=\"%scan(&_attributes_, &_J_)\" ;\n");
        sb.append("          SourceRow=pointSrcRow;\n");
        sb.append("          TargetRow=pointTgtRow;\n");
        sb.append("          output;\n");
        sb.append("       end;\n");
        sb.append(" %END;\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("run;  \n");
        sb.append("%mend DifferencesInAttributes;\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("** Call Macro to determine attributes for each metadata type                *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("\n");
        sb.append("%attributes;\n");
        sb.append("\n");
        sb.append("/****************************************************************************\n");
        sb.append("**                          DELETE DUPLICATES                               *\n");
        sb.append("*****************************************************************************/\n");
        sb.append("\n");
        sb.append("%macro deleteDuplicates(_ds_, _byvar_);\n");
        sb.append("\tproc sort data=&_ds_ NODUPKEY;\n");
        sb.append("\tby &_byvar_;\n");
        sb.append("\trun; \n");
        sb.append("%mend deleteDuplicates;\n");
        sb.append("\n");
        sb.append("/*****************************************************************************\n");
        sb.append("**                        PHYSICALTABLE                                     *\n");
        sb.append("*****************************************************************************/\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName;\n");
        sb.append("%let keepvars=table_id;\n");
        sb.append("%differences(&byvars, &mt_physicaltable, &sourceTables, &targetTables, &locnTables, &keepvars, &caseSensitive);\n");
        sb.append("\n");
        sb.append("%DifferencesInAttributes(&physicaltablelist, &sourceTables, &targetTables, &locnTables,\n");
        sb.append("                           &attrTables,&keepvars );\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("**                        COLUMN                                            *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("/* Order Number needs to be reset everytime a new tablename is encountered */\n");
        sb.append("%macro addOrder(_ds_, _var_ );\n");
        sb.append("\tproc sort data=&_ds_;\n");
        sb.append("\t   by &_var_;\n");
        sb.append("\trun;\n");
        sb.append("\tdata &_ds_;\n");
        sb.append("\tset &_ds_;\n");
        sb.append("\t\tby &_var_;\n");
        sb.append("\t    length ColOrder 4.;\n");
        sb.append("\t\tretain const;\n");
        sb.append("\t\tdrop const;\n");
        sb.append("\t\tif first.&_var_ then \n");
        sb.append("\t\t   do;\n");
        sb.append("\t\t      ColOrder=1;\n");
        sb.append("\t\t\t  const=_N_-1;\n");
        sb.append("\t\t   end;\n");
        sb.append("\t\telse\n");
        sb.append("\t\t   do;\n");
        sb.append("\t\t      ColOrder=_N_-const;\n");
        sb.append("\t \t   end;\n");
        sb.append("\n");
        sb.append("\trun;\n");
        sb.append("%mend addOrder;\n");
        sb.append("\n");
        sb.append("%addOrder(&sourceColumns, Table_ID);\n");
        sb.append("%addOrder(&targetColumns, Table_Id);\n");
        sb.append("proc datasets library=&CALibrary nolist nowarn memtype=(data view);\n");
        sb.append("   modify &ETLS&src&column&etls_tblid;\n");
        sb.append("      rename ColOrder=SrcColOrder;\n");
        sb.append("quit;\n");
        sb.append("\n");
        sb.append("proc datasets library=&CALibrary nolist nowarn memtype=(data view);\n");
        sb.append("   modify &ETLS&tgt&column&etls_tblid;\n");
        sb.append("      rename ColOrder=TgtColOrder;\n");
        sb.append("quit;\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName SASColumnName ;\n");
        sb.append("%deleteDuplicates(&sourceColumns, &byvars);\n");
        sb.append("\n");
        sb.append("%let keepvars=table_id column_id SASTableName SASColumnName SrcColOrder TgtColOrder;\n");
        sb.append("\n");
        sb.append("%differences(&byvars, &mt_column, &sourceColumns, &targetColumns, &locnColumns, &keepvars, &caseSensitive);\n");
        sb.append("\n");
        sb.append("data &locnColumns (drop=srcColOrder TgtColOrder);\n");
        sb.append("set &locnColumns;\n");
        sb.append("length ColOrder 4.;\n");
        sb.append("if srcColOrder > 0 then ColOrder = srcColOrder;\n");
        sb.append("else ColOrder = tgtColOrder;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%macro sortColumns(_case_);\n");
        sb.append(" proc sort data=&locnColumns;\n");
        sb.append("   %if &_case_ =F %then\n");
        sb.append("      by UC_SASTableName UC_SASColumnName ColOrder;\n");
        sb.append("   %else\n");
        sb.append("      by SASTableName SASColumnName ColOrder;\n");
        sb.append(" ; run;\n");
        sb.append("%mend sortColumns;\n");
        sb.append("%sortColumns(&caseSensitive);\n");
        sb.append("\n");
        sb.append("%DifferencesInAttributes(&columnList, &sourceColumns, &targetColumns, &locnColumns,\n");
        sb.append("                           &attrColumns,&keepvars );\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName ;\n");
        sb.append("%getIdFromTarget(&targetTables, &locnColumns, &byVars, &caseSensitive, table_id);\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("**                              INDEXES                                     *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("/* Must Set the order of the rows and restore the order after getting SAS Table Name */\n");
        sb.append("data &sourceIndexes;\n");
        sb.append("   set &sourceIndexes;\n");
        sb.append("   SourceRow = _N_ ;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName Name;\n");
        sb.append("%deleteDuplicates(&sourceIndexes, &byvars);\n");
        sb.append("\n");
        sb.append("/* Restore the order or Rows */\n");
        sb.append("proc sort data =&sourceIndexes;\n");
        sb.append(" by SourceRow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let keepvars=table_id index_id SASTableName IndexName;\n");
        sb.append("%let byvars=SASTableName IndexName;\n");
        sb.append("%differences(&byvars, &mt_index, &sourceIndexes, &targetIndexes, \n");
        sb.append("                &locnIndexes, &keepvars, &caseSensitive);\n");
        sb.append("\n");
        sb.append("%DifferencesInAttributes(&indexlist, &sourceIndexes, &targetIndexes, &locnIndexes,\n");
        sb.append("                           &attrIndexes,&keepvars );\n");
        sb.append("\n");
        sb.append("/*  Get table_ID from Target when available.  This is for new columns in source */\n");
        sb.append("%let byvars=SASTableName ;\n");
        sb.append("%getIdFromTarget(&targetTables, &locnIndexes, &byVars, &caseSensitive, table_id);\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("**                             UNIQUE KEYS                                  *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName Name;\n");
        sb.append("%deleteDuplicates(&sourceUniqueKeys, &byvars);\n");
        sb.append("\n");
        sb.append("%let keepvars=Table_Id UniqueKey_Id SASTableName Name;\n");
        sb.append("%differences(&byvars, &mt_UniqueKeys, &sourceUniqueKeys, &targetUniqueKeys, \n");
        sb.append("                &locnUniqueKeys, &keepvars, &caseSensitive);\n");
        sb.append("\n");
        sb.append("%DifferencesInAttributes(&uniquekeylist, &sourceUniqueKeys, &targetUniqueKeys, &locnUniqueKeys,\n");
        sb.append("                           &attrUniqueKeys,&keepvars );\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName ;\n");
        sb.append("%getIdFromTarget(&targetTables, &locnUniqueKeys, &byVars, &caseSensitive, table_id);\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("**                             FOREIGN KEYS                                 *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("/* Must Set the order of the rows and restore the order after getting SAS Table Name */\n");
        sb.append("data &sourceForeignKeys;\n");
        sb.append("   set &sourceForeignKeys (drop=SASTableName);\n");
        sb.append("   SourceRow = _N_ ;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/* If you do not drop SASTableName  merge will only get the first match */\n");
        sb.append("proc sort data =&sourceForeignKeys;\n");
        sb.append(" by table_ID;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data =&sourceTables;\n");
        sb.append(" by table_ID;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/* Get SASTablename based on Table Id */\n");
        sb.append("%macro getSASTableName(_case_);\n");
        sb.append(" data &sourceForeignKeys;\n");
        sb.append("    %if &_case_=F %then\n");
        sb.append("       %DO;\n");
        sb.append("           merge &sourceForeignKeys (in=inIndex)\n");
        sb.append("                 &sourceTables (keep=table_ID SASTableName UC_SASTableName);\n");
        sb.append("          by table_ID;\n");
        sb.append("       %END;\n");
        sb.append("    %else\n");
        sb.append("       %DO;\n");
        sb.append("           merge &sourceForeignKeys (in=inIndex)\n");
        sb.append("                 &sourceTables (keep=table_ID SASTableName );\n");
        sb.append("          by table_ID;\n");
        sb.append("       %END;\n");
        sb.append("    if inIndex;\n");
        sb.append(" run;\n");
        sb.append("%mend getSASTableName;\n");
        sb.append("%getSASTableName(&caseSensitive);\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("%macro getUniqueKeyName(_ForeignKeys_, _UniqueKeys_, _case_);\n");
        sb.append("\n");
        sb.append("    proc sort data=&_ForeignKeys_;\n");
        sb.append("\t   by UniqueKey_ID;\n");
        sb.append("    run;\n");
        sb.append("\n");
        sb.append("    proc sort data=&_UniqueKeys_;\n");
        sb.append("\t   by UniqueKey_ID;\n");
        sb.append("    run;\n");
        sb.append("\n");
        sb.append("\tdata &_ForeignKeys_;\n");
        sb.append("\n");
        sb.append("\t\t%if &_case_=F %then\n");
        sb.append("\t\t  \t%DO;\n");
        sb.append("\t\t\t    merge &_ForeignKeys_ (in=inFK drop=UniqueKey_Name)\n");
        sb.append("\t\t\t          &_UniqueKeys_ (keep=UniqueKey_ID name UC_name SASTableName \n");
        sb.append("                                       rename=(name=UniqueKey_Name SASTableName=UK_SASTableName));\n");
        sb.append("\t\t\t\tby UniqueKey_ID;\n");
        sb.append("\t\t\t\tlabel UK_SASTableName='UK_SASTableName';\n");
        sb.append("\t\t\t\tlabel UC_UK_SASTableName='UC_UK_SASTableName';\n");
        sb.append("\t\t\t\tUC_UniqueKey_Name  = upcase(UniqueKey_Name);\n");
        sb.append("\t\t\t\tUC_UK_SASTableName = upcase(UK_SASTableName);\n");
        sb.append("\t\t  \t%END;\n");
        sb.append("\t\t%else\n");
        sb.append("\t\t  \t%DO;\n");
        sb.append("\t\t\t    merge &_ForeignKeys_ (in=inFK)\n");
        sb.append("\t\t\t          &_UniqueKeys_ (keep=UniqueKey_ID name SASTableName\n");
        sb.append("                                   rename=(name=UniqueKey_Name SASTableName=UK_SASTableName));\n");
        sb.append("\t\t\t\tby UniqueKey_ID;\n");
        sb.append("\t\t\t\tlabel UK_SASTableName='UK_SASTableName';\n");
        sb.append("\t\t  \t%END;\n");
        sb.append("\t\t  if inFK;\n");
        sb.append("\trun;\n");
        sb.append("%mend getUniqueKeyName;\n");
        sb.append("%getUniqueKeyName(&sourceForeignKeys, &sourceUniqueKeys, &caseSensitive);\n");
        sb.append("%getUniqueKeyName(&targetForeignKeys, &targetUniqueKeys, &caseSensitive);\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName Name;\n");
        sb.append("%deleteDuplicates(&sourceForeignKeys, &byvars);\n");
        sb.append("\n");
        sb.append("/* Restore the order or Rows */\n");
        sb.append("proc sort data =&sourceForeignKeys;\n");
        sb.append(" by SourceRow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let keepvars=Table_Id ForeignKey_Id SASTableName Name UK_SASTableName UniqueKey_Name;\n");
        sb.append("%differences(&byvars, &mt_ForeignKeys, &sourceForeignKeys, &targetForeignKeys, \n");
        sb.append("                &locnForeignKeys, &keepvars, &caseSensitive);\n");
        sb.append("\n");
        sb.append("%DifferencesInAttributes(&foreignkeylist, &sourceForeignKeys, &targetForeignKeys, &locnForeignKeys,\n");
        sb.append("                           &attrForeignKeys, &keepvars );\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName ;\n");
        sb.append("%getIdFromTarget(&targetTables, &locnForeignKeys, &byVars, &caseSensitive, table_id);\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("**                             FOREIGNKEY/UNIQUEKEY                         *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("data &sourceForeignUnique;\n");
        sb.append("    set &sourceForeignKeys;\n");
        sb.append("\tUC_UniqueKey_Name=upcase(UniqueKey_Name);\n");
        sb.append("\tUC_UK_SASTableName=upcase(UK_SASTableName);\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("data &targetForeignUnique;\n");
        sb.append("    set &targetForeignKeys;\n");
        sb.append("\tUC_UniqueKey_Name=upcase(UniqueKey_Name);\n");
        sb.append("\tUC_UK_SASTableName=upcase(UK_SASTableName);\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName Name UK_SASTableName UniqueKey_Name;\n");
        sb.append("%deleteDuplicates(&sourceForeignUnique, &byvars);\n");
        sb.append("%let keepvars=Table_Id ForeignKey_Id UniqueKey_Id SASTableName Name UniqueKey_Name                   UC_UniqueKey_Name UK_SASTableName UC_UK_SASTableName;\n");
        sb.append("%differences(&byvars, &mt_ForeignKeys, &sourceForeignUnique, &targetForeignUnique, \n");
        sb.append("                &locnForeignUnique, &keepvars, &caseSensitive);\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName ;\n");
        sb.append("%getIdFromTarget(&targetTables, &locnForeignUnique, &byVars, &caseSensitive, table_id);\n");
        sb.append("\n");
        sb.append("data &tempCols;\n");
        sb.append("set &targetUniqueKeys (keep=UniqueKey_id SASTableName Name \n");
        sb.append("                       rename=(SASTableName=UK_SASTableName Name=UniqueKey_Name));\n");
        sb.append("   UC_UniqueKey_Name=upcase(UniqueKey_Name);\n");
        sb.append("   UC_UK_SASTableName=upcase(UK_SASTableName);\n");
        sb.append("run;\n");
        sb.append("%let byvars=UK_SASTableName UniqueKey_Name;\n");
        sb.append("%getIdFromTarget(&tempCols, &locnForeignUnique, &byVars, &caseSensitive, UniqueKey_id);\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName Name;\n");
        sb.append("%getIdFromTarget(&targetForeignKeys, &locnForeignUnique, &byVars, &caseSensitive, ForeignKey_id);\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("**                          FOREIGN KEY COLUMNS                             *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("%addOrder(&sourceForeignKeyColumns, ForeignKey_ID);\n");
        sb.append("%addOrder(&targetForeignKeyColumns, ForeignKey_ID);\n");
        sb.append("/* Must Set the order of the rows and restore the order after getting SAS Table Name */\n");
        sb.append("data &sourceForeignKeyColumns;\n");
        sb.append("   set &sourceForeignKeyColumns (drop=SASTableName);\n");
        sb.append("   SourceRow = _N_ ;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/* If you do not drop SASTableName  merge will only get the first match */\n");
        sb.append("proc sort data =&sourceForeignKeyColumns;\n");
        sb.append(" by table_ID;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data =&sourceTables;\n");
        sb.append(" by table_ID;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/* Get SASTablename based on Table Id */\n");
        sb.append("%macro getSASTableName(_case_);\n");
        sb.append(" data &sourceForeignKeyColumns;\n");
        sb.append("    %if &_case_=F %then\n");
        sb.append("       %DO;\n");
        sb.append("           merge &sourceForeignKeyColumns (in=inIndex)\n");
        sb.append("                 &sourceTables (keep=table_ID SASTableName UC_SASTableName);\n");
        sb.append("          by table_ID;\n");
        sb.append("       %END;\n");
        sb.append("    %else\n");
        sb.append("       %DO;\n");
        sb.append("           merge &sourceForeignKeyColumns (in=inIndex)\n");
        sb.append("                 &sourceTables (keep=table_ID SASTableName );\n");
        sb.append("          by table_ID;\n");
        sb.append("       %END;\n");
        sb.append("    if inIndex;\n");
        sb.append(" run;\n");
        sb.append("%mend getSASTableName;\n");
        sb.append("%getSASTableName(&caseSensitive);\n");
        sb.append("\n");
        sb.append("proc sort data=&sourceForeignKeyColumns;\n");
        sb.append("   by Column_Id;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/* Should sort into a different dataset and drop it */\n");
        sb.append("proc sort data=&sourceColumns out=&tempCols;\n");
        sb.append("   by Column_Id;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/*  Get SASColumnName.  Keep only records found in sourceForeignKeyColumns */\n");
        sb.append("%macro getSASColumnNameForFK(_case_);\n");
        sb.append(" data &sourceForeignKeyColumns;\n");
        sb.append("    %if &_case_ =F %then\n");
        sb.append("       %DO;\n");
        sb.append("          merge &sourceForeignKeyColumns (drop=SASColumnName in=one) \n");
        sb.append("                &tempCols (keep=Column_id SASColumnName UC_SASColumnName );\n");
        sb.append("          by Column_Id;\n");
        sb.append("          if one;\n");
        sb.append("\n");
        sb.append("       %END;\n");
        sb.append("    %else\n");
        sb.append("       %DO;\n");
        sb.append("          merge &sourceForeignKeyColumns (drop=SASColumnName in=one) \n");
        sb.append("                &tempCols (keep=Column_id SASColumnName );\n");
        sb.append("          by Column_Id;\n");
        sb.append("          if one;\n");
        sb.append("\n");
        sb.append("       %END;\n");
        sb.append("\n");
        sb.append(" run;\n");
        sb.append("%mend getSASColumnNameForFK;\n");
        sb.append("%getSASColumnNameForFK(&caseSensitive);\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName SASColumnName ForeignKey_Name;\n");
        sb.append("%deleteDuplicates(&sourceForeignKeyColumns, &byvars);\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName SASColumnName ForeignKey_Name ColOrder;\n");
        sb.append("%let keepvars=Table_Id Column_Id ForeignKey_Id SASTableName SASColumnName ForeignKey_Name ColOrder;\n");
        sb.append("%differences(&byvars, &mt_ForeignKeyColumn, &sourceForeignKeyColumns, \n");
        sb.append("                &targetForeignKeyColumns, &locnForeignKeyColumns, &keepvars, &caseSensitive);\n");
        sb.append("\n");
        sb.append("/*  Get table_ID from Target when available.  This is for new indexes in source */\n");
        sb.append("%let byvars=SASTableName ;\n");
        sb.append("%getIdFromTarget(&targetTables, &locnForeignKeyColumns, &byVars, &caseSensitive, table_id);\n");
        sb.append("%let byvars=SASTableName SASColumnName;\n");
        sb.append("%getIdFromTarget(&targetColumns, &locnForeignKeyColumns, &byVars, &caseSensitive, column_id);\n");
        sb.append("data &tempCols (keep=ForeignKey_Id SASTableName UC_SASTableName UC_ForeignKey_Name ForeignKey_Name) ;\n");
        sb.append("   set &targetForeignKeys (rename=(Name=ForeignKey_Name));\n");
        sb.append("   UC_ForeignKey_Name=upcase(ForeignKey_Name);\n");
        sb.append("   UC_SASTableName=upcase(SASTableName);\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName ForeignKey_Name ;\n");
        sb.append("%getIdFromTarget(&tempCols, &locnForeignKeyColumns, &byVars, &caseSensitive, ForeignKey_id);\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("**                          UNIQUE KEY COLUMNS                             *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("%addOrder(&sourceUniqueKeyColumns, UniqueKey_ID);\n");
        sb.append("%addOrder(&targetUniqueKeyColumns, UniqueKey_ID);\n");
        sb.append("proc sort data=&sourceUniqueKeyColumns;\n");
        sb.append("   by Column_Id;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/* Should sort into a different dataset and drop it */\n");
        sb.append("proc sort data=&sourceColumns out=&tempCols;\n");
        sb.append("   by Column_Id;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/*  Keep only records found in sourceUniqueKeyColumns */\n");
        sb.append("%macro getSASColumnNameForUK(_case_);\n");
        sb.append("data &sourceUniqueKeyColumns;\n");
        sb.append("\n");
        sb.append(" %if &_case_ =F %then\n");
        sb.append("    %DO;\n");
        sb.append("       merge &sourceUniqueKeyColumns (drop=SASColumnName in=one) \n");
        sb.append("             &tempCols (keep=Column_id SASColumnName UC_SASColumnName);\n");
        sb.append("       by Column_Id;\n");
        sb.append("       if one;\n");
        sb.append("    %END;\n");
        sb.append(" %else\n");
        sb.append("    %DO;\n");
        sb.append("       merge &sourceUniqueKeyColumns (drop=SASColumnName in=one) \n");
        sb.append("             &tempCols (keep=Column_id SASColumnName );\n");
        sb.append("       by Column_Id;\n");
        sb.append("       if one;\n");
        sb.append("    %END;\n");
        sb.append("\n");
        sb.append("run;\n");
        sb.append("%mend getSASColumnNameForUK;\n");
        sb.append("%getSASColumnNameForUK(&caseSensitive);\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName SASColumnName UniqueKey_Name;\n");
        sb.append("%deleteDuplicates(&sourceUniqueKeyColumns, &byvars);\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName SASColumnName UniqueKey_Name ColOrder;\n");
        sb.append("%let keepvars=Table_Id Column_Id UniqueKey_Id SASTableName SASColumnName UniqueKey_Name ColOrder;\n");
        sb.append("%differences(&byvars, &mt_UniqueKeyColumn, &sourceUniqueKeyColumns, \n");
        sb.append("              &targetUniqueKeyColumns, &locnUniqueKeyColumns, &keepvars, &caseSensitive);\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("/*  Get table_ID from Target when available.  This is for new indexes in source */\n");
        sb.append("%let byvars=SASTableName ;\n");
        sb.append("%getIdFromTarget(&targetTables, &locnUniqueKeyColumns, &byVars, &caseSensitive, table_id);\n");
        sb.append("%let byvars=SASTableName SASColumnName;\n");
        sb.append("%getIdFromTarget(&targetColumns, &locnUniqueKeyColumns, &byVars, &caseSensitive, column_id);\n");
        sb.append("data &tempCols (keep=UniqueKey_Id SASTableName UC_SASTableName UC_UniqueKey_Name UniqueKey_Name) ;\n");
        sb.append("   set &targetUniqueKeys (rename=(Name=UniqueKey_Name));\n");
        sb.append("   UC_UniqueKey_Name=upcase(UniqueKey_Name);\n");
        sb.append("   UC_SASTableName=upcase(SASTableName);\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName UniqueKey_Name ;\n");
        sb.append("%getIdFromTarget(&tempCols, &locnUniqueKeyColumns, &byVars, &caseSensitive, UniqueKey_id);\n");
        sb.append("\n");
        sb.append("/*\n");
        sb.append("*****************************************************************************\n");
        sb.append("**                            INDEX KEY COLUMNS                             *\n");
        sb.append("*****************************************************************************\n");
        sb.append("*/\n");
        sb.append("\n");
        sb.append("%addOrder(&sourceIndexColumns, Index_ID);\n");
        sb.append("%addOrder(&targetIndexColumns, Index_ID);\n");
        sb.append("/*  Get SASTableName */\n");
        sb.append("proc sort data=&sourceIndexColumns;\n");
        sb.append("by table_ID;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/* Should sort into a different dataset and drop it */\n");
        sb.append("proc sort data=&sourceTables out=&tempCols;\n");
        sb.append("by table_ID;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/*  Keep only records found in sourceIndexColumns */\n");
        sb.append("\n");
        sb.append("%macro getSASTableNameForIndexes(_case_);\n");
        sb.append(" data &sourceIndexColumns;\n");
        sb.append("\n");
        sb.append("    %if &_case_ =F %then\n");
        sb.append("       %DO;\n");
        sb.append("          merge &sourceIndexColumns (drop=SASTableName in=one) \n");
        sb.append("                &tempCols (keep=table_ID SASTableName UC_SASTableName );\n");
        sb.append("          by table_ID;\n");
        sb.append("          if one;\n");
        sb.append("       %END;\n");
        sb.append("    %else\n");
        sb.append("       %DO;\n");
        sb.append("          merge &sourceIndexColumns (drop=SASTableName in=one) \n");
        sb.append("                &tempCols (keep=table_ID SASTableName );\n");
        sb.append("          by table_ID;\n");
        sb.append("          if one;\n");
        sb.append("       %END;\n");
        sb.append("\n");
        sb.append(" run;\n");
        sb.append("%mend getSASTableNameForIndexes;\n");
        sb.append("%getSASTableNameForIndexes(&caseSensitive);\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("/*  Get SASColumnName */\n");
        sb.append("proc sort data=&sourceIndexColumns;\n");
        sb.append(" by Column_Id;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/* Should sort into a different dataset and drop it */\n");
        sb.append("proc sort data=&sourceColumns out=&tempCols;\n");
        sb.append(" by Column_Id;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/*  Keep only records found in sourceIndexColumns */\n");
        sb.append("%macro getSASColumnNameForIndexes(_case_);\n");
        sb.append(" data &sourceIndexColumns;\n");
        sb.append("    %if &_case_ =F %then\n");
        sb.append("       %DO;\n");
        sb.append("          merge &sourceIndexColumns (drop=SASColumnName in=one) \n");
        sb.append("              &tempCols (keep=Column_id SASColumnName UC_SASColumnName);\n");
        sb.append("          by Column_Id;\n");
        sb.append("          if one;\n");
        sb.append("       %END;\n");
        sb.append("    %else\n");
        sb.append("       %DO;\n");
        sb.append("          merge &sourceIndexColumns (drop=SASColumnName in=one) \n");
        sb.append("              &tempCols (keep=Column_id SASColumnName );\n");
        sb.append("          by Column_Id;\n");
        sb.append("          if one;\n");
        sb.append("       %END;\n");
        sb.append(" run;\n");
        sb.append("%mend getSASColumnNameForIndexes;\n");
        sb.append("%getSASColumnNameForIndexes(&caseSensitive);\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName SASColumnName Name;\n");
        sb.append("%deleteDuplicates(&sourceIndexColumns, &byvars);\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName SASColumnName IndexName ColOrder ;\n");
        sb.append("%let keepvars=Table_Id  Column_Id Index_Id  SASTableName SASColumnName IndexName ColOrder ;\n");
        sb.append("%differences(&byvars, &mt_IndexColumn, &sourceIndexColumns, \n");
        sb.append("              &targetIndexColumns, &locnIndexColumns, &keepvars, &caseSensitive);\n");
        sb.append("\n");
        sb.append("/*  Get table_ID from Target when available.  This is for new indexes in source */\n");
        sb.append("%let byvars=SASTableName ;\n");
        sb.append("%getIdFromTarget(&targetTables, &locnIndexColumns, &byVars, &caseSensitive, table_id);\n");
        sb.append("%let byvars=SASTableName SASColumnName;\n");
        sb.append("%getIdFromTarget(&targetColumns, &locnIndexColumns, &byVars, &caseSensitive, column_id);\n");
        sb.append("%let byvars=SASTableName IndexName ;\n");
        sb.append("%getIdFromTarget(&targetIndexes, &locnIndexColumns, &byVars, &caseSensitive, index_id);\n");
        sb.append("\n");
        sb.append("/****************************************************************************\n");
        sb.append("**                            KEY ASSOCIATION                             *\n");
        sb.append("****************************************************************************/\n");
        sb.append("/*  Get SASColumnName */\n");
        sb.append("proc sort data=&sourceKeyAssociation;\n");
        sb.append("\tby UniqueKeyColumn_Id;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/*  Keep only records found in sourceKeyAssociation */\n");
        sb.append("%macro getSASColumnNameForKeyAssn1(_case_);\n");
        sb.append("\tdata &sourceKeyAssociation;\n");
        sb.append("\t\t%if &_case_ =F %then\n");
        sb.append("\t\t  \t%DO;\n");
        sb.append("\t\t\t   merge &sourceKeyAssociation (drop=UK_SASColumnName in=one ) \n");
        sb.append("\t\t\t\t\t &tempCols (keep=SASTableName UC_SASTableName Column_Id SASColumnName UC_SASColumnName \n");
        sb.append("                                            rename=(column_Id=UniqueKeyColumn_Id\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t        SASColumnName=UK_SASColumnName\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t\t\tUC_SASColumnName=UC_UK_SASColumnName\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t\t\tSASTableName=UK_SASTableName\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t\t\tUC_SASTableName=UC_UK_SASTableName\n");
        sb.append("                                            ));\n");
        sb.append("\t\t\t   by UniqueKeyColumn_Id;\n");
        sb.append("\t\t\t   if one;\n");
        sb.append("\t\t  \t%END;\n");
        sb.append("\t\t%else\n");
        sb.append("\t\t  \t%DO;\n");
        sb.append("\t\t\t   merge &sourceKeyAssociation (drop=UK_SASColumnName in=one) \n");
        sb.append("\t\t\t\t\t &tempCols (keep=SASTableName Column_Id SASColumnName  rename=(column_Id=UniqueKeyColumn_Id\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t        SASColumnName=UK_SASColumnName\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t\t\tSASTableName=UK_SASTableName\n");
        sb.append("                                            ));\n");
        sb.append("\t\t\t   by UniqueKeyColumn_Id;\n");
        sb.append("\t\t\t   if one;\n");
        sb.append("\t\t  \t%END;\n");
        sb.append("\trun;\n");
        sb.append("%mend getSASColumnNameForKeyAssn1;\n");
        sb.append("%getSASColumnNameForKeyAssn1(&caseSensitive);\n");
        sb.append("\n");
        sb.append("/*  Get SASColumnName */\n");
        sb.append("proc sort data=&sourceKeyAssociation;\n");
        sb.append("\tby ForeignKeyColumn_Id;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/*  Keep only records found in sourceKeyAssociation */\n");
        sb.append("%macro getSASColumnNameForKeyAssn2(_case_);\n");
        sb.append("\tdata &sourceKeyAssociation;\n");
        sb.append("\t\t%if &_case_ =F %then\n");
        sb.append("\t\t  \t%DO;\n");
        sb.append("\t\t\t   merge &sourceKeyAssociation (drop=FK_SASColumnName  Table_ID SASTableName in=one ) \n");
        sb.append("\t\t\t\t\t &tempCols (keep=Table_ID SASTableName UC_SASTableName Column_Id SASColumnName UC_SASColumnName \n");
        sb.append("                                            rename=(column_Id=ForeignKeyColumn_Id\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t        SASColumnName=FK_SASColumnName\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t\t\tUC_SASColumnName=UC_FK_SASColumnName\n");
        sb.append("                                            ));\n");
        sb.append("\t\t\t   by ForeignKeyColumn_Id;\n");
        sb.append("\t\t\t   if one;\n");
        sb.append("\t\t  \t%END;\n");
        sb.append("\t\t%else\n");
        sb.append("\t\t  \t%DO;\n");
        sb.append("\t\t\t   merge &sourceKeyAssociation (drop=FK_SASColumnName Table_ID SASTableName in=one) \n");
        sb.append("\t\t\t\t\t &tempCols (keep=Table_ID SASTableName Column_Id SASColumnName  rename=(column_Id=ForeignKeyColumn_Id\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t        SASColumnName=FK_SASColumnName\n");
        sb.append("                                            ));\n");
        sb.append("\t\t\t   by ForeignKeyColumn_Id;\n");
        sb.append("\t\t\t   if one;\n");
        sb.append("\t\t  \t%END;\n");
        sb.append("\trun;\n");
        sb.append("%mend getSASColumnNameForKeyAssn2;\n");
        sb.append("%getSASColumnNameForKeyAssn2(&caseSensitive);\n");
        sb.append("\n");
        sb.append("proc sort data=&targetColumns out=&tempCols;\n");
        sb.append("\tby Column_Id;\n");
        sb.append("run;\n");
        sb.append("proc sort data=&targetKeyAssociation;\n");
        sb.append("\tby UniqueKeyColumn_Id;\n");
        sb.append("run;\n");
        sb.append("proc sort data=&sourceKeyAssociation;\n");
        sb.append("\tby UniqueKeyColumn_Id;\n");
        sb.append("run;\n");
        sb.append("%macro getUniqueKeyTableName(_case_);\n");
        sb.append("\tdata &targetKeyAssociation;\n");
        sb.append("\t\t%if &_case_ =F %then\n");
        sb.append("\t\t  \t%DO;\n");
        sb.append("\t\t\t   merge &targetKeyAssociation (drop=UK_SASColumnName in=one ) \n");
        sb.append("\t\t\t\t\t &tempCols (keep=SASTableName UC_SASTableName Column_Id SASColumnName UC_SASColumnName \n");
        sb.append("                                            rename=(column_Id=UniqueKeyColumn_Id\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t        SASColumnName=UK_SASColumnName\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t\t\tUC_SASColumnName=UC_UK_SASColumnName\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t\t\tSASTableName=UK_SASTableName\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t\t\tUC_SASTableName=UC_UK_SASTableName\n");
        sb.append("                                            ));\n");
        sb.append("\t\t\t   by UniqueKeyColumn_Id;\n");
        sb.append("\t\t\t   if one;\n");
        sb.append("\t\t  \t%END;\n");
        sb.append("\t\t%else\n");
        sb.append("\t\t  \t%DO;\n");
        sb.append("\t\t\t   merge &targetKeyAssociation (drop=UK_SASColumnName in=one) \n");
        sb.append("\t\t\t\t\t &tempCols (keep=SASTableName Column_Id SASColumnName  rename=(column_Id=UniqueKeyColumn_Id\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t        SASColumnName=UK_SASColumnName\n");
        sb.append("\t\t\t\t\t\t\t\t\t\t\t\t\tSASTableName=UK_SASTableName\n");
        sb.append("                                            ));\n");
        sb.append("\t\t\t   by UniqueKeyColumn_Id;\n");
        sb.append("\t\t\t   if one;\n");
        sb.append("\t\t  \t%END;\n");
        sb.append("\trun;\n");
        sb.append("%mend getUniqueKeyTableName;\n");
        sb.append("%getUniqueKeyTableName(&caseSensitive);\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName Name ForeignKey_Name UK_SASColumnName FK_SASColumnName UK_SASTableName;\n");
        sb.append("%deleteDuplicates(&sourceKeyAssociation, &byvars);\n");
        sb.append("\n");
        sb.append("%let keepvars=KeyAssociation_ID ForeignKey_Id UniqueKeyColumn_Id ForeignKeyColumn_Id \n");
        sb.append("              ForeignKey_Name UK_SASTableName UK_SASColumnName FK_SASColumnName SASTableName;\n");
        sb.append("\n");
        sb.append("%differences(&byvars, &mt_keyassociation, &sourceKeyAssociation, \n");
        sb.append("              &targetKeyAssociation, &locnKeyAssociation, &keepvars, &caseSensitive);\n");
        sb.append("\n");
        sb.append("%DifferencesInAttributes(&keyassociationlist, &sourceKeyAssociation, &targetKeyAssociation, &locnKeyAssociation,\n");
        sb.append("                           &attrKeyAssociation, &keepvars );\n");
        sb.append("\n");
        sb.append("data &tempCols (rename=(SASColumnName=FK_SASColumnName Column_Id=ForeignKeyColumn_Id)\n");
        sb.append("                keep=SASColumnName Column_Id UC_FK_SASColumnName SASTableName UC_SASTableName UC_FK_SASColumnName) ;\n");
        sb.append("   set &targetColumns;\n");
        sb.append("   UC_FK_SASColumnName=upcase(SASColumnName);\n");
        sb.append("   UC_SASTableName=upcase(SASTableName);\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let byvars=SASTableName FK_SASColumnName;\n");
        sb.append("%getIdFromTarget(&tempCols, &locnKeyAssociation, &byVars, &caseSensitive, ForeignKeyColumn_id);\n");
        sb.append("\n");
        sb.append("data &tempCols (rename=(FK_SASColumnName=UK_SASColumnName ForeignKeyColumn_Id=UniqueKeyColumn_Id\n");
        sb.append("                UC_FK_SASColumnName=UC_UK_SASColumnName UC_SASTableName=UC_UK_SASTableName\n");
        sb.append("                SASTableName=UK_SASTableName  ));\n");
        sb.append("   set &tempCols;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let byvars=UK_SASTableName UK_SASColumnName ;\n");
        sb.append("%getIdFromTarget(&tempCols, &locnKeyAssociation, &byVars, &caseSensitive, UniqueKeyColumn_id);\n");
        sb.append("\n");
        sb.append("/* Name &tempcols is being used for convenience even though the table is Foreign Keys */\n");
        sb.append("data &tempCols;\n");
        sb.append("   set &targetForeignKeys(rename=(Name=ForeignKey_Name));\n");
        sb.append("   UC_ForeignKey_Name=upcase(ForeignKey_Name);\n");
        sb.append("   UC_SASTableName=upcase(SASTableName);\n");
        sb.append("run;\n");
        sb.append("%let byvars=SASTableName ForeignKey_Name ;\n");
        sb.append("%getIdFromTarget(&tempCols, &locnKeyAssociation, &byVars, &caseSensitive, ForeignKey_id);\n");
        sb.append("\n");
        sb.append("/************************* END KEY ASSOCIATION *****************************/\n");
        sb.append("\n");
        sb.append("%macro NewAndDeletedObjects(_dsin_, _dsout_, _keepvar_,_chgReason_, _metadataType_ );\n");
        sb.append(" data &_dsout_ (keep=&_keepvar_ changeReason metadatatype);\n");
        sb.append("     Length changeReason $30;\n");
        sb.append("     Length metadataType $60;\n");
        sb.append("     set &_dsin_ (keep=&_keepvar_ code where=(code=\"&source\" or code=\"&target\"));\n");
        sb.append("    changeReason=\"&_chgReason_\";\n");
        sb.append("    metadataType=\"&_metadataType_\";\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append("%mend  NewAndDeletedObjects;\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("%macro ObjectAttributesChanged(_STB_, _diffAtts_, _dsout_, _var1_, _chgReason_, _metadataType_ );\n");
        sb.append(" %let temp1=etls_tmp1;\n");
        sb.append("\n");
        sb.append(" * Table ids for attribute changes;\n");
        sb.append(" proc sql;\n");
        sb.append(" create table work.&temp1 as\n");
        sb.append(" select a.&_var1_, \n");
        sb.append("        \"&_chgReason_\" as changeReason length=30,\n");
        sb.append("        \"&_metadataType_\" as metadataType length=60\n");
        sb.append("     from &_STB_ as a, &_diffAtts_ as b\n");
        sb.append("    where a.code=\"&both\"\n");
        sb.append("    and   a.&_var1_=b.&_var1_;\n");
        sb.append(" quit;\n");
        sb.append("\n");
        sb.append(" proc append base=&_dsout_ data=work.&temp1;\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" proc datasets library=work nolist;\n");
        sb.append("   Delete  &temp1;\n");
        sb.append(" quit;\n");
        sb.append("\n");
        sb.append("%mend ObjectAttributesChanged;\n");
        sb.append("\n");
        sb.append("/* Get table_ID for those records that are either in Source or Target but not in both */\n");
        sb.append("%macro NewDeletedAssociatedObjects(_STB_, _dsout_, _var1_, _chgReason_, _metadataType_ );\n");
        sb.append("\n");
        sb.append(" %let temp1=etls_tmp1;\n");
        sb.append("\n");
        sb.append(" data work.&temp1 (keep=&_var1_ changeReason metadataType);\n");
        sb.append("      Length changeReason $30;\n");
        sb.append("   Length metadataType $60;\n");
        sb.append("   set &_STB_ (keep=&_var1_ code);\n");
        sb.append("   if (code =\"&source\" or code=\"&target\" );\n");
        sb.append("   retain changeReason \"&_chgReason_\";\n");
        sb.append("      retain metadataType \"&_metadataType_\";\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" proc append base=&_dsout_ data=work.&temp1;\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" proc datasets library=work nolist;\n");
        sb.append("   delete  &temp1;\n");
        sb.append(" quit;\n");
        sb.append("\n");
        sb.append("%mend  NewDeletedAssociatedObjects;\n");
        sb.append("\n");
        sb.append("%macro AssocObjectsAttsChanged(_STB_, _diffAtts_, _dsout_, _var1_, _var2_, _chgReason_, _metadataType_ );\n");
        sb.append("\n");
        sb.append(" %let temp1=etls_tmp1;\n");
        sb.append("\n");
        sb.append(" /* Sort Column Attributes by Colum Id */\n");
        sb.append(" proc sort data=&_diffAtts_ out=&_diffAtts_;\n");
        sb.append("   by &_var2_;\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" /* Sort Differences in Columns by Id.  */\n");
        sb.append(" proc sort data=&_STB_ out=&_STB_;\n");
        sb.append("    by &_var2_;\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" /* Gets Column Ids for those columns that are in both source and column and attributes are different */\n");
        sb.append(" data work.&temp1 (keep=&_var1_ changeReason metadataType);\n");
        sb.append("      Length changeReason $30;\n");
        sb.append("   Length metadataType $60;\n");
        sb.append("   merge &_diffAtts_ (keep=&_var1_ &_var2_ in=one) \n");
        sb.append("         &_STB_    (keep=&_var1_ &_var2_ in=two);\n");
        sb.append("   by &_var2_;\n");
        sb.append("   if one and two;\n");
        sb.append("   changeReason=\"&_chgReason_\";\n");
        sb.append("      metadataType=\"&_metadataType_\";\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" proc append base=&_dsout_ data=work.&temp1;\n");
        sb.append(" run;\n");
        sb.append("\n");
        sb.append(" proc datasets library=work nolist;\n");
        sb.append("   delete  &temp1;\n");
        sb.append(" quit;\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("%mend AssocObjectsAttsChanged;\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       New TABLE or TABLE Attributes Changed?\n");
        sb.append("************************************************************************/\n");
        sb.append("%let chgReason=Table - Add Delete;\n");
        sb.append("%NewAndDeletedObjects(&locnTables, &chngTables, table_id, &chgReason, &mt_physicaltable);\n");
        sb.append("%let chgReason=Table - Attribute Change;\n");
        sb.append("%ObjectAttributesChanged(&locnTables, &attrTables, &chngTables, table_id, &chgReason, &mt_physicaltable);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       New COLUMN or COLUMN Attributes Changed?\n");
        sb.append("************************************************************************/\n");
        sb.append("%let chgReason=Column - Add Delete;\n");
        sb.append("%NewAndDeletedObjects(&locnColumns, &chngColumns, column_id, &chgReason, &mt_column);\n");
        sb.append("%let chgReason=Column - Attribute Change;\n");
        sb.append("%ObjectAttributesChanged(&locnColumns, &attrColumns, &chngColumns, column_id, &chgReason, &mt_column);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       New INDEX or INDEX Attributes Changed?\n");
        sb.append("************************************************************************/\n");
        sb.append("%let chgReason=Index - Add Delete;\n");
        sb.append("%NewAndDeletedObjects(&locnIndexes, &chngIndexes, Index_id, &chgReason, &mt_index);\n");
        sb.append("%let chgReason=Index - Attribute Change;\n");
        sb.append("%ObjectAttributesChanged(&locnIndexes, &attrIndexes, &chngIndexes, Index_id, &chgReason, &mt_index);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       New UNIQUEKEY or UNIQUEKEY Attributes Changed?\n");
        sb.append("************************************************************************/\n");
        sb.append("%let chgReason=UniqueKey - Add Delete;\n");
        sb.append("%NewAndDeletedObjects(&locnUniqueKeys, &chngUniqueKeys, UniqueKey_id, &chgReason, &mt_uniquekeys);\n");
        sb.append("%let chgReason=UniqueKey - Attribute Change;\n");
        sb.append("%ObjectAttributesChanged(&locnUniqueKeys, &attrUniqueKeys, &chngUniqueKeys, UniqueKey_id, &chgReason, &mt_uniquekeys);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       New FOREIGNKEY or FOREIGNKEY Attributes Changed?\n");
        sb.append("************************************************************************/\n");
        sb.append("%let chgReason=ForeignKey - Add Delete;\n");
        sb.append("%NewAndDeletedObjects(&locnForeignKeys, &chngForeignKeys, ForeignKey_id, &chgReason, &mt_foreignkeys);\n");
        sb.append("%let chgReason=ForeignKey - Attribute Change;\n");
        sb.append("%ObjectAttributesChanged(&locnForeignKeys, &attrForeignKeys, &chngForeignKeys, ForeignKey_id, &chgReason, &mt_foreignkeys);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       New KEYASSOCIATION or KEYASSOCIATION Attributes Changed?\n");
        sb.append("************************************************************************/\n");
        sb.append("%let chgReason=KeyAssociation - Add Delete;\n");
        sb.append("%NewAndDeletedObjects(&locnKeyAssociation, &chngKeyAssociation, KeyAssociation_id, &chgReason, &mt_KeyAssociation);\n");
        sb.append("%let chgReason=KeyAssociation - Attribute Change;\n");
        sb.append("%ObjectAttributesChanged(&locnKeyAssociation, &attrKeyAssociation, &chngKeyAssociation, KeyAssociation_id, &chgReason, &mt_KeyAssociation);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("  New INDEXKEYCOLUMN - IF CODE='S' OR 'T' IN LIDXC (NO ATTRIBUTES)\n");
        sb.append("************************************************************************/\n");
        sb.append("%let chgReason=IndexColumn - Add Delete;\n");
        sb.append("%NewAndDeletedObjects(&locnIndexColumns, &chngIndexColumns, Index_id, &chgReason, &mt_Column);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("  New UNIQUEKEYCOLUMN - IF CODE='S' OR 'T' IN LUQKY (NO ATTRIBUTES)\n");
        sb.append("************************************************************************/\n");
        sb.append("%let chgReason=UniqueKeyColumn - Add Delete;\n");
        sb.append("%NewAndDeletedObjects(&locnUniqueKeyColumns, &chngUniqueKeyColumns, UniqueKey_id, &chgReason, &mt_Column);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("  New FOREIGNKEYCOLUMN - IF CODE='S' OR 'T' IN LFKYC (NO ATTRIBUTES)\n");
        sb.append("************************************************************************/\n");
        sb.append("%let chgReason=ForeignKeyColumn - Add Delete;\n");
        sb.append("%NewAndDeletedObjects(&locnForeignKeyColumns, &chngForeignKeyColumns, ForeignKey_id, &chgReason, &mt_Column);\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       INDEX ASSOCIATIONS CHANGED?\n");
        sb.append("************************************************************************/\n");
        sb.append("\n");
        sb.append("%let chgReason=Index Columns Chg;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnIndexColumns, &chngIndexes, Index_id, &chgReason, &mt_column);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       UNIQUEKEY ASSOCIATIONS CHANGED?\n");
        sb.append("************************************************************************/\n");
        sb.append("\n");
        sb.append("%let chgReason=Assoc Object Chg;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnUniqueKeys, &chngUniqueKeys, UniqueKey_id, &chgReason, &mt_uniquekeys);\n");
        sb.append("/* UniqueKeyColumn Changes */\n");
        sb.append("%let chgReason=UK Column Chg;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnUniqueKeyColumns, &chngUniqueKeys, UniqueKey_id, &chgReason, &mt_uniqueKeys);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       FOREIGNKEY ASSOCIATIONS CHANGED?\n");
        sb.append("************************************************************************/\n");
        sb.append("%let chgReason=Add Delete;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnForeignKeyColumns, &chngForeignKeys, ForeignKey_id, &chgReason, &mt_foreignkeys);\n");
        sb.append("%NewDeletedAssociatedObjects(&locnForeignUnique, &chngForeignKeys, ForeignKey_id, &chgReason, &mt_uniquekeys);\n");
        sb.append("%NewDeletedAssociatedObjects(&locnKeyAssociation, &chngForeignKeys, ForeignKey_id, &chgReason, &mt_keyassociation);\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       TABLE ASSOCIATIONS CHANGED?\n");
        sb.append("************************************************************************/\n");
        sb.append("/* Column Changes */\n");
        sb.append("%let chgReason=Add Delete;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnColumns, &chngTables, table_id, &chgReason, &mt_column);\n");
        sb.append("%let chgReason=Attribute Change;\n");
        sb.append("%AssocObjectsAttsChanged(&locnColumns, &attrColumns, &chngTables, table_id, column_id, &chgReason, &mt_column);\n");
        sb.append("\n");
        sb.append("/* Index Changes */\n");
        sb.append("%let chgReason=Add Delete;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnIndexes, &chngTables, table_id, &chgReason, &mt_index);\n");
        sb.append("%let chgReason=Attribute Change;\n");
        sb.append("%AssocObjectsAttsChanged(&locnIndexes, &attrIndexes, &chngTables, table_id, index_id, &chgReason, &mt_index);\n");
        sb.append("%let chgReason=Add Delete Indx Cols;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnIndexColumns, &chngTables, table_id, &chgReason, &mt_index);\n");
        sb.append("\n");
        sb.append("/* Unique Key Changes */\n");
        sb.append("%let chgReason=Add Delete;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnUniqueKeys, &chngTables, table_id, &chgReason, &mt_uniquekeys);\n");
        sb.append("%let chgReason=Attribute Change;\n");
        sb.append("%AssocObjectsAttsChanged(&locnUniqueKeys, &attrUniqueKeys, &chngTables, table_id, uniquekey_id, &chgReason, &mt_uniquekeys);\n");
        sb.append("%let chgReason=Add Delete UK Cols;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnUniqueKeyColumns, &chngTables, table_id, &chgReason, &mt_UniqueKeys);\n");
        sb.append("\n");
        sb.append("/* Foreign Key Changes */\n");
        sb.append("%let chgReason=Add Delete;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnForeignKeys, &chngTables, table_id, &chgReason, &mt_foreignkeys);\n");
        sb.append("%let chgReason=Attribute Change;\n");
        sb.append("%AssocObjectsAttsChanged(&locnForeignKeys, &attrForeignKeys, &chngTables, table_id, foreignkey_id, &chgReason, &mt_foreignkeys);\n");
        sb.append("%let chgReason=Add Delete FK Cols;\n");
        sb.append("%NewDeletedAssociatedObjects(&locnForeignKeyColumns, &chngTables, table_id, &chgReason, &mt_ForeignKeys);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       MACRO FOR EVALUATING CHANGES\n");
        sb.append("************************************************************************/\n");
        sb.append("%macro objectChanged(_changesDS_, _locationDS_, _modelDS_, _byvar_);\n");
        sb.append("\n");
        sb.append("%let tempChanges=temp1;\n");
        sb.append("%let tempLocation=temp2;\n");
        sb.append("PROC SORT IN=&_changesDS_ OUT=work.&tempChanges NODUPKEY ;\n");
        sb.append("by &_byvar_;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("PROC SORT IN=&_locationDS_ OUT=work.&tempLocation NODUPKEY ;\n");
        sb.append("by &_byvar_;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/*  Get changed field for Physical Tables, T=Changed, F=No Change */\n");
        sb.append("data &_modelDS_  (keep=code metadatatype &_byvar_ changed state rename=(&_byvar_=id));\n");
        sb.append("   merge work.&tempLocation (in=one keep=code metadatatype &_byvar_)\n");
        sb.append("         work.&tempChanges (in=two keep=&_byvar_);\n");
        sb.append("   by &_byvar_;\n");
        sb.append("   attrib State length=$1 label ='State';\n");
        sb.append("   if (one and two) then changed='T';\n");
        sb.append("   else if one then changed='F';\n");
        sb.append("   else if two then delete;\n");
        sb.append("run;\n");
        sb.append("%mend objectChanged;\n");
        sb.append("\n");
        sb.append("%objectChanged(&chngTables, &locnTables, &modlTables, table_id);\n");
        sb.append("%objectChanged(&chngColumns, &locnColumns, &modlColumns, column_id);\n");
        sb.append("%objectChanged(&chngIndexes, &locnIndexes, &modlIndexes, Index_id);\n");
        sb.append("%objectChanged(&chngUniqueKeys, &locnUniqueKeys, &modlUniqueKeys, UniqueKey_id);\n");
        sb.append("%objectChanged(&chngForeignKeys, &locnForeignKeys, &modlForeignKeys, ForeignKey_id);\n");
        sb.append("%objectChanged(&chngKeyAssociation, &locnKeyAssociation, &modlKeyAssociation, KeyAssociation_id);\n");
        sb.append("\n");
        sb.append("/**********************************************************************\n");
        sb.append("                       GET ALL COMPAREDOBJECTS\n");
        sb.append("************************************************************************/\n");
        sb.append("data &modlAllObjects;\n");
        sb.append(" set &modlTables\n");
        sb.append("    &modlColumns\n");
        sb.append("    &modlIndexes\n");
        sb.append("    &modlUniqueKeys\n");
        sb.append("    &modlForeignKeys\n");
        sb.append("    &modlKeyAssociation\n");
        sb.append(";\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%macro getNames(_source_, _target_, _diffs_, _idvar_);\n");
        sb.append("\n");
        sb.append("   proc sort data=&_source_;\n");
        sb.append("      by sourceRow;\n");
        sb.append("\n");
        sb.append("   proc sort data=&_target_;\n");
        sb.append("      by targetRow;\n");
        sb.append("\n");
        sb.append("   proc sort data=&_source_;\n");
        sb.append("      by sourceRow;\n");
        sb.append("\n");
        sb.append("   proc sort data=&_target_;\n");
        sb.append("      by targetRow;\n");
        sb.append("\n");
        sb.append("    /* Determine source, target and STB datasets to use */\n");
        sb.append("\t%let temp1 = etls_tmp1;\n");
        sb.append("\tdata &temp1  (keep=id sourceName targetName);\n");
        sb.append("\tLength sourceName $60.;\n");
        sb.append("\tLength targetName $60.;\n");
        sb.append("\n");
        sb.append("\tset &_diffs_ (rename=(&_idvar_=id));\n");
        sb.append("\n");
        sb.append("\tpointSrcRow=sourceRow;\n");
        sb.append("\tpointTgtRow=targetRow;\n");
        sb.append("\n");
        sb.append("\tif code=\"&both\" then \n");
        sb.append("      do;\n");
        sb.append(" \t\tset &_source_ point=pointSrcRow;\n");
        sb.append("\n");
        sb.append("\t       \tsourceName=Name;\n");
        sb.append("\n");
        sb.append("\t\tset &_target_ point=pointTgtRow;\n");
        sb.append("\n");
        sb.append("\t       \ttargetName=Name;\n");
        sb.append("  \t\t\toutput;\n");
        sb.append("\t  END;\n");
        sb.append("\n");
        sb.append("\tif code=\"&source\" then \n");
        sb.append("      do;\n");
        sb.append(" \t\tset &_source_ point=pointSrcRow;\n");
        sb.append("\n");
        sb.append("\t       \tsourceName=Name;\n");
        sb.append("\t\t   \ttargetName = \"\";\n");
        sb.append("\t\t\toutput;\n");
        sb.append("\n");
        sb.append("\t  END;\n");
        sb.append("\n");
        sb.append("\tif code=\"&target\" then \n");
        sb.append("      do;\n");
        sb.append(" \t\tset &_target_ point=pointTgtRow;\n");
        sb.append("\n");
        sb.append("\t\t\ttargetName = Name;\n");
        sb.append("\t\t\tsourceName = \"\";\n");
        sb.append("\t\t\toutput;\n");
        sb.append("\n");
        sb.append("\t  END;\n");
        sb.append("\n");
        sb.append("\tproc append base=work.etls_names data=work.&temp1;\n");
        sb.append("\trun;\n");
        sb.append("\n");
        sb.append("\tproc datasets library=work nolist;\n");
        sb.append("\t  Delete  &temp1;\n");
        sb.append("\tquit;\n");
        sb.append("run;  \n");
        sb.append("%mend getNames;\n");
        sb.append("\n");
        sb.append("%getNames ( &sourceTables         , &targetTables         , &locnTables         , table_id          );\n");
        sb.append("%getNames ( &sourceColumns        , &targetColumns        , &locnColumns        , column_id         );\n");
        sb.append("%getNames ( &sourceIndexes        , &targetIndexes        , &locnIndexes        , index_id          );\n");
        sb.append("%getNames ( &sourceUniqueKeys     , &targetUniqueKeys     , &locnUniqueKeys     , uniquekey_id      );\n");
        sb.append("%getNames ( &sourceForeignKeys    , &targetForeignKeys    , &locnForeignKeys    , Foreignkey_id     );\n");
        sb.append("%getNames ( &sourceKeyAssociation , &targetKeyAssociation , &locnKeyAssociation , keyassociation_id );\n");
        sb.append("\n");
        sb.append("proc sort data=&modlAllObjects force;\n");
        sb.append("   by id;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data=work.etls_names;\n");
        sb.append("   by id;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("data &modlAllObjects;\n");
        sb.append("  merge &modlAllObjects (in=one)\n");
        sb.append("        work.etls_names;\n");
        sb.append("  by id;\n");
        sb.append("  if one;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc datasets library=work nolist;\n");
        sb.append("  Delete  etls_names;\n");
        sb.append("quit;\n");
        sb.append("\n");
        sb.append("/* Create index to update */\n");
        sb.append("proc datasets library=&CALibrary nolist nowarn memtype=(data view);\n");
        sb.append("   modify &ETLS.ComparedObjects&etls_tblid;\n");
        sb.append("   index create id;\n");
        sb.append("quit;\n");
        sb.append("\n");
        sb.append("proc datasets library=&CALibrary nolist;\n");
        sb.append("    Delete  &ETLS&mdl&table&etls_tblid\n");
        sb.append("       &ETLS&mdl&column&etls_tblid\n");
        sb.append("       &ETLS&mdl&index&etls_tblid\n");
        sb.append("       &ETLS&mdl&uniquekey&etls_tblid\n");
        sb.append("       &ETLS&mdl&foreignkey&etls_tblid\n");
        sb.append(" ;\n");
        sb.append("quit;\n");
        sb.append("\n");
        sb.append("/* SORT TO prepare for calling getAttributes macro from the visual */\n");
        sb.append("%let _source_ = &sourceTables;\n");
        sb.append("%let _target_ = &targetTables;\n");
        sb.append("proc sort data=&_source_;\n");
        sb.append("   by sourcerow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("/* Must be sorted in this order or else Row order is different from field */\n");
        sb.append("proc sort data=&_target_;\n");
        sb.append("   by targetrow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let _source_ = &sourceColumns;\n");
        sb.append("%let _target_ = &targetColumns;\n");
        sb.append("proc sort data=&_source_;\n");
        sb.append("   by sourcerow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data=&_target_;\n");
        sb.append("   by targetrow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let _source_ = &sourceIndexes;\n");
        sb.append("%let _target_ = &targetIndexes;\n");
        sb.append("proc sort data=&_source_;\n");
        sb.append("   by sourcerow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data=&_target_;\n");
        sb.append("   by targetrow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("%let _target_ = &targetUniqueKeys;\n");
        sb.append("%let _source_ = &sourceUniqueKeys;\n");
        sb.append("proc sort data=&_source_;\n");
        sb.append("   by sourcerow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data=&_target_;\n");
        sb.append("   by targetrow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("%let _source_ = &sourceForeignKeys;\n");
        sb.append("%let _target_ = &targetForeignKeys;\n");
        sb.append("proc sort data=&_source_;\n");
        sb.append("   by sourcerow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data=&_target_;\n");
        sb.append("   by targetrow;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data=&locnColumns;\n");
        sb.append("   by SASTableName ColOrder Code ;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data=&locnIndexColumns;\n");
        sb.append("   by SASTableName IndexName ColOrder Code;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data=&locnForeignKeyColumns;\n");
        sb.append("   by SASTableName ForeignKey_Name ColOrder Code;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("proc sort data=&locnUniqueKeyColumns;\n");
        sb.append("   by SASTableName UniqueKey_Name ColOrder Code;\n");
        sb.append("run;\n");
        sb.append("\n");
        sb.append("\n");
        sb.append("%macro finddups( _inputDS_, _byvars_, _srctgt_);\n");
        sb.append("    %local ukeyno numwrds1 lstbyvar ;\n");
        sb.append("\n");
        sb.append("    %let _byvars_=%sysfunc( upcase( &_byvars_));\n");
        sb.append("    %let _inputDS_=%sysfunc( upcase( &_inputDS_));\n");
        sb.append("    %let _srctgt_=%sysfunc( upcase( &_srctgt_));\n");
        sb.append("\n");
        sb.append("    %do %until(\"&ukeyno\"=\"\");\n");
        sb.append("        %let numwrds1=%eval(&numwrds1 + 1);\n");
        sb.append("          %let ukeyno=%qscan(&_byvars_,&numwrds1, %str( ) );\n");
        sb.append("    %end;\n");
        sb.append("\n");
        sb.append("    %let lstbyvar=%scan( &_byvars_, %eval( &numwrds1 - 1));\n");
        sb.append("\n");
        sb.append("    proc sort data=&_inputDS_ (keep=&_byvars_ Table_Id) out=etls_dups; \n");
        sb.append("        by &_byvars_; \n");
        sb.append("    run;\n");
        sb.append("\n");
        sb.append("    data etls_dups  ;\n");
        sb.append("     set etls_dups  ;\n");
        sb.append("            by &_byvars_ ;\n");
        sb.append("\t\t\tLength SrcTgt $1.;\n");
        sb.append("\t\t\tSrcTgt=\"&_srctgt_\";\n");
        sb.append("            if first.&lstbyvar+last.&lstbyvar<2 then output;\n");
        sb.append("    run;\n");
        sb.append("\n");
        sb.append("\tproc append base=&dsDuplicates data=etls_dups force;\n");
        sb.append("\trun;\n");
        sb.append("\n");
        sb.append("    proc datasets nolist;\n");
        sb.append("       delete etls_dups ;\n");
        sb.append("    quit;\n");
        sb.append("%mend finddups;\n");
        sb.append("\n");
        sb.append("%finddups(&sourceTables, SASTableName, S);\n");
        sb.append("%finddups(&targetTables, SASTableName, T);\n");
        sb.append("\n");
        return sb.toString();
    }

    protected String getMacrosForComparisonResultsModel() {
        StringBuffer code = new StringBuffer();
        code.append("/*\n");
        code.append("*****************************************************************************\n");
        code.append("*  Read attributes and store into a macro variable for each metadata type   *\n");
        code.append("*  _type_   = Metadata type                                                 *\n");
        code.append("*  _var_    = macro variable to store attributes into                       *\n");
        code.append("*****************************************************************************\n");
        code.append("*/\n");
        code.append("%macro readAttributes(_type_, _var_);\n");
        code.append(" %let list=;\n");
        code.append("    data _null_;\n");
        code.append(" %global &_var_;\n");
        code.append("     length allvars $1000;\n");
        code.append("    retain allvars ' ';\n");
        code.append("     set &dsMetaAttributes(where=(metadatatype=\"&_type_\")) end=LastRecord ;\n");
        code.append("        allvars = trim(left(allvars)) || ' ' || left(attributename);\n");
        code.append("    if lastrecord then call symput(\"&_var_\", allvars);\n");
        code.append("    run;\n");
        code.append("%mend readAttributes;\n");
        code.append("\n");
        code.append("%macro GetAllAttributes();\n");
        code.append("    %readAttributes(&mt_physicaltable, &mt_physicaltable.list);\n");
        code.append(" %readAttributes(&mt_column, &mt_column.list);\n");
        code.append(" %readAttributes(&mt_index, &mt_index.list);\n");
        code.append(" %readAttributes(&mt_uniquekeys, &mt_uniquekeys.list);\n");
        code.append(" %readAttributes(&mt_foreignkeys, &mt_foreignkeys.list);\n");
        code.append(" %readAttributes(&mt_keyassociation, &mt_keyassociation.list);\n");
        code.append("%mend GetAllAttributes;\n");
        code.append("%macro hasAssociationChanged(_id_, _metatype_, _Association_ );\n");
        code.append("\n");
        code.append("  /* Type of Object */\n");
        code.append("   %let associationMetadataObject=Column;  \n");
        code.append("\n");
        code.append("   %if (&_Association_ = \"Columns\") %then\n");
        code.append("       %let associationMetadataObject=Column;  \n");
        code.append("   %else %if (&_Association_ = \"Indexes\") %then\n");
        code.append("       %let associationMetadataObject=Index;\n");
        code.append("   %else %if (&_Association_ = \"UniqueKeys\") %then\n");
        code.append("       %let associationMetadataObject=UniqueKey;\n");
        code.append("   %else %if (&_Association_ = \"ForeignKeys\") %then\n");
        code.append("       %let associationMetadataObject=ForeignKey;\n");
        code.append("   %else %if (&_Association_ = \"KeyedColumns\" and &_metatype_ = \"UniqueKey\" ) %then\n");
        code.append("       %let associationMetadataObject=Column;\n");
        code.append("   %else %if (&_Association_ = \"KeyedColumns\" and &_metatype_ = \"ForeignKey\" ) %then\n");
        code.append("       %let associationMetadataObject=Column;\n");
        code.append("   %else %if (&_Association_ = \"PartnerUniqueKey\" and &_metatype_ = \"ForeignKey\" ) %then\n");
        code.append("       %let associationMetadataObject=UniqueKey;\n");
        code.append("   %else %if (&_Association_ = \"KeyAssociations\" and &_metatype_ = \"ForeignKey\" ) %then\n");
        code.append("       %let associationMetadataObject=KeyAssociation;\n");
        code.append("   %else %if (&_Association_ = \"UniqueKeyColumn\" and &_metatype_ = \"KeyAssociation\" ) %then\n");
        code.append("       %let associationMetadataObject=KeyAssociation;\n");
        code.append("   %else %if (&_Association_ = \"ForeignKeyColumn\" and &_metatype_ = \"KeyAssociation\" ) %then\n");
        code.append("       %let associationMetadataObject=KeyAssociation;\n");
        code.append("   %else %put \"Cannot find Association\" &_Association_;\n");
        code.append("\n");
        code.append("   /* Id field to lookup */\n");
        code.append("   %let objectIdField=column_Id;\n");
        code.append("   %if &_metatype_ = \"PhysicalTable\" %then \n");
        code.append("       %let objectIdField=table_Id;\n");
        code.append("   %else %if &_metatype_ = \"Column\" %then \n");
        code.append("       %let objectIdField=Column_Id;  \n");
        code.append("   %else %if &_metatype_ = \"UniqueKey\" %then \n");
        code.append("       %let objectIdField=UniqueKey_Id;\n");
        code.append("   %else %if &_metatype_ = \"ForeignKey\" %then \n");
        code.append("       %let objectIdField=ForeignKey_Id;\n");
        code.append("   %else %if &_metatype_ = \"Index\" %then \n");
        code.append("       %let objectIdField=Index_Id;\n");
        code.append("   %else %if &_metatype_ = \"KeyAssociation\" %then \n");
        code.append("       %let objectIdField=KeyAssociation_Id;\n");
        code.append("\n");
        code.append("   /* Table to lookup */\n");
        code.append("   %let lookInDataset=&chngColumns;\n");
        code.append("   %if &_metatype_ = \"PhysicalTable\" %then \n");
        code.append("       %let lookInDataset= &chngTables;  \n");
        code.append("   %else %if &_metatype_ = \"Index\" and &_Association_ = \"Column\" %then \n");
        code.append("       %let lookInDataset= &chngIndexColumns;  \n");
        code.append("   %else %if &_metatype_ = \"Column\" %then \n");
        code.append("       %let lookInDataset= &chngColumns;  \n");
        code.append("   %else %if (&_Association_ = \"KeyedColumns\" and &_metatype_ = \"UniqueKey\" ) %then \n");
        code.append("       %let lookInDataset= &chngUniqueKeyColumns;  \n");
        code.append("   %else %if &_metatype_ = \"UniqueKey\" %then \n");
        code.append("       %let lookInDataset= &chngUniqueKeys;  \n");
        code.append("   %else %if (&_Association_ = \"KeyedColumns\" and &_metatype_ = \"ForeignKey\" ) %then \n");
        code.append("       %let lookInDataset= &chngForeignKeyColumns;  \n");
        code.append("   %else %if &_metatype_ = \"ForeignKey\" %then \n");
        code.append("       %let lookInDataset= &chngForeignKeys;  \n");
        code.append("   %else %if &_metatype_ = \"Index\" %then \n");
        code.append("       %let lookInDataset= &chngIndexes;  \n");
        code.append("   %else %if &_metatype_ = \"KeyAssociation\" %then \n");
        code.append("       %let lookInDataset= &chngKeyAssociation;  \n");
        code.append("  data &dsAssociationChanged;\n");
        code.append("     set &lookInDataset(where=(metadatatype=\"&associationMetadataObject\" && &objectIdField=\"&_id_\"));\n");
        code.append("  \n");
        code.append("  run;\n");
        code.append("\n");
        code.append("%mend hasAssociationChanged;\n");
        code.append("/*\n");
        code.append("*****************************************************************************\n");
        code.append("*  Macro to get associated objects                                          *\n");
        code.append("*  _id_         = id                                                    *\n");
        code.append("*  _metatype_      = metadata type                                         *\n");
        code.append("*  _Association_   = Association Type                                      *\n");
        code.append("*****************************************************************************\n");
        code.append("*/\n");
        code.append("%macro getAssociations(_id_, _metatype_, _Association_ );\n");
        code.append("\n");
        code.append("   %let lookInDataset=&locnColumns;\n");
        code.append("   /* Decide on the table to search for */\n");
        code.append("   %if (&_metatype_=Index and &_Association_=Columns) %then\n");
        code.append("       %let lookInDataset= &locnIndexColumns ;  \n");
        code.append("   %else %if (&_Association_ =&assn_columns) %then\n");
        code.append("       %let lookInDataset= &locnColumns;  \n");
        code.append("   %else %if (&_Association_ =&assn_Table and &_metatype_ = &mt_uniquekeys ) %then\n");
        code.append("       %let lookInDataset= &locnUniqueKeys;  \n");
        code.append("   %else %if (&_Association_ =&assn_Table and &_metatype_ = &mt_foreignkeys ) %then\n");
        code.append("       %let lookInDataset= &locnForeignKeys;  \n");
        code.append("   %else %if (&_Association_ =&assn_Table) %then\n");
        code.append("       %let lookInDataset= &locnColumns;  \n");
        code.append("   %else %if (&_Association_ =&assn_Indexes) %then\n");
        code.append("       %let lookInDataset= &locnIndexes;\n");
        code.append("   %else %if (&_Association_ =&assn_UniqueKeys ) %then\n");
        code.append("       %let lookInDataset= &locnUniqueKeys;\n");
        code.append("   %else %if (&_Association_ = &assn_ForeignKeys and &_metatype_ = &mt_uniquekeys ) %then\n");
        code.append("       %let lookInDataset= &locnForeignUnique;\n");
        code.append("   %else %if (&_Association_ = &assn_ForeignKeys) %then\n");
        code.append("       %let lookInDataset= &locnForeignKeys;\n");
        code.append("   %else %if (&_Association_ = &assn_KeyedColumns and &_metatype_ = &mt_uniquekeys ) %then\n");
        code.append("       %let lookInDataset= &locnUniqueKeyColumns;\n");
        code.append("   %else %if (&_Association_ = &assn_KeyedColumns and &_metatype_ = &mt_foreignkeys ) %then\n");
        code.append("       %let lookInDataset= &locnForeignKeyColumns;\n");
        code.append("   %else %if (&_Association_ = &assn_PartnerUniqueKey) %then\n");
        code.append("       %let lookInDataset= &locnForeignUnique;\n");
        code.append("   %else %if (&_Association_ = &assn_KeyAssociation) %then\n");
        code.append("       %let lookInDataset= &locnKeyAssociation;\n");
        code.append("   %else %if (&_Association_ = &mt_foreignkeycolumn) %then\n");
        code.append("       %let lookInDataset= &locnKeyAssociation;\n");
        code.append("   %else %if (&_Association_ = &mt_uniquekeycolumn) %then\n");
        code.append("       %let lookInDataset= &locnKeyAssociation;\n");
        code.append("   %else %put \"Cannot find Association\" &_Association_;\n");
        code.append("\n");
        code.append("   /* Type of Object */\n");
        code.append("   %let objectIdField=Column_Id;  \n");
        code.append("\n");
        code.append("   %if (&_Association_ = &assn_Table) %then\n");
        code.append("       %let objectIdField=Table_Id;  \n");
        code.append("   %if (&_Association_ = &assn_columns) %then\n");
        code.append("       %let objectIdField=Column_Id;  \n");
        code.append("   %else %if (&_Association_ = &assn_Indexes) %then\n");
        code.append("       %let objectIdField=Index_Id;\n");
        code.append("   %else %if (&_Association_ = &assn_UniqueKeys) %then\n");
        code.append("       %let objectIdField=UniqueKey_Id;\n");
        code.append("   %else %if (&_Association_ = &assn_ForeignKeys) %then\n");
        code.append("       %let objectIdField=ForeignKey_Id;\n");
        code.append("   %else %if (&_Association_ = &assn_KeyedColumns and &_metatype_ = &mt_uniquekeys ) %then\n");
        code.append("       %let objectIdField=Column_Id;\n");
        code.append("   %else %if (&_Association_ = &assn_KeyedColumns and &_metatype_ = &mt_foreignkeys ) %then\n");
        code.append("       %let objectIdField=Column_Id;\n");
        code.append("   %else %if (&_Association_ = &assn_PartnerUniqueKey and &_metatype_ = &mt_foreignkeys ) %then\n");
        code.append("       %let objectIdField=UniqueKey_Id;\n");
        code.append("   %else %if (&_Association_ = &assn_KeyAssociation and &_metatype_ = &mt_foreignkeys ) %then\n");
        code.append("       %let objectIdField=KeyAssociation_Id;\n");
        code.append("   %else %if (&_Association_ = &mt_foreignkeycolumn ) %then\n");
        code.append("       %let objectIdField=ForeignKeyColumn_Id;\n");
        code.append("   %else %if (&_Association_ = &mt_uniquekeycolumn ) %then\n");
        code.append("       %let objectIdField=UniqueKeyColumn_Id;\n");
        code.append("   %else %put \"Cannot find Association\" &_Association_;\n");
        code.append("\n");
        code.append("   /* Id field to lookup */\n");
        code.append("   %let lookUpField=Table_Id;\n");
        code.append("   %if &_metatype_ =&mt_physicaltable %then \n");
        code.append("       %let lookUpField=Table_Id;\n");
        code.append("   %else %if &_metatype_ =&mt_column %then \n");
        code.append("       %let lookUpField=Column_Id;\n");
        code.append("   %else %if &_metatype_ =&mt_uniquekeys %then \n");
        code.append("       %let lookUpField=UniqueKey_Id;\n");
        code.append("   %else %if &_metatype_ =&mt_foreignkeys %then \n");
        code.append("       %let lookUpField=ForeignKey_Id;\n");
        code.append("   %else %if &_metatype_ =&mt_index %then \n");
        code.append("       %let lookUpField=Index_Id;\n");
        code.append("   %else %if &_metatype_ =&mt_KeyAssociation %then \n");
        code.append("       %let lookUpField=KeyAssociation_Id;\n");
        code.append("\n");
        code.append("  data &dsAssociations(keep=code metadatatype id);\n");
        code.append("     set &lookInDataset(rename=(&objectIdField=id) where=(&lookUpField=\"&_id_\"));\n");
        code.append("  if metadatatype=\"&mt_foreignkeys\" and \"&_Association_\" = \"&assn_PartnerUniqueKey\"  \n");
        code.append("  \t\t\t\t\t\t\tthen metadatatype=\"&mt_uniquekeys\";\n");
        code.append("  if metadatatype=\"&mt_foreignkeycolumn\" then metadatatype=\"&mt_column\";\n");
        code.append("  if metadatatype=\"&mt_uniquekeycolumn\" then metadatatype=\"&mt_column\";\n");
        code.append("  if metadatatype=\"&mt_indexColumn\" then metadatatype=\"&mt_column\";\n");
        code.append("  if &lookupField=\"KeyAssociation_ID\" then metadatatype=\"&mt_column\";\n");
        code.append("  %if &objectIdField=UniqueKeyColumn_Id %then metadatatype=\"&mt_column\" ;\n");
        code.append("  ;\n");
        code.append("  %if &objectIdField=ForeignKeyColumn_Id %then metadatatype=\"&mt_column\" ;\n");
        code.append("  ;\n");
        code.append("  %if &objectIdField=Table_Id %then metadatatype=\"&mt_physicaltable\" ;\n");
        code.append("  ;\n");
        code.append("  \n");
        code.append("  run;\n");
        code.append("  %if (&_Association_ = &assn_PartnerUniqueKey and &_metatype_ = &mt_foreignkeys ) %then %do;\n");
        code.append("     proc sort data=&dsAssociations;\n by code; \n run;\n");
        code.append("  %end;\n");
        code.append("\n");
        code.append("%mend getAssociations;\n");
        code.append("%macro readAttributes(_type_, _var_);\n");
        code.append(" %let list=;\n");
        code.append("    data _null_;\n");
        code.append(" %global &_var_;\n");
        code.append("     length allvars $1000;\n");
        code.append("    retain allvars ' ';\n");
        code.append("     set &dsMetaAttributes (where=(metadatatype=\"&_type_\")) end=LastRecord ;\n");
        code.append("        allvars = trim(left(allvars)) || ' ' || left(attributename);\n");
        code.append("    if lastrecord then call symput(\"&_var_\", allvars);\n");
        code.append("    run;\n");
        code.append("%mend readAttributes;\n");
        code.append("\n");
        code.append("%macro getAttributes(_id_, _metatype_, _case_ );\n");
        code.append("\n");
        code.append("    /* Determine source, target and STB datasets to use */\n");
        code.append("    %if &_metatype_=&mt_physicaltable %then\n");
        code.append("    %do;\n");
        code.append("       %let _source_ = &sourceTables;\n");
        code.append("       %let _target_ = &targetTables;\n");
        code.append("       %let _diffs_  = &locnTables;\n");
        code.append("       %let _attributes_ = &physicaltablelist;\n");
        code.append("       %let _idvar_ =table_id;\n");
        code.append("    %end;\n");
        code.append("    %else %if(&_metatype_=&mt_column or &_metatype_=&mt_indexColumn \n");
        code.append("            or &_metatype_=&mt_column or &_metatype_=&mt_indexColumn) %then\n");
        code.append("    %do;\n");
        code.append("       %let _source_ = &sourceColumns;\n");
        code.append("       %let _target_ = &targetColumns;\n");
        code.append("       %let _diffs_  = &locnColumns;\n");
        code.append("       %let _attributes_ = &columnlist;\n");
        code.append("       %let _idvar_ =column_id;\n");
        code.append("    %end;\n");
        code.append("    %else %if &_metatype_=&mt_index %then\n");
        code.append("    %do;\n");
        code.append("       %let _source_ = &sourceIndexes;\n");
        code.append("       %let _target_ = &targetIndexes;\n");
        code.append("       %let _diffs_  = &locnIndexes;\n");
        code.append("       %let _attributes_ = &indexlist;\n");
        code.append("       %let _idvar_ =index_id;\n");
        code.append("    %end;\n");
        code.append("    %else %if &_metatype_=&mt_uniquekeys %then\n");
        code.append("    %do;\n");
        code.append("       %let _source_ = &sourceUniqueKeys;\n");
        code.append("       %let _target_ = &targetUniqueKeys;\n");
        code.append("       %let _diffs_  = &locnUniqueKeys;\n");
        code.append("       %let _attributes_ = &uniquekeylist;\n");
        code.append("       %let _idvar_ =uniquekey_id;\n");
        code.append("    %end;\n");
        code.append("    %else %if &_metatype_=&mt_foreignkeys %then\n");
        code.append("    %do;\n");
        code.append("       %let _source_ = &sourceForeignKeys;\n");
        code.append("       %let _target_ = &targetForeignKeys;\n");
        code.append("       %let _diffs_  = &locnForeignKeys;\n");
        code.append("       %let _attributes_ = &foreignkeylist;\n");
        code.append("       %let _idvar_ =foreignkey_id;\n");
        code.append("    %end;\n");
        code.append("    %else %if &_metatype_=&mt_foreignkeycolumn %then\n");
        code.append("    %do;\n");
        code.append("       %let _source_ = &sourceForeignKeyColumns;\n");
        code.append("       %let _target_ = &targetForeignKeyColumns;\n");
        code.append("       %let _diffs_  = &locnForeignKeyColumns;\n");
        code.append("       %let _attributes_ = &foreignkeylist;\n");
        code.append("       %let _idvar_ =foreignkey_id;\n");
        code.append("    %end;\n");
        code.append("    %else %if &_metatype_=&mt_uniquekeycolumn %then\n");
        code.append("    %do;\n");
        code.append("       %let _source_ = &sourceUniqueKeyColumns;\n");
        code.append("       %let _target_ = &targetUniqueKeyColumns;\n");
        code.append("       %let _diffs_  = &locnUniqueKeyColumns;\n");
        code.append("       %let _attributes_ = &uniquekeylist;\n");
        code.append("       %let _idvar_ =uniquekey_id;\n");
        code.append("    %end;\n");
        code.append("\n");
        code.append("    %else %if &_metatype_=&mt_keyassociation %then\n");
        code.append("    %do;\n");
        code.append("       %let _source_ = &sourceKeyAssociation;\n");
        code.append("       %let _target_ = &targetKeyAssociation;\n");
        code.append("       %let _diffs_  = &locnKeyAssociation;\n");
        code.append("       %let _attributes_ = &keyassociationlist;\n");
        code.append("       %let _idvar_ =keyassociation_id;\n");
        code.append("    %end;\n");
        code.append("\n");
        code.append("  %LOCAL _J_ _ATTRCOUNT_;\n");
        code.append("\n");
        code.append(" /*** determine number of SAS variables in _attributes_ ***/\n");
        code.append(" %let _ATTRCOUNT_ = %eval( 1 + (%length(%sysfunc(compbl(&_attributes_)))  -\n");
        code.append("                          %length(%sysfunc(compress(&_attributes_)))));\n");
        code.append("\n");
        code.append("\n");
        code.append(" data &modlAttributes  (keep=attribute sourceValue targetValue change);\n");
        code.append(" Length attribute $32.;\n");
        code.append(" Length sourceValue $200.;\n");
        code.append(" Length targetValue $200.;\n");
        code.append(" Length change $1.;\n");
        code.append("\n");
        code.append(" set &_diffs_ (where=(&_idvar_=&_id_));\n");
        code.append("\n");
        code.append(" pointSrcRow=sourceRow;\n");
        code.append(" pointTgtRow=targetRow;\n");
        code.append("\n");
        code.append(" /* Get attributes from source and target.  Compare each attribute and output as a separate row */\n");
        code.append(" if code=\"&both\" then \n");
        code.append("      do;\n");
        code.append("       set &_source_ point=pointSrcRow;\n");
        code.append("\n");
        code.append("       %DO _J_=1 %TO &_ATTRCOUNT_;\n");
        code.append("        %scan(&_attributes_, &_J_)s=%scan(&_attributes_, &_J_);\n");
        code.append("    %END;\n");
        code.append("\n");
        code.append("    set &_target_ point=pointTgtRow;\n");
        code.append("\n");
        code.append("       %DO _J_=1 %TO &_ATTRCOUNT_;\n");
        code.append("             %scan(&_attributes_, &_J_)t=%scan(&_attributes_, &_J_);\n");
        code.append("    %END;\n");
        code.append("\n");
        code.append("       %DO _J_=1 %TO &_ATTRCOUNT_;\n");
        code.append("        \n");
        code.append("       sourceValue = (%scan(&_attributes_, &_J_)s);\n");
        code.append("       targetValue = (%scan(&_attributes_, &_J_)t);\n");
        code.append("       attribute = \"%scan(&_attributes_, &_J_)\";\n");
        code.append("            change=\"F\";\n");
        code.append("\n");
        code.append("        %if &_case_=F %then\n");
        code.append("                 if upcase(sourceValue) ne upcase(targetValue) then change = \"T\";\n");
        code.append("       %else\n");
        code.append("                 if sourceValue ne targetValue then change = \"T\";\n");
        code.append("       ;\n");
        code.append("       output;\n");
        code.append("     %END;\n");
        code.append("\n");
        code.append("   END;\n");
        code.append(" if code=\"&source\" then \n");
        code.append("      do;\n");
        code.append("       set &_source_ point=pointSrcRow;\n");
        code.append("\n");
        code.append("       %DO _J_=1 %TO &_ATTRCOUNT_;\n");
        code.append("        %scan(&_attributes_, &_J_)s=%scan(&_attributes_, &_J_);\n");
        code.append("    %END;\n");
        code.append("\n");
        code.append("       %DO _J_=1 %TO &_ATTRCOUNT_;\n");
        code.append("        \n");
        code.append("       sourceValue = (%scan(&_attributes_, &_J_)s);\n");
        code.append("       targetValue = \"\";\n");
        code.append("       attribute = \"%scan(&_attributes_, &_J_)\";\n");
        code.append("       change = \"T\";\n");
        code.append("       output;\n");
        code.append("     %END;\n");
        code.append("\n");
        code.append("   END;\n");
        code.append("\n");
        code.append(" if code=\"&target\" then \n");
        code.append("      do;\n");
        code.append("       set &_target_ point=pointTgtRow;\n");
        code.append("\n");
        code.append("       %DO _J_=1 %TO &_ATTRCOUNT_;\n");
        code.append("        %scan(&_attributes_, &_J_)s=%scan(&_attributes_, &_J_);\n");
        code.append("    %END;\n");
        code.append("\n");
        code.append("       %DO _J_=1 %TO &_ATTRCOUNT_;\n");
        code.append("        \n");
        code.append("       targetValue = (%scan(&_attributes_, &_J_)s);\n");
        code.append("       sourceValue = \"\";\n");
        code.append("       change = \"T\";\n");
        code.append("       attribute = \"%scan(&_attributes_, &_J_)\";\n");
        code.append("       output;\n");
        code.append("     %END;\n");
        code.append("\n");
        code.append("   END;\n");
        code.append("\n");
        code.append("run;  \n");
        code.append("%mend getAttributes;\n");
        code.append("\n");
        return code.toString();
    }

    protected String substituteID() {
        StringBuffer code = new StringBuffer();
        code.append("/* Substitute IDs */\n").append("%let dsWithNewIDs=WORK.ETLS_NEWIDS;\n").append("\n").append("PROC SORT DATA=&dsWithNewIDs;\n").append("   BY OLD_ID;\n").append("RUN;\n").append("\n").append("%macro substituteNewID(_dsWithNewIds_, _dsToModify_, _idfield_);\n").append("\n").append("\tproc sort data=&_dsToModify_;\n").append("\t    by &_idfield_;\n").append("\trun;\n").append("\n").append("\tdata &_dsToModify_ (DROP=NEW_ID);\n").append("\t   merge &_dsToModify_ (in=one)\n").append("\t   &_dsWithNewIds_ (IN=TWO RENAME=(OLD_ID=&_idfield_) KEEP=OLD_ID NEW_ID)\n").append("\t   ;\n").append("\t   BY &_idfield_;\n").append("\t   IF ONE;\n").append("\t   IF TWO THEN &_idfield_=NEW_ID;\n").append("\tRUN;\n").append("\n").append("%mend substituteNewID;\n").append("\n").append("%substituteNewId(&dsWithNewIDs, &attrColumns\t\t\t\t, Column_Id) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrColumns\t\t\t\t, Table_Id) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrForeignKeys\t\t\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrForeignKeys\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrIndexes\t\t\t\t, Index_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrIndexes\t\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrKeyAssociation\t\t, ForeignKeyColumn_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrKeyAssociation\t\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrKeyAssociation\t\t, KeyAssociation_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrKeyAssociation\t\t, UniqueKeyColumn_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrTables\t\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrUniqueKeys\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &attrUniqueKeys\t\t\t, UniqueKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &chngColumns\t\t\t\t, Column_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &chngForeignKeyColumns\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &chngForeignKeys\t\t\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &chngIndexColumns\t\t, Index_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &chngIndexes\t\t\t\t, Index_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &chngKeyAssociation\t\t, KeyAssociation_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &chngTables\t\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &chngUniqueKeys\t\t\t, UniqueKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &chngUniqueKeyColumns\t, UniqueKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnColumns\t\t\t\t, Column_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnColumns\t\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnForeignUnique\t\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnForeignUnique\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnForeignUnique\t\t, UniqueKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnForeignKeyColumns\t, Column_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnForeignKeyColumns\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnForeignKeyColumns\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnForeignKeys\t\t\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnForeignKeys\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnIndexColumns\t\t, Column_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnIndexColumns\t\t, Index_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnIndexColumns\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnIndexes\t\t\t\t, Index_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnIndexes\t\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnKeyAssociation\t\t, ForeignKeyColumn_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnKeyAssociation\t\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnKeyAssociation\t\t, KeyAssociation_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnKeyAssociation\t\t, UniqueKeyColumn_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnTables\t\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnUniqueKeyColumns\t, Column_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnUniqueKeyColumns\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnUniqueKeyColumns\t, UniqueKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnUniqueKeys\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &locnUniqueKeys\t\t\t, UniqueKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceColumns\t\t\t, Column_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceColumns\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceForeignUnique\t\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceForeignUnique\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceForeignUnique\t\t, UniqueKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceForeignKeyColumns\t, Column_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceForeignKeyColumns\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceForeignKeyColumns\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceForeignKeys\t\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceForeignKeys\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceForeignKeys\t\t, UniqueKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceIndexColumns\t\t, Column_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceIndexColumns\t\t, Index_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceIndexColumns\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceIndexes\t\t\t, Index_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceIndexes\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceKeyAssociation\t, ForeignKeyColumn_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceKeyAssociation\t, ForeignKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceKeyAssociation\t, KeyAssociation_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceKeyAssociation\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceKeyAssociation\t, UniqueKeyColumn_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceTables\t\t\t, SASLibrary_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceTables\t\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceUniqueKeyColumns\t, Column_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceUniqueKeyColumns\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceUniqueKeyColumns\t, UniqueKey_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceUniqueKeys\t\t, Table_Id ) ;\n").append("%substituteNewId(&dsWithNewIDs, &sourceUniqueKeys\t\t, UniqueKey_Id ) ;\n").append("proc datasets library=&CALibrary nolist nowarn memtype=(data view);\n").append("   modify &ETLS.ComparedObjects&etls_tblid;\n").append("   index delete id;\n").append("quit;\n").append("%substituteNewId(&dsWithNewIDs, &modlAllObjects\t\t\t, Id ) ;\n").append("proc datasets library=&CALibrary nolist nowarn memtype=(data view);\n").append("   modify &ETLS.ComparedObjects&etls_tblid;\n").append("   index create id;\n").append("quit;\n").append("/* SORT TO prepare for calling getAttributes macro from the visual */\n").append("%let _source_ = &sourceTables;\n").append("%let _target_ = &targetTables;\n").append("proc sort data=&_source_;\n").append("   by sourcerow;\n").append("run;\n").append("\n").append("/* Put datasets back in the order they were in */\n").append("proc sort data=&_target_;\n").append("   by targetrow;\n").append("run;\n").append("\n").append("%let _source_ = &sourceColumns;\n").append("%let _target_ = &targetColumns;\n").append("proc sort data=&_source_;\n").append("   by sourcerow;\n").append("run;\n").append("\n").append("proc sort data=&_target_;\n").append("   by targetrow;\n").append("run;\n").append("\n").append("%let _source_ = &sourceIndexes;\n").append("%let _target_ = &targetIndexes;\n").append("proc sort data=&_source_;\n").append("   by sourcerow;\n").append("run;\n").append("\n").append("proc sort data=&_target_;\n").append("   by targetrow;\n").append("run;\n").append("\n").append("%let _target_ = &targetUniqueKeys;\n").append("%let _source_ = &sourceUniqueKeys;\n").append("proc sort data=&_source_;\n").append("   by sourcerow;\n").append("run;\n").append("\n").append("proc sort data=&_target_;\n").append("   by targetrow;\n").append("run;\n").append("\n").append("\n").append("%let _source_ = &sourceForeignKeys;\n").append("%let _target_ = &targetForeignKeys;\n").append("proc sort data=&_source_;\n").append("   by sourcerow;\n").append("run;\n").append("\n").append("proc sort data=&_target_;\n").append("   by targetrow;\n").append("run;\n").append("\n").append("\n").append("\n").append("%let _source_ = &sourceKeyAssociation;\n").append("%let _target_ = &targetKeyAssociation;\n").append("proc sort data=&_source_;\n").append("   by sourcerow;\n").append("run;\n").append("\n").append("proc sort data=&_target_;\n").append("   by targetrow;\n").append("run;\n").append("\n").append("proc sort data=&locnColumns;\n").append("   by SASTableName Code ;\n").append("run;\n").append("\n").append("proc sort data=&locnColumns;\n").append("   by SASTableName ColOrder Code ;\n").append("run;\n").append("\n").append("proc sort data=&locnIndexColumns;\n").append("   by SASTableName IndexName ColOrder Code;\n").append("run;\n").append("\n").append("proc sort data=&locnForeignKeyColumns;\n").append("   by SASTableName ForeignKey_Name ColOrder Code;\n").append("run;\n").append("\n").append("proc sort data=&locnUniqueKeyColumns;\n").append("   by SASTableName UniqueKey_Name ColOrder Code;\n").append("run;\n").append("\n");
        return code.toString();
    }
}

