/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.wizards;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionWizard;
import com.sas.metadata.promotion.visuals.ExportTreePanel;
import com.sas.metadata.promotion.visuals.ExportWizardInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WizardFinishTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class CheckInWizard
extends AbstractPromotionWizard
implements ExportWizardInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(CheckInWizard.class);
    private SimpleLogicalObjectInterface[] _logicalObjects;
    private ExportHandler _exportHandler;
    private cDependenciesTab _finishPanel;
    private Map m_lCheckInObjects;

    public CheckInWizard(SimpleLogicalObjectInterface[] logicalObjects, TypeInterface[] availableTypes, String title) {
        super(availableTypes, title);
        title = bundle.getString("CheckInWizard.Title.txt");
        this.setTitle(title);
        this._logicalObjects = logicalObjects;
        this.initializePanels();
    }

    protected void initializePanels() {
        try {
            Workspace workspace = Workspace.getWorkspace();
            MdFactory factory = workspace.getMdFactory();
            if (this._logicalObjects == null) {
                return;
            }
            this._exportHandler = new ExportHandler(factory, this._logicalObjects, 0, this._availableTypes, true);
            this._exportHandler.setSessionContext(workspace.getSessionContext(), true);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            return;
        }
        this.addTab(bundle.getString("CheckInWizard.InfoTab.Title.txt"), "CheckInWizardInfoTab", (WAPropertyTab)new cCheckInWizardInfoTab(), false);
        cDependenciesTab treePanel = null;
        try {
            String projectReposID = Workspace.getWorkspace().getProjectRepositoryId();
            if (this._logicalObjects == null) {
                return;
            }
            treePanel = new cDependenciesTab(this, this._logicalObjects, projectReposID, Workspace.getWorkspace().getProjectRepository().getName());
            treePanel.setDescription(bundle.getString("CheckInWizard.TreePanel.Description.txt"));
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        treePanel.setHelpProduct("wdb");
        treePanel.setHelpTopic("cm_dependencies");
        this.addTab(bundle.getString("CheckInWizard.TreePanel.Title.txt"), "TreePanel", (WAPropertyTab)treePanel, false);
        WizardFinishTab wizfinish = new WizardFinishTab(bundle.getString("CheckInWizard.FinishTab.Title.txt"));
        this.addTab(bundle.getString("CheckInWizard.FinishTab.Title.txt"), "CheckInWizardFinishTab", (WAPropertyTab)wizfinish, true);
        this.setupTransitions();
    }

    protected void setupTransitions() {
        String[][] transitions = new String[][]{{"CheckInWizardInfoTab", "NEXT", "TreePanel"}, {"TreePanel", "NEXT", "CheckInWizardFinishTab"}};
        this._model.addTransitions(transitions);
    }

    public ExportHandler getExportHandler() {
        return this._exportHandler;
    }

    protected WAPanel getFinishPanel() {
        return this._finishPanel;
    }

    protected void cleanUp(boolean cancelling) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._exportHandler.dispose();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public Map getCheckInObjectIDs() {
        return this.m_lCheckInObjects;
    }

    protected class cCheckInWizardInfoTab
    extends WsDescriptionWizardTab {
        protected JLabel m_nameLabel;
        protected WATextField m_nameText;
        protected JLabel m_descriptionLabel;
        protected WATextArea m_descriptionText;
        protected JScrollPane m_textPane;

        protected cCheckInWizardInfoTab() {
            super(bundle.getString("CheckInWizard.InfoTab.Description.txt"));
            this.initialize();
            this.layoutWidgets();
            this.setHelpProduct("wdb");
            this.setHelpTopic("cm_checkin_win");
        }

        public boolean doDataExchange(boolean bSaveToModel) {
            return true;
        }

        public boolean validateData() {
            String strNameText = this.getChangeName();
            if (strNameText == null || strNameText.length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("CheckInWizard.InfoTab.NoTitle.Error.txt"), (int)0, (int)-1);
                this.m_nameText.requestFocus();
                return false;
            }
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            myParent.addWizardData("CHANGENAME", (Object)strNameText);
            myParent.addWizardData("CHANGEDESC", (Object)this.getChangeDesc());
            return true;
        }

        protected void initialize() {
            this.m_nameText = new WATextField();
            this.m_nameText.setMaxCharacters(60);
            this.m_nameText.setToolTipText(bundle.getString("CheckInWizard.InfoTab.Label.Name.tip"));
            this.m_nameLabel = WsUIUtilities.createLabelForComponent((JComponent)this.m_nameText, (String)bundle.getString("CheckInWizard.InfoTab.Label.Name.txt"));
            this.m_descriptionText = new WATextArea();
            this.m_descriptionText.setToolTipText(bundle.getString("CheckInWizard.InfoTab.Label.Desc.tip"));
            this.m_descriptionText.setLineWrap(true);
            this.m_descriptionText.setWrapStyleWord(true);
            this.m_descriptionLabel = WsUIUtilities.createLabelForComponent((JComponent)this.m_descriptionText, (String)bundle.getString("CheckInWizard.InfoTab.Label.Desc.txt"));
            this.m_textPane = new JScrollPane((Component)this.m_descriptionText, 20, 31);
            this.m_textPane.setBorder(BorderFactory.createBevelBorder(1));
            this.m_textPane.setPreferredSize(new Dimension(400, 150));
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(this.m_nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_nameText, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add(this.m_descriptionLabel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add(this.m_textPane, new GridBagConstraints(0, 2, 3, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        }

        public String getChangeName() {
            return this.m_nameText.getText();
        }

        public String getChangeDesc() {
            return this.m_descriptionText.getText();
        }

        public String createFinishString() {
            StringBuffer temp = new StringBuffer();
            temp.append(bundle.getString("CheckInWizard.FinishTab.StartFinishString.txt")).append("\n\n");
            CheckInWizard ciw = (CheckInWizard)((Object)this.getTopLevelAncestor());
            CheckInWizard.this.m_lCheckInObjects = new HashMap(CheckInWizard.this._exportHandler.getExportItems());
            for (String type : CheckInWizard.this.m_lCheckInObjects.keySet()) {
                List items = (List)CheckInWizard.this.m_lCheckInObjects.get(type);
                for (int i = 0; i < items.size(); ++i) {
                    ExportItemInterface item = (ExportItemInterface)items.get(i);
                    temp.append(item.getName()).append("\n");
                }
            }
            return temp.toString();
        }
    }

    protected class cDependenciesTab
    extends ExportTreePanel {
        public cDependenciesTab(ExportWizardInterface wizard, SimpleLogicalObjectInterface[] logicalObjects, String projectReposID, String treeName) {
            super(wizard, logicalObjects, projectReposID, treeName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public boolean validateData() {
            boolean bvalid = super.validateData();
            try {
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "CheckInWizard: cDependenciesTab.validateData");
                ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                ChildServerInterface childServer = server.newChild(true);
                try {
                    StringBuilder sbDupsInSelections = new StringBuilder();
                    StringBuilder sbDupsInFolder = new StringBuilder();
                    HashMap hmFoundObjects = new HashMap();
                    HashMap<String, String> mapMessage = new HashMap<String, String>();
                    HashMap<String, Integer> mapOccurrences = new HashMap<String, Integer>();
                    HashMap lCheckInObjects = new HashMap(CheckInWizard.this._exportHandler.getExportItems());
                    for (String type : lCheckInObjects.keySet()) {
                        String typeName = childServer.getTypeDescriptor(type).getLabel();
                        List items = (List)lCheckInObjects.get(type);
                        hmFoundObjects.clear();
                        mapMessage.clear();
                        mapOccurrences.clear();
                        if (items.size() <= 1) continue;
                        for (int i = 0; i < items.size(); ++i) {
                            ExportItemInterface item = (ExportItemInterface)items.get(i);
                            Root oData = (Root)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, item.getTypeInterface().getMetadataType(), item.getID(), null, null, null, 8);
                            String sItemName = oData.getName();
                            Root oParent = null;
                            oParent = this.getParent(oData);
                            if (oParent == null) continue;
                            String sIDOfParentFolder = this.getParentFolderID(oParent);
                            ArrayList<String> lFolders = (ArrayList<String>)hmFoundObjects.get(sItemName.toUpperCase());
                            if (lFolders == null) {
                                lFolders = new ArrayList<String>();
                                lFolders.add(sIDOfParentFolder);
                                hmFoundObjects.put(sItemName.toUpperCase(), lFolders);
                            } else if (lFolders.contains(sIDOfParentFolder)) {
                                String sNameFolder = sItemName.toUpperCase() + sIDOfParentFolder;
                                if (!mapMessage.containsKey(sNameFolder)) {
                                    mapMessage.put(sNameFolder, bundle.formatString("CheckInWizard.DuplicatesSelectedNameAndFolder.fmt", (Object)sItemName, (Object)oParent.getName()));
                                }
                                if (mapOccurrences.containsKey(sNameFolder)) {
                                    Integer occur = (Integer)mapOccurrences.get(sNameFolder);
                                    int count = occur + 1;
                                    mapOccurrences.put(sNameFolder, count);
                                } else {
                                    mapOccurrences.put(sNameFolder, new Integer(1));
                                }
                            } else {
                                lFolders.add(sIDOfParentFolder);
                            }
                            if (items.size() != i + 1) continue;
                            Iterator iter2 = mapMessage.keySet().iterator();
                            if (mapMessage.size() > 0) {
                                if (sbDupsInSelections.length() == 0) {
                                    sbDupsInSelections.append(bundle.getString("CheckInWizard.DuplicatesSelectedWarningStart.txt"));
                                }
                                sbDupsInSelections.append("\n\n").append(bundle.formatString("CheckInWizard.DuplicatesSelectedTypeName.fmt", (Object)typeName));
                            }
                            while (iter2.hasNext()) {
                                String sNameFolderValue = (String)iter2.next();
                                String sMessage = (String)mapMessage.get(sNameFolderValue);
                                Integer howMany = (Integer)mapOccurrences.get(sNameFolderValue);
                                sbDupsInSelections.append("\n").append(bundle.formatString("CheckInWizard.DuplicatesMessageWithCount.fmt", (Object)howMany.toString(), (Object)sMessage));
                            }
                        }
                    }
                    if (sbDupsInSelections.length() > 0) {
                        MessageUtil.displayMessage((String)sbDupsInSelections.toString(), (String)bundle.getString("CheckInWizard.DuplicatesSelectedTitle.txt"), (int)2);
                        bvalid = false;
                    } else {
                        for (String type : lCheckInObjects.keySet()) {
                            String typeName = childServer.getTypeDescriptor(type).getLabel();
                            List items = (List)lCheckInObjects.get(type);
                            boolean bDupTypeFound = false;
                            for (int i = 0; i < items.size(); ++i) {
                                MetadataInterface mi;
                                String key;
                                ExportItemInterface item = (ExportItemInterface)items.get(i);
                                Root oData = (Root)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, item.getTypeInterface().getMetadataType(), item.getID(), null, null, null, 8);
                                Root oParent = null;
                                List lItemsInFolder = new ArrayList();
                                oParent = this.getParent(oData);
                                if (oParent == null) {
                                    String message = bundle.formatString("CheckInWizard.NoFolder.Message.fmt", (Object)oData.getName());
                                    MessageUtil.displayMessage((String)message, (int)2);
                                    boolean sNameFolderValue = false;
                                    return sNameFolderValue;
                                }
                                String sIDOfParent = this.getParentFolderID(oParent);
                                if (oData.getCMetadataType().equals("Tree")) {
                                    key = sIDOfParent + "/" + oParent.getCMetadataType();
                                    mi = childServer.fetch(key, true);
                                    lItemsInFolder = ((FolderInterface)mi).getSubfolders();
                                } else {
                                    key = sIDOfParent + "/" + oParent.getCMetadataType();
                                    mi = childServer.fetch(key, true);
                                    lItemsInFolder = ((FolderInterface)mi).getItemsByType(item.getTypeInterface().getPublicType());
                                }
                                String sItemName = oData.getName();
                                boolean bIsProjectFolder = Workspace.getWorkspace().getProjectRepositoryId().equals(oParent.getFQID().substring(0, 8));
                                for (int x = 0; x < lItemsInFolder.size(); ++x) {
                                    String sNonProjectID;
                                    String sChangeState;
                                    MetadataInterface omi = (MetadataInterface)lItemsInFolder.get(x);
                                    if (bIsProjectFolder && omi.getIdentifier().substring(0, 8).equals(Workspace.getWorkspace().getProjectRepositoryId()) || !sItemName.equalsIgnoreCase(omi.getName()) || (sChangeState = oData.getChangeState()).toUpperCase().startsWith("CHECKOUT") && (sNonProjectID = sChangeState.substring(sChangeState.indexOf(":") + 2)).equals(omi.getIdentifier())) continue;
                                    if (sbDupsInFolder.length() == 0) {
                                        sbDupsInFolder.append(bundle.getString("CheckInWizard.DuplicatesExistWarningStart.txt"));
                                    }
                                    if (!bDupTypeFound) {
                                        bDupTypeFound = true;
                                        sbDupsInFolder.append("\n\n").append(bundle.formatString("CheckInWizard.DuplicatesExistTypeName.fmt", (Object)typeName));
                                    }
                                    sbDupsInFolder.append("\n").append(bundle.formatString("CheckInWizard.DuplicatesExistNameAndFolder.fmt", (Object)sItemName, (Object)oParent.getName()));
                                }
                            }
                        }
                    }
                    if (sbDupsInFolder.length() > 0) {
                        MessageUtil.displayMessage((String)sbDupsInFolder.toString(), (String)bundle.getString("CheckInWizard.DuplicatesExistTitle.txt"), (int)2);
                        bvalid = false;
                    }
                    childServer.rollback();
                    childServer = null;
                }
                catch (MdException mde) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
                }
                finally {
                    store.dispose();
                    if (childServer != null) {
                        childServer.rollback();
                    }
                }
            }
            catch (ServiceException se) {
                MessageUtil.displayServiceExceptionMessage((ServiceException)se);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return bvalid;
        }

        protected Root getParent(Root oData) {
            Tree oParent = null;
            try {
                if (oData.getCMetadataType().equals("Tree")) {
                    AssociationList alSC;
                    oParent = ((Tree)oData).getParentTree();
                    if (oParent == null && (alSC = ((Tree)oData).getSoftwareComponents()).size() > 0) {
                        oParent = (SoftwareComponent)alSC.get(0);
                    }
                } else {
                    AssociationList lTrees = oData.getTrees();
                    if (lTrees.size() > 0) {
                        oParent = (Tree)lTrees.get(0);
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            }
            return oParent;
        }

        protected String getParentFolderID(Root oParent) {
            try {
                String sParentChangeState = oParent.getChangeState();
                if (sParentChangeState.toUpperCase().startsWith("CHECKOUT")) {
                    return sParentChangeState.substring(sParentChangeState.indexOf(":") + 2);
                }
                return oParent.getFQID();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
                return "";
            }
        }
    }
}

