/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.etl.DirectiveInterface;
import com.sas.services.information.metadata.etl.ProfileReportInterface;
import com.sas.wadmin.app.AppViewFactory;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.wadmin.app.actions.UpgradeLogicalObjectAction;
import com.sas.wadmin.jobeditor.diagram.ISASApplicationServerDiagramPanel;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.models.SimpleObject;
import java.net.URI;
import java.rmi.RemoteException;

class OpenSelectedObjectsAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(OpenSelectedObjectsAction.class);

    public OpenSelectedObjectsAction() {
        super(bundle, "AppActionsManager.Action.FileOpenSelectedObjects", 256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        WsSelectionProvider provider = this.getSelectionProvider();
        for (int iObject = 0; iObject < aSelectedObjects.length; ++iObject) {
            SimpleObject obj = (SimpleObject)aSelectedObjects[iObject];
            boolean bContinue = UpgradeLogicalObjectAction.isVersionSupported(obj);
            if (!bContinue) {
                return;
            }
            if (provider instanceof ISASApplicationServerDiagramPanel && ("Table".equals(obj.getPublicType()) || "WorkTable".equals(obj.getPublicType()) || "ExternalFile".equals(obj.getPublicType()))) {
                AppViewFactory.getInstance().showOpenView(obj, ((ISASApplicationServerDiagramPanel)provider).getSASAppServer());
                continue;
            }
            if ("Directive.DL".equals(obj.getPublicType()) || "ProfileReport.DL".equals(obj.getPublicType())) {
                URI webpage;
                DirectiveInterface directive;
                String key;
                ServerInterface server;
                ChildServerInterface child;
                if ("Directive.DL".equals(obj.getPublicType())) {
                    child = null;
                    try {
                        server = Workspace.getWorkspace().getUserContext().getAuthServer();
                        child = server.newChild(true);
                        key = obj.getID() + "/" + "Transformation";
                        directive = (DirectiveInterface)child.fetch(key, false);
                        webpage = directive.getApplicationOpenURI();
                        ModelUIUtilities.showWebpage(webpage.toString());
                    }
                    catch (ServiceException e) {
                        Workspace.handleServiceException((ServiceException)e);
                    }
                    catch (RemoteException e) {
                        Workspace.handleRemoteException((RemoteException)e);
                    }
                    finally {
                        try {
                            if (child != null) {
                                child.destroy();
                            }
                        }
                        catch (ServiceException e) {
                            Workspace.handleServiceException((ServiceException)e);
                        }
                        catch (RemoteException e) {
                            Workspace.handleRemoteException((RemoteException)e);
                        }
                    }
                }
                if (!"ProfileReport.DL".equals(obj.getPublicType())) continue;
                child = null;
                try {
                    server = Workspace.getWorkspace().getUserContext().getAuthServer();
                    child = server.newChild(true);
                    key = obj.getID() + "/" + "Transformation";
                    directive = (ProfileReportInterface)child.fetch(key, false);
                    webpage = directive.getApplicationOpenURI();
                    ModelUIUtilities.showWebpage(webpage.toString());
                    continue;
                }
                catch (ServiceException e) {
                    Workspace.handleServiceException((ServiceException)e);
                    continue;
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException((RemoteException)e);
                    continue;
                }
                finally {
                    try {
                        if (child != null) {
                            child.destroy();
                        }
                    }
                    catch (ServiceException e) {
                        Workspace.handleServiceException((ServiceException)e);
                    }
                    catch (RemoteException e) {
                        Workspace.handleRemoteException((RemoteException)e);
                    }
                }
            }
            if (obj instanceof JobTransformModel && !(bContinue = UpgradeLogicalObjectAction.isVersionSupported(obj = ((JobTransformModel)obj).getInnerJob()))) {
                return;
            }
            AppViewFactory.getInstance().showOpenView(obj);
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        int numTables = 0;
        if (aSelectedObjects.length == 0) {
            return false;
        }
        WsSelectionProvider provider = this.getSelectionProvider();
        for (int iObject = 0; iObject < aSelectedObjects.length; ++iObject) {
            if (!(aSelectedObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            if (aSelectedObjects[iObject] instanceof IWorkTable && provider instanceof ISASApplicationServerDiagramPanel && ((ISASApplicationServerDiagramPanel)provider).getSASAppServer() != null) continue;
            SimpleObject obj = (SimpleObject)aSelectedObjects[iObject];
            if ("Directive.DL".equals(obj.getPublicType()) || "ProfileReport.DL".equals(obj.getPublicType())) {
                return true;
            }
            if (!AppViewFactory.getInstance().isOpenViewSupported(obj)) {
                return false;
            }
            String sType = ((SimpleObject)aSelectedObjects[iObject]).getPublicType();
            if (!"Table".equals(sType)) continue;
            if (numTables > 0) {
                return false;
            }
            ++numTables;
        }
        return true;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        if ("DiagramTab".equals(context.getType()) && aObjects.length == 1 && aObjects[0] instanceof SimpleObject && "Job".equals(((SimpleObject)aObjects[0]).getPublicType())) {
            return false;
        }
        WsSelectionProvider provider = this.getSelectionProvider();
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (!(aObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            if (aObjects[iObject] instanceof IWorkTable && provider instanceof ISASApplicationServerDiagramPanel) continue;
            SimpleObject obj = (SimpleObject)aObjects[iObject];
            if ("Directive.DL".equals(obj.getPublicType()) || "ProfileReport.DL".equals(obj.getPublicType())) {
                return true;
            }
            if (AppViewFactory.getInstance().isOpenViewSupported(obj)) continue;
            return false;
        }
        return true;
    }
}

