/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppDialogFactory;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.TransportUtil;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import javax.swing.JFrame;

class MoveToFolderAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(MoveToFolderAction.class);

    public MoveToFolderAction() {
        super(bundle, "AppActionsManager.Action.EditMoveToFolder", 257);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        AppDialogFactory.getInstance().showMoveToFolderDialog((JFrame)Workspace.getWorkspace(), aObjects);
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length == 0) {
            return false;
        }
        for (int iSelectedObject = 0; iSelectedObject < aSelectedObjects.length; ++iSelectedObject) {
            if (aSelectedObjects[iSelectedObject] instanceof SimpleObject) continue;
            return false;
        }
        try {
            LogicalObjectInterface[] aLogicalObjects = ObjectConverter.getInstance().convertToLogicalObjects(aSelectedObjects);
            for (int iSelectedObject = 0; iSelectedObject < aLogicalObjects.length; ++iSelectedObject) {
                LogicalObjectInterface oLogical = aLogicalObjects[iSelectedObject];
                if (oLogical == null) {
                    return false;
                }
                if (((LogicalObject)oLogical).checkMoveAllowed() == null) continue;
                return false;
            }
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        return TransportUtil.areObjectsTransportable(aObjects);
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if ("DiagramTab".equals(context.getType())) {
            return false;
        }
        return this.isSelectionValid(context.getSelectedObjects());
    }
}

