/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.wadmin.app.AppFrameworkManager;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;

class FindInTransformationsAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(FindInTransformationsAction.class);

    public FindInTransformationsAction() {
        super(bundle, "AppActionsManager.Action.EditFindInTransformations", 257);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        ((AppFrameworkManager)AppFrameworkManager.getInstance()).findInTransformations(aObjects);
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aSelectedObjects.length; ++iObject) {
            if (aSelectedObjects[iObject] instanceof JobTransformModel) {
                return false;
            }
            if (!(aSelectedObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            String sType = ((SimpleObject)aSelectedObjects[iObject]).getPublicType();
            if ("GeneratedTransform".equals(sType) || "TransformInstance".equals(sType)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if ("TransformationsTree".equals(context.getType())) {
            return false;
        }
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] instanceof JobTransformModel) {
                return false;
            }
            if (!(aObjects[iObject] instanceof SimpleObject)) {
                return false;
            }
            String sType = ((SimpleObject)aObjects[iObject]).getPublicType();
            if ("GeneratedTransform".equals(sType) || "TransformInstance".equals(sType)) continue;
            return false;
        }
        return true;
    }
}

