/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.wadmin.app.AppDialogFactory;
import com.sas.wadmin.app.TransportUtil;
import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import javax.swing.JFrame;

class ArchiveAsSASPackageAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(ArchiveAsSASPackageAction.class);

    public ArchiveAsSASPackageAction() {
        super(bundle, "AppActionsManager.Action.FileArchiveAsSASPackage", 256);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        AppDialogFactory.getInstance().showArchiveDialog((JFrame)Workspace.getWorkspace(), aObjects);
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length == 0) {
            return false;
        }
        for (int iSelectedObject = 0; iSelectedObject < aSelectedObjects.length; ++iSelectedObject) {
            if (aSelectedObjects[iSelectedObject] instanceof SimpleObject) continue;
            return false;
        }
        SimpleObject[] aObjects = new SimpleObject[aSelectedObjects.length];
        System.arraycopy(aSelectedObjects, 0, aObjects, 0, aSelectedObjects.length);
        return TransportUtil.areObjectsTransportable(aObjects);
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        String contextType = context.getType();
        if (contextType.equals("DiagramTab") || contextType.equals("CheckoutsTree")) {
            return false;
        }
        if (context.getSelectedObjects().length == 0) {
            return false;
        }
        return this.isSelectionValid(context.getSelectedObjects());
    }
}

