/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app.actions;

import com.sas.wadmin.app.actions.AbstractSelectionAction;
import com.sas.wadmin.drill.DrillPanel;
import com.sas.wadmin.jobeditor.JobEditorPanel;
import com.sas.wadmin.jobeditor.diagram.DiagramPanel;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardInternalFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import java.util.Arrays;
import javax.swing.JInternalFrame;

public class AddToDiagramAction
extends AbstractSelectionAction {
    private static final WAdminResource bundle = WAdminResource.getBundle(AddToDiagramAction.class);

    public AddToDiagramAction() {
        super(bundle, "AppActionsManager.Action.ActionsAddToDiagram", 257);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        JobEditorPanel pnl = this.getActiveJobEditorPanel();
        if (pnl == null) {
            throw new IllegalStateException("Add to diagram action performed when there is no active diagram panel.");
        }
        pnl.addNodes(aSelectedObjects);
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        if (aSelectedObjects.length == 0) {
            return false;
        }
        JobEditorPanel pnl = this.getActiveJobEditorPanel();
        if (pnl == null) {
            return false;
        }
        return pnl.isAddValid(aSelectedObjects);
    }

    private JobEditorPanel getActiveJobEditorPanel() {
        WAPanel pnl;
        JInternalFrame[] aFrames = Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames();
        if (aFrames.length > 0 && aFrames[0] instanceof WAStandardInternalFrame && (pnl = ((WAStandardInternalFrame)aFrames[0]).getMainPanel()) instanceof DrillPanel && (pnl = ((DrillPanel)pnl).getCurrentPanel()) instanceof JobEditorPanel) {
            return (JobEditorPanel)pnl;
        }
        return null;
    }

    public boolean isValidForContext(WsActionContextInterface context) {
        if ("DiagramTab".equals(context.getType())) {
            return false;
        }
        Object[] aSelectedObjects = context.getSelectedObjects();
        if (aSelectedObjects.length == 0) {
            return false;
        }
        return DiagramPanel.isAddPossible(Arrays.asList(aSelectedObjects));
    }
}

