/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app;

import com.sas.metadata.Util;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.wizards.CheckInWizard;
import com.sas.wadmin.visuals.ClearProjectDialog;
import com.sas.wadmin.visuals.OperationUIAdapter;
import com.sas.wadmin.visuals.WAdminTreeObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.OpRequestUICancellableRunnable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractOperation;
import com.sas.workspace.WsLockManager;
import com.sas.workspace.WsMessageDisplayer;
import com.sas.workspace.changemanagement.CMEvent;
import com.sas.workspace.changemanagement.CMListenerManager;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.SimpleBrowseObjectTreeNode;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class ChangeManagementUtil {
    private static final WAdminResource bundle = WAdminResource.getBundle(ChangeManagementUtil.class);
    private static final String TEMPLATE_STRING_VALUE = "                                                            ";
    private static String m_changeName;
    private static String m_changeDesc;

    private ChangeManagementUtil() {
    }

    public static boolean isCheckOutAllowed(SimpleBrowseObject object) {
        if (Workspace.getWorkspace().getChangeManagementState() == Workspace.CHANGEMANAGEMENT_OFF) {
            return false;
        }
        String sChangeState = object.getChangeState();
        if (sChangeState != null && sChangeState.toUpperCase().startsWith("CHECK")) {
            return false;
        }
        try {
            String sProjectReposID = Workspace.getWorkspace().getProjectRepositoryId();
            if (sProjectReposID != null && sProjectReposID.equals(object.getID().substring(0, 8))) {
                return false;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        try {
            LogicalObjectInterface lob = ObjectConverter.getInstance().convertToLogicalObject((SimpleObject)object);
            return lob == null ? false : lob.ischeckOutAllowed();
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        return false;
    }

    public static void checkOut(SimpleObject[] aObjects) {
        if (ChangeManagementUtil.isAnyObjectInUse(aObjects, "ChangeManagementUtil.ObjectInUseNoCheckout.Text.fmt")) {
            return;
        }
        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace());
        request.setDelayBeforeProgressCancelDialog(0);
        request.executeWithCancel((OpRequestUICancellableRunnable)new CheckOutOperation2(aObjects, request));
        Workspace.getLogger((String)ChangeManagementUtil.class.getName()).debug((Object)"Finished checking out");
    }

    private static void checkOutObject(SimpleObject aObject) {
        try {
            StringBuffer sbXML = new StringBuffer();
            int flags = 1032;
            sbXML.append("<CheckoutLogical><Metadata>");
            sbXML.append("<").append(aObject.getMetadataType());
            sbXML.append(" ID=\"").append(aObject.getID()).append("\"/>");
            sbXML.append("</Metadata>");
            sbXML.append("<ProjectReposid>").append(Workspace.getWorkspace().getProjectRepository().getFQID()).append("</ProjectReposid>");
            sbXML.append("<Ns>SAS</Ns>");
            sbXML.append("<Flags>").append(flags).append("</Flags>");
            sbXML.append("<Options/></CheckoutLogical>");
            Util.printLogln((String)("Checkout XML: " + sbXML.toString()));
            try {
                Document ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(sbXML.toString(), false);
                CMListenerManager cmManager = CMListenerManager.getInstance();
                if (cmManager != null) {
                    cmManager.populateCheckOutMaps(ioutDoc);
                    cmManager.fireCMObjectsCreated(new CMEvent((Object)ioutDoc, null, cmManager.getProjectObjectsCreated(), "CHECKOUT"));
                    cmManager.fireCMObjectsUpdated(new CMEvent((Object)ioutDoc, cmManager.getPrimaryObjectsUpdated(), null, "CHECKOUT"));
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Checkingout");
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private static void checkOutObjects(SimpleObject[] aObjects) {
        try {
            StringBuffer sbXML = new StringBuffer();
            int flags = 1032;
            sbXML.append("<CheckoutLogical><Metadata>");
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                SimpleObject object = aObjects[iObject];
                sbXML.append("<").append(object.getMetadataType());
                sbXML.append(" ID=\"").append(object.getID()).append("\"/>");
            }
            sbXML.append("</Metadata>");
            sbXML.append("<ProjectReposid>").append(Workspace.getWorkspace().getProjectRepository().getFQID()).append("</ProjectReposid>");
            sbXML.append("<Ns>SAS</Ns>");
            sbXML.append("<Flags>").append(flags).append("</Flags>");
            sbXML.append("<Options/></CheckoutLogical>");
            Util.printLogln((String)("Checkout XML: " + sbXML.toString()));
            try {
                Document ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(sbXML.toString(), false);
                CMListenerManager cmManager = CMListenerManager.getInstance();
                if (cmManager != null) {
                    cmManager.populateCheckOutMaps(ioutDoc);
                    cmManager.fireCMObjectsCreated(new CMEvent((Object)ioutDoc, null, cmManager.getProjectObjectsCreated(), "CHECKOUT"));
                    cmManager.fireCMObjectsUpdated(new CMEvent((Object)ioutDoc, cmManager.getPrimaryObjectsUpdated(), null, "CHECKOUT"));
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Checkingout");
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public static boolean isFetchAllowed(SimpleObject object) {
        return false;
    }

    public static void fetch(SimpleObject[] aObjects) {
        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace());
        request.setDelayBeforeProgressCancelDialog(0);
        request.executeWithCancel((OpRequestUICancellableRunnable)new FetchOperation(aObjects, request));
        Workspace.getLogger((String)ChangeManagementUtil.class.getName()).debug((Object)"Finished fetching");
    }

    public static boolean isCheckInAllowed(SimpleObject object) {
        if (Workspace.getWorkspace().getChangeManagementState() == Workspace.CHANGEMANAGEMENT_OFF) {
            return false;
        }
        try {
            String sProjectReposID = Workspace.getWorkspace().getProjectRepositoryId();
            if (sProjectReposID != null && !sProjectReposID.equals(object.getID().substring(0, 8))) {
                return false;
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return true;
    }

    public static void checkIn(SimpleObject[] aObjects) {
        try {
            if (ChangeManagementUtil.isAnyObjectInUse(aObjects, "ChangeManagementUtil.ObjectInUseNoCheckin.Text.fmt")) {
                return;
            }
            TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
            LogicalObjectInterface[] aLogicalObjects = ObjectConverter.getInstance().convertToLogicalObjects(aObjects);
            CheckInWizard wizard = new CheckInWizard((SimpleLogicalObjectInterface[])aLogicalObjects, aSupportedTypes, "");
            wizard.show();
            if (wizard.getReturnValue() == 2) {
                wizard.dispose();
                return;
            }
            String sOptions = "<XMLSELECT Search=\"*[@ChangeState ? 'Checkout']\"/>";
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ChangeManagementUtil: checkIn");
            List listObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, Workspace.getWorkspace().getProjectRepository().getFQID(), "Root", 408, sOptions);
            store.dispose();
            ArrayList<String> lExistingObjects = new ArrayList<String>();
            for (int i = 0; i < listObjects.size(); ++i) {
                Root object = (Root)listObjects.get(i);
                String changeState = object.getChangeState();
                lExistingObjects.add(changeState.substring(changeState.indexOf(":") + 2));
            }
            m_changeName = (String)wizard.getWizardData("CHANGENAME");
            m_changeDesc = (String)wizard.getWizardData("CHANGEDESC");
            Map lObjects = wizard.getCheckInObjectIDs();
            Iterator iter = lObjects.keySet().iterator();
            ArrayList<SimpleObjectImpl> alObjects = new ArrayList<SimpleObjectImpl>();
            while (iter.hasNext()) {
                String type = (String)iter.next();
                List items = (List)lObjects.get(type);
                for (int i = 0; i < items.size(); ++i) {
                    ExportItemInterface item = (ExportItemInterface)items.get(i);
                    SimpleObjectImpl so = new SimpleObjectImpl(item.getName(), item.getID(), item.getTypeInterface().getMetadataType(), item.getTypeInterface().getPublicType());
                    alObjects.add(so);
                }
            }
            SimpleObject[] aSimpleObjects = alObjects.toArray(new SimpleObject[alObjects.size()]);
            if (ChangeManagementUtil.isAnyObjectInUse(aSimpleObjects, "ChangeManagementUtil.ObjectInUseNoCheckin.Text.fmt")) {
                return;
            }
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace());
            request.setDelayBeforeProgressCancelDialog(0);
            request.executeWithCancel((OpRequestUICancellableRunnable)new CheckInOperation2(aSimpleObjects, request, lExistingObjects));
            Workspace.getLogger((String)ChangeManagementUtil.class.getName()).debug((Object)"Finished checking in");
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
    }

    public static void checkInNoWizard(SimpleObject[] aObjects, String sChangeName, String sChangeDesc) {
        try {
            if (ChangeManagementUtil.isAnyObjectInUse(aObjects, "ChangeManagementUtil.ObjectInUseNoCheckin.Text.fmt")) {
                return;
            }
            String sOptions = "<XMLSELECT Search=\"*[@ChangeState ? 'Checkout']\"/>";
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ChangeManagementUtil: checkIn");
            List listObjects = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, Workspace.getWorkspace().getProjectRepository().getFQID(), "Root", 408, sOptions);
            store.dispose();
            ArrayList<String> lExistingObjects = new ArrayList<String>();
            for (int i = 0; i < listObjects.size(); ++i) {
                Root object = (Root)listObjects.get(i);
                String changeState = object.getChangeState();
                lExistingObjects.add(changeState.substring(changeState.indexOf(":") + 2));
            }
            m_changeName = sChangeName != null && sChangeName.length() >= 0 ? sChangeName : "Check In Job Code";
            m_changeDesc = sChangeDesc != null && sChangeDesc.length() >= 0 ? sChangeDesc : "";
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace());
            request.setDelayBeforeProgressCancelDialog(0);
            request.executeWithCancel((OpRequestUICancellableRunnable)new CheckInOperation2(aObjects, request, lExistingObjects));
            Workspace.getLogger((String)ChangeManagementUtil.class.getName()).debug((Object)"Finished checking in");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
    }

    private static void checkInObject(SimpleObject aObject, List lCheckOuts) {
        try {
            boolean bSuccess = ChangeManagementUtil.setChangeStateForNewObjects(aObject);
            if (!bSuccess) {
                MessageUtil.displayMessage((String)bundle.getString("ChangeManagementUtil.ChangeStateError.CannotSetChangeState.txt"), (String)bundle.getString("ChangeManagementUtil.ChangeStateError.Title.txt"), (int)0);
                return;
            }
            String strCleanChangeName = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(m_changeName);
            String strCleanChangeDesc = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(m_changeDesc);
            StringBuffer sbXML = new StringBuffer();
            int flags = 1032;
            sbXML.append("<CheckinLogical><Metadata>");
            sbXML.append("<").append(aObject.getMetadataType());
            sbXML.append(" ID=\"").append(aObject.getID()).append("\"/>");
            sbXML.append("</Metadata>");
            sbXML.append("<ProjectReposid>").append(Workspace.getWorkspace().getProjectRepository().getFQID()).append("</ProjectReposid>");
            sbXML.append("<ChangeName>").append(strCleanChangeName).append("</ChangeName>");
            sbXML.append("<ChangeDesc>").append(strCleanChangeDesc).append("</ChangeDesc>");
            sbXML.append("<Ns>SAS</Ns>");
            sbXML.append("<Flags>").append(flags).append("</Flags>");
            sbXML.append("<Options/></CheckinLogical>");
            Util.printLogln((String)("Checkin XML: " + sbXML.toString()));
            try {
                Document ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(sbXML.toString(), false);
                CMListenerManager cmManager = CMListenerManager.getInstance();
                if (cmManager != null) {
                    cmManager.populateCheckInMaps(ioutDoc, lCheckOuts, aObject.getID(), aObject.getMetadataType());
                    cmManager.fireCMObjectsCreated(new CMEvent((Object)ioutDoc, cmManager.getPrimaryObjectsCreated(), null, "CHECKIN"));
                    cmManager.fireCMObjectsUpdated(new CMEvent((Object)ioutDoc, cmManager.getPrimaryObjectsUpdated(), null, "CHECKIN"));
                    cmManager.fireCMObjectsDeleted(new CMEvent((Object)ioutDoc, null, cmManager.getProjectObjectsDeleted(), "CHECKIN"));
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Checkingin");
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private static void checkInObjects(SimpleObject[] aObjects, List lCheckOuts) {
        try {
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                SimpleObject aObject = aObjects[iObject];
                boolean bSuccess = ChangeManagementUtil.setChangeStateForNewObjects(aObject);
                if (bSuccess) continue;
                MessageUtil.displayMessage((String)bundle.getString("ChangeManagementUtil.ChangeStateError.CannotSetChangeState.txt"), (String)bundle.getString("ChangeManagementUtil.ChangeStateError.Title.txt"), (int)0);
                return;
            }
            String strCleanChangeName = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(m_changeName);
            String strCleanChangeDesc = Workspace.getMdFactory().getOMIUtil().cleanStringForXML(m_changeDesc);
            StringBuffer sbXML = new StringBuffer();
            int flags = 1032;
            sbXML.append("<CheckinLogical><Metadata>");
            for (int iObject = 0; iObject < aObjects.length; ++iObject) {
                SimpleObject aObject = aObjects[iObject];
                sbXML.append("<").append(aObject.getMetadataType());
                sbXML.append(" ID=\"").append(aObject.getID()).append("\"/>");
            }
            sbXML.append("</Metadata>");
            sbXML.append("<ProjectReposid>").append(Workspace.getWorkspace().getProjectRepository().getFQID()).append("</ProjectReposid>");
            sbXML.append("<ChangeName>").append(strCleanChangeName).append("</ChangeName>");
            sbXML.append("<ChangeDesc>").append(strCleanChangeDesc).append("</ChangeDesc>");
            sbXML.append("<Ns>SAS</Ns>");
            sbXML.append("<Flags>").append(flags).append("</Flags>");
            sbXML.append("<Options/></CheckinLogical>");
            Util.printLogln((String)("Checkin XML: " + sbXML.toString()));
            try {
                Document ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(sbXML.toString(), false);
                CMListenerManager cmManager = CMListenerManager.getInstance();
                if (cmManager != null) {
                    cmManager.populateCheckInMaps(ioutDoc, lCheckOuts, aObjects);
                    cmManager.fireCMObjectsCreated(new CMEvent((Object)ioutDoc, cmManager.getPrimaryObjectsCreated(), null, "CHECKIN"));
                    cmManager.fireCMObjectsUpdated(new CMEvent((Object)ioutDoc, cmManager.getPrimaryObjectsUpdated(), null, "CHECKIN"));
                    cmManager.fireCMObjectsDeleted(new CMEvent((Object)ioutDoc, null, cmManager.getProjectObjectsDeleted(), "CHECKIN"));
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Checkingin");
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearProject(boolean bShowDialog) {
        try {
            List aRepositories = new ArrayList();
            if (bShowDialog) {
                ClearProjectDialog clearDlg = new ClearProjectDialog();
                clearDlg.show();
                if (clearDlg.getReturnValue() == 2) {
                    clearDlg.dispose();
                    return;
                }
                clearDlg.dispose();
                aRepositories = clearDlg.getSelectedProjects();
            } else {
                int eAnswer = MessageUtil.displayMessage((String)bundle.getString("ChangeManagementUtil.ClearProjectWarning.Message.txt"), (String)bundle.getString("ChangeManagementUtil.ClearProjectWarning.Title.txt"), (int)2, (int)0);
                if (eAnswer == 1) {
                    return;
                }
                WAdminTreeObject treeObject = (WAdminTreeObject)Workspace.getWorkspace().getTreeObject();
                ITreeNode rootNode = (ITreeNode)treeObject.getCheckoutsTree().getModel().getRoot();
                Enumeration logicalBrowseObjectTreeNodes = rootNode.children();
                SimpleBrowseObject[] aObjects = new SimpleBrowseObject[rootNode.getChildCount()];
                int i = 0;
                while (logicalBrowseObjectTreeNodes.hasMoreElements()) {
                    ITreeNode nextChildNode = (ITreeNode)logicalBrowseObjectTreeNodes.nextElement();
                    if (!(nextChildNode instanceof SimpleBrowseObjectTreeNode)) continue;
                    aObjects[i] = ((SimpleBrowseObjectTreeNode)nextChildNode).getSimpleBrowseObject();
                    ++i;
                }
                if (ChangeManagementUtil.isAnyObjectInUse((SimpleObject[])aObjects, "ChangeManagementUtil.ObjectInUseNoClear.Text.fmt")) {
                    return;
                }
                ArrayList<Object> alRow = new ArrayList<Object>();
                String sProjectName = Workspace.getWorkspace().getProjectRepository().getName();
                String sProjectID = Workspace.getWorkspace().getProjectRepository().getFQID();
                Boolean bDeletedRepos = Boolean.FALSE;
                alRow.add(sProjectName);
                alRow.add(sProjectID);
                alRow.add(bDeletedRepos);
                aRepositories.add(alRow);
            }
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace());
            request.setDelayBeforeProgressCancelDialog(0);
            request.executeWithCancel((OpRequestUICancellableRunnable)new ClearProjectOperation(aRepositories, request));
            Workspace.getLogger((String)ChangeManagementUtil.class.getName()).debug((Object)"Finished clearing project");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private static void clearProjectRepository(String sName, String sID, boolean bDeleted) {
        block9: {
            try {
                if (bDeleted) {
                    try {
                        String sFoundationReposID = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
                        StringBuffer sbXML = new StringBuffer();
                        int flags = 1033;
                        sbXML.append("<UndoCheckoutLogical><Metadata>");
                        sbXML.append("<PhysicalTable ChangeState=\"").append(sID.substring(9)).append("\"/></Metadata>");
                        sbXML.append("<ProjectReposid>").append(sFoundationReposID).append("</ProjectReposid>");
                        sbXML.append("<Ns>SAS</Ns>");
                        sbXML.append("<Flags>").append(flags).append("</Flags>");
                        sbXML.append("<Options/></UndoCheckoutLogical>");
                        Util.printLogln((String)("ClearProject XML: " + sbXML.toString()));
                        Document ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(sbXML.toString(), false);
                        CMListenerManager cmManager = CMListenerManager.getInstance();
                        if (cmManager != null) {
                            cmManager.populateClearDeletedProjectMaps(ioutDoc);
                            cmManager.fireCMObjectsUpdated(new CMEvent((Object)ioutDoc, cmManager.getPrimaryObjectsUpdated(), null, "CLEARPROJECT"));
                        }
                        break block9;
                    }
                    catch (MdException e) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"ClearProject");
                    }
                    break block9;
                }
                StringBuffer sbXML = new StringBuffer();
                int flags = 1033;
                sbXML.append("<UndoCheckoutLogical><Metadata/>");
                sbXML.append("<ProjectReposid>").append(sID).append("</ProjectReposid>");
                sbXML.append("<Ns>SAS</Ns>");
                sbXML.append("<Flags>").append(flags).append("</Flags>");
                sbXML.append("<Options/></UndoCheckoutLogical>");
                Util.printLogln((String)("ClearProject XML: " + sbXML.toString()));
                try {
                    Document ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(sbXML.toString(), false);
                    CMListenerManager cmManager = CMListenerManager.getInstance();
                    if (cmManager != null) {
                        cmManager.populateUndoCheckOutMaps(ioutDoc);
                        cmManager.fireCMObjectsDeleted(new CMEvent((Object)ioutDoc, null, cmManager.getProjectObjectsDeleted(), "CLEARPROJECT"));
                        cmManager.fireCMObjectsUpdated(new CMEvent((Object)ioutDoc, cmManager.getPrimaryObjectsUpdated(), null, "CLEARPROJECT"));
                    }
                }
                catch (MdException e) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"ClearProject");
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public static boolean isUndoCheckOutAllowed(SimpleBrowseObject object) {
        if (Workspace.getWorkspace().getChangeManagementState() == Workspace.CHANGEMANAGEMENT_OFF) {
            return false;
        }
        String sChangeState = object.getChangeState();
        return sChangeState != null && sChangeState.toUpperCase().startsWith("CHECKOUT");
    }

    public static void undoCheckOut(SimpleObject[] aObjects) {
        int answer;
        if (ChangeManagementUtil.isAnyObjectInUse(aObjects, "ChangeManagementUtil.ObjectInUseNoUndoCheckout.Text.fmt")) {
            return;
        }
        ArrayList<String> lUndoObjects = new ArrayList<String>();
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            SimpleObject so = aObjects[iObject];
            if (so == null) continue;
            lUndoObjects.add(so.getName());
        }
        String message = "";
        if (lUndoObjects.size() == 1) {
            message = bundle.getString("ChangeManagementUtil.UndoCheckOutSingleObjectConfirmation.Message.txt");
        } else if (lUndoObjects.size() > 1) {
            message = bundle.getString("ChangeManagementUtil.UndoCheckOutMultipleObjectsConfirmation.Message.txt");
        }
        if (lUndoObjects.size() > 0 && ((answer = MessageUtil.displayListMessage((String)message, lUndoObjects, (String)bundle.getString("ChangeManagementUtil.UndoCheckOutConfirmation.Title.txt"), (int)2, (int)0)) == 1 || answer == -1)) {
            return;
        }
        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace());
        request.setDelayBeforeProgressCancelDialog(0);
        request.executeWithCancel((OpRequestUICancellableRunnable)new UndoCheckOutOperation(aObjects, request));
        Workspace.getLogger((String)ChangeManagementUtil.class.getName()).debug((Object)"Finished undoing check out");
    }

    private static void undoCheckOutObject(SimpleObject aObject) {
        try {
            StringBuffer sbXML = new StringBuffer();
            int flags = 1032;
            sbXML.append("<UndoCheckoutLogical><Metadata>");
            sbXML.append("<").append(aObject.getMetadataType());
            sbXML.append(" ID=\"").append(aObject.getID()).append("\"/>");
            sbXML.append("</Metadata>");
            sbXML.append("<ProjectReposid>").append(Workspace.getWorkspace().getProjectRepository().getFQID()).append("</ProjectReposid>");
            sbXML.append("<Ns>SAS</Ns>");
            sbXML.append("<Flags>").append(flags).append("</Flags>");
            sbXML.append("<Options/></UndoCheckoutLogical>");
            Util.printLogln((String)("UndoCheckout XML: " + sbXML.toString()));
            try {
                Document ioutDoc = Workspace.getMdFactory().getOMIUtil().DoRequest(sbXML.toString(), false);
                CMListenerManager cmManager = CMListenerManager.getInstance();
                if (cmManager != null) {
                    cmManager.populateUndoCheckOutMaps(ioutDoc);
                    cmManager.fireCMObjectsDeleted(new CMEvent((Object)ioutDoc, null, cmManager.getProjectObjectsDeleted(), "UNDOCHECKOUT"));
                    cmManager.fireCMObjectsUpdated(new CMEvent((Object)ioutDoc, cmManager.getPrimaryObjectsUpdated(), null, "UNDOCHECKOUT"));
                }
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"UndoCheckOut");
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean setChangeStateForNewObjects(SimpleObject aObject) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "ChangeManagementUtil: setChangeStateForNewObjects");
            try {
                String sFQID = aObject.getID();
                String sType = aObject.getMetadataType();
                Root oData = (Root)Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, sType, sFQID, null, null, null, 8);
                String sChangeState = oData.getChangeState();
                if (sChangeState.length() != 0 && !sChangeState.startsWith("New")) {
                    boolean bl = true;
                    return bl;
                }
                Root parentObject = ChangeManagementUtil.findCheckInRepository(oData);
                if (parentObject != null) {
                    oData.setChangeState("New:" + parentObject.getFQID().substring(0, 8));
                    oData.updateMetadataAll();
                    boolean bl = true;
                    return bl;
                }
                Workspace.getDefaultLogger().error((Object)("Could not set change state on: " + oData.getName()));
                boolean bl = false;
                return bl;
            }
            finally {
                store.dispose();
            }
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return false;
    }

    public static boolean isAnyObjectInUse(SimpleObject[] aObjects, String sMessageKey) {
        int nObjects = aObjects.length;
        for (int iObject = 0; iObject < nObjects; ++iObject) {
            if (aObjects[iObject] == null) continue;
            SimpleObject object = aObjects[iObject];
            if (!WsLockManager.getInstance().isLocked(object.getID())) continue;
            String message = bundle.formatString(sMessageKey, (Object)object.getName());
            MessageUtil.displayMessage((String)message, (int)2);
            return true;
        }
        return false;
    }

    private static Root findCheckInRepository(Root oData) {
        block9: {
            try {
                if (oData.getCMetadataType().equals("Tree")) {
                    Tree parentTree = ((Tree)oData).getParentTree();
                    if (parentTree == null) {
                        AssociationList alSC = ((Tree)oData).getSoftwareComponents();
                        if (alSC.size() > 0) {
                            SoftwareComponent sc = (SoftwareComponent)alSC.get(0);
                            return sc;
                        }
                        break block9;
                    }
                    String sProjectReposID = Workspace.getWorkspace().getProjectRepositoryId();
                    if (sProjectReposID != null && !sProjectReposID.equals(parentTree.getFQID().substring(0, 8))) {
                        return parentTree;
                    }
                    return ChangeManagementUtil.findCheckInRepository((Root)parentTree);
                }
                AssociationList lTrees = oData.getTrees();
                if (lTrees.size() < 1) {
                    return null;
                }
                Tree oTree = (Tree)lTrees.get(0);
                String sProjectReposID = Workspace.getWorkspace().getProjectRepositoryId();
                if (sProjectReposID != null && !sProjectReposID.equals(oTree.getFQID().substring(0, 8))) {
                    return oTree;
                }
                return ChangeManagementUtil.findCheckInRepository((Root)oTree);
            }
            catch (MdException mde) {
                MessageUtil.displayMetadataExceptionMessage((MdException)mde, (String)"Accessing");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return null;
    }

    private static class CheckOutOperation2
    extends WsAbstractOperation {
        private SimpleObject[] m_aObjects;
        private OpRequestUI m_opUI;

        public CheckOutOperation2(SimpleObject[] aObjects, OpRequestUI opUI) {
            super(opUI);
            this.m_aObjects = aObjects;
            this.m_opUI = opUI;
            opUI.setMessage(bundle.formatString("ChangeManagementUtil.CheckOut.Message.fmt", (Object)ChangeManagementUtil.TEMPLATE_STRING_VALUE));
            opUI.setTitle(bundle.getString("ChangeManagementUtil.CheckOut.Title.txt"));
        }

        public void run() {
            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)this.m_opUI);
            this.updateProgress(bundle.getString("ChangeManagementUtil.CheckOutMultipleObjects.txt"));
            ChangeManagementUtil.checkOutObjects(this.m_aObjects);
        }
    }

    private static class FetchOperation
    extends WsAbstractOperation {
        private SimpleObject[] m_aObjects;
        private OpRequestUI m_opUI;

        public FetchOperation(SimpleObject[] aObjects, OpRequestUI opUI) {
            super(opUI);
            this.m_aObjects = aObjects;
            this.m_opUI = opUI;
            opUI.setMessage(bundle.formatString("ChangeManagementUtil.Fetch.Message.fmt", (Object)ChangeManagementUtil.TEMPLATE_STRING_VALUE));
            opUI.setTitle(bundle.getString("ChangeManagementUtil.Fetch.Title.txt"));
        }

        public void run() {
            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)this.m_opUI);
            for (int iObject = 0; iObject < this.m_aObjects.length; ++iObject) {
                if (this.isOperationCancelled() || op.isOperationCancelled()) {
                    return;
                }
                this.updateProgress(bundle.formatString("ChangeManagementUtil.Fetch.Message.fmt", (Object)this.m_aObjects[iObject].getName()));
                Util.printLogln((String)(this.m_aObjects[iObject].getName() + " fetched"));
            }
        }
    }

    private static class CheckInOperation2
    extends WsAbstractOperation {
        private SimpleObject[] m_aObjects;
        private OpRequestUI m_opUI;
        private List m_lCheckOuts;

        public CheckInOperation2(SimpleObject[] aObjects, OpRequestUI opUI, List lCheckOuts) {
            super(opUI);
            this.m_aObjects = aObjects;
            this.m_opUI = opUI;
            this.m_lCheckOuts = lCheckOuts;
            opUI.setMessage(bundle.formatString("ChangeManagementUtil.CheckIn.Message.fmt", (Object)ChangeManagementUtil.TEMPLATE_STRING_VALUE));
            opUI.setTitle(bundle.getString("ChangeManagementUtil.CheckIn.Title.txt"));
        }

        public void run() {
            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)this.m_opUI);
            this.updateProgress(bundle.getString("ChangeManagementUtil.CheckInMultipleObjects.txt"));
            ChangeManagementUtil.checkInObjects(this.m_aObjects, this.m_lCheckOuts);
        }
    }

    private static class ClearProjectOperation
    extends WsAbstractOperation {
        private List m_lRepositories;
        private OpRequestUI m_opUI;

        public ClearProjectOperation(List lRepositories, OpRequestUI opUI) {
            super(opUI);
            this.m_lRepositories = lRepositories;
            this.m_opUI = opUI;
            opUI.setMessage(bundle.formatString("ChangeManagementUtil.ClearingProject.Message.fmt", (Object)ChangeManagementUtil.TEMPLATE_STRING_VALUE));
            opUI.setTitle(bundle.getString("ChangeManagementUtil.ClearingProject.Title.txt"));
        }

        public void run() {
            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)this.m_opUI);
            boolean bDeletedRepos = false;
            for (int iRepos = 0; iRepos < this.m_lRepositories.size(); ++iRepos) {
                List lRow = (List)this.m_lRepositories.get(iRepos);
                String sReposName = (String)lRow.get(0);
                String sReposID = (String)lRow.get(1);
                bDeletedRepos = (Boolean)lRow.get(2);
                if (this.isOperationCancelled() || op.isOperationCancelled()) {
                    return;
                }
                this.updateProgress(bundle.formatString("ChangeManagementUtil.ClearingProject.Message.fmt", (Object)sReposName));
                ChangeManagementUtil.clearProjectRepository(sReposName, sReposID, bDeletedRepos);
                Util.printLogln((String)(sReposName + " cleared"));
                Workspace.getDefaultLogger().debug((Object)(sReposName + " checked in"));
            }
        }
    }

    private static class UndoCheckOutOperation
    extends WsAbstractOperation {
        private SimpleObject[] m_aObjects;
        private OpRequestUI m_opUI;

        public UndoCheckOutOperation(SimpleObject[] aObjects, OpRequestUI opUI) {
            super(opUI);
            this.m_aObjects = aObjects;
            this.m_opUI = opUI;
            opUI.setMessage(bundle.formatString("ChangeManagementUtil.UndoCheckOut.Message.fmt", (Object)ChangeManagementUtil.TEMPLATE_STRING_VALUE));
            opUI.setTitle(bundle.getString("ChangeManagementUtil.UndoCheckOut.Title.txt"));
        }

        public void run() {
            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)this.m_opUI);
            for (int iObject = 0; iObject < this.m_aObjects.length; ++iObject) {
                if (this.isOperationCancelled() || op.isOperationCancelled()) {
                    return;
                }
                this.updateProgress(bundle.formatString("ChangeManagementUtil.UndoCheckOut.Message.fmt", (Object)this.m_aObjects[iObject].getName()));
                ChangeManagementUtil.undoCheckOutObject(this.m_aObjects[iObject]);
                Util.printLogln((String)(this.m_aObjects[iObject].getName() + " check out undone"));
                Workspace.getDefaultLogger().debug((Object)(this.m_aObjects[iObject].getName() + " check out undone"));
            }
        }
    }

    private static class CheckInOperation
    extends WsAbstractOperation {
        private SimpleObject[] m_aObjects;
        private OpRequestUI m_opUI;
        private List m_lCheckOuts;

        public CheckInOperation(SimpleObject[] aObjects, OpRequestUI opUI, List lCheckOuts) {
            super(opUI);
            this.m_aObjects = aObjects;
            this.m_opUI = opUI;
            this.m_lCheckOuts = lCheckOuts;
            opUI.setMessage(bundle.formatString("ChangeManagementUtil.CheckIn.Message.fmt", (Object)ChangeManagementUtil.TEMPLATE_STRING_VALUE));
            opUI.setTitle(bundle.getString("ChangeManagementUtil.CheckIn.Title.txt"));
        }

        public void run() {
            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)this.m_opUI);
            for (int iObject = 0; iObject < this.m_aObjects.length; ++iObject) {
                if (this.isOperationCancelled() || op.isOperationCancelled()) {
                    return;
                }
                this.updateProgress(bundle.formatString("ChangeManagementUtil.CheckIn.Message.fmt", (Object)this.m_aObjects[iObject].getName()));
                ChangeManagementUtil.checkInObject(this.m_aObjects[iObject], this.m_lCheckOuts);
                Util.printLogln((String)(this.m_aObjects[iObject].getName() + " checked in"));
            }
        }
    }

    private static class CheckOutOperation
    extends WsAbstractOperation {
        private SimpleObject[] m_aObjects;
        private OpRequestUI m_opUI;

        public CheckOutOperation(SimpleObject[] aObjects, OpRequestUI opUI) {
            super(opUI);
            this.m_aObjects = aObjects;
            this.m_opUI = opUI;
            opUI.setMessage(bundle.formatString("ChangeManagementUtil.CheckOut.Message.fmt", (Object)ChangeManagementUtil.TEMPLATE_STRING_VALUE));
            opUI.setTitle(bundle.getString("ChangeManagementUtil.CheckOut.Title.txt"));
        }

        public void run() {
            OperationUIAdapter op = new OperationUIAdapter((WsMessageDisplayer)this.m_opUI);
            for (int iObject = 0; iObject < this.m_aObjects.length; ++iObject) {
                if (this.isOperationCancelled() || op.isOperationCancelled()) {
                    return;
                }
                this.updateProgress(bundle.formatString("ChangeManagementUtil.CheckOut.Message.fmt", (Object)this.m_aObjects[iObject].getName()));
                ChangeManagementUtil.checkOutObject(this.m_aObjects[iObject]);
                Util.printLogln((String)(this.m_aObjects[iObject].getName() + " checked out"));
                Workspace.getDefaultLogger().debug((Object)(this.m_aObjects[iObject].getName() + " checked out"));
            }
        }
    }
}

