/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app;

import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.job.transforms.GeneratedTransformModel;
import com.sas.etl.models.job.transforms.JobTransformModel;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.wadmin.analysis.ColumnAnalysisView;
import com.sas.wadmin.analysis.ExternalTableAnalysisView;
import com.sas.wadmin.analysis.GeneratedTransformationAnalysisView;
import com.sas.wadmin.analysis.MessageQueueAnalysisView;
import com.sas.wadmin.analysis.PhysicalTableAnalysisView;
import com.sas.wadmin.analysis.WorkTableAnalysisView;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.changeanalysis.ComparisonResultsView;
import com.sas.wadmin.jobeditor.JobEditorView;
import com.sas.wadmin.lineage.LineageExporterView;
import com.sas.wadmin.reports.ReportingView;
import com.sas.wadmin.search.SearchFolderView;
import com.sas.wadmin.search.SearchView;
import com.sas.wadmin.viewdata2.ViewDataView;
import com.sas.wadmin.visuals.ChangeHistoryView;
import com.sas.wadmin.visuals.RawDataView;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyFrame;
import com.sas.workspace.WASplittablePropertyFrame;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceOMAView;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsBaseView;
import com.sas.workspace.WsNewView;
import com.sas.workspace.WsOMAView;
import com.sas.workspace.WsView;
import com.sas.workspace.WsViewFactory;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.ContainedByFolderFilter;
import com.sas.workspace.visuals.WsEditorOMAView;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;

public class AppViewFactory {
    private static final WAdminResource bundle = WAdminResource.getBundle(AppViewFactory.class);
    private static AppViewFactory s_instance;
    private static final String WINDOWS_COMMAND = "rundll32 url.dll,FileProtocolHandler ";
    private static final String UNIX_COMMAND = "netscape -remote openURL(";
    private static final String UNIX_COMMAND_END = ")";

    public static void setInstance(AppViewFactory instance) {
        s_instance = instance;
    }

    public static AppViewFactory getInstance() {
        return s_instance;
    }

    public boolean isOpenViewSupported(SimpleObject object) {
        String sType;
        if (object instanceof JobTransformModel) {
            object = ((JobTransformModel)object).getInnerJob();
        }
        return "Table".equals(sType = object.getPublicType()) || "ExternalFile".equals(sType) || "Job".equals(sType) || "Document".equals(sType) || "SearchFolder".equals(sType);
    }

    public WsBaseView showOpenView(SimpleObject object) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            String sType = object.getPublicType();
            String sMetadataType = object.getMetadataType();
            String sName = object.getName();
            String sFQID = object.getID();
            if ("Table".equals(sType)) {
                WsOMAView wsOMAView = WsViewFactory.showView((String)sName, (String)sMetadataType, (String)sFQID, ViewDataView.class);
                return wsOMAView;
            }
            if ("ExternalFile".equals(sType)) {
                WsOMAView wsOMAView = WsViewFactory.showView((String)sName, (String)sMetadataType, (String)sFQID, RawDataView.class);
                return wsOMAView;
            }
            if ("SearchFolder".equals(sType)) {
                WsOMAView wsOMAView = WsViewFactory.showView((String)sName, (String)sMetadataType, (String)sFQID, SearchFolderView.class);
                return wsOMAView;
            }
            if ("Job".equals(sType)) {
                Workspace.getDefaultLogger().debug((Object)"create view start");
                WsNewView view = WsViewFactory.showNewView((String)sFQID, (String)sMetadataType, (String)sName, JobEditorView.class);
                Workspace.getDefaultLogger().debug((Object)"create view finish");
                WsNewView wsNewView = view;
                return wsNewView;
            }
            if ("Document".equals(sType)) {
                this.showDocumentURL(object);
                WsBaseView wsBaseView = null;
                return wsBaseView;
            }
            throw new UnsupportedOperationException("No open view is defined for " + sType + " objects");
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsBaseView showOpenView(SimpleObject object, WsAppServer server) {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            String sType = object.getPublicType();
            if (!("WorkTable".equals(sType) || "Table".equals(sType) || "ExternalFile".equals(sType))) {
                throw new UnsupportedOperationException("Open view for a table was called with a " + sType + " object; only tables are valid");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("AppServer", server);
            if (object instanceof IPhysicalTable) {
                map.put("NewViewData", object);
            }
            if ("ExternalFile".equals(object.getPublicType())) {
                WsOMAView wsOMAView = WsViewFactory.showView((String)object.getName(), (String)object.getMetadataType(), (String)object.getID(), RawDataView.class, map);
                return wsOMAView;
            }
            WsOMAView wsOMAView = WsViewFactory.showView((String)object.getName(), (String)object.getMetadataType(), (String)object.getID(), ViewDataView.class, map);
            return wsOMAView;
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean isOpenAsTableViewSupported(SimpleObject object) {
        return "ExternalFile".equals(object.getPublicType());
    }

    public WsBaseView showOpenAsTableView(SimpleObject object) {
        String sType = object.getPublicType();
        String sMetadataType = object.getMetadataType();
        String sName = object.getName();
        String sFQID = object.getID();
        HashMap<String, SimpleObject> map = new HashMap<String, SimpleObject>();
        if ("ExternalFile".equals(sType)) {
            if (object instanceof IExternalTable) {
                map.put("NewViewData", object);
            }
            return WsViewFactory.showView((String)sName, (String)sMetadataType, (String)sFQID, ViewDataView.class, map);
        }
        throw new UnsupportedOperationException("No \"open as table\" view is defined for " + sType + " objects");
    }

    public boolean isAnalysisViewSupported(SimpleObject object) {
        String sType;
        if (object instanceof GeneratedTransformModel) {
            object = ((GeneratedTransformModel)object).getTransformDefinition();
        }
        return "Table".equals(sType = object.getPublicType()) || "ExternalFile".equals(sType) || "GeneratedTransform".equals(sType) || "MessageQueue".equals(sType) || "WorkTable".equals(sType);
    }

    public WsBaseView showAnalysisView(SimpleObject object) {
        if (object instanceof GeneratedTransformModel) {
            object = ((GeneratedTransformModel)object).getTransformDefinition();
        }
        String sType = object.getPublicType();
        String sMetadataType = object.getMetadataType();
        String sName = object.getName();
        String sFQID = object.getID();
        if ("Table".equals(sType)) {
            return WsViewFactory.showNewView((String)sFQID, (String)sMetadataType, (String)sName, PhysicalTableAnalysisView.class);
        }
        if ("ExternalFile".equals(sType)) {
            return WsViewFactory.showNewView((String)sFQID, (String)sMetadataType, (String)sName, ExternalTableAnalysisView.class);
        }
        if (sType.indexOf("Column") > -1) {
            return WsViewFactory.showNewView((String)sFQID, (String)sMetadataType, (String)sName, ColumnAnalysisView.class);
        }
        if ("GeneratedTransform".equals(sType)) {
            return WsViewFactory.showNewView((String)sFQID, (String)sMetadataType, (String)sName, GeneratedTransformationAnalysisView.class);
        }
        if ("MessageQueue".equals(sType)) {
            return WsViewFactory.showNewView((String)sFQID, (String)sMetadataType, (String)sName, MessageQueueAnalysisView.class);
        }
        if ("WorkTable".equals(sType)) {
            return WsViewFactory.showNewView((String)sFQID, (String)sMetadataType, (String)sName, WorkTableAnalysisView.class);
        }
        throw new UnsupportedOperationException("No analysis view is defined for " + sType + " objects");
    }

    public boolean isHistoryViewSupported(SimpleObject object) {
        if (object instanceof JobTransformModel) {
            object = ((JobTransformModel)object).getInnerJob();
        }
        if (object instanceof GeneratedTransformModel) {
            object = ((GeneratedTransformModel)object).getTransformDefinition();
        }
        return object.isPublicObject() && ContainedByFolderFilter.accept((String)object.getPublicType());
    }

    public WsBaseView showHistoryView(SimpleObject object) {
        if (object instanceof JobTransformModel) {
            object = ((JobTransformModel)object).getInnerJob();
        }
        String sType = object.getMetadataType();
        String sName = object.getName();
        String sFQID = object.getID();
        return WsViewFactory.showView((String)sName, (String)sType, (String)sFQID, ChangeHistoryView.class);
    }

    public WsBaseView showCodeEditorView() {
        WsEditorOMAView view = new WsEditorOMAView();
        WsViewFactory.attachViewToFrame(null, (WorkspaceOMAView)view, (WAPropertyFrame)new WASplittablePropertyFrame());
        return view;
    }

    public WsView showSearchView() {
        return WsViewFactory.showView(SearchView.class);
    }

    public WsView showReportsView() {
        return WsViewFactory.showView(ReportingView.class);
    }

    public WsView showImportComparisonResultsView() {
        MessageUtil.displayMessage((String)"Importer Comparison Results", (String)"TODO");
        return null;
    }

    public void showURL(String sURL) {
        if (!this.isURLValid(sURL)) {
            String sMessage = bundle.formatString("AppViewFactory.Error.InvalidURL.fmt", (Object)sURL);
            MessageUtil.displayMessage((String)sMessage, (int)0);
            return;
        }
        this.showURLImpl(sURL);
    }

    public WsBaseView showComparisonResultsView() {
        return WsViewFactory.showNewView((String)"AA", (String)"NONE", (String)"NAME", ComparisonResultsView.class);
    }

    public WsBaseView showLineageExporterView() {
        return WsViewFactory.showNewView((String)"AA", (String)"NONE", (String)"NAME", LineageExporterView.class);
    }

    private void showDocumentURL(SimpleObject document) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "NewDocumentDialog");
            Document md = (Document)ObjectConverter.getInstance().convertToJOMAObject(store, document);
            if (md.getURIType().equals("REMOTE")) {
                WsAppServer appServer = WsAppServer.createDefaultAppServer();
                String sURL = WsMetadataUtil.getSimpleAttribute((String)document.getMetadataType(), (String)document.getID(), (String)"URI");
                try {
                    String content = appServer.readFile(sURL);
                    MessageUtil.displayMessage((String)content, (int)1);
                }
                catch (Exception exception) {}
            } else {
                String sURL = WsMetadataUtil.getSimpleAttribute((String)document.getMetadataType(), (String)document.getID(), (String)"URI");
                if (!this.isURLValid(sURL)) {
                    String sMessage = bundle.formatString("AppViewFactory.Error.DocumentDoesNotExist.fmt", (Object)document.getName(), (Object)sURL);
                    MessageUtil.displayMessage((String)sMessage, (int)0);
                } else {
                    this.showURLImpl(sURL);
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
    }

    private void showURLImpl(String sURL) {
        String sCommand = System.getProperty("os.name").startsWith("Windows") ? WINDOWS_COMMAND + sURL : UNIX_COMMAND + sURL + UNIX_COMMAND_END;
        try {
            Runtime.getRuntime().exec(sCommand);
        }
        catch (IOException ex) {
            MessageUtil.displayMessage((String)ex.getMessage(), (int)0);
        }
    }

    private boolean isURLValid(String sURL) {
        try {
            new URL(sURL);
            return true;
        }
        catch (MalformedURLException ex) {
            return new File(sURL).exists();
        }
    }
}

