/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.app;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.promotion.visuals.ExportWizard;
import com.sas.metadata.promotion.visuals.ImportWizard;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.wadmin.app.AppFrameworkManager;
import com.sas.wadmin.app.AppViewFactory;
import com.sas.wadmin.app.ApplicationOptionsPluginInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.TransportUtil;
import com.sas.wadmin.efi2.ImportCobolCopyBookPanel;
import com.sas.wadmin.pfd.PFDOptionsTab;
import com.sas.wadmin.viewdata2.ViewDataGlobalOptionsTab;
import com.sas.wadmin.visuals.CodeConditionConfigPanel;
import com.sas.wadmin.visuals.EditorOptionsPropertyTab;
import com.sas.wadmin.visuals.EngineDesigner;
import com.sas.wadmin.visuals.GeneralOptionsPropertyTab;
import com.sas.wadmin.visuals.MacroPluginWizard;
import com.sas.wadmin.visuals.NewDocumentDialog;
import com.sas.wadmin.visuals.NewFolderDialog;
import com.sas.wadmin.visuals.NewJobDialog;
import com.sas.wadmin.visuals.NewNoteDialog;
import com.sas.wadmin.visuals.NewObjectWizard;
import com.sas.wadmin.visuals.SASCodeGenerationOptionsPropertyTab;
import com.sas.wadmin.visuals.SASLibnameDialog;
import com.sas.wadmin.visuals.ServerOptionsPropertyTab;
import com.sas.wadmin.visuals.SourceDesigner;
import com.sas.wadmin.visuals.TargetTableDesigner;
import com.sas.wadmin.visuals.common.ImportUserDefinedFunctionsPanel;
import com.sas.workspace.AbstractDesigner;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.OpRequestUICancellableRunnable;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractOperation;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.visuals.Library;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.plugins.ArchiveCorePluginInterface;
import com.sas.workspace.visuals.MetadataExporter;
import com.sas.workspace.visuals.MetadataImporter;
import com.sas.workspace.visuals.WsAboutBox;
import com.sas.workspace.visuals.tree.FoldersTree;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class AppDialogFactory {
    private static final WAdminResource bundle = WAdminResource.getBundle(AppDialogFactory.class);
    public static final String DELIMITED_EXTERNAL_FILE = "Delimited";
    public static final String FIXED_WIDTH_EXTERNAL_FILE = "FixedWidth";
    public static final String USER_WRITTEN_EXTERNAL_FILE = "UserWritten";
    private static AppDialogFactory s_instance;

    public static AppDialogFactory getInstance() {
        if (s_instance == null) {
            s_instance = new AppDialogFactory();
        }
        return s_instance;
    }

    private AppDialogFactory() {
    }

    public boolean isNewObjectDialogSupported(TypeInterface type) {
        return NewObjectWizard.isTypeSupported(type.getMetadataType());
    }

    public SimpleObject showNewFolderDialog(JFrame frmParent, SimpleObject folder) {
        if (folder != null && !this.canWriteToFolder(folder)) {
            return null;
        }
        NewFolderDialog dlg = new NewFolderDialog(frmParent, folder);
        dlg.show();
        return dlg.getNewFolder();
    }

    public SimpleObject showNewJobDialog(JFrame frmParent, SimpleObject folder, boolean bShowJobEditor) {
        if (folder != null && !this.canWriteToFolder(folder)) {
            return null;
        }
        NewJobDialog dlg = new NewJobDialog(frmParent, folder);
        dlg.show();
        SimpleObject job = dlg.getNewJob();
        if (bShowJobEditor && job != null) {
            AppViewFactory.getInstance().showOpenView(job);
        }
        return job;
    }

    public WAStandardDialog showNewTableDialog(JFrame frmParent, SimpleObject folder) {
        if (folder != null && !this.canWriteToFolder(folder)) {
            return null;
        }
        TargetTableDesigner plugin = new TargetTableDesigner(folder);
        NewObjectWizard dlg = new NewObjectWizard((Frame)Workspace.getWorkspace(), bundle.getString("AppDialogFactory.NewTableDialog.Title.txt"), plugin, "");
        dlg.show();
        return dlg;
    }

    public WAStandardDialog showNewExternalFileDialog(JFrame frmParent, String sType, SimpleObject folder) {
        if (folder != null && !this.canWriteToFolder(folder)) {
            return null;
        }
        try {
            return this.showNewObjectDialog(frmParent, Factory.getInstance().getTypeInterface("ExternalFile"), sType, folder);
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleObject showNewLibraryDialog(JFrame frmParent, SimpleObject folder) {
        SimpleObject simpleObject;
        if (folder != null && !this.canWriteToFolder(folder)) {
            return null;
        }
        WAWizardDialog dlg = null;
        try {
            dlg = (WAWizardDialog)this.showNewObjectDialog(frmParent, Factory.getInstance().getTypeInterface("Library"), null, folder);
            Library lib = (Library)dlg.getWizardData("NEWOBJECT");
            if (lib == null) {
                SimpleObject simpleObject2 = null;
                return simpleObject2;
            }
            DeployedDataPackage dataPackage = lib.getDeployedDataPackage();
            if (dataPackage == null) {
                SimpleObject simpleObject3 = null;
                return simpleObject3;
            }
            SimpleObjectImpl simpleObjectImpl = new SimpleObjectImpl(dataPackage.getName(), dataPackage.getFQID(), dataPackage.getCMetadataType(), dataPackage.getPublicType());
            return simpleObjectImpl;
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            simpleObject = null;
            return simpleObject;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            simpleObject = null;
            return simpleObject;
        }
        finally {
            if (dlg != null) {
                dlg.doDisposeOfStore();
            }
        }
    }

    public SimpleObject showNewDocumentDialog(JFrame frmParent, SimpleObject folder) {
        if (folder != null && !this.canWriteToFolder(folder)) {
            return null;
        }
        NewDocumentDialog dlg = new NewDocumentDialog(frmParent, folder);
        dlg.show();
        return dlg.getNewDocument();
    }

    public SimpleObject showNewNoteDialog(JFrame frmParent, SimpleObject folder) {
        if (folder != null && !this.canWriteToFolder(folder)) {
            return null;
        }
        NewNoteDialog dlg = new NewNoteDialog(frmParent, folder);
        dlg.show();
        return dlg.getNewNote();
    }

    public WAStandardDialog showNewTransformationDialog(JFrame frmParent, TypeInterface type, SimpleObject folder, String sCategory) {
        if (folder != null && !this.canWriteToFolder(folder)) {
            return null;
        }
        MacroPluginWizard dlg = new MacroPluginWizard(frmParent, null, folder, sCategory);
        dlg.setTitle(bundle.getString("AppDialogFactory.NewTransformationDialog.Title.txt"));
        dlg.show();
        return dlg;
    }

    private WAStandardDialog showNewObjectDialog(JFrame frmParent, TypeInterface type, String sSubType, SimpleObject folder) {
        String dlgTitle = "";
        dlgTitle = type.getPublicType().equals("ExternalFile") ? (sSubType.equalsIgnoreCase("DELIMITED") ? bundle.getString("AppDialogFactory.NewDelimitedExternalFileWizard.Title.txt") : (sSubType.equalsIgnoreCase("FIXEDWIDTH") ? bundle.getString("AppDialogFactory.NewFixedWidthExternalFileWizard.Title.txt") : bundle.getString("AppDialogFactory.NewUserWrittenExternalFileWizard.Title.txt"))) : bundle.formatString("AppDialogFactory.NewObjectDialog.Title.fmt", (Object)type.getDisplayType());
        NewObjectWizard dlg = new NewObjectWizard(frmParent, dlgTitle, type.getMetadataType(), sSubType, folder);
        return dlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WAStandardDialog showRegisterTablesDialog(JFrame frmParent, SimpleObject library, SimpleObject folder) {
        SourceDesigner sourceDesigner;
        if (folder != null && !this.canWriteToFolder(folder)) {
            return null;
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "AppDialogFactory:showRegisterTablesDialog");
        try {
            AbstractDesigner dlg;
            Tree mdoFolder;
            Tree tree = mdoFolder = folder == null ? null : (Tree)ObjectConverter.getInstance().convertToJOMAObject(store, folder);
            if (library != null) {
                SASLibrary mdoLibrary = (SASLibrary)ObjectConverter.getInstance().convertToJOMAObject(store, library);
                dlg = new EngineDesigner(frmParent, bundle.getString("AppDialogFactory.ImportTableMetadataDialog.Title.txt"), mdoLibrary, false);
            } else {
                dlg = new SourceDesigner(frmParent, bundle.getString("AppDialogFactory.ImportTableMetadataDialog.Title.txt"), mdoFolder, false);
            }
            dlg.show();
            sourceDesigner = dlg;
        }
        catch (MdException ex) {
            WAStandardDialog wAStandardDialog;
            try {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                wAStandardDialog = null;
            }
            catch (Throwable throwable) {
                try {
                    store.dispose();
                    throw throwable;
                }
                catch (RemoteException ex2) {
                    Workspace.handleRemoteException((RemoteException)ex2);
                    return null;
                }
            }
            store.dispose();
            return wAStandardDialog;
        }
        store.dispose();
        return sourceDesigner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WAStandardDialog showImportMetadataDialog(JFrame frmParent, SimpleObject folder) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "AppDialogFactory:showRegisterTablesDialog");
            try {
                Tree tree = folder == null ? null : (Tree)ObjectConverter.getInstance().convertToJOMAObject(store, folder);
                MetadataImporter dlg = new MetadataImporter((Frame)frmParent, bundle.getString("AppDialogFactory.MetadataImporter.Title.txt"), true);
                if (!dlg.m_noTypes) {
                    dlg.addWizardData("GROUP", (Object)tree);
                    dlg.show();
                    MetadataImporter metadataImporter = dlg;
                    return metadataImporter;
                }
                WAStandardDialog wAStandardDialog = null;
                return wAStandardDialog;
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                WAStandardDialog wAStandardDialog2 = null;
                return wAStandardDialog2;
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex2) {
            Workspace.handleRemoteException((RemoteException)ex2);
            return null;
        }
    }

    public WAStandardDialog showExportMetadataDialog(JFrame frmParent, SimpleObject folder) {
        MetadataExporter dlg = new MetadataExporter((Frame)frmParent, bundle.getString("AppDialogFactory.MetadataExporter.Title.txt"));
        if (!dlg.m_noTypes) {
            dlg.addWizardData("FOLDER", (Object)folder);
            dlg.show();
            return dlg;
        }
        return null;
    }

    public WAStandardDialog showExportSASPackageDialog() {
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            SoftwareComponent target = (SoftwareComponent)server.getRootFolder().getRepositoryEntity();
            return this.showExportSASPackageDialog(new Object[]{target});
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
            return null;
        }
    }

    public WAStandardDialog showExportSASPackageDialog(SimpleObject[] aObjects) {
        try {
            return this.showExportSASPackageDialog(ObjectConverter.getInstance().convertToLogicalObjects(aObjects));
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return null;
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    private WAStandardDialog showExportSASPackageDialog(Object[] aObjects) {
        String sWizardTitle = bundle.getString("AppDialogFactory.ExportToSASPackageDialog.Title.txt");
        try {
            ExportWizard wizard;
            TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
            if (aObjects instanceof LogicalObjectInterface[]) {
                wizard = new ExportWizard((SimpleLogicalObjectInterface[])((LogicalObjectInterface[])aObjects), aSupportedTypes, sWizardTitle);
            } else if (aObjects.length == 1 && aObjects[0] instanceof SoftwareComponent) {
                wizard = new ExportWizard((SoftwareComponent)aObjects[0], aSupportedTypes, sWizardTitle);
            } else {
                throw new IllegalArgumentException("The supplied target must be of type LogicalObjectInterface[] or Object[] containg a single SoftwareComponent");
            }
            wizard.show();
            return wizard;
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public WAStandardDialog showImportSASPackageDialog() {
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            SoftwareComponent target = (SoftwareComponent)server.getRootFolder().getRepositoryEntity();
            return this.showImportSASPackageDialog((Root)target);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WAStandardDialog showImportSASPackageDialog(SimpleObject folder) {
        WAStandardDialog wAStandardDialog;
        MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "AppDialogFactory.showImportSASPackageDialog");
        try {
            Tree target = (Tree)ObjectConverter.getInstance().convertToJOMAObject(store, folder);
            wAStandardDialog = this.showImportSASPackageDialog((Root)target);
        }
        catch (MdException ex) {
            WAStandardDialog wAStandardDialog2;
            try {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                wAStandardDialog2 = null;
            }
            catch (Throwable throwable) {
                try {
                    store.dispose();
                    throw throwable;
                }
                catch (RemoteException ex2) {
                    Workspace.handleRemoteException((RemoteException)ex2);
                    return null;
                }
            }
            store.dispose();
            return wAStandardDialog2;
        }
        store.dispose();
        return wAStandardDialog;
    }

    public WAStandardDialog showImportSASPackageDialog(SimpleObject folder, String sCategory) {
        ImportWizard wizard = (ImportWizard)this.showImportSASPackageDialog(folder);
        if (wizard.objectsWereImported()) {
            TransportUtil.updateTransformationPaths(wizard.getTargetObjectIDs(), sCategory);
        }
        return wizard;
    }

    private WAStandardDialog showImportSASPackageDialog(Root target) throws RemoteException {
        try {
            ImportWizard wizard;
            TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
            String sWizardTitle = bundle.getString("AppDialogFactory.ImportFromSASPackageDialog.Title.txt");
            if (target instanceof Tree) {
                wizard = new ImportWizard((Tree)target, aSupportedTypes, sWizardTitle);
            } else if (target instanceof SoftwareComponent) {
                wizard = new ImportWizard((SoftwareComponent)target, aSupportedTypes, sWizardTitle);
            } else {
                throw new IllegalArgumentException("The supplied target must be of type Tree or SoftwareComponent");
            }
            if (Workspace.getWorkspace().isChangeManagementOn()) {
                wizard.changeRepositoryID(Workspace.getWorkspace().getProjectRepository().getFQID());
            }
            wizard.show();
            if (wizard.getReturnValue() == 1 && wizard.objectsWereImported()) {
                TransportUtil.generateObjectsModifiedEvent(wizard.getTargetObjectIDs());
            }
            return wizard;
        }
        catch (LogicalTypeException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            return null;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WAStandardDialog showViewLibnameDialog(Workspace frmParent, SimpleObject library) {
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        try {
            MdObjectStore store = factory.createObjectStore();
            try {
                SASLibrary mdoLibrary = (SASLibrary)ObjectConverter.getInstance().convertToJOMAObject(store, library);
                ArrayList<String> lAttributes = new ArrayList<String>();
                lAttributes.add("IsPreassigned");
                WsMetadataUtil.populateSimpleAttributes((Root)mdoLibrary, lAttributes);
                if (mdoLibrary.getIsPreassigned() == 1) {
                    String sMessage = bundle.formatString("AppDialogFactory.PreassignedLibrary.Message.fmt", (Object)mdoLibrary.getName());
                    String sTitle = bundle.getString("AppDialogFactory.PreassignedLibrary.Title.txt");
                    MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)1);
                    WAStandardDialog wAStandardDialog = null;
                    return wAStandardDialog;
                }
                SASLibnameDialog dlg = new SASLibnameDialog(mdoLibrary);
                dlg.show();
                SASLibnameDialog sASLibnameDialog = dlg;
                return sASLibnameDialog;
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                return null;
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex2) {
            Workspace.handleRemoteException((RemoteException)ex2);
        }
        return null;
    }

    public WAStandardDialog showImportUserDefinedFunctionsDialog(JFrame frmParent) {
        ImportUserDefinedFunctionsPanel pnlUDFs = new ImportUserDefinedFunctionsPanel();
        String sTitle = bundle.getString("AppDialogFactory.ImportUserDefinedFunctionsDialog.Title.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)frmParent, sTitle, true);
        dlg.setCloseButtonVisible(true);
        dlg.setCancelButtonVisible(false);
        dlg.setOKButtonVisible(false);
        dlg.setMainPanel((WAPanel)pnlUDFs);
        dlg.setResizable(true);
        dlg.show();
        return dlg;
    }

    public WAStandardDialog showImportCOBOLCopyBookDialog(JFrame frmParent) {
        ImportCobolCopyBookPanel pnlCobol = new ImportCobolCopyBookPanel();
        String sTitle = bundle.getString("AppDialogFactory.ImportCOBOLCopybookDialog.Title.txt");
        WAStandardDialog dlg = new WAStandardDialog((Frame)frmParent, sTitle, true);
        dlg.setMainPanel((WAPanel)pnlCobol);
        dlg.setResizable(true);
        dlg.show();
        return dlg;
    }

    public WAStandardDialog showConfigureStatusHandlingDialog(JFrame frmParent) {
        Group mdoGroup = CodeConditionConfigPanel.getMetadataObject();
        mdoGroup = null;
        if (mdoGroup == null) {
            MessageUtil.displayMessage((String)bundle.getString("AppDialogFactory.ConfigureStatusHandlingDialog.Error.txt"), (int)0);
            return null;
        }
        CodeConditionConfigPanel pnlCodeConditions = new CodeConditionConfigPanel(mdoGroup);
        String sTitle = bundle.getString("AppDialogFactory.ConfigureStatusHandlingDialog.Title.txt");
        WAPropertyDialog dlg = new WAPropertyDialog((Frame)frmParent, sTitle, true);
        dlg.setMainPanel((WAPanel)pnlCodeConditions);
        dlg.setMetadataObject((CMetadata)mdoGroup);
        dlg.show();
        return dlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WAStandardDialog showApplicationOptionsDialog(JFrame frmParent) {
        frmParent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String sTitle = bundle.getString("AppDialogFactory.OptionsDialog.Title.txt");
            WAPropertyDialog dlg = new WAPropertyDialog((Frame)frmParent, sTitle, true);
            dlg.addTab((WAPropertyTab)new GeneralOptionsPropertyTab());
            dlg.addTab((WAPropertyTab)new PFDOptionsTab());
            dlg.addTab((WAPropertyTab)new EditorOptionsPropertyTab((Dialog)dlg));
            dlg.addTab((WAPropertyTab)new ServerOptionsPropertyTab());
            dlg.addTab((WAPropertyTab)new ViewDataGlobalOptionsTab());
            dlg.addTab((WAPropertyTab)new SASCodeGenerationOptionsPropertyTab());
            dlg.setResizable(true);
            List plugins = Workspace.getWorkspace().getPluginLoader().getPlugins(ApplicationOptionsPluginInterface.class);
            for (int i = 0; i < plugins.size(); ++i) {
                WAPropertyTab pluginTab = ((ApplicationOptionsPluginInterface)plugins.get(i)).getApplicationOptionTab();
                if (pluginTab == null) continue;
                dlg.addTab(pluginTab);
            }
            dlg.show();
            WAPropertyDialog wAPropertyDialog = dlg;
            return wAPropertyDialog;
        }
        finally {
            frmParent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void showHelpDialog() {
        Workspace.getWorkspace().showHelp(null, "4.910");
    }

    public JDialog showAboutDialog(JFrame frmParent) {
        Icon icon = bundle.getIcon("AppDialogFactory.AboutDialog.image");
        String sTitle = bundle.formatString("AppDialogFactory.AboutDialog.Title.fmt", (Object)Workspace.getWorkspace().getApplicationName());
        WsAboutBox dlg = new WsAboutBox(frmParent, icon, sTitle, "sas.dbuilder.app");
        dlg.setCopyright(bundle.getString("AppDialogFactory.AboutDialog.Copyright.txt"));
        dlg.setVisible(true);
        return dlg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showMoveToFolderDialog(JFrame frmParent, SimpleObject[] aObjects) {
        block7: {
            try {
                Tree mdoTree = (Tree)WsMetadataUtil.promptForFolder(null, (boolean)false, (SimpleObject[])aObjects);
                if (mdoTree == null) break block7;
                FoldersTree foldersTree = ((AppFrameworkManager)AppFrameworkManager.getInstance()).getFoldersTree();
                foldersTree.setListeningForSelectionChanges(false);
                try {
                    LogicalObjectInterface targetFolder = ObjectConverter.getInstance().convertToLogicalObject((Root)mdoTree);
                    OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("AppDialogFactory.MoveProgressIndicator.MessagePrototype.txt"), bundle.getString("AppDialogFactory.MoveProgressIndicator.Title.txt"));
                    request.setDelayBeforeProgressCancelDialog(200);
                    request.executeWithCancel((OpRequestUICancellableRunnable)new MoveToFolderOperation(targetFolder, aObjects, request));
                }
                finally {
                    foldersTree.setListeningForSelectionChanges(true);
                }
                AppFrameworkManager.getInstance().findInFolders(aObjects);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (String)"Accessing");
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCopyToFolderDialog(JFrame frmParent, SimpleObject[] aObjects) {
        MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
        try {
            MdObjectStore store = factory.createObjectStore();
            try {
                Tree mdoTree = (Tree)WsMetadataUtil.promptForFolder(null, (boolean)false);
                if (mdoTree != null) {
                    FolderInterface folder = (FolderInterface)Factory.getInstance().getObject((Root)mdoTree);
                    CopyPasteUtil.copy((SimpleLogicalObjectInterface[])ObjectConverter.getInstance().convertToLogicalObjects(aObjects));
                    TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
                    if (Workspace.getWorkspace().isChangeManagementOn()) {
                        CopyPasteUtil.paste((FolderInterface)folder, (TypeInterface[])aSupportedTypes, (String)Workspace.getWorkspace().getProjectRepository().getFQID());
                    } else {
                        CopyPasteUtil.paste((FolderInterface)folder, (TypeInterface[])aSupportedTypes);
                    }
                    if (CopyPasteUtil.objectsWerePasted()) {
                        TransportUtil.generateObjectsModifiedEvent(CopyPasteUtil.getObjectsPasted());
                    }
                }
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
    }

    private boolean canWriteToFolder(SimpleObject folder) {
        try {
            if (folder != null && !Workspace.getWorkspace().isChangeManagementOn()) {
                boolean hasWriteFolderPermission = Workspace.getMdFactory().getSecurityUtil().isFolderWriteAuthorized(folder.getID());
                if (!hasWriteFolderPermission) {
                    MessageUtil.displayMessage((String)bundle.getString("AppDialogFactory.CannotWriteToFolder.Message.txt"), (int)2);
                    return false;
                }
                return true;
            }
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return true;
    }

    public void showArchiveDialog(JFrame parent, SimpleObject[] objects) {
        List lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins(ArchiveCorePluginInterface.class);
        if (!lPlugins.isEmpty()) {
            try {
                Object[] urls = ObjectConverter.getInstance().convertToPathURLs(objects);
                ArchiveCorePluginInterface plugin = (ArchiveCorePluginInterface)lPlugins.get(0);
                plugin.showArchiveDialog(parent, AppDialogFactory.ToList(urls));
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
        }
    }

    public void showArchiveHistoryDialog(JFrame parent, SimpleObject object) {
        List lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins(ArchiveCorePluginInterface.class);
        if (!lPlugins.isEmpty()) {
            try {
                PathUrl url = null;
                if (object != null) {
                    SimpleObject[] objects = new SimpleObject[]{object};
                    url = ObjectConverter.getInstance().convertToPathURLs(objects)[0];
                }
                ArchiveCorePluginInterface plugin = (ArchiveCorePluginInterface)lPlugins.get(0);
                plugin.showHistoryDialog(parent, url);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
        }
    }

    public void showCompareDialog(JFrame parent, SimpleObject object) {
        List lPlugins = Workspace.getWorkspace().getPluginLoader().getPlugins(ArchiveCorePluginInterface.class);
        if (!lPlugins.isEmpty()) {
            try {
                SimpleObject[] objects = new SimpleObject[]{object};
                PathUrl url = ObjectConverter.getInstance().convertToPathURLs(objects)[0];
                ArchiveCorePluginInterface plugin = (ArchiveCorePluginInterface)lPlugins.get(0);
                plugin.showCompareDialog(parent, url, null);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ServiceException ex) {
                Workspace.handleServiceException((ServiceException)ex);
            }
        }
    }

    private static List ToList(Object[] objects) {
        ArrayList<Object> lURLs = new ArrayList<Object>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            lURLs.add(objects[i]);
        }
        return lURLs;
    }

    private class MoveToFolderOperation
    extends WsAbstractOperation {
        private OpRequestUI m_opUI;
        private LogicalObjectInterface m_targetFolder;
        private SimpleObject[] m_aObjects;

        public MoveToFolderOperation(LogicalObjectInterface targetFolder, SimpleObject[] aObjects, OpRequestUI opUI) {
            super(opUI);
            this.m_targetFolder = targetFolder;
            this.m_aObjects = aObjects;
            this.m_opUI = opUI;
        }

        public void run() {
            try {
                Integer nObjects = new Integer(this.m_aObjects.length);
                for (int iObject = 0; iObject < nObjects && !this.isOperationCancelled(); ++iObject) {
                    this.m_opUI.setMessage(bundle.formatString("AppDialogFactory.MoveProgressIndicator.Message.fmt", (Object)new Integer(iObject + 1), (Object)nObjects));
                    LogicalObjectInterface logicalObject = ObjectConverter.getInstance().convertToLogicalObject(this.m_aObjects[iObject]);
                    if (logicalObject == null) continue;
                    logicalObject.move((FolderInterface)this.m_targetFolder);
                }
            }
            catch (LogicalTypeException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Accessing");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

