/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenInterface;
import com.sas.codegen.CodeGenRoot;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ExternalTableCG;
import com.sas.codegen.GetMetadataUtil;
import com.sas.codegen.PhysicalTableCG;
import com.sas.codegen.WorkTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.StepPrecedence;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.WorkTable;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.ServerSupport;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.EFIDataModel;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TransformationActivityCG
extends CodeGenRoot {
    private static WAdminResource bundle = WAdminResource.getBundle(TransformationActivityCG.class);
    private static final String TRANSFORM_MACRO_NAME = "etls_transformationStep";
    private static final String TRANSFER_CLASS = "com.sas.wadmin.visuals.SASDataTransfer";
    private static final String TRANSFER_ROLE = "TransferStep";
    private static final String CLASS_PROPERTY = "CLASS";
    private static final String CONTENTS_ROLE = "Contents";
    private static final String CONTENTS_PACKAGE = "com.sas.wadmin.transforms.contentreaders";

    @Override
    public void codeGen(CodegenRequest cgReq) throws MdException, RemoteException {
        TransformationActivity activity = (TransformationActivity)this.getMetadataClass();
        if (cgReq.onContextList(activity.getFQID())) {
            return;
        }
        cgReq.addContextList(activity.getFQID());
        if (activity.getSteps(false).getState() == 0) {
            GetMetadataUtil.getTransformationActivityMetadata(activity);
        }
        this.codeGenForSteps(cgReq, this.buildDTree(activity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void codeGenForSteps(CodegenRequest cgReq, List stepList) throws MdException, RemoteException {
        TransformationActivity activity = (TransformationActivity)this.getMetadataClass();
        if (activity.getIsUserDefined() == 0) {
            ServerContext defaultServerContext = cgReq.getAppServerContext();
            try {
                ServerContext localServer = cgReq.getCurrentServer();
                int isActiveStep = 1;
                for (int i = 0; i < stepList.size(); ++i) {
                    ServerContext nextServer;
                    TransformationStep nextStep;
                    int k;
                    List lNextSteps;
                    AssociationList lSPs;
                    Object obj = stepList.get(i);
                    TransformationStep step = null;
                    if (!(obj instanceof DTreeNode)) continue;
                    step = ((DTreeNode)obj).getStep();
                    CodeGenInterface stepCG = CodeGenUtil.getCodeGenClass((CMetadata)step);
                    ServerContext serverForStep = TransformationActivityCG.getServerForStep(step, cgReq.getCurrentServer());
                    if (TransformationActivityCG.isTransferStep(step)) {
                        serverForStep = TransformationActivityCG.getPreviousServer(step, defaultServerContext);
                        cgReq.setGlobalData(TRANSFER_ROLE, "Y");
                    } else if (TransformationActivityCG.isContentsStep(step)) {
                        serverForStep = TransformationActivityCG.getPreviousServer(step, defaultServerContext);
                        cgReq.setGlobalData("ContentsStep", "Y");
                    }
                    if (serverForStep == null) {
                        serverForStep = defaultServerContext;
                    }
                    if (isActiveStep <= 0) continue;
                    AssociationList classifierMaps = step.getTransformations();
                    if (!classifierMaps.isEmpty() && classifierMaps.get(0) instanceof ClassifierMap) {
                        ExternalTableCG tableCG;
                        EFIDataModel efiModel;
                        Object input;
                        ClassifierMap map = (ClassifierMap)classifierMaps.get(0);
                        AssociationList inputs = map.getClassifierSources();
                        if (!inputs.isEmpty() && (input = inputs.get(0)) instanceof ExternalTable && (serverForStep = (ServerContext)(efiModel = (tableCG = (ExternalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)((ExternalTable)input))).getModel()).getAppServerDC()) == null) {
                            serverForStep = defaultServerContext;
                        }
                        AssociationList sourceTables = map.getClassifierSources();
                        AssociationList targetTables = map.getClassifierTargets();
                        if (TransformationActivityCG.isContentsStep(step)) {
                            cgReq.genValidVarName((List)sourceTables, (List)((TransformationActivity)step.getActivities(false).get(0)).getTransformationTargets(false));
                        } else {
                            cgReq.genValidVarName((List)sourceTables, (List)targetTables);
                        }
                    }
                    ServerSupport servSuppForStep = new ServerSupport(serverForStep, localServer);
                    boolean local = servSuppForStep.checkLocal();
                    boolean resetValidVarName = false;
                    if (!local && !TransformationActivityCG.isTransferStep(step)) {
                        cgReq.addSourceCode(servSuppForStep.access());
                        cgReq.addSourceCode("\n");
                        cgReq.genReturnCodeRemoteSetup(servSuppForStep.getHostName());
                        cgReq.genRemoteMacroVariablesSetup(servSuppForStep.getHostName()).addSourceCode("\n");
                        cgReq.addSourceCode(servSuppForStep.startSubmit(SASCodeGeneration.SYSRPUTSYNC_YES));
                        cgReq.indent();
                        cgReq.addSourceCode("%macro ").addSourceCode(TRANSFORM_MACRO_NAME).addSourceCode("(); \n").indent();
                        String vvnOption = cgReq.getGlobalData("ValidVarName");
                        if (vvnOption.equals("ANY")) {
                            resetValidVarName = true;
                            cgReq.addSourceCode("%let vvnOption = %sysfunc(getOption(VALIDVARNAME)); \n").addSourceCode("options validVarname = ANY; \n");
                        }
                        cgReq.addSourceCode("\n");
                        cgReq.genReturnCodeMacro();
                        cgReq.setCurrentServer((DeployedComponent)serverForStep);
                        if (step.getTransformRole().equals("LOOP")) {
                            cgReq.setCurrentParallelTask(step.getFQID());
                        }
                    }
                    stepCG.codeGen(cgReq);
                    if (!local && !TransformationActivityCG.isTransferStep(step)) {
                        if (step.getTransformRole().equals("LOOP")) {
                            cgReq.setCurrentParallelTask("");
                        }
                        lSPs = step.getPredecessorDependencies();
                        for (int m = 0; m < lSPs.size(); ++m) {
                            StepPrecedence sp = (StepPrecedence)lSPs.get(m);
                            lNextSteps = this.getCorrectNextSteps(step, sp);
                            for (k = 0; k < lNextSteps.size(); ++k) {
                                nextStep = (TransformationStep)lNextSteps.get(k);
                                if (TransformationActivityCG.isTransferStep(nextStep)) continue;
                                nextServer = TransformationActivityCG.getServerForStep(nextStep, cgReq.getCurrentServer(), localServer);
                                if (nextServer == null) {
                                    nextServer = defaultServerContext;
                                }
                                if (servSuppForStep.checkLocal(nextServer)) continue;
                                List lTabs = this.triangulateToFindTable(nextStep, step);
                                for (int l = 0; l < lTabs.size(); ++l) {
                                    DataTable table = (DataTable)lTabs.get(l);
                                    if (!(table instanceof WorkTable)) continue;
                                    cgReq.addSectionComment(bundle.getString("Transfer.ImplicitComment.msg.txt"));
                                    cgReq.genDownload(table).addSourceCode("\n");
                                }
                            }
                        }
                        if (resetValidVarName) {
                            cgReq.addSourceCode("options validVarname = &vvnOption;\n\n");
                        }
                        cgReq.genReturnCodeRemoteEnding();
                        cgReq.unIndent();
                        cgReq.addSourceCode("\n%mend ").addSourceCode(TRANSFORM_MACRO_NAME).addSourceCode("; \n\n").addSourceCode("%").addSourceCode(TRANSFORM_MACRO_NAME).addSourceCode(";\n\n");
                        cgReq.unIndent();
                        cgReq.addSourceCode(servSuppForStep.endSubmit());
                        cgReq.setCurrentServer((DeployedComponent)localServer);
                    }
                    if (!TransformationActivityCG.isTransferStep(step)) {
                        lSPs = step.getPredecessorDependencies();
                        for (int m = 0; m < lSPs.size(); ++m) {
                            StepPrecedence iSP = (StepPrecedence)lSPs.get(m);
                            lNextSteps = this.getCorrectNextSteps(step, iSP);
                            for (k = 0; k < lNextSteps.size(); ++k) {
                                nextStep = (TransformationStep)lNextSteps.get(k);
                                if (TransformationActivityCG.isTransferStep(nextStep)) continue;
                                nextServer = TransformationActivityCG.getServerForStep(nextStep, cgReq.getCurrentServer());
                                if (nextServer == null) {
                                    nextServer = defaultServerContext;
                                }
                                if (servSuppForStep.checkLocal(nextServer) || nextServer.getId().equalsIgnoreCase(localServer.getId())) continue;
                                ServerSupport nextServSupp = new ServerSupport(nextServer, localServer);
                                List lTabs = this.triangulateToFindTable(nextStep, step);
                                for (int l = 0; l < lTabs.size(); ++l) {
                                    WorkTableCG tableCG;
                                    SASLibrary lib;
                                    DataTable table = (DataTable)lTabs.get(l);
                                    if (!(table instanceof WorkTable)) continue;
                                    cgReq.addSectionComment(bundle.getString("Transfer.ImplicitComment.msg.txt"));
                                    cgReq.addSourceCode(nextServSupp.access());
                                    cgReq.genReturnCodeRemoteSetup(nextServSupp.getHostName());
                                    cgReq.genRemoteMacroVariablesSetup(nextServSupp.getHostName()).addSourceCode("\n");
                                    cgReq.addSourceCode(nextServSupp.startSubmit(SASCodeGeneration.SYSRPUTSYNC_YES));
                                    cgReq.indent().addSourceCode("\n");
                                    cgReq.addSourceCode("%macro ").addSourceCode(TRANSFORM_MACRO_NAME).addSourceCode("(); \n").indent();
                                    cgReq.genUpload(table).addSourceCode("\n");
                                    if (!(table.getTablePackages().size() <= 0 || (lib = (tableCG = (WorkTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table)).getBestDeployment(cgReq).getLibrary()) != null && lib.getLibref().equalsIgnoreCase("work"))) {
                                        cgReq.addSourceCode("libname ").addSourceCode(lib.getLibref()).addSourceCode(" (").addSourceCode("work").addSourceCode("); \n");
                                        cgReq.genRCSetCall("&syslibrc");
                                    }
                                    cgReq.genReturnCodeRemoteEnding();
                                    cgReq.unIndent();
                                    cgReq.addSourceCode("\n%mend ").addSourceCode(TRANSFORM_MACRO_NAME).addSourceCode("; \n\n").addSourceCode("%").addSourceCode(TRANSFORM_MACRO_NAME).addSourceCode(";\n\n");
                                    cgReq.unIndent();
                                    cgReq.addSourceCode(nextServSupp.endSubmit());
                                }
                            }
                        }
                    }
                    if (TransformationActivityCG.isTransferStep(step)) {
                        cgReq.removeGlobalData(TRANSFER_ROLE);
                        continue;
                    }
                    if (!TransformationActivityCG.isContentsStep(step)) continue;
                    cgReq.removeGlobalData("ContentsStep");
                }
            }
            catch (MdException mde) {
                throw mde;
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            finally {
                ServerSupport.clearSignonCache();
            }
        }
        this.codeGenSelfOnly(cgReq);
    }

    private List getCorrectNextSteps(TransformationStep step, StepPrecedence iSP) throws MdException, RemoteException {
        Object lNextSteps = new ArrayList();
        if (step.getTransformRole().equals("LOOP")) {
            AssociationList nextSteps = iSP.getSuccessors();
            for (int i = 0; i < nextSteps.size(); ++i) {
                StepPrecedence pd;
                int j;
                TransformationStep loopEnd = (TransformationStep)nextSteps.get(i);
                AssociationList pdList = loopEnd.getPredecessorDependencies();
                if (loopEnd.getTransformRole().equals("LOOPEND")) {
                    for (j = 0; j < pdList.size(); ++j) {
                        pd = (StepPrecedence)pdList.get(j);
                        lNextSteps = pd.getSuccessors();
                    }
                    continue;
                }
                for (j = 0; j < pdList.size(); ++j) {
                    pd = (StepPrecedence)pdList.get(j);
                    lNextSteps = this.getCorrectNextSteps(step, pd);
                }
            }
        } else {
            lNextSteps = iSP.getSuccessors();
        }
        return lNextSteps;
    }

    @Override
    public void codeGenSelfOnly(CodegenRequest cgReq) throws MdException, RemoteException {
        TransformationActivity activity = (TransformationActivity)this.getMetadataClass();
        if (activity.getIsUserDefined() > 0) {
            cgReq.genUWC((AbstractTransformation)activity);
        }
    }

    private List triangulateToFindTable(TransformationStep step1, TransformationStep step2) throws MdException, RemoteException {
        ArrayList<DataTable> retList = new ArrayList<DataTable>();
        AssociationList lcms1 = step1.getTransformations();
        AssociationList lcms2 = step2.getTransformations();
        for (int i = 0; i < lcms1.size(); ++i) {
            if (!(lcms1.get(i) instanceof ClassifierMap)) continue;
            ClassifierMap map = (ClassifierMap)lcms1.get(i);
            AssociationList inputs = map.getClassifierSources();
            for (int j = 0; j < inputs.size(); ++j) {
                DataTable table = (DataTable)inputs.get(j);
                AssociationList lTargCMs = table.getTargetClassifierMaps(false);
                if (lTargCMs.size() <= 0) continue;
                ClassifierMap inputCM = (ClassifierMap)lTargCMs.get(0);
                String id1 = inputCM.getId();
                for (int k = 0; k < lcms2.size(); ++k) {
                    ClassifierMap iMap2 = (ClassifierMap)lcms2.get(k);
                    if (!id1.equalsIgnoreCase(iMap2.getId()) || retList.contains(table)) continue;
                    retList.add(table);
                }
            }
        }
        return retList;
    }

    public static ServerContext getServerForStep(TransformationStep step, ServerContext server) throws MdException, RemoteException {
        return TransformationActivityCG.getServerForStep(step, server, null);
    }

    public static ServerContext getServerForStep(TransformationStep step, ServerContext server, ServerContext defaultServer) throws MdException, RemoteException {
        return TransformationActivityCG.getServerForStep(step, server, defaultServer, null);
    }

    public static ServerContext getServerForStep(TransformationStep step, ServerContext server, ServerContext defaultServer, CodegenRequest cgReq) throws MdException, RemoteException {
        int i;
        AssociationList lHosts = new ArrayList();
        boolean found = false;
        AssociationList lCMs = step.getTransformations();
        for (i = 0; i < lCMs.size(); ++i) {
            Object input;
            AssociationList inputs;
            Object output;
            if (!(lCMs.get(i) instanceof ClassifierMap)) continue;
            ClassifierMap cm = (ClassifierMap)lCMs.get(i);
            if (CodeGenUtil.isLoaderTransformation((CMetadata)cm)) {
                found = true;
                AssociationList lTabs = cm.getClassifierTargets();
                for (int j = 0; j < lTabs.size(); ++j) {
                    DataTable table = (DataTable)lTabs.get(j);
                    RelationalSchema tablePackage = table.getTablePackage();
                    if (tablePackage == null && table.getCMetadataType().equals("PhysicalTable")) {
                        String tableName = table.getName();
                        if (table instanceof PhysicalTable) {
                            tableName = ((PhysicalTable)table).getSASTableName();
                        }
                        if (cgReq == null || cgReq.isThrowingExceptions()) {
                            throw new CodegenException(bundle.formatString("PROCESS.NoLibraryForTable.msg.txt", (Object)tableName));
                        }
                    }
                    if (tablePackage instanceof SASLibrary) {
                        lHosts.addAll(LibraryUtil.getClientLibrary((SASLibrary)((SASLibrary)tablePackage), (ServerContext)server).getDeployedComponents());
                        continue;
                    }
                    if (tablePackage == null) continue;
                    AssociationList libs = tablePackage.getUsedByPackages();
                    for (int k = 0; k < libs.size(); ++k) {
                        lHosts.addAll(LibraryUtil.getClientLibrary((SASLibrary)((SASLibrary)libs.get(k)), (ServerContext)server).getDeployedComponents());
                    }
                }
                if (defaultServer == null) continue;
                boolean localFound = false;
                for (int k = 0; k < lHosts.size(); ++k) {
                    if (!((ServerContext)lHosts.get(k)).getId().equals(defaultServer.getId())) continue;
                    localFound = true;
                    break;
                }
                if (!localFound) continue;
                lHosts.clear();
                lHosts.add(defaultServer);
                continue;
            }
            AssociationList outputs = cm.getClassifierTargets();
            if (!outputs.isEmpty() && (output = outputs.get(0)) instanceof ExternalTable) {
                ExternalTableCG tableCG = (ExternalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)((ExternalTable)output));
                EFIDataModel efiModel = tableCG.getModel();
                ServerContext etServer = (ServerContext)efiModel.getAppServerDC();
                if (etServer == null) {
                    lHosts.add(server);
                } else {
                    lHosts.add(etServer);
                }
                found = true;
            }
            if ((inputs = cm.getClassifierSources()).isEmpty() || !((input = inputs.get(0)) instanceof ExternalTable)) continue;
            ExternalTableCG tableCG = (ExternalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)((ExternalTable)input));
            EFIDataModel efiModel = tableCG.getModel();
            ServerContext etServer = (ServerContext)efiModel.getAppServerDC();
            if (etServer == null) {
                lHosts.add(server);
            } else {
                lHosts.add(etServer);
            }
            found = true;
        }
        if (!found) {
            lHosts = step.getComputeLocations();
        }
        if (lHosts.size() == 0) {
            return null;
        }
        for (i = 0; i < lHosts.size(); ++i) {
            ServerContext iComputeServer = (ServerContext)lHosts.get(i);
            if (iComputeServer == null || server == null || !iComputeServer.getId().equals(server.getId())) continue;
            return iComputeServer;
        }
        return (ServerContext)lHosts.get(0);
    }

    public static ServerContext getPreviousServer(TransformationStep step, ServerContext currentServer) throws MdException, RemoteException {
        AssociationList lSPs = step.getSuccessorDependencies();
        if (lSPs.size() > 0) {
            StepPrecedence sp = (StepPrecedence)lSPs.get(0);
            AssociationList steps = sp.getPredecessors();
            TransformationStep prevStep = (TransformationStep)steps.get(0);
            if (prevStep.getComputeLocations().size() > 0) {
                return (ServerContext)prevStep.getComputeLocations().get(0);
            }
        } else {
            DataTable tab;
            SASLibrary lib;
            AssociationList cms = step.getTransformations();
            ClassifierMap cm = (ClassifierMap)cms.get(0);
            AssociationList tabs = cm.getClassifierSources();
            if (tabs.size() > 0 && (lib = LibraryUtil.getLibrary((DataTable)(tab = (DataTable)tabs.get(0)), (ServerContext)currentServer)) != null) {
                return LibraryUtil.getServer((SASLibrary)lib, (ServerContext)currentServer);
            }
        }
        return currentServer;
    }

    public static ServerContext getNextServer(TransformationStep step, ServerContext currentServer) throws MdException, RemoteException {
        AssociationList lSPs = step.getPredecessorDependencies();
        if (lSPs.size() > 0) {
            StepPrecedence iSP = (StepPrecedence)lSPs.get(0);
            AssociationList steps = iSP.getSuccessors();
            TransformationStep iNextStep = (TransformationStep)steps.get(0);
            ServerContext iServer = TransformationActivityCG.getServerForStep(iNextStep, currentServer);
            if (iServer != null) {
                return iServer;
            }
        } else {
            throw new CodegenException(bundle.getString("Transfer.NoTarget.msg.txt"));
        }
        return currentServer;
    }

    protected List buildDTree(TransformationActivity activity) throws MdException, RemoteException {
        int size;
        int i;
        AssociationList lSteps = activity.getSteps(false);
        ArrayList<DTreeNode> results = new ArrayList<DTreeNode>(lSteps.size());
        ArrayList<DTreeNode> tresults = new ArrayList<DTreeNode>(lSteps.size());
        ArrayList<DTreeNode> viewDependency = new ArrayList<DTreeNode>();
        for (i = 0; i < lSteps.size(); ++i) {
            TransformationStep step = (TransformationStep)lSteps.get(i);
            boolean isFedByView = false;
            if (!step.getTransformations().isEmpty()) {
                int transSize = step.getTransformations().size();
                block1: for (int j = 0; j < transSize; ++j) {
                    if (!(step.getTransformations().get(j) instanceof ClassifierMap)) continue;
                    ClassifierMap cMap = (ClassifierMap)step.getTransformations().get(j);
                    int sources = cMap.getClassifierSources().size();
                    for (int k = 0; k < sources; ++k) {
                        TransformationStep tStep;
                        ClassifierMap tempCMap;
                        if (!(cMap.getClassifierSources().get(k) instanceof PhysicalTable)) continue;
                        PhysicalTable pTable = (PhysicalTable)cMap.getClassifierSources().get(k);
                        PhysicalTableCG pTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)pTable);
                        if (pTable.getTargetClassifierMaps(false).isEmpty() || (tempCMap = (ClassifierMap)pTable.getTargetClassifierMaps(false).get(0)).getSteps(false).isEmpty() || !pTableCG.isView(tStep = (TransformationStep)tempCMap.getSteps(false).get(0))) continue;
                        isFedByView = true;
                        continue block1;
                    }
                }
            }
            AssociationList lPrec = step.getSuccessorDependencies(false);
            ArrayList<TransformationStep> lNsteps = new ArrayList<TransformationStep>();
            for (int j = 0; j < lPrec.size(); ++j) {
                StepPrecedence iPrec = (StepPrecedence)lPrec.get(j);
                AssociationList predList = iPrec.getPredecessors(false);
                for (int k = 0; k < predList.size(); ++k) {
                    TransformationStep tempStep = (TransformationStep)predList.get(k);
                    AssociationList lActivities = tempStep.getActivities(false);
                    for (int l = 0; l < lActivities.size(); ++l) {
                        TransformationActivity act = (TransformationActivity)lActivities.get(l);
                        if (!act.getFQID().equals(activity.getFQID())) continue;
                        lNsteps.add(tempStep);
                    }
                }
            }
            AssociationList lSucc = step.getPredecessorDependencies(false);
            ArrayList<TransformationStep> lChildSteps = new ArrayList<TransformationStep>();
            for (int j = 0; j < lSucc.size(); ++j) {
                StepPrecedence iSucc = (StepPrecedence)lSucc.get(j);
                AssociationList succList = iSucc.getSuccessors(false);
                for (int k = 0; k < succList.size(); ++k) {
                    TransformationStep tempStep = (TransformationStep)succList.get(k);
                    AssociationList lActivities = tempStep.getActivities(false);
                    for (int l = 0; l < lActivities.size(); ++l) {
                        TransformationActivity act = (TransformationActivity)lActivities.get(l);
                        if (!act.getFQID().equals(activity.getFQID())) continue;
                        lChildSteps.add(tempStep);
                    }
                }
            }
            DTreeNode node = new DTreeNode(step, lNsteps, lChildSteps, isFedByView);
            if (isFedByView) {
                viewDependency.add(node);
            }
            tresults.add(node);
        }
        Workspace.getDefaultLogger().debug((Object)"Starting order: ");
        for (i = 0; i < tresults.size(); ++i) {
            Workspace.getDefaultLogger().debug((Object)("\t" + ((DTreeNode)tresults.get(i)).getStepID() + "    " + ((DTreeNode)tresults.get(i)).getStepName()));
        }
        for (int i2 = size = tresults.size() - 1; i2 >= 0; --i2) {
            DTreeNode node = (DTreeNode)tresults.get(i2);
            if (node.getPreviousSteps().size() != 0) continue;
            results.add(node);
            tresults.remove(i2);
        }
        int count = 0;
        while (tresults.size() > 0) {
            DTreeNode node = (DTreeNode)tresults.get(count);
            boolean found = false;
            int maxCount = 0;
            int numNextSteps = node.getPreviousSteps().size();
            int numFoundSteps = 0;
            for (int i3 = 0; i3 < numNextSteps; ++i3) {
                TransformationStep nStep = (TransformationStep)node.getPreviousSteps().get(i3);
                boolean foundThisStep = false;
                for (int j = 0; j < results.size(); ++j) {
                    TransformationStep tempStep = ((DTreeNode)results.get(j)).getStep();
                    if (!tempStep.equals((Object)nStep)) continue;
                    foundThisStep = true;
                    ++numFoundSteps;
                    if (j <= maxCount) break;
                    maxCount = j;
                    break;
                }
                if (!foundThisStep) break;
            }
            if (numFoundSteps == numNextSteps) {
                found = true;
            }
            if (found) {
                results.add(maxCount + 1, node);
                tresults.remove(count);
                count = 0;
                continue;
            }
            ++count;
        }
        Workspace.getDefaultLogger().debug((Object)"Verify Codegen Step order: ");
        for (int i4 = 0; i4 < results.size(); ++i4) {
            Workspace.getDefaultLogger().debug((Object)("\t" + ((DTreeNode)results.get(i4)).getStepID() + "    " + ((DTreeNode)results.get(i4)).getStepName()));
        }
        return results;
    }

    private HashMap buildMapOfNodes(List nodeList) {
        HashMap<String, DTreeNode> map = new HashMap<String, DTreeNode>(nodeList.size());
        int size = nodeList.size();
        for (int i = 0; i < size; ++i) {
            DTreeNode node = (DTreeNode)nodeList.get(i);
            try {
                map.put(node.getStepID(), node);
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return map;
    }

    public void codeGenPriorSteps(TransformationStep step, CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.genReturnCodeSetup();
        this.codeGenForSteps(cgReq, this.getStepSequencePriorToStep(step));
    }

    public void getSourceAndTargetTablesOnPriorSteps(TransformationStep step, CodegenRequest cgReq, List sources) throws MdException, RemoteException {
        List steps = this.getStepSequencePriorToStep(step);
        int size = steps.size();
        for (int i = 0; i < size; ++i) {
            DTreeNode node = (DTreeNode)steps.get(i);
            AssociationList cms = node.getStep().getTransformations();
            int cmSize = cms.size();
            if (cmSize <= 0 || !(cms.get(0) instanceof ClassifierMap)) continue;
            ClassifierMap cm = (ClassifierMap)cms.get(0);
            ArrayList tables = new ArrayList();
            tables.addAll(cm.getClassifierSources());
            tables.addAll(cm.getClassifierTargets());
            int tSize = tables.size();
            for (int j = 0; j < tSize; ++j) {
                if (sources.contains(tables.get(j))) continue;
                sources.add(tables.get(j));
            }
        }
    }

    public TransformationStep getNextStep(TransformationStep step) throws MdException, RemoteException {
        TransformationActivity activity = (TransformationActivity)this.getMetadataClass();
        List nodes = this.buildDTree(activity);
        TransformationStep nextStep = null;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            DTreeNode node = (DTreeNode)nodes.get(i);
            if (!node.getStepID().equals(step.getFQID())) continue;
            if (i + 1 >= size) break;
            nextStep = ((DTreeNode)nodes.get(i + 1)).getStep();
            break;
        }
        return nextStep;
    }

    private List getStepSequencePriorToStep(TransformationStep step) throws MdException, RemoteException {
        TransformationActivity activity = (TransformationActivity)this.getMetadataClass();
        List steps = this.buildDTree(activity);
        ArrayList stepsPrior = new ArrayList();
        int size = steps.size();
        int stepIndex = -1;
        for (int i = 0; i < size; ++i) {
            DTreeNode node = (DTreeNode)steps.get(i);
            if (!node.getStepID().equals(step.getFQID())) continue;
            stepIndex = i;
            break;
        }
        if (stepIndex > -1) {
            DTreeNode stepNode = (DTreeNode)steps.get(stepIndex);
            this.getStepsPriorToStep(stepNode, stepsPrior, this.buildMapOfNodes(steps));
        }
        return stepsPrior;
    }

    private void getStepsPriorToStep(DTreeNode stepNode, List stepsPrior, HashMap mapOfAllSteps) {
        List previousSteps = stepNode.getPreviousSteps();
        int size = previousSteps.size();
        for (int i = 0; i < size; ++i) {
            TransformationStep step = (TransformationStep)previousSteps.get(i);
            try {
                DTreeNode prevNode = (DTreeNode)mapOfAllSteps.get(step.getFQID());
                stepsPrior.add(0, prevNode);
                this.getStepsPriorToStep(prevNode, stepsPrior, mapOfAllSteps);
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    public static boolean isTransferStep(TransformationStep step) throws MdException, RemoteException {
        if (step.getTransformRole().indexOf(TRANSFER_ROLE) > -1) {
            return true;
        }
        AssociationList props = step.getProperties();
        String classname = null;
        for (int j = 0; j < props.size(); ++j) {
            Property prop = (Property)props.get(j);
            if (!prop.getPropertyName().equalsIgnoreCase(CLASS_PROPERTY)) continue;
            classname = prop.getDefaultValue();
            if (!classname.equals(TRANSFER_CLASS)) break;
            return true;
        }
        return false;
    }

    public static boolean isContentsStep(TransformationStep step) throws MdException, RemoteException {
        if (step.getTransformRole().indexOf(CONTENTS_ROLE) > -1) {
            return true;
        }
        AssociationList props = step.getProperties();
        String classname = null;
        for (int j = 0; j < props.size(); ++j) {
            Property prop = (Property)props.get(j);
            if (!prop.getPropertyName().equalsIgnoreCase(CLASS_PROPERTY)) continue;
            classname = prop.getDefaultValue();
            if (classname.indexOf(CONTENTS_PACKAGE) <= -1) break;
            return true;
        }
        return false;
    }

    protected class DTreeNode {
        private TransformationStep m_step;
        private List m_previousSteps;
        private boolean m_bIsFedByView = false;
        private List m_nextSteps;

        protected DTreeNode(TransformationStep step, List previousSteps, List nextSteps, boolean isFedByView) {
            this.m_step = step;
            this.m_previousSteps = previousSteps;
            this.m_bIsFedByView = isFedByView;
            this.m_nextSteps = nextSteps;
        }

        public String getStepID() throws RemoteException {
            return this.m_step.getFQID();
        }

        public String getStepName() throws RemoteException {
            return this.m_step.getName();
        }

        public TransformationStep getStep() {
            return this.m_step;
        }

        public String toString() {
            String name = "";
            try {
                name = this.getStepName();
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            return name;
        }

        public List getPreviousSteps() {
            return this.m_previousSteps;
        }

        public boolean isViewSource() {
            return this.m_bIsFedByView;
        }

        public List getNextSteps() {
            return this.m_nextSteps;
        }

        public void moveChildNodes(List results, int moveToIndex) {
            if (moveToIndex > results.size()) {
                moveToIndex = results.size();
            }
            results.add(moveToIndex, this);
            int numChildren = this.getNextSteps().size();
            for (int i = 0; i < numChildren; ++i) {
                TransformationStep step = (TransformationStep)this.getNextSteps().get(i);
                for (int k = 0; k < results.size(); ++k) {
                    DTreeNode node = (DTreeNode)results.get(k);
                    try {
                        if (node.getStepID() != step.getFQID()) continue;
                        int newIndex = i + moveToIndex + 1;
                        results.remove(k);
                        node.moveChildNodes(results, newIndex);
                        continue;
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException((RemoteException)ex);
                    }
                }
            }
        }
    }
}

