/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.DBMSSTORE;
import com.sas.codegen.PhysicalTableCG;
import com.sas.codegen.SAS;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.PropertyHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;

public class TableLoaderModel {
    private static WAdminResource bundle = WAdminResource.getBundle(TableLoaderModel.class);
    private ClassifierMap m_classifierMap = null;
    private PhysicalTable m_physicalTable = null;
    private DBMSSTORE m_physicalTableCG = null;
    private MdObjectStore m_store = null;
    private OptionsPropertyHandler m_phlOptions = null;
    private static final String PROPERTY_NAME_LOADTIME_COLUMN = "LoadTime";
    private NameValueComboBoxModel m_mdlLoadStyle;
    private PropertyHandler m_phlTableEngine = null;
    private static final String PROPERTY_SET_NAME_TABLE_ENGINE = "EngineForOptions";
    private static final String PROPERTY_NAME_ENGINE = "EngineForOptions";
    public static final String LOADSTYLE_UPDATE = "Update";
    public static final String LOADSTYLE_APPEND_EXISTING = "AppendToExisting";
    public static final String LOADSTYLE_REPLACE = "Replace";
    private PropertyHandler m_phlRowActions = null;
    public static final String PROPERTY_SET_NAME_ROW_ACTIONS = "RowActions";
    public static final String PROPERTY_NAME_MATCH_COLUMNS = "MatchColumns";
    public static final String PROPERTY_NAME_MODIFY_INDEX = "ModifyIndex";
    private PropertyHandler m_phlLoadStyle = null;
    private String DEFAULT_LOAD_STYLE = "Replace";
    private static final String PROPERTY_SET_NAME_LOAD_STYLE = "LoadStyle";
    private static final String PROPERTY_NAME_STYLE = "Style";
    private static final String PROPERTY_NAME_REPLACE_TYPE = "ReplaceType";
    private NameValueComboBoxModel m_mdlMatchingRows = null;
    private String DEFAULT_MATCHING_ROWS = "SQLSet";
    private String DEFAULT_NEW_ROWS = "AppendProc";
    private NameValueComboBoxModel m_mdlNewRows = null;
    public static final String PROPERTY_NAME_NOMISSINGCHECK = "nomissingcheck";
    private static final String PROPERTY_NAME_MATCHING_ROWS = "MatchingRows";
    private static final String PROPERTY_NAME_NEW_ROWS = "NewRows";
    public static final String MODIFYBYCOLUMN = "ModifyByColumn";
    public static final String MODIFYUSINGINDEX = "ModifyUsingIndex";
    public static final String SKIP = "Skip";
    public static final String MATCHING_ROWS_SQLSET = "SQLSet";
    public static final String MATCHING_ROWS_UPSERT = "Upsert";
    public static final String NEW_ROWS_INSERT_SQL = "InsertSQL";
    public static final String NEW_ROWS_UPSERT = "Upsert";
    public static final String NEW_ROWS_APPEND_PROC = "AppendProc";
    private PropertyHandler m_phlAdditionalAction = null;
    private static final String PROPERTY_SET_NAME_ADDITIONAL_ACTION = "AdditionalActions";
    private static final String PROPERTY_NAME_INDEX_BEFORE = "IndexActionBefore";
    private static final String PROPERTY_NAME_INDEX_AFTER = "IndexActionAfter";
    private static final String PROPERTY_NAME_CONSTRAINT_BEFORE = "ConstraintActionBefore";
    private static final String PROPERTY_NAME_CONSTRAINT_AFTER = "ConstraintActionAfter";
    private static final String PROPERTY_NAME_UNIQUE = "unique";
    private static final String PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE = "UnmappedEqMissingInUpdate";
    private static final String PROPERTY_NAME_REAPPLY_C_IN_REPLACE_DS = "ReapplyConstraintsInReplaceDS";
    private DefaultComboBoxModel m_mdlModifyIndexes = null;
    private NameValueComboBoxModel m_mdlIndexBefore = null;
    private NameValueComboBoxModel m_mdlConstraintBefore = null;
    private NameValueComboBoxModel m_mdlConstraintAfter = null;
    private NameValueComboBoxModel m_mdlIndexAfter = null;
    public static final String CI_ACTION_NONE = "ASIS";
    public static final String CI_ACTION_ON = "ON";
    public static final String CI_ACTION_OFF = "OFF";
    public static final String CI_ACTION_INITIAL_LOAD = "INIT";
    private String DEFAULT_INDEX_BEFORE = "INIT";
    private String DEFAULT_CONSTRAINT_BEFORE = "INIT";
    private String DEFAULT_CONSTRAINT_AFTER = "ASIS";
    private String DEFAULT_INDEX_AFTER = "ASIS";
    public static final boolean DEFAULT_NOMISSING_CHECK = true;
    private String DEFAULT_REPLACE_TYPE = "EntireTable";
    private boolean DEFAULT_UNMAPPED_EQ_MISSING = false;
    private boolean DEFAULT_APPLY_C_IN_REPLACE_TABLE = false;
    public static final String REPLACE_ALL_ROWS_DELETE = "Delete";
    public static final String REPLACE_ALL_ROWS_TRUNCATE = "Truncate";
    public static final String REPLACE_ENTIRE_TABLE = "EntireTable";
    private Index m_modifyIndex;
    private boolean m_noMissingCheck;
    private boolean m_indexUnique;
    private List m_aMatchColumns = new ArrayList();
    private boolean m_unmappedEqMissingInUpdate;
    private boolean m_reapplyCInReplaceTable;
    private NameValueComboBoxModel m_mdlReplaceType = null;

    public TableLoaderModel(ClassifierMap meta) throws MdException, RemoteException {
        this.m_classifierMap = meta;
        this.m_store = (MdObjectStore)meta.getObjectStore();
        this.m_phlOptions = new OptionsPropertyHandler((Root)this.m_classifierMap);
        this.m_phlRowActions = new PropertyHandler((Root)this.m_classifierMap, PROPERTY_SET_NAME_ROW_ACTIONS, true);
        this.m_phlLoadStyle = new PropertyHandler((Root)this.m_classifierMap, PROPERTY_SET_NAME_LOAD_STYLE, true);
        this.m_phlAdditionalAction = new PropertyHandler((Root)this.m_classifierMap, PROPERTY_SET_NAME_ADDITIONAL_ACTION, true);
        this.m_phlTableEngine = new PropertyHandler((Root)this.m_classifierMap, "EngineForOptions", true);
        this.m_mdlLoadStyle = new NameValueComboBoxModel("TableLoaderModel.LoadStyle", true);
        this.m_mdlLoadStyle.addItem(LOADSTYLE_UPDATE).addItem(LOADSTYLE_REPLACE).addItem(LOADSTYLE_APPEND_EXISTING);
        this.m_mdlMatchingRows = new NameValueComboBoxModel("TableLoaderModel.MatchingRows", true);
        this.m_mdlNewRows = new NameValueComboBoxModel("TableLoaderModel.NewRows", true);
        this.m_mdlReplaceType = new NameValueComboBoxModel("TableLoader.ReplaceType", true);
        this.m_mdlIndexBefore = new NameValueComboBoxModel("TableLoaderModel.CIAction", true);
        this.m_mdlIndexAfter = new NameValueComboBoxModel("TableLoaderModel.CIAction", true);
        this.m_mdlConstraintBefore = new NameValueComboBoxModel("TableLoaderModel.CIAction", true);
        this.m_mdlConstraintAfter = new NameValueComboBoxModel("TableLoaderModel.CIAction", true);
        this.moveDataToModel();
    }

    public void setTargetTable(PhysicalTable table) throws MdException, RemoteException {
        this.m_physicalTable = table;
        if (this.m_physicalTable != null) {
            PhysicalTableCG pTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table, true);
            if (!(pTableCG instanceof DBMSSTORE)) {
                pTableCG = new DBMSSTORE();
                pTableCG.setMetadataClass((CMetadata)table);
            }
            this.m_physicalTableCG = (DBMSSTORE)pTableCG;
            this.setReplaceDefault();
        }
    }

    public void moveDataToModel() throws MdException, RemoteException {
        if (!this.m_classifierMap.getClassifierTargets().isEmpty()) {
            this.setTargetTable((PhysicalTable)this.m_classifierMap.getClassifierTargets().get(0));
        }
        this.getLoadStyleModel();
        this.getMatchingRowsModel();
        this.getReplaceTypeModel();
        this.getIndexBeforeModel();
        this.getIndexAfterModel();
        this.getConstraintBeforeModel();
        this.getConstraintAfterModel();
        this.getNewRowsModel();
        this.m_aMatchColumns = this.m_phlRowActions.getPropertyMetadataObjects(PROPERTY_NAME_MATCH_COLUMNS);
        List indexes = this.getAvailableIndexes();
        this.m_mdlModifyIndexes = new DefaultComboBoxModel<Object>(indexes.toArray());
        CMetadata modIndex = this.m_phlRowActions.getPropertyMetadataObject(PROPERTY_NAME_MODIFY_INDEX);
        this.m_modifyIndex = modIndex != null ? (Index)modIndex : (!indexes.isEmpty() ? (Index)indexes.get(0) : null);
        if (this.m_physicalTable != null) {
            this.resetLoadStyleDefault();
        }
        this.resetUnmappedEqMissingDefault();
        this.m_unmappedEqMissingInUpdate = this.getUnmappedEqMissingInUpdate();
        this.m_reapplyCInReplaceTable = this.getReapplyCInReplaceDS();
    }

    public void moveDataToStore() throws MdException, RemoteException {
        String libraryEngine = "";
        if (this.m_physicalTableCG != null) {
            libraryEngine = this.m_physicalTableCG.getClass().getName();
        }
        this.m_phlTableEngine.setSpecificProperty("EngineForOptions", libraryEngine, "EngineForOptions", "", 0, null);
        this.m_phlLoadStyle.setSpecificProperty(PROPERTY_NAME_STYLE, this.m_mdlLoadStyle.getSelectedValue(), PROPERTY_NAME_STYLE, "", 0, null);
        this.m_phlRowActions.setPropertyMetadataObjects(this.m_store, PROPERTY_NAME_MATCH_COLUMNS, this.m_aMatchColumns);
        this.m_phlRowActions.setPropertyMetadataObject(this.m_store, PROPERTY_NAME_MODIFY_INDEX, (CMetadata)this.m_modifyIndex);
        this.m_phlLoadStyle.setSpecificProperty(PROPERTY_NAME_REPLACE_TYPE, this.m_mdlReplaceType.getSelectedValue(), PROPERTY_NAME_REPLACE_TYPE, "", 0, null);
        this.m_phlRowActions.setSpecificProperty(PROPERTY_NAME_NOMISSINGCHECK, this.m_noMissingCheck ? PROPERTY_NAME_NOMISSINGCHECK : "", PROPERTY_NAME_NOMISSINGCHECK, "", 1, null);
        this.m_phlRowActions.setSpecificProperty(PROPERTY_NAME_MATCHING_ROWS, this.m_mdlMatchingRows.getSelectedValue(), PROPERTY_NAME_MATCHING_ROWS, "", 0, null);
        this.m_phlRowActions.setSpecificProperty(PROPERTY_NAME_NEW_ROWS, this.m_mdlNewRows.getSelectedValue(), PROPERTY_NAME_NEW_ROWS, "", 0, null);
        this.m_phlAdditionalAction.setSpecificProperty(PROPERTY_NAME_CONSTRAINT_BEFORE, this.m_mdlConstraintBefore.getSelectedValue(), PROPERTY_NAME_CONSTRAINT_BEFORE, "", 0, null);
        this.m_phlAdditionalAction.setSpecificProperty(PROPERTY_NAME_CONSTRAINT_AFTER, this.m_mdlConstraintAfter.getSelectedValue(), PROPERTY_NAME_CONSTRAINT_AFTER, "", 0, null);
        this.m_phlAdditionalAction.setSpecificProperty(PROPERTY_NAME_INDEX_AFTER, this.m_mdlIndexAfter.getSelectedValue(), PROPERTY_NAME_INDEX_AFTER, "", 0, null);
        this.m_phlAdditionalAction.setSpecificProperty(PROPERTY_NAME_INDEX_BEFORE, this.m_mdlIndexBefore.getSelectedValue(), PROPERTY_NAME_INDEX_BEFORE, "", 0, null);
        this.m_phlRowActions.setSpecificProperty(PROPERTY_NAME_UNIQUE, this.m_phlRowActions.booleanToString(this.m_indexUnique), PROPERTY_NAME_UNIQUE, "", 1, null);
        this.m_phlRowActions.setSpecificProperty(PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE, this.m_phlRowActions.booleanToString(this.m_unmappedEqMissingInUpdate), PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE, "", 1, null);
        this.m_phlRowActions.setSpecificProperty(PROPERTY_NAME_REAPPLY_C_IN_REPLACE_DS, this.m_phlRowActions.booleanToString(this.m_reapplyCInReplaceTable), PROPERTY_NAME_REAPPLY_C_IN_REPLACE_DS, "", 1, null);
    }

    private boolean isRefreshIndexesAvailable() throws MdException, RemoteException {
        return this.isIndexEnabled();
    }

    public String getLoadTimeSASColumnName() throws MdException, RemoteException {
        Property prop = this.m_phlOptions.getSpecificProperty(PROPERTY_NAME_LOADTIME_COLUMN);
        Object col = this.m_phlOptions.getSpecificOptionObjectValue(PROPERTY_NAME_LOADTIME_COLUMN, 2000, true, false);
        String loadTimeColumnSASName = "";
        if (col != null && col instanceof Column) {
            loadTimeColumnSASName = ((Column)col).getSASColumnName();
        } else if (col != null && col instanceof String) {
            loadTimeColumnSASName = col.toString();
        } else if (prop == null && this.m_physicalTable != null) {
            AssociationList columns = this.m_physicalTable.getColumns();
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                Column c = (Column)columns.get(i);
                if (!c.getSASColumnName().equalsIgnoreCase("_LOADTM")) continue;
                return "_LOADTM";
            }
        }
        return loadTimeColumnSASName;
    }

    public NameValueComboBoxModel getLoadStyleModel() throws MdException, RemoteException {
        this.m_mdlLoadStyle.setSelectedValue(this.getLoadStyleValue());
        return this.m_mdlLoadStyle;
    }

    public NameValueComboBoxModel getReplaceTypeModel() throws MdException, RemoteException {
        this.resetReplaceTypeModel();
        this.m_mdlReplaceType.setSelectedValue(this.getReplaceType());
        return this.m_mdlReplaceType;
    }

    public void setReplaceDefault() throws MdException, RemoteException {
        this.DEFAULT_REPLACE_TYPE = REPLACE_ENTIRE_TABLE;
        if (this.isDeleteAllRowsEnabled()) {
            if (this.isTruncateSupported()) {
                this.DEFAULT_REPLACE_TYPE = REPLACE_ALL_ROWS_TRUNCATE;
            } else if (this.m_physicalTableCG != null && !(this.m_physicalTableCG instanceof SAS)) {
                this.DEFAULT_REPLACE_TYPE = REPLACE_ALL_ROWS_DELETE;
            }
        }
    }

    public boolean isDeleteAllRowsEnabled() {
        boolean enabled = true;
        if (this.m_physicalTableCG != null) {
            enabled = this.m_physicalTableCG.getDeleteAllRowsSupport();
        }
        return enabled;
    }

    public void resetLoadStyleDefault() throws MdException, RemoteException {
        this.setLoadStyleDefault(LOADSTYLE_REPLACE);
    }

    public void resetUnmappedEqMissingDefault() throws MdException, RemoteException {
        String propValue = this.m_phlRowActions.getSpecificOptionValue(PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE);
        if (this.getLoadStyleValue().equalsIgnoreCase(LOADSTYLE_UPDATE) && !propValue.equals("N") && !propValue.equals("Y")) {
            this.DEFAULT_UNMAPPED_EQ_MISSING = true;
        }
    }

    public void setLoadStyleDefault(String newdefault) {
        this.DEFAULT_LOAD_STYLE = newdefault;
    }

    public String getLoadStyleValue() throws MdException, RemoteException {
        String style = this.m_phlLoadStyle.getSpecificOptionValue(PROPERTY_NAME_STYLE);
        if ("".equals(style)) {
            style = this.DEFAULT_LOAD_STYLE;
        }
        return style;
    }

    public String getModifyPanel() {
        String panelName = "";
        if (this.m_mdlLoadStyle.getSelectedValue().equals(LOADSTYLE_UPDATE) && !this.m_mdlMatchingRows.getSelectedValue().equals(MODIFYUSINGINDEX) && !this.m_mdlNewRows.getSelectedValue().equals(MODIFYUSINGINDEX)) {
            panelName = MODIFYBYCOLUMN;
        } else if (this.m_mdlLoadStyle.getSelectedValue().equals(LOADSTYLE_UPDATE) && (this.m_mdlMatchingRows.getSelectedValue().equals(MODIFYUSINGINDEX) || this.m_mdlNewRows.getSelectedValue().equals(MODIFYUSINGINDEX))) {
            panelName = MODIFYUSINGINDEX;
        }
        return panelName;
    }

    public List getAvailableMatchColumns() throws MdException, RemoteException {
        ArrayList availColumns = this.m_physicalTable != null ? new ArrayList(this.m_physicalTable.getColumns()) : new ArrayList();
        int numCols = availColumns.size();
        for (int i = numCols - 1; i >= 0; --i) {
            Column col = (Column)availColumns.get(i);
            if (!this.m_aMatchColumns.contains(col)) continue;
            availColumns.remove(i);
        }
        return availColumns;
    }

    public List getSelectedMatchColumns() throws MdException, RemoteException {
        return this.m_aMatchColumns;
    }

    public void setSelectedMatchColumns(List columns) throws MdException, RemoteException {
        this.m_aMatchColumns = columns;
    }

    public void setNoMissingCheck(boolean check) throws MdException, RemoteException {
        this.m_noMissingCheck = check;
    }

    public Index getModifyUsingIndex() throws MdException, RemoteException {
        CMetadata ind = this.m_phlRowActions.getPropertyMetadataObject(PROPERTY_NAME_MODIFY_INDEX);
        Index index = null;
        if (ind != null) {
            index = (Index)ind;
        } else {
            List indexes = this.getAvailableIndexes();
            if (!indexes.isEmpty()) {
                index = (Index)this.getAvailableIndexes().get(0);
            }
        }
        return index;
    }

    public void setModifyUsingIndex(Index index) throws MdException, RemoteException {
        this.m_modifyIndex = index;
    }

    public DefaultComboBoxModel getMatchIndexModel() throws MdException, RemoteException {
        List indexes;
        Index selIndex = this.getModifyUsingIndex();
        if (selIndex == null && !(indexes = this.getAvailableIndexes()).isEmpty()) {
            selIndex = (Index)indexes.get(0);
        }
        if (selIndex != null) {
            this.m_mdlModifyIndexes.setSelectedItem(selIndex);
        }
        return this.m_mdlModifyIndexes;
    }

    public List getAvailableIndexes() throws MdException, RemoteException {
        if (this.m_physicalTable != null) {
            return new ArrayList(this.m_physicalTable.getIndexes());
        }
        return new ArrayList();
    }

    public void setIndexUniqueValue(boolean unique) throws MdException, RemoteException {
        this.m_indexUnique = unique;
    }

    public boolean getIndexUniqueValue() throws MdException, RemoteException {
        return this.m_phlRowActions.stringToBoolean(this.m_phlRowActions.getSpecificOptionValue(PROPERTY_NAME_UNIQUE), false);
    }

    public String getReplaceType() throws MdException, RemoteException {
        String value = this.m_phlLoadStyle.getSpecificOptionValue(PROPERTY_NAME_REPLACE_TYPE);
        if ("".equals(value)) {
            value = this.DEFAULT_REPLACE_TYPE;
        }
        return value;
    }

    public void resetReplaceTypeModel() throws MdException, RemoteException {
        String currentValue = this.m_phlLoadStyle.getSpecificOptionValue(PROPERTY_NAME_REPLACE_TYPE);
        this.m_mdlReplaceType.removeAllElements();
        this.m_mdlReplaceType.addItem(REPLACE_ENTIRE_TABLE);
        if (this.isDeleteAllRowsEnabled()) {
            this.m_mdlReplaceType.addItem(REPLACE_ALL_ROWS_DELETE);
        }
        if (this.isTruncateSupported()) {
            this.m_mdlReplaceType.addItem(REPLACE_ALL_ROWS_TRUNCATE);
        }
        if (this.m_mdlReplaceType.getValueList().contains(currentValue)) {
            this.m_mdlReplaceType.setSelectedValue(currentValue);
        } else {
            this.m_mdlReplaceType.setSelectedValue(this.DEFAULT_REPLACE_TYPE);
        }
    }

    public void resetMatchingRowsModel() throws MdException, RemoteException {
        String currentValue = this.m_phlLoadStyle.getSpecificOptionValue(PROPERTY_NAME_REPLACE_TYPE);
        boolean addUsingIndex = false;
        boolean addModBy = false;
        boolean addUpsert = false;
        if (this.m_physicalTable != null) {
            addUsingIndex = this.m_physicalTableCG.getIndexSupport() && !this.getAvailableIndexes().isEmpty();
            addModBy = this.m_physicalTableCG.getRandomAccessSupport();
            addUpsert = this.m_physicalTableCG.getUpsertSupport();
        }
        this.m_mdlMatchingRows.removeAllElements();
        this.m_mdlMatchingRows.addItem(MATCHING_ROWS_SQLSET).addItem(SKIP);
        if (addModBy) {
            this.m_mdlMatchingRows.addItem(MODIFYBYCOLUMN);
        }
        if (addUsingIndex) {
            this.m_mdlMatchingRows.addItem(MODIFYUSINGINDEX);
        }
        if (addUpsert) {
            this.m_mdlMatchingRows.addItem("Upsert");
        }
        if (this.m_mdlMatchingRows.getValueList().contains(currentValue)) {
            this.m_mdlMatchingRows.setSelectedValue(currentValue);
        } else {
            this.m_mdlMatchingRows.setSelectedValue(this.DEFAULT_MATCHING_ROWS);
        }
    }

    public boolean isReplaceTypeEnabled() throws MdException, RemoteException {
        return this.m_physicalTable != null && this.m_mdlLoadStyle.getSelectedValue().equals(LOADSTYLE_REPLACE);
    }

    public String getReplaceTypeDefault() {
        return this.DEFAULT_REPLACE_TYPE;
    }

    public boolean isReplacingTable() throws MdException, RemoteException {
        return this.isReplaceTypeEnabled() && this.getReplaceType().equalsIgnoreCase(REPLACE_ENTIRE_TABLE);
    }

    public boolean isTruncateSupported() throws MdException, RemoteException {
        boolean truncate = false;
        if (this.m_physicalTableCG != null) {
            truncate = this.m_physicalTableCG.getTruncateSupport();
        }
        return truncate;
    }

    public boolean isRefreshConstraintsAvailable() throws MdException, RemoteException {
        boolean supported = false;
        if (this.m_physicalTableCG != null) {
            supported = !this.m_physicalTableCG.getConstraintTypesDroppable().equals("");
        }
        return supported;
    }

    public boolean isIndexEnabled() throws MdException, RemoteException {
        boolean index = false;
        if (this.m_physicalTableCG != null) {
            index = this.m_physicalTableCG.getIndexSupport() && !this.m_physicalTableCG.getIndexesNotInPrimaryKey().isEmpty();
        }
        return index;
    }

    public boolean isConstraintEnabled() throws MdException, RemoteException {
        boolean constraint = false;
        if (this.m_physicalTableCG != null) {
            constraint = this.m_physicalTableCG.getConstraintSupport() && this.m_physicalTableCG.hasConstraints();
        }
        return constraint;
    }

    public NameValueComboBoxModel getMatchingRowsModel() throws MdException, RemoteException {
        this.resetMatchingRowsModel();
        this.m_mdlMatchingRows.setSelectedValue(this.getMatchingRowsValue());
        return this.m_mdlMatchingRows;
    }

    public void setMatchingRowsDefault(String newDefault) {
        this.DEFAULT_MATCHING_ROWS = newDefault;
    }

    public String getMatchingRowsValue() throws MdException, RemoteException {
        String value = this.m_phlRowActions.getSpecificOptionValue(PROPERTY_NAME_MATCHING_ROWS);
        if ("".equals(value)) {
            value = this.DEFAULT_MATCHING_ROWS;
        }
        return value;
    }

    public boolean isMatchingRowsEnabled() {
        boolean match = false;
        if (this.m_physicalTable != null && this.m_mdlLoadStyle.getSelectedValue().equals(LOADSTYLE_UPDATE)) {
            match = true;
        }
        return match;
    }

    public NameValueComboBoxModel getNewRowsModel() throws MdException, RemoteException {
        this.resetNewRowsModel();
        this.m_mdlNewRows.setSelectedValue(this.getNewRowsValue());
        return this.m_mdlNewRows;
    }

    public void resetNewRowsModel() {
        String currentValue = this.m_mdlNewRows.getSelectedValue();
        this.m_mdlNewRows.removeAllElements();
        if (this.m_mdlLoadStyle.getSelectedValue().equals(LOADSTYLE_UPDATE)) {
            String selectedMatchValue = this.m_mdlMatchingRows.getSelectedValue();
            if (selectedMatchValue.equals("Upsert")) {
                this.DEFAULT_NEW_ROWS = "Upsert";
                this.m_mdlNewRows.addItem("Upsert");
            } else if (selectedMatchValue.equals(MATCHING_ROWS_SQLSET)) {
                this.DEFAULT_NEW_ROWS = NEW_ROWS_APPEND_PROC;
                this.m_mdlNewRows.addItem(NEW_ROWS_APPEND_PROC).addItem(NEW_ROWS_INSERT_SQL).addItem(SKIP);
            } else if (selectedMatchValue.equals(MODIFYBYCOLUMN)) {
                this.DEFAULT_NEW_ROWS = MODIFYBYCOLUMN;
                this.m_mdlNewRows.addItem(MODIFYBYCOLUMN).addItem(SKIP);
            } else if (selectedMatchValue.equals(MODIFYUSINGINDEX)) {
                this.DEFAULT_NEW_ROWS = MODIFYUSINGINDEX;
                this.m_mdlNewRows.addItem(MODIFYUSINGINDEX).addItem(SKIP);
            } else if (selectedMatchValue.equals(SKIP)) {
                this.DEFAULT_NEW_ROWS = NEW_ROWS_APPEND_PROC;
                this.m_mdlNewRows.addItem(NEW_ROWS_APPEND_PROC).addItem(NEW_ROWS_INSERT_SQL);
                try {
                    boolean addUsingIndex = false;
                    boolean addModBy = false;
                    if (this.m_physicalTable != null) {
                        addUsingIndex = this.m_physicalTableCG.getIndexSupport() && !this.getAvailableIndexes().isEmpty();
                        addModBy = this.m_physicalTableCG.getRandomAccessSupport();
                    }
                    if (addUsingIndex) {
                        this.m_mdlNewRows.addItem(MODIFYUSINGINDEX);
                    }
                    if (addModBy) {
                        this.m_mdlNewRows.addItem(MODIFYBYCOLUMN);
                    }
                }
                catch (MdException exc) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        if (this.m_mdlNewRows.getSize() == 0) {
            this.DEFAULT_NEW_ROWS = NEW_ROWS_APPEND_PROC;
            this.m_mdlNewRows.addItem(NEW_ROWS_APPEND_PROC).addItem(NEW_ROWS_INSERT_SQL);
        }
        if (this.m_mdlNewRows.getValueList().contains(currentValue)) {
            this.m_mdlNewRows.setSelectedValue(currentValue);
        } else {
            this.m_mdlNewRows.setSelectedValue(this.DEFAULT_NEW_ROWS);
            if (this.DEFAULT_NEW_ROWS == "Upsert" || currentValue == "Upsert") {
                this.resetIndexBeforeModel();
            }
        }
    }

    public void resetConstraintBeforeModel() {
        boolean canRefresh = false;
        boolean replacingT = false;
        boolean enabled = false;
        try {
            canRefresh = this.isRefreshConstraintsAvailable();
            replacingT = this.isReplaceTypeEnabled() && this.m_mdlReplaceType.getSelectedValue().equals(REPLACE_ENTIRE_TABLE);
            enabled = this.isConstraintEnabled();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_mdlConstraintBefore.removeAllElements();
        this.m_mdlConstraintBefore.addItem(CI_ACTION_NONE);
        if (enabled) {
            this.DEFAULT_CONSTRAINT_BEFORE = CI_ACTION_INITIAL_LOAD;
            this.m_mdlConstraintBefore.addItem(CI_ACTION_INITIAL_LOAD);
        } else {
            this.DEFAULT_CONSTRAINT_BEFORE = CI_ACTION_NONE;
        }
        if (canRefresh && !replacingT) {
            this.m_mdlConstraintBefore.addItem(CI_ACTION_OFF).addItem(CI_ACTION_ON);
        }
        this.m_mdlConstraintBefore.setSelectedValue(this.DEFAULT_CONSTRAINT_BEFORE);
        this.resetCIComboText(this.m_mdlConstraintBefore, null);
    }

    public void resetIndexBeforeModel() {
        boolean canRefresh = false;
        boolean replacingT = false;
        boolean enabled = false;
        try {
            canRefresh = this.isRefreshIndexesAvailable();
            replacingT = this.isReplaceTypeEnabled() && this.m_mdlReplaceType.getSelectedValue().equals(REPLACE_ENTIRE_TABLE);
            enabled = this.isIndexEnabled();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_mdlIndexBefore.removeAllElements();
        this.m_mdlIndexBefore.addItem(CI_ACTION_NONE);
        if (enabled) {
            this.DEFAULT_INDEX_BEFORE = CI_ACTION_INITIAL_LOAD;
            this.m_mdlIndexBefore.addItem(CI_ACTION_INITIAL_LOAD);
        } else {
            this.DEFAULT_INDEX_BEFORE = CI_ACTION_NONE;
        }
        if (canRefresh && !replacingT) {
            this.m_mdlIndexBefore.addItem(CI_ACTION_OFF).addItem(CI_ACTION_ON);
            if (this.m_mdlLoadStyle.getSelectedValue().equals(LOADSTYLE_UPDATE) && this.m_mdlMatchingRows.getSelectedValue().equals("Upsert")) {
                this.DEFAULT_INDEX_BEFORE = CI_ACTION_OFF;
            }
        }
        this.m_mdlIndexBefore.setSelectedValue(this.DEFAULT_INDEX_BEFORE);
        this.resetCIComboText(this.m_mdlIndexBefore, null);
    }

    public void resetConstraintAfterModel() {
        boolean canRefresh = false;
        boolean replacingT = false;
        try {
            canRefresh = this.isRefreshConstraintsAvailable();
            replacingT = this.isReplaceTypeEnabled() && this.m_mdlReplaceType.getSelectedValue().equals(REPLACE_ENTIRE_TABLE);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_mdlConstraintAfter.removeAllElements();
        if (this.m_mdlConstraintBefore.getSelectedValue().equals(CI_ACTION_INITIAL_LOAD)) {
            this.DEFAULT_CONSTRAINT_AFTER = CI_ACTION_NONE;
            this.m_mdlConstraintAfter.addItem(CI_ACTION_NONE);
            if (canRefresh) {
                this.m_mdlConstraintAfter.addItem(CI_ACTION_OFF);
            }
        } else if (this.m_mdlConstraintBefore.getSelectedValue().equals(CI_ACTION_OFF)) {
            this.DEFAULT_CONSTRAINT_AFTER = CI_ACTION_NONE;
            this.m_mdlConstraintAfter.addItem(CI_ACTION_NONE).addItem(CI_ACTION_ON);
        } else if (this.m_mdlConstraintBefore.getSelectedValue().equals(CI_ACTION_ON)) {
            this.DEFAULT_CONSTRAINT_AFTER = CI_ACTION_NONE;
            this.m_mdlConstraintAfter.addItem(CI_ACTION_NONE).addItem(CI_ACTION_OFF);
        } else if (this.m_mdlConstraintBefore.getSelectedValue().equals(CI_ACTION_NONE)) {
            this.DEFAULT_CONSTRAINT_AFTER = CI_ACTION_NONE;
            this.m_mdlConstraintAfter.addItem(CI_ACTION_INITIAL_LOAD).addItem(CI_ACTION_NONE);
            if (canRefresh && !replacingT) {
                this.m_mdlConstraintAfter.addItem(CI_ACTION_OFF).addItem(CI_ACTION_ON);
            }
        }
        this.m_mdlConstraintAfter.setSelectedValue(this.DEFAULT_CONSTRAINT_AFTER);
        this.resetCIComboText(this.m_mdlConstraintBefore, this.m_mdlConstraintAfter);
    }

    public void resetIndexAfterModel() {
        boolean canRefresh = false;
        boolean replacingT = false;
        try {
            replacingT = this.isReplaceTypeEnabled() && this.m_mdlReplaceType.getSelectedValue().equals(REPLACE_ENTIRE_TABLE);
            canRefresh = this.isRefreshIndexesAvailable();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_mdlIndexAfter.removeAllElements();
        if (this.m_mdlIndexBefore.getSelectedValue().equals(CI_ACTION_INITIAL_LOAD)) {
            this.DEFAULT_INDEX_AFTER = CI_ACTION_NONE;
            this.m_mdlIndexAfter.addItem(CI_ACTION_NONE);
            if (canRefresh) {
                this.m_mdlIndexAfter.addItem(CI_ACTION_OFF);
            }
        } else if (this.m_mdlIndexBefore.getSelectedValue().equals(CI_ACTION_OFF)) {
            this.DEFAULT_INDEX_AFTER = CI_ACTION_ON;
            this.m_mdlIndexAfter.addItem(CI_ACTION_NONE).addItem(CI_ACTION_ON);
        } else if (this.m_mdlIndexBefore.getSelectedValue().equals(CI_ACTION_ON)) {
            this.DEFAULT_INDEX_AFTER = CI_ACTION_NONE;
            this.m_mdlIndexAfter.addItem(CI_ACTION_NONE).addItem(CI_ACTION_OFF);
        } else if (this.m_mdlIndexBefore.getSelectedValue().equals(CI_ACTION_NONE)) {
            this.DEFAULT_INDEX_AFTER = CI_ACTION_INITIAL_LOAD;
            this.m_mdlIndexAfter.addItem(CI_ACTION_INITIAL_LOAD).addItem(CI_ACTION_NONE);
            if (canRefresh && !replacingT) {
                this.m_mdlIndexAfter.addItem(CI_ACTION_OFF).addItem(CI_ACTION_ON);
            }
        }
        this.m_mdlIndexAfter.setSelectedValue(this.DEFAULT_INDEX_AFTER);
        this.resetCIComboText(this.m_mdlIndexBefore, this.m_mdlIndexAfter);
    }

    private void resetCIComboText(NameValueComboBoxModel combo1Mdl, NameValueComboBoxModel combo2Mdl) {
        boolean isReplacingTable = false;
        try {
            isReplacingTable = this.isReplaceTypeEnabled() && this.m_mdlReplaceType.getSelectedValue().equals(REPLACE_ENTIRE_TABLE);
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        if (combo2Mdl == null) {
            for (int i = 0; i < combo1Mdl.getSize(); ++i) {
                String code = combo1Mdl.getElementValueAt(i) + "_*_" + (isReplacingTable ? "NEW" : "OLD");
                combo1Mdl.setElementNameAt(i, this.getCIComboText(code));
            }
        } else {
            for (int i = 0; i < combo2Mdl.getSize(); ++i) {
                String code = combo1Mdl.getSelectedValue() + "_" + combo2Mdl.getElementValueAt(i) + "_" + (isReplacingTable ? "NEW" : "OLD");
                combo2Mdl.setElementNameAt(i, this.getCIComboText(code));
            }
        }
    }

    private String getCIComboText(String codeToFind) {
        String value;
        HashMap<String, String> hMap = new HashMap<String, String>();
        hMap.put("INIT_*_OLD", "OnInit");
        hMap.put("INIT_*_NEW", "OnInitNewTable");
        hMap.put("OFF_*_OLD", "Off");
        hMap.put("ON_*_OLD", "OnFix");
        hMap.put("ASIS_*_OLD", "DoNothing");
        hMap.put("ASIS_*_NEW", "LeaveOff");
        hMap.put("INIT_OFF_OLD", "Off");
        hMap.put("INIT_OFF_NEW", "Off");
        hMap.put("INIT_ASIS_OLD", "LeaveOn");
        hMap.put("INIT_ASIS_NEW", "LeaveOn");
        hMap.put("OFF_ON_OLD", "On");
        hMap.put("OFF_ASIS_OLD", "LeaveOff");
        hMap.put("ON_OFF_OLD", "Off");
        hMap.put("ON_ASIS_OLD", "LeaveOn");
        hMap.put("ASIS_INIT_OLD", "OnInit");
        hMap.put("ASIS_INIT_NEW", "OnInitNewTable");
        hMap.put("ASIS_OFF_OLD", "Off");
        hMap.put("ASIS_ON_OLD", "OnFix");
        hMap.put("ASIS_ASIS_OLD", "DoNothing");
        hMap.put("ASIS_ASIS_NEW", "LeaveOff");
        if (hMap.containsKey(codeToFind)) {
            String propName = hMap.get(codeToFind).toString();
            value = bundle.getRawString("TableLoaderModel.CIComboChoices." + propName + ".txt");
            if (value == null) {
                value = "NF: " + propName;
            }
        } else {
            value = "NF:" + codeToFind;
        }
        return value;
    }

    public String getNewRowsValue() throws MdException, RemoteException {
        String value = this.m_phlRowActions.getSpecificOptionValue(PROPERTY_NAME_NEW_ROWS);
        if ("".equals(value)) {
            value = this.DEFAULT_NEW_ROWS;
        }
        return value;
    }

    public void setNewRowsDefault(String newDefault) {
        this.DEFAULT_NEW_ROWS = newDefault;
    }

    public boolean isNewRowsEnabled() {
        boolean value = false;
        if (this.m_physicalTable != null) {
            value = true;
        }
        return value;
    }

    public boolean getNoMissingCheck() throws MdException, RemoteException {
        return !"".equals(this.m_phlRowActions.getSpecificOptionValue(PROPERTY_NAME_NOMISSINGCHECK));
    }

    public boolean getUnmappedEqMissingInUpdate() throws MdException, RemoteException {
        return this.getUnmappedEqMissingInUpdate(true);
    }

    public boolean getUnmappedEqMissingInUpdate(boolean getFromStore) throws MdException, RemoteException {
        if (getFromStore) {
            return this.m_phlRowActions.stringToBoolean(this.m_phlRowActions.getSpecificOptionValue(PROPERTY_NAME_UNMAPPED_EQ_MISSING_IN_UPDATE), this.DEFAULT_UNMAPPED_EQ_MISSING);
        }
        return this.m_unmappedEqMissingInUpdate;
    }

    public void setUnmappedEqMissingInUpdate(boolean unmappedEqMissing) {
        this.m_unmappedEqMissingInUpdate = unmappedEqMissing;
    }

    public boolean getReapplyCInReplaceDS() throws MdException, RemoteException {
        return this.getReapplyCInReplaceDS(true);
    }

    public boolean getReapplyCInReplaceDS(boolean getFromStore) throws MdException, RemoteException {
        if (getFromStore) {
            return this.m_phlRowActions.stringToBoolean(this.m_phlRowActions.getSpecificOptionValue(PROPERTY_NAME_REAPPLY_C_IN_REPLACE_DS), false);
        }
        return this.m_reapplyCInReplaceTable;
    }

    public void setReapplyCInReplaceTable(boolean reapplyPreExistingConstraints) {
        this.m_reapplyCInReplaceTable = reapplyPreExistingConstraints;
    }

    public boolean isNoMissingCheckEnabled() {
        boolean match = false;
        if (this.m_physicalTable != null && this.m_mdlLoadStyle.getSelectedValue().equals(LOADSTYLE_UPDATE) && (this.m_mdlMatchingRows.getSelectedValue().equals(MATCHING_ROWS_SQLSET) || this.m_mdlMatchingRows.getSelectedValue().equals(MODIFYBYCOLUMN) || this.m_mdlMatchingRows.getSelectedValue().equals(MODIFYUSINGINDEX))) {
            match = true;
        }
        return match;
    }

    public NameValueComboBoxModel getIndexBeforeModel() throws MdException, RemoteException {
        this.resetIndexBeforeModel();
        this.m_mdlIndexBefore.setSelectedValue(this.getIndexBeforeValue());
        return this.m_mdlIndexBefore;
    }

    public NameValueComboBoxModel getConstraintBeforeModel() throws MdException, RemoteException {
        this.resetConstraintBeforeModel();
        this.m_mdlConstraintBefore.setSelectedValue(this.getConstraintBeforeValue());
        return this.m_mdlConstraintBefore;
    }

    public NameValueComboBoxModel getConstraintAfterModel() throws MdException, RemoteException {
        this.resetConstraintAfterModel();
        this.m_mdlConstraintAfter.setSelectedValue(this.getConstraintAfterValue());
        return this.m_mdlConstraintAfter;
    }

    public NameValueComboBoxModel getIndexAfterModel() throws MdException, RemoteException {
        this.resetIndexAfterModel();
        this.m_mdlIndexAfter.setSelectedValue(this.getIndexAfterValue());
        return this.m_mdlIndexAfter;
    }

    public String getIndexBeforeValue() throws MdException, RemoteException {
        String value = this.m_phlAdditionalAction.getSpecificOptionValue(PROPERTY_NAME_INDEX_BEFORE);
        if ("".equals(value)) {
            value = this.DEFAULT_INDEX_BEFORE;
        }
        return value;
    }

    public String getConstraintBeforeValue() throws MdException, RemoteException {
        String value = this.m_phlAdditionalAction.getSpecificOptionValue(PROPERTY_NAME_CONSTRAINT_BEFORE);
        if ("".equals(value)) {
            value = this.DEFAULT_CONSTRAINT_BEFORE;
        }
        return value;
    }

    public String getConstraintAfterValue() throws MdException, RemoteException {
        String value = this.m_phlAdditionalAction.getSpecificOptionValue(PROPERTY_NAME_CONSTRAINT_AFTER);
        if ("".equals(value)) {
            value = this.DEFAULT_CONSTRAINT_AFTER;
        }
        return value;
    }

    public String getIndexAfterValue() throws MdException, RemoteException {
        String value = this.m_phlAdditionalAction.getSpecificOptionValue(PROPERTY_NAME_INDEX_AFTER);
        if ("".equals(value)) {
            value = this.DEFAULT_INDEX_AFTER;
        }
        return value;
    }

    public String getCIActionsSelected(String delim, boolean useQuotes) throws MdException, RemoteException {
        String quote = "";
        if (useQuotes) {
            quote = "'";
        }
        StringBuffer code = new StringBuffer();
        code.append(quote + (this.isConstraintEnabled() ? this.getConstraintBeforeValue() : CI_ACTION_NONE));
        code.append(quote + delim + quote + (this.isConstraintEnabled() ? this.getConstraintAfterValue() : CI_ACTION_NONE));
        code.append(quote + delim + quote + (this.isIndexEnabled() ? this.getIndexBeforeValue() : CI_ACTION_NONE));
        code.append(quote + delim + quote + (this.isIndexEnabled() ? this.getIndexAfterValue() : CI_ACTION_NONE) + quote);
        return code.toString();
    }

    public boolean isSyncCIPreLoadNeeded() throws MdException, RemoteException {
        boolean isNeeded = false;
        if (this.isReplacingTable()) {
            isNeeded = false;
        } else if (this.isIndexEnabled() && this.getIndexBeforeValue().equals(CI_ACTION_ON)) {
            isNeeded = true;
        } else if (this.isConstraintEnabled() && this.getConstraintBeforeValue().equals(CI_ACTION_ON)) {
            isNeeded = true;
        }
        return isNeeded;
    }

    public boolean isSyncCIPostLoadNeeded() throws MdException, RemoteException {
        return !this.isReplacingTable() && (this.getIndexBeforeValue().equals(CI_ACTION_NONE) && this.getIndexAfterValue().equals(CI_ACTION_ON) || this.getConstraintBeforeValue().equals(CI_ACTION_NONE) && this.getConstraintAfterValue().equals(CI_ACTION_ON));
    }

    public boolean isCIPostLoadNeeded() throws MdException, RemoteException {
        return !this.getPostLoadCActionNeeded().equals("") || !this.getPostLoadIActionNeeded().equals("");
    }

    public String getPostLoadCActionNeeded() throws MdException, RemoteException {
        String cAfterActionNeeded = "";
        if (!this.isConstraintEnabled()) {
            return cAfterActionNeeded;
        }
        if (this.getConstraintBeforeValue().equals(CI_ACTION_NONE) && this.getConstraintAfterValue().equals(CI_ACTION_OFF)) {
            cAfterActionNeeded = "DROP";
        } else if (this.getConstraintBeforeValue().equals(CI_ACTION_NONE) || this.getConstraintBeforeValue().equals(CI_ACTION_OFF)) {
            if (this.getConstraintAfterValue().equals(CI_ACTION_ON) || this.getConstraintAfterValue().equals(CI_ACTION_INITIAL_LOAD)) {
                cAfterActionNeeded = "CREATE";
            }
        } else if (this.getConstraintAfterValue().equals(CI_ACTION_OFF)) {
            cAfterActionNeeded = "DROP";
        }
        return cAfterActionNeeded;
    }

    public String getPostLoadIActionNeeded() throws MdException, RemoteException {
        String iAfterActionNeeded = "";
        if (!this.isIndexEnabled()) {
            return iAfterActionNeeded;
        }
        if (this.getIndexBeforeValue().equals(CI_ACTION_NONE) && this.getIndexAfterValue().equals(CI_ACTION_OFF)) {
            iAfterActionNeeded = "DROP";
        } else if (this.getIndexBeforeValue().equals(CI_ACTION_NONE) || this.getIndexBeforeValue().equals(CI_ACTION_OFF)) {
            if (this.getIndexAfterValue().equals(CI_ACTION_ON) || this.getIndexAfterValue().equals(CI_ACTION_INITIAL_LOAD)) {
                iAfterActionNeeded = "CREATE";
            }
        } else if (this.getIndexAfterValue().equals(CI_ACTION_OFF)) {
            iAfterActionNeeded = "DROP";
        }
        return iAfterActionNeeded;
    }

    public boolean isIndexAfterInit() throws MdException, RemoteException {
        return this.getIndexAfterValue().equals(CI_ACTION_INITIAL_LOAD);
    }

    public boolean isConstraintAfterInit() throws MdException, RemoteException {
        return this.getConstraintAfterValue().equals(CI_ACTION_INITIAL_LOAD);
    }

    public void resetModelDefaults() {
        try {
            this.resetLoadStyleDefault();
            this.setReplaceDefault();
        }
        catch (MdException exc) {
            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.m_mdlLoadStyle.setSelectedValue(this.DEFAULT_LOAD_STYLE);
        this.m_mdlMatchingRows.setSelectedValue(this.DEFAULT_MATCHING_ROWS);
        this.m_mdlNewRows.setSelectedValue(this.DEFAULT_NEW_ROWS);
        this.m_mdlIndexBefore.setSelectedValue(this.DEFAULT_INDEX_BEFORE);
        this.m_mdlIndexAfter.setSelectedValue(this.DEFAULT_INDEX_AFTER);
        this.m_mdlConstraintBefore.setSelectedValue(this.DEFAULT_CONSTRAINT_BEFORE);
        this.m_mdlConstraintAfter.setSelectedValue(this.DEFAULT_CONSTRAINT_AFTER);
        this.m_mdlReplaceType.setSelectedValue(this.DEFAULT_REPLACE_TYPE);
        this.setUnmappedEqMissingInUpdate(this.DEFAULT_UNMAPPED_EQ_MISSING);
        this.setReapplyCInReplaceTable(this.DEFAULT_APPLY_C_IN_REPLACE_TABLE);
    }

    public boolean validateData() throws MdException, RemoteException {
        boolean noByColumn = this.m_aMatchColumns.isEmpty();
        if (this.m_physicalTable != null && this.m_mdlLoadStyle.getSelectedValue().equals(LOADSTYLE_UPDATE)) {
            if ((this.m_mdlNewRows.getSelectedValue().equals(MODIFYUSINGINDEX) || this.m_mdlMatchingRows.getSelectedValue().equals(MODIFYUSINGINDEX)) && this.m_mdlModifyIndexes.getSelectedItem() == null) {
                MessageUtil.displayMessage((String)bundle.getString("TableLoaderModel.NoSelectedIndex.Error.txt"), (int)0);
                return false;
            }
            if (!this.m_mdlNewRows.getSelectedValue().equals(MODIFYUSINGINDEX) && !this.m_mdlMatchingRows.getSelectedValue().equals(MODIFYUSINGINDEX)) {
                if (noByColumn) {
                    MessageUtil.displayMessage((String)bundle.getString("TableLoaderModel.NoSelectedColumns.Error.txt"), (int)0);
                    return false;
                }
                if (this.m_physicalTableCG != null && !(this.m_physicalTableCG instanceof SAS) && (this.m_mdlNewRows.getSelectedValue().equals(MODIFYBYCOLUMN) || this.m_mdlMatchingRows.getSelectedValue().equals(MODIFYBYCOLUMN))) {
                    SASLibrary lib = CodeGenUtil.getLibrary((DataTable)this.m_physicalTable);
                    if (lib != null) {
                        if (lib.getIsPreassigned() == 1) {
                            MessageUtil.displayMessage((String)bundle.getString("TableLoaderModel.PreassignedDBMSLibraryReread.Warning.txt"), (int)2);
                        } else {
                            MessageUtil.displayMessage((String)bundle.getString("TableLoaderModel.DBMSLibraryReread.Warning.txt"), (int)2);
                        }
                    }
                } else if (this.m_mdlMatchingRows.getSelectedValue().equals(MATCHING_ROWS_SQLSET) && this.getAvailableMatchColumns().isEmpty()) {
                    MessageUtil.displayMessage((String)bundle.getString("TableLoaderModel.NoSetColumns.Error.txt"), (int)0);
                    return false;
                }
            }
        }
        return true;
    }

    public class NameValueComboBoxModel
    extends DefaultComboBoxModel {
        private String m_bundleKey;
        private boolean m_bSorted = false;

        public NameValueComboBoxModel(String bundleKey, boolean sorted) {
            this.m_bundleKey = bundleKey;
            this.m_bSorted = sorted;
        }

        public NameValueComboBoxModel addItem(String value) {
            String name = bundle.getRawString(this.m_bundleKey + "." + value + ".txt");
            if (name == null) {
                name = "";
            }
            NameValueObject object = new NameValueObject(value, name);
            if (this.m_bSorted) {
                int x;
                int iElement;
                String sObject = object.toString();
                int nElements = this.getSize();
                for (iElement = 0; iElement < nElements && (x = sObject.compareToIgnoreCase(this.getElementAt(iElement).toString())) >= 0; ++iElement) {
                }
                super.insertElementAt(object, iElement);
            } else {
                super.addElement(object);
            }
            return this;
        }

        public NameValueComboBoxModel removeItem(String value) {
            String name = bundle.getRawString(this.m_bundleKey + "." + value + ".txt");
            if (name == null) {
                name = "";
            }
            for (int i = 0; i < this.getSize(); ++i) {
                NameValueObject objInd = (NameValueObject)this.getElementAt(i);
                if (!objInd.getValue().equals(value)) continue;
                this.removeElementAt(i);
            }
            return this;
        }

        public String getSelectedValue() {
            if (this.getSelectedItem() instanceof NameValueObject) {
                return ((NameValueObject)this.getSelectedItem()).getValue();
            }
            if (this.getSelectedItem() != null) {
                return this.getSelectedItem().toString();
            }
            return "";
        }

        public void setSelectedValue(String value) {
            String strValue = value;
            for (int i = 0; i < this.getSize(); ++i) {
                NameValueObject n = (NameValueObject)this.getElementAt(i);
                if (!strValue.equals(n.getValue())) continue;
                super.setSelectedItem(n);
                return;
            }
        }

        public void setElementNameAt(int i, String name) {
            NameValueObject n = (NameValueObject)this.getElementAt(i);
            n.m_name = name;
        }

        public String getElementValueAt(int i) {
            NameValueObject n = (NameValueObject)this.getElementAt(i);
            return n.m_value;
        }

        public List getValueList() {
            ArrayList<String> valueList = new ArrayList<String>();
            for (int i = 0; i < this.getSize(); ++i) {
                valueList.add(((NameValueObject)this.getElementAt(i)).getValue());
            }
            return valueList;
        }

        public String getBundleKey() {
            return this.m_bundleKey;
        }

        public void setBundleKey(String key) {
            this.m_bundleKey = key;
        }

        private class NameValueObject {
            private String m_name;
            private String m_value;

            public NameValueObject(String value, String name) {
                this.m_name = name;
                this.m_value = value;
            }

            public String toString() {
                return this.m_name;
            }

            public String getName() {
                return this.m_name;
            }

            public String getValue() {
                return this.m_value;
            }
        }
    }
}

