/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ColumnCG;
import com.sas.codegen.DBMSSTORE;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.UniqueKey;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class TERADATA
extends DBMSSTORE {
    private static WAdminResource bundle = WAdminResource.getBundle(TERADATA.class);
    private static final String UPSERT_CMD = "multiload=yes upsert=yes";

    public TERADATA() {
        this.setAddOneKeyPerExecute(true);
        this.setUpsertSupport(true);
    }

    @Override
    public void dropSingleIndex(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq, true, true);
        boolean quoting = cgReq.getQuoting();
        if (quoting) {
            cgReq.addSourceCode("drop index \"%trim(%bquote(&etls_indexName))\"");
        } else {
            cgReq.addSourceCode("drop index &etls_indexName");
        }
        cgReq.addSourceCode(" on " + tableName + " \n");
    }

    @Override
    public List getIndexesToCreate() throws MdException, RemoteException {
        List indexList = this.getIndexesNotInUniqKeys();
        this.removeIndexMatchingCol1(indexList);
        return indexList;
    }

    public void removeIndexMatchingCol1(List indexList) throws MdException, RemoteException {
        Column col1 = (Column)this.m_table.getColumns().get(0);
        for (int i = indexList.size() - 1; i >= 0; --i) {
            Index index = (Index)indexList.get(i);
            if (index.getColumns().size() != 1) continue;
            Column indexCol = (Column)index.getColumns().get(0);
            if (!col1.getFQID().equals(indexCol.getFQID())) continue;
            indexList.remove(i);
        }
    }

    @Override
    public List getUniqueKeysToCreate() throws MdException, RemoteException {
        AssociationList keyList = this.m_table.getUniqueKeys();
        this.removeUniqueKeyMatchingCol1((List)keyList);
        return keyList;
    }

    public void removeUniqueKeyMatchingCol1(List keyList) throws MdException, RemoteException {
        Column col1 = (Column)this.m_table.getColumns().get(0);
        for (int i = keyList.size() - 1; i >= 0; --i) {
            UniqueKey thisKey = (UniqueKey)keyList.get(i);
            if (thisKey.getKeyedColumns().size() != 1) continue;
            Column keyCol1 = (Column)thisKey.getKeyedColumns().get(0);
            if (!col1.getFQID().equals(keyCol1.getFQID())) continue;
            keyList.remove(i);
        }
    }

    @Override
    public void genSingleIndex(CodegenRequest cgReq, Index index) throws MdException, RemoteException {
        String pre_opts = this.getPreIndexOptions(index);
        String tableName = this.getDataLocation(cgReq, true, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        String idxname = this.getIndexName(cgReq, index);
        if (idxname == null || idxname.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.IndexNameUndefined.msg.txt"));
        }
        AssociationList cols = index.getColumns();
        int cols_length = cols.size();
        if (cols_length > 0) {
            cgReq.addSourceCode("create " + pre_opts + "\n").indent().addSourceCode("index " + idxname + "\n");
            cgReq.indent().addSourceCode("(");
            for (int i = 0; i < cols_length; ++i) {
                Column col = (Column)cols.elementAt(i);
                String colName = this.getIndexColumnName(cgReq, col);
                if (i > 0) {
                    cgReq.addSourceCode(", \n ");
                }
                cgReq.addSourceCode(colName);
            }
        } else {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoColumnsDefined.msg.txt"));
        }
        cgReq.addSourceCode(")\n").unIndent();
        cgReq.unIndent().addSourceCode("on " + tableName + "\n");
    }

    @Override
    public void queryIndexes(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = TERADATA.getTableName(this.getDataLocation(cgReq, false, false));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.indent().addSourceCode("from connection to " + this.getNickname() + "\n").addSourceCode("( \n").indent().addSourceCode("select distinct IndexName as idxname, \n").addSourceCode("       TableName as tabname \n").indent().addSourceCode("from DBC.IndicesX\n").indent();
        tableName = tableName.replaceAll("'", "''");
        cgReq.addSourceCode("where TableName eq '" + tableName + "' and \n").addSourceCode("      IndexName ne ' '\n").unIndent().unIndent().unIndent().addSourceCode(");\n").unIndent();
    }

    @Override
    public void genDeleteAll(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq, true, true);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.addSourceCode("delete from " + tableName + " ALL\n");
    }

    @Override
    public void genDeleteAll2(CodegenRequest cgReq) throws MdException, RemoteException {
        this.genDeleteAll(cgReq);
    }

    @Override
    public void genExecuteCommit(CodegenRequest cgReq, String prefix) {
        cgReq.addSourceCode("execute (commit) by " + this.getNickname() + "; \n");
    }

    @Override
    public void loadWithUpsert(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = this.getDataLocation(cgReq);
        StringBuffer gen_opts = this.getDSOptions(false);
        AssociationList columnList = this.m_table.getColumns();
        boolean allowUpdates = !this.m_TLM.getMatchingRowsValue().equals("Skip");
        boolean allowNew = !this.m_TLM.getNewRowsValue().equals("Skip");
        List matchColList = this.m_TLM.getSelectedMatchColumns();
        String matchColStr = cgReq.makeColumnList(matchColList, false, "   ", false, ",", "");
        String colsToKeepStr = "";
        List listUnmapped = AutoExtract.getTargetColsNotMapped(false);
        if (!this.m_TLM.getUnmappedEqMissingInUpdate() && listUnmapped.size() > 0) {
            ArrayList<String> colsToKeep = new ArrayList<String>();
            for (int i = 0; i < columnList.size(); ++i) {
                Column col = (Column)columnList.get(i);
                ColumnCG colCG = (ColumnCG)CodeGenUtil.getCodeGenClass((CMetadata)col);
                String columnName = colCG.getColumnName(cgReq, false);
                if (listUnmapped.indexOf(columnName) >= 0) continue;
                colsToKeep.add(col.getSASColumnName());
            }
            if (colsToKeep.size() > 0) {
                colsToKeepStr = "keep = " + cgReq.makeColumnList(colsToKeep, "     ");
            }
        }
        String optionIndent = "            ";
        cgReq.addCommentLine(bundle.getString("DBMSSTORE.UpsertRequirements.msg.notrans")).addSourceCode("proc append base = " + tableName + " ( \n").addSourceCode(optionIndent + UPSERT_CMD + "\n").addSourceCode(optionIndent + "upsert_where=(").addSourceCode(matchColStr + ")\n");
        if (!colsToKeepStr.equals("")) {
            cgReq.addSourceCode(optionIndent + colsToKeepStr + "\n");
        }
        cgReq.addSourceCode(optionIndent + gen_opts.toString() + ") \n").addSourceCode(optionIndent + "data = &etls_lastTable (");
        if (!colsToKeepStr.equals("")) {
            cgReq.addSourceCode("\n" + optionIndent + colsToKeepStr + "\n" + optionIndent);
        }
        cgReq.addSourceCode("&SYSOPT) force; \n").addSourceCode("run;\n\n");
        if (allowNew) {
            // empty if block
        }
        if (allowUpdates) {
            // empty if block
        }
        cgReq.genRCSetCall("&syserr");
        this.genCodeConditionCheck(cgReq, "Condition4");
    }

    @Override
    public boolean getTruncateSupport() throws MdException, RemoteException {
        return false;
    }
}

