/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DataTableCG;
import com.sas.codegen.RowSelectorCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.RowSelector;
import com.sas.metadata.remote.TransformationStep;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class Splitter {
    private static final String TEMP_MAPPED_NAME = "work.etls_mapped";

    private Splitter() {
    }

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        int i;
        cgReq.checkSourceAndTarget(classifierMap);
        cgReq.checkTargetsForExternalTable(classifierMap);
        cgReq.checkSourcesForExternalTable(classifierMap);
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        ArrayList<String> subsetIfs = new ArrayList<String>();
        DataTableCG sourceTableCG = cgReq.getSourceTableCG(classifierMap);
        String dsOptions = sourceTableCG.getSourceTableOptions(true).trim();
        AssociationList mySteps = classifierMap.getSteps(false);
        TransformationStep splitStep = (TransformationStep)mySteps.get(0);
        AssociationList maps = splitStep.getTransformations();
        int numMaps = maps.size();
        ArrayList<String> targetTableNames = new ArrayList<String>(numMaps);
        ArrayList<ClassifierMap> classifierMaps = new ArrayList<ClassifierMap>(numMaps);
        ArrayList targetTables = new ArrayList();
        for (i = 0; i < numMaps; ++i) {
            ClassifierMap cm = (ClassifierMap)maps.get(i);
            DataTableCG targetTableCG = cgReq.getTargetTableCG(cm);
            targetTableNames.add(targetTableCG.getDataLocation(cgReq));
            classifierMaps.add(cm);
            targetTables.addAll(cm.getClassifierTargets());
        }
        cgReq.genTableDelete(targetTables);
        for (i = 0; i < numMaps; ++i) {
            if (i == 0) {
                cgReq.addSourceCode("data ").addSourceCode((String)targetTableNames.get(i));
            } else {
                cgReq.addSourceCode("\n").addSourceCode("     ").addSourceCode((String)targetTableNames.get(i));
            }
            ClassifierMap map = (ClassifierMap)maps.get(i);
            boolean tableHasFilter = false;
            RowSelector oRowSel = map.getAssociatedRowSelector();
            if (oRowSel != null) {
                String expression;
                RowSelectorCG oRowSelCG = (RowSelectorCG)CodeGenUtil.getCodeGenClass((CMetadata)oRowSel);
                String rslType = oRowSel.getRowsSelected().toUpperCase();
                if (!rslType.startsWith("All Rows".toUpperCase()) && (expression = oRowSelCG.getExpression(cgReq)).length() > 0) {
                    tableHasFilter = true;
                    subsetIfs.add(expression);
                    if (rslType.startsWith("Row Selection Conditions".toUpperCase())) {
                        expression = " then \n" + cgReq.getDefaultIndent() + "output " + (String)targetTableNames.get(i) + ";\n";
                        subsetIfs.add(expression);
                    } else {
                        subsetIfs.add("\n");
                    }
                }
            }
            if (!tableHasFilter) {
                subsetIfs.add("output " + (String)targetTableNames.get(i) + ";\n");
            }
            if (cgReq.onContextList(map.getFQID())) continue;
            cgReq.addContextList(map.getFQID());
        }
        cgReq.addSourceCode(";\n").indent().addSourceCode("set &SYSLAST");
        if (dsOptions.length() > 0) {
            cgReq.addSourceCode(" " + dsOptions);
        }
        cgReq.addSourceCode(";\n");
        for (int j = 0; j < subsetIfs.size(); ++j) {
            cgReq.addSourceCode((String)subsetIfs.get(j));
        }
        cgReq.unIndent().addSourceCode("run;\n\n").genRCSetCall("&syserr");
        for (i = 0; i < targetTableNames.size(); ++i) {
            boolean isMapGenerated = AutoExtract.columnMapping(TEMP_MAPPED_NAME, (ClassifierMap)classifierMaps.get(i), cgReq, (String)targetTableNames.get(i), "");
            if (!isMapGenerated) continue;
            cgReq.addSourceCode("data ").addSourceCode((String)targetTableNames.get(i)).addSourceCode("; \n").indent().addSourceCode("set ").addSourceCode(TEMP_MAPPED_NAME).addSourceCode("; \n").unIndent().addSourceCode("run; \n\n").genTableDelete(TEMP_MAPPED_NAME);
        }
    }
}

