/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DBMSSTORE;
import com.sas.codegen.IndexCG;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Index;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASLibrary;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class SYBASE
extends DBMSSTORE {
    private static WAdminResource bundle = WAdminResource.getBundle(SYBASE.class);
    private static final String QUOTED_OPTION = "QUOTED_IDENTIFIER";

    public SYBASE() {
        this.setClusterWord("CLUSTERED");
    }

    @Override
    public void queryIndexes(CodegenRequest cgReq) throws MdException, RemoteException {
        String user;
        String tableName = this.getDataLocation(cgReq, this.m_passthru, false);
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        if (tableName.indexOf(46) > 0) {
            user = "\"" + tableName.substring(0, tableName.indexOf(46)) + "\"";
            tableName = SYBASE.getTableName(tableName);
        } else {
            user = "";
        }
        cgReq.indent().addSourceCode("from \n").addSourceCode("( \n").indent().addSourceCode("select distinct compress ('\"' || table_name || '\".' || index_name) as idxname, \n").addSourceCode("       table_name as tabname, \n").addSourceCode("       translate(substr(left(reverse(index_name)),1,10),'9999999999','1234567890') as systemAdded \n").indent().addSourceCode("from connection to " + this.getNickname() + "\n").indent().addSourceCode("(DBMS::Indexes (\"\", \"" + user.trim() + "\", \"" + tableName.trim() + "\"))\n").unIndent().unIndent().unIndent().addSourceCode(" ) having systemAdded ne '9999999999';\n").unIndent();
    }

    @Override
    public void dropSingleIndex(CodegenRequest cgReq) throws MdException, RemoteException {
        cgReq.addSourceCode("drop index %bquote(&etls_indexName) \n");
    }

    @Override
    public String getIndexName(CodegenRequest cgReq, Index index) throws MdException, RemoteException {
        IndexCG indexCG = (IndexCG)CodeGenUtil.getCodeGenClass((CMetadata)index);
        String indexName = indexCG.getIndexName(cgReq, true);
        if (indexName == null || indexName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.IndexNameUndefined.msg.txt"));
        }
        if (indexName.startsWith("'")) {
            indexName = indexName.replaceAll("'", "\"");
        }
        return indexName;
    }

    @Override
    public void genDeleteAll(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = SYBASE.getTableName(this.getDataLocation(cgReq, true, true));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.addSourceCode("truncate table " + tableName + "\n");
    }

    @Override
    public void genDeleteAll2(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = SYBASE.getTableName(this.getDataLocation(cgReq, true, true));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.addSourceCode("delete from " + tableName + "\n");
    }

    @Override
    public void genTruncate(CodegenRequest cgReq) throws MdException, RemoteException {
        String tableName = SYBASE.getTableName(this.getDataLocation(cgReq, true, true));
        if (tableName == null || tableName.length() == 0) {
            throw new CodegenException(bundle.getString("DBMSSTORE.NoTableReference.msg.txt"));
        }
        cgReq.addSourceCode("truncate table " + tableName + "\n");
    }

    @Override
    public boolean getTruncateSupport() throws MdException, RemoteException {
        return true;
    }

    @Override
    public String getSQLInsertOptions() {
        return "undo_policy = none";
    }

    @Override
    public String getAdditionalConnectionOptions(SASLibrary iMeta, String stdConnectOptions) {
        AssociationList lProps;
        String retString = "";
        if (stdConnectOptions.toUpperCase().indexOf(QUOTED_OPTION) > -1) {
            return retString;
        }
        try {
            lProps = iMeta.getProperties();
        }
        catch (Exception e) {
            return "";
        }
        for (int i = 0; i < lProps.size(); ++i) {
            String option = "";
            String optValue = "";
            Property iProp = (Property)lProps.get(i);
            try {
                if (iProp.getUseValueOnly() != 0 || (optValue = iProp.getDefaultValue()) == null || optValue.length() == 0 || !(option = iProp.getPropertyName()).equalsIgnoreCase(QUOTED_OPTION) || !"YES".equalsIgnoreCase(optValue)) continue;
                retString = " " + option + iProp.getDelimiter() + optValue;
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return retString;
    }
}

