/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.SyncStep;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class ReturnCodeCheck {
    private static WAdminResource bundle = WAdminResource.getBundle(ReturnCodeCheck.class);

    public static void executeUtility(CodegenRequest cgReq, SyncStep step) throws MdException, RemoteException {
        AssociationList alTriggeredEvents = step.getTriggeredEvents();
        if (alTriggeredEvents.size() <= 0) {
            return;
        }
        cgReq.genSystemOptions((AbstractTransformation)step);
        cgReq.addSourceCode("%macro etls_rcCheck; \n\n").indent();
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event oEvent = (Event)alTriggeredEvents.get(iEvent);
            String sEventCondition = oEvent.getCondition().trim();
            cgReq.addSourceCode(sEventCondition).addSourceCode("\n").addSourceCode("%do;").indent();
            if (oEvent.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("ReturnCodeCheck.NoPropertySets.msg.txt"));
            }
            PropertySet oTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(oEvent, true);
            AssociationList lTrueProperties = oTruePropertySet.getSetProperties();
            Property oAbortProperty = null;
            for (int iAction = 0; iAction < lTrueProperties.size(); ++iAction) {
                Property oAction = (Property)lTrueProperties.get(iAction);
                if (oAction.getDefaultValue().equals("Abort")) {
                    oAbortProperty = oAction;
                    continue;
                }
                cgReq.addSourceCode("\n").addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (AbstractTransformation)step));
            }
            if (oAbortProperty != null) {
                cgReq.addSourceCode("\n").addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAbortProperty, (AbstractTransformation)step));
            }
            cgReq.unIndent().addSourceCode("%end; \n");
        }
        cgReq.addSourceCode("\n").unIndent().addSourceCode("%mend etls_rcCheck; \n").addSourceCode("%etls_rcCheck; \n\n");
    }
}

