/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeConditionOptionsUtil;
import com.sas.codegen.CodeGenInterface;
import com.sas.codegen.CodeGenRoot;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.GetMetadataUtil;
import com.sas.codegen.TransformationActivityCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.OptionsPropertyHandler;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class JobCG
extends CodeGenRoot
implements CodeGenInterface {
    private static WAdminResource bundle = WAdminResource.getBundle(JobCG.class);
    private static final String MACROS = "MACROS";
    private static final String JOB_STATUS = "Job Status";
    private static final String PARALLEL_OPTION = "PARALLEL";
    private static final String PARALLEL_NESTING_OPTION = "PARALLEL_NESTING";
    private static final String PIPING_OPTION = "PIPING";
    private static final String MAXIMUM = "MAXIMUM";
    private static final int MAXIMUM_INT = -1;
    private static final String STATUSHANDLINGLAST = "STATUSHANDLINGLAST";

    @Override
    public void codeGen(CodegenRequest cgReq) throws MdException, RemoteException {
        Job job = (Job)this.getMetadataClass();
        if (cgReq.onContextList(job.getFQID())) {
            return;
        }
        cgReq.addContextList(job.getFQID());
        cgReq.setCurrentJob(job);
        cgReq.setCurrentTransformation((AbstractTransformation)job);
        if (job.getJobActivities(false).getState() == 0) {
            GetMetadataUtil.getJobMetadata(job);
        }
        this.codeGenSelfOnly(cgReq);
        cgReq.endCurrentJob();
    }

    public static TransformationStep[] getStepOrder(Job job) throws RemoteException, MdException {
        TransformationStep[] steps = new TransformationStep[]{};
        ArrayList<String> complexAttr = new ArrayList<String>();
        complexAttr.add("JobActivities");
        String template = "<TEMPLATES><TransformationActivity><Steps/></TransformationActivity><TransformationStep TransformRole=\"\"><SuccessorDependencies/><Transformations/><PredecessorDependencies/></TransformationStep><SyncStep TransformRole=\"\"><SuccessorDependencies/><Transformations/><PredecessorDependencies/></SyncStep><StepPrecedence><Predecessors/></StepPrecedence></TEMPLATES>";
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)job, null, complexAttr, template, 524316);
        AssociationList acts = job.getJobActivities();
        if (!acts.isEmpty()) {
            TransformationActivityCG transCG = new TransformationActivityCG();
            List nodes = transCG.buildDTree((TransformationActivity)acts.get(0));
            steps = new TransformationStep[nodes.size()];
            for (int i = 0; i < nodes.size(); ++i) {
                steps[i] = ((TransformationActivityCG.DTreeNode)nodes.get(i)).getStep();
            }
        }
        return steps;
    }

    @Override
    public void codeGenSelfOnly(CodegenRequest cgReq) throws MdException, RemoteException {
        Job job = (Job)this.getMetadataClass();
        cgReq.addJobComment(job);
        if (job.getIsActive() <= 0) {
            return;
        }
        this.genJobMacros(cgReq, job);
        cgReq.genParameterDefaultValueCode((Root)job);
        this.doMacroVariablesSetup(cgReq, job);
        this.doJobStatusSetup(cgReq, job);
        this.setupProcessStats(cgReq);
        this.doReturnCodeSetup(cgReq);
        if (cgReq.isGeneratingDebugSetting()) {
            cgReq.addSourceCode("\n%global etls_debug; \n").addSourceCode("%macro etls_setDebug; \n").indent().addSourceCode("%if %str(&etls_debug) ne 0 %then \n").indent().addSourceCode("OPTIONS MPRINT%str(;); \n").unIndent().unIndent().addSourceCode("%mend; \n").addSourceCode("%etls_setDebug; \n\n");
        }
        this.doProcess(cgReq, job, "PreProcess");
        this.setupParallelProcessing(cgReq);
        cgReq.genSystemOptions((AbstractTransformation)job);
        if (job.getIsUserDefined() > 0) {
            cgReq.genUWC((AbstractTransformation)job);
        } else {
            for (int i = 0; i < job.getJobActivities().size(); ++i) {
                TransformationActivity activity = (TransformationActivity)job.getJobActivities().get(i);
                CodeGenInterface activityCG = CodeGenUtil.getCodeGenClass((CMetadata)activity);
                activityCG.codeGen(cgReq);
            }
        }
        cgReq.setCurrentTransformation((AbstractTransformation)job);
        OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)job);
        boolean genStatusHandlingLast = OP.stringToBoolean(OP.getSpecificOptionValue(STATUSHANDLINGLAST), false);
        if (genStatusHandlingLast) {
            this.doProcess(cgReq, job, "PostProcess");
            this.doCodeConditionCheck(cgReq, job);
        } else {
            this.doCodeConditionCheck(cgReq, job);
            this.doProcess(cgReq, job, "PostProcess");
        }
        this.createProcessStats(cgReq);
    }

    protected void genJobMacros(CodegenRequest cgReq, Job job) {
        try {
            String jobName = cgReq.getEscapedMacroValue(job.getName());
            cgReq.addCommentLine(bundle.getString("JobCG.GeneralMacroVariables.comment.txt")).addSourceCode("%let jobID = %quote(").addSourceCode(job.getFQID()).addSourceCode(");\n").addSourceCode("%let etls_jobName = %nrquote(" + jobName + ");\n").addSourceCode("%let etls_userID = %nrquote(" + Workspace.getWorkspace().getUsername() + ");\n\n");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void doProcess(CodegenRequest cgReq, Job job, String type) throws MdException, RemoteException {
        AssociationList transList;
        if (type.equals("PreProcess")) {
            transList = job.getTransformationSources();
        } else if (type.equals("PostProcess")) {
            transList = job.getTransformationTargets();
        } else {
            return;
        }
        for (int i = 0; i < transList.size(); ++i) {
            Transformation step;
            Root root = (Root)transList.get(i);
            if (!(root instanceof Transformation) || !(step = (Transformation)root).getTransformRole().equals(type)) continue;
            if (step.getIsActive() != 1) break;
            cgReq.genUWC((AbstractTransformation)step);
            break;
        }
    }

    private void doMacroVariablesSetup(CodegenRequest cgReq, Job job) throws MdException, RemoteException {
        OptionsPropertyHandler oph = new OptionsPropertyHandler((Root)job);
        boolean bEnableMacroVariables = oph.stringToBoolean(oph.getSpecificOptionValue(MACROS), false);
        if (bEnableMacroVariables) {
            ServerContext appServer = cgReq.getCurrentServer();
            SASCodeGeneration sasCode = cgReq.getSASCodeGeneration();
            StringBuffer code = sasCode.getMetadataMacrosAndOptions((CMetadata)job, appServer, false);
            cgReq.addSourceCode(code.toString());
            cgReq.setGlobalData("Macro Variables", "Y");
        }
    }

    protected void doReturnCodeSetup(CodegenRequest cgReq) {
        cgReq.genReturnCodeSetup();
    }

    protected void doJobStatusSetup(CodegenRequest cgReq, Job job) throws MdException, RemoteException {
        AssociationList alTriggeredEvents = job.getTriggeredEvents();
        if (alTriggeredEvents.size() <= 0) {
            return;
        }
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event lEvent = (Event)alTriggeredEvents.get(iEvent);
            if (!lEvent.getEventRole().equals("Condition12")) continue;
            String dateFormat = cgReq.isJobDateFormatNLS((AbstractTransformation)job) ? "nldatm." : "datetime.";
            cgReq.addCommentLine(bundle.getString("JobCG.JobStatusSetup.msg.txt")).addSourceCode("%let etls_startTime = %sysfunc(datetime(),").addSourceCode(dateFormat).addSourceCode(");\n").addSourceCode("%let etls_recordsBefore = 0;\n").addSourceCode("%let etls_recordsAfter = 0;\n").addSourceCode("%let etls_lib = 0;\n").addSourceCode("%let etls_table = 0;\n\n");
            cgReq.setJobStatus(job);
            break;
        }
    }

    protected void doCodeConditionCheck(CodegenRequest cgReq, Job job) throws MdException, RemoteException {
        AssociationList alTriggeredEvents;
        if (cgReq.getJobStatus()) {
            String dateFormat = cgReq.isJobDateFormatNLS((AbstractTransformation)job) ? "nldatm." : "datetime.";
            cgReq.addSourceCode("%let etls_endTime = %sysfunc(datetime(),").addSourceCode(dateFormat).addSourceCode(");\n\n");
        }
        if ((alTriggeredEvents = job.getTriggeredEvents()).size() <= 0) {
            return;
        }
        for (int iEvent = 0; iEvent < alTriggeredEvents.size(); ++iEvent) {
            Event oEvent = (Event)alTriggeredEvents.get(iEvent);
            if (oEvent.getPropertySets().size() <= 0) {
                throw new CodegenException(bundle.getString("ReturnCodeCheck.NoPropertySets.msg.txt"));
            }
            if (!oEvent.getName().equals(JOB_STATUS)) {
                cgReq.addCommentLine(bundle.getString("JobCG.JobReturnCodeCheck.msg.txt")).addSourceCode("%macro etls_jobRCChk; \n").indent();
                String lEventCondition = oEvent.getCondition().trim();
                cgReq.addSourceCode(lEventCondition).addSourceCode("\n").addSourceCode("%do; \n").indent();
                PropertySet oTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(oEvent, true);
                AssociationList alTrueProperties = oTruePropertySet.getSetProperties();
                for (int iAction = 0; iAction < alTrueProperties.size(); ++iAction) {
                    Property oAction = (Property)alTrueProperties.get(iAction);
                    cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (AbstractTransformation)job));
                }
                cgReq.unIndent().addSourceCode("%end; \n").unIndent().addSourceCode("%mend etls_jobRCChk; \n").addSourceCode("%etls_jobRCChk; \n\n");
                continue;
            }
            cgReq.addSectionComment(bundle.getString("JobCG.JobStatusCode.msg.txt"));
            PropertySet oTruePropertySet = CodeConditionOptionsUtil.getActionsPropertySet(oEvent, true);
            AssociationList alTrueProperties = oTruePropertySet.getSetProperties();
            for (int iAction = 0; iAction < alTrueProperties.size(); ++iAction) {
                Property oAction = (Property)alTrueProperties.get(iAction);
                cgReq.addSourceCode(CodeConditionOptionsUtil.getActionMacroCall(oAction, (AbstractTransformation)job));
            }
        }
    }

    private void setupParallelProcessing(CodegenRequest cgReq) throws MdException, RemoteException {
        int parallelNestLevels;
        Job job = (Job)this.getMetadataClass();
        OptionsPropertyHandler OP = new OptionsPropertyHandler((Root)job);
        boolean parallelOn = OP.stringToBoolean(OP.getSpecificOptionValue(PARALLEL_OPTION), false);
        boolean pipingOn = OP.stringToBoolean(OP.getSpecificOptionValue(PIPING_OPTION), false);
        String parallelNesting = OP.getSpecificOptionValue(PARALLEL_NESTING_OPTION);
        if (parallelNesting.equalsIgnoreCase(MAXIMUM)) {
            parallelNestLevels = -1;
        } else {
            try {
                parallelNestLevels = Integer.valueOf(parallelNesting);
            }
            catch (NumberFormatException e) {
                parallelNestLevels = -1;
            }
        }
        cgReq.setParallel(parallelOn);
        cgReq.setPiping(pipingOn);
        cgReq.setParallelNestLevels(parallelNestLevels);
        if (parallelOn) {
            cgReq.genParallelMacros(cgReq.getCurrentServer(), true);
        }
    }

    protected void setupProcessStats(CodegenRequest cgReq) throws MdException, RemoteException {
        Job job = (Job)this.getMetadataClass();
        AssociationList triggeredEvents = job.getTriggeredEvents();
        if (triggeredEvents.size() <= 0) {
            return;
        }
        for (int i = 0; i < triggeredEvents.size(); ++i) {
            Event event = (Event)triggeredEvents.get(i);
            if (!event.getEventRole().equals("Condition13")) continue;
            if (!cgReq.getJobStatus()) {
                String dateFormat = cgReq.isJobDateFormatNLS((AbstractTransformation)job) ? "nldatm." : "datetime.";
                cgReq.addCommentLine(bundle.getString("JobCG.ProcessStatsSetup.msg.txt")).addSourceCode("%let etls_startTime = %sysfunc(datetime(), ").addSourceCode(dateFormat).addSourceCode("); \n\n");
            }
            cgReq.setGlobalData("Process Stats", "Y");
            break;
        }
    }

    protected void createProcessStats(CodegenRequest cgReq) throws MdException, RemoteException {
        String processStats = cgReq.getGlobalData("Process Stats");
        if (!processStats.equals("Y")) {
            return;
        }
        cgReq.incrementProcessNumber();
        Job job = (Job)this.getMetadataClass();
        String endTime = !cgReq.getJobStatus() ? "datetime()" : "\"&etls_endTime\"dt";
        cgReq.genCreateProcessStatTable(job, null, "\"&etls_startTime\"dt", endTime, "&job_rc");
        cgReq.addSectionComment(bundle.getString("JobCG.ProcessStats.CreateTable.comment.txt")).addSourceCode("data ").addSourceCode("work").addSourceCode(".etls_ProcessStats; \n\n").indent().addSourceCode("attrib jobTime length=8 format=datetime19.2 informat=datetime. label=\"" + bundle.getString("JobCG.ProcessStats.JobTime.Label.txt") + "\"; \n").addSourceCode("attrib job length=$60 label=\"" + bundle.getString("JobCG.ProcessStats.Job.Label.txt") + "\"; \n").addSourceCode("attrib jobID length=$17 label=\"" + bundle.getString("JobCG.ProcessStats.JobID.Label.txt") + "\"; \n").addSourceCode("attrib task length=$8 label=\"" + bundle.getString("JobCG.ProcessStats.ParallelTask.Label.txt") + "\"; \n").addSourceCode("attrib step length=$60 label=\"" + bundle.getString("JobCG.ProcessStats.Step.Label.txt") + "\"; \n").addSourceCode("attrib stepID length=$16 label=\"" + bundle.getString("JobCG.ProcessStats.StepID.Label.txt") + "\"; \n").addSourceCode("attrib stepType length=$20 label=\"" + bundle.getString("JobCG.ProcessStats.StepType.Label.txt") + "\"; \n").addSourceCode("attrib recordType length=$8 label=\"" + bundle.getString("JobCG.ProcessStats.TypeOfRecord.Label.txt") + "\"; \n").addSourceCode("attrib recordNumber length=8 label=\"" + bundle.getString("JobCG.ProcessStats.RecordNumber.Label.txt") + "\"; \n").addSourceCode("attrib startTime length=8 format=datetime19.2 informat=datetime. label=\"" + bundle.getString("JobCG.ProcessStats.StartTime.Label.txt") + "\"; \n").addSourceCode("attrib endTime length=8 format=datetime19.2 informat=datetime. label=\"" + bundle.getString("JobCG.ProcessStats.EndTime.Label.txt") + "\"; \n").addSourceCode("attrib processTime length=8 format=time11.2 informat=time. label=\"" + bundle.getString("JobCG.ProcessStats.ProcessTime.Label.txt") + "\"; \n").addSourceCode("attrib returnCode length=8 label=\"" + bundle.getString("JobCG.ProcessStats.ReturnCode.Label.txt") + "\"; \n\n").addSourceCode("jobTime = \"&etls_startTime\"dt; \n\n").addSourceCode("set ");
        int processNum = cgReq.getProcessNumber();
        ArrayList<String> tableList = new ArrayList<String>(processNum + 1);
        for (int i = 0; i <= processNum; ++i) {
            if (i > 0) {
                cgReq.addSourceCode("\n    ");
            }
            String tableName = "work.etls_ProcessStats_" + String.valueOf(i);
            cgReq.addSourceCode(tableName);
            tableList.add(tableName);
        }
        cgReq.addSourceCode("; \n\n").unIndent().addSourceCode("run; \n\n").genTableDelete(tableList);
        AssociationList triggeredEvents = job.getTriggeredEvents();
        if (triggeredEvents.size() <= 0) {
            return;
        }
        for (int i = 0; i < triggeredEvents.size(); ++i) {
            PropertySet truePS;
            Event event = (Event)triggeredEvents.get(i);
            if (!event.getEventRole().equals("Condition13") || event.getPropertySets().size() <= 0 || (truePS = CodeConditionOptionsUtil.getActionsPropertySet(event, true)) == null) continue;
            AssociationList trueProperties = truePS.getSetProperties();
            for (int j = 0; j < trueProperties.size(); ++j) {
                Property optionProp;
                AssociationList optionList;
                Property action = (Property)trueProperties.get(j);
                String actionValue = action.getDefaultValue();
                if (actionValue.equals("DISPLAY_REPORT")) {
                    cgReq.addCommentLine(bundle.getString("JobCG.DisplayReport.comment.txt"));
                    this.genProcessReport(cgReq);
                    continue;
                }
                if (actionValue.equals("SAVE_REPORT")) {
                    optionList = action.getProperties();
                    if (optionList.isEmpty()) continue;
                    optionProp = (Property)optionList.get(0);
                    String fileName = optionProp.getDefaultValue();
                    cgReq.addCommentLine(bundle.getString("JobCG.SaveReport.comment.txt")).addSourceCode("ods html body = \"").addSourceCode(fileName).addSourceCode("\"; \n\n");
                    this.genProcessReport(cgReq);
                    cgReq.addSourceCode("ods html close \n\n");
                    continue;
                }
                if (actionValue.equals("EMAIL_REPORT")) {
                    optionList = action.getProperties();
                    if (optionList.isEmpty()) continue;
                    optionProp = (Property)optionList.get(0);
                    String emailAddress = optionProp.getDefaultValue();
                    String jobName = job.getName();
                    cgReq.addCommentLine(bundle.getString("JobCG.EmailReport.comment.txt")).addSourceCode("filename report email \"").addSourceCode(emailAddress).addSourceCode("\" subject= \"").addSourceCode(bundle.formatString("JobCG.EmailSubject.txt", (Object)jobName)).addSourceCode("\"; \n\n").addSourceCode("proc printto file = report; \n").addSourceCode("run; \n\n");
                    this.genProcessReport(cgReq);
                    cgReq.addSourceCode("proc printto; \n").addSourceCode("run; \n\n");
                    continue;
                }
                if (!actionValue.equals("SAVE_TABLE")) continue;
                String libref = "work";
                String tableName = "";
                AssociationList optionList2 = action.getProperties();
                if (optionList2.isEmpty()) continue;
                for (int k = 0; k < optionList2.size(); ++k) {
                    Property optionProp2 = (Property)optionList2.get(k);
                    if (optionProp2.getName().equals("LIBREF")) {
                        libref = optionProp2.getDefaultValue();
                        continue;
                    }
                    tableName = optionProp2.getDefaultValue();
                }
                if (tableName.length() == 0) continue;
                cgReq.addCommentLine(bundle.getString("JobCG.SaveTable.comment.txt")).addSourceCode("proc append base = ").addSourceCode(libref).addSourceCode(".").addSourceCode(tableName).addSourceCode(" data = ").addSourceCode("work").addSourceCode(".etls_ProcessStats; \n").addSourceCode("run; \n\n");
            }
        }
    }

    private void genProcessReport(CodegenRequest cgReq) {
        String taskColumn = "";
        if (cgReq.isParallelOn()) {
            taskColumn = "task ";
        }
        cgReq.addSourceCode("proc sort data = ").addSourceCode("work").addSourceCode(".etls_ProcessStats; \n").indent().addSourceCode("by job jobTime recordNumber; \n").unIndent().addSourceCode("run; \n\n").addSourceCode("options pageno = 1 nodate; \n\n").addSourceCode("proc print data = ").addSourceCode("work").addSourceCode(".etls_ProcessStats label noobs; \n").indent().addSourceCode("by job jobTime; \n").addSourceCode("var step ").addSourceCode(taskColumn).addSourceCode("startTime endTime processTime returnCode; \n").addSourceCode("title \"Process Statistics\"; \n").unIndent().addSourceCode("run; \n\n");
    }
}

