/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.AutoExtract;
import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.ExternalTableCG;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TransformationStep;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;

public class FileReaderCodegen {
    private static WAdminResource bundle = WAdminResource.getBundle(FileReaderCodegen.class);

    private FileReaderCodegen() {
    }

    public static void executeUtility(CodegenRequest cgReq, ClassifierMap classifierMap) throws MdException, RemoteException {
        cgReq.checkSourceAndTarget(classifierMap);
        cgReq.checkTargetsForExternalTable(classifierMap);
        AssociationList sourceTables = classifierMap.getClassifierSources();
        DataTable sourceTable = (DataTable)sourceTables.get(0);
        if (!(sourceTable instanceof ExternalTable)) {
            throw new CodegenException(bundle.getString("ExternalTableReaderCodegen.SourceNotExternalTable.msg.txt"));
        }
        cgReq.genSystemOptions((AbstractTransformation)classifierMap);
        DataTable targetTable = cgReq.getTargetTable(classifierMap);
        PhysicalTableCG targetTableCG = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)targetTable);
        String targetTableFullName = targetTableCG.getDataLocation(cgReq);
        String targetTableName = PhysicalTableCG.getTableName(targetTableFullName);
        String tempTargetName = "";
        tempTargetName = targetTableName.length() > 27 ? PhysicalTableCG.getLibref(targetTableFullName) + ".etls_" + cgReq.getUniqueWorkTableName() : targetTableCG.getDataLocation(cgReq, false, true, true);
        TransformationStep step = (TransformationStep)classifierMap.getSteps(false).get(0);
        ExternalTableCG sourceTableCG = (ExternalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)sourceTable);
        sourceTableCG.getModel().setCreateView(targetTableCG.isView(step));
        sourceTableCG.generateSASTable(cgReq, tempTargetName);
        boolean isAutoExtractPerformed = AutoExtract.columnMapping(classifierMap, cgReq, true, targetTableFullName, tempTargetName, sourceTableCG.getSourceTableOptions(), sourceTable, targetTable, targetTableCG.isView(step, cgReq));
        if (!isAutoExtractPerformed) {
            String metaTableName = PhysicalTableCG.getTableName(targetTableName);
            String tempTableName = PhysicalTableCG.getTableName(tempTargetName);
            cgReq.genTableDelete(targetTableFullName);
            cgReq.addSourceCode("proc datasets lib = " + PhysicalTableCG.getLibref(targetTableFullName) + " nolist nowarn memtype = (data view);\n").indent().addSourceCode("change ").addSourceCode(tempTableName).addSourceCode(" = ").addSourceCode(metaTableName).addSourceCode(";").unIndent().addSourceCode("\nquit;\n\n");
        }
    }
}

