/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodeGenRoot;
import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.LongSeqHolder;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.workspace.AppServer;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.rmi.RemoteException;
import org.omg.CORBA.StringHolder;

public class FileCG
extends CodeGenRoot {
    private static WAdminResource bundle = WAdminResource.getBundle(FileCG.class);

    @Override
    public void codeGen(CodegenRequest cgReq) throws MdException, RemoteException {
        File file = (File)this.getMetadataClass();
        this.readRemoteFile(cgReq, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void readRemoteFile(CodegenRequest cgReq, File file) throws MdException, RemoteException {
        block44: {
            String filename = file.getFileName();
            AppServer appServer = null;
            WsAppServer wsAppServer = null;
            boolean useWsAppServer = false;
            boolean newAppServer = true;
            ITextStream ts = null;
            try {
                AssociationList serverList = file.getDeployedComponents();
                appServer = cgReq.getAppServer();
                if (appServer == null) {
                    wsAppServer = cgReq.getWsAppServer();
                    useWsAppServer = true;
                }
                if (serverList.size() <= 0) {
                    if (appServer == null && wsAppServer == null) {
                        throw new CodegenException(bundle.formatString("FileCG.NoServer.msg.txt", (Object)filename));
                    }
                    newAppServer = false;
                } else {
                    ServerContext server = (ServerContext)serverList.get(0);
                    String scID = server.getFQID();
                    if (!useWsAppServer) {
                        appServer = new AppServer(scID);
                    } else {
                        wsAppServer = WsAppServer.createAppServer((ServerContext)server);
                    }
                }
                if (!useWsAppServer) {
                    try {
                        String fileRef = "TempFileRef";
                        IWorkspace iWorkspace = appServer.makeConnection();
                        IFileService rio = iWorkspace.FileService();
                        IFileref fr = rio.AssignFileref(fileRef, "DISK", filename, "", new StringHolder("test"));
                        ts = fr.OpenTextStream(StreamOpenMode.StreamOpenModeForReading, Short.MAX_VALUE);
                        LongSeqHolder lg = new LongSeqHolder();
                        StringSeqHolder st = new StringSeqHolder();
                        boolean loop = true;
                        while (loop) {
                            ts.ReadLines(10000, lg, st);
                            if (st.value.length < 10000) {
                                loop = false;
                            }
                            for (int i = 0; i < st.value.length; ++i) {
                                cgReq.addSourceCode(st.value[i]);
                                cgReq.addSourceCode("\n");
                            }
                        }
                        break block44;
                    }
                    catch (Exception e) {
                        throw new CodegenException(bundle.formatString("FileCG.NoFile.msg.txt", (Object)filename));
                    }
                }
                try {
                    wsAppServer.open();
                    cgReq.addSourceCode(wsAppServer.readFile(filename));
                }
                catch (WsAppServerFailException fe) {
                    throw new CodegenException(bundle.formatString("FileCG.NoServer.msg.txt", (Object)filename));
                }
            }
            catch (GenericError e) {
                throw new CodegenException(e.getMessage());
            }
            finally {
                block45: {
                    ts.Close();
                    try {
                        if (!newAppServer) break block45;
                        if (!useWsAppServer) {
                            appServer.termAppServer();
                            appServer = null;
                            break block45;
                        }
                        wsAppServer.dispose();
                        wsAppServer = null;
                    }
                    catch (Exception exception) {}
                    break block45;
                    catch (Exception exception) {
                        try {
                            if (!newAppServer) break block45;
                            if (!useWsAppServer) {
                                appServer.termAppServer();
                                appServer = null;
                            }
                            wsAppServer.dispose();
                            wsAppServer = null;
                        }
                        catch (Exception exception2) {}
                        catch (Throwable throwable) {
                            try {
                                if (newAppServer) {
                                    if (!useWsAppServer) {
                                        appServer.termAppServer();
                                        appServer = null;
                                    } else {
                                        wsAppServer.dispose();
                                        wsAppServer = null;
                                    }
                                }
                            }
                            catch (Exception exception3) {}
                            throw throwable;
                        }
                    }
                }
            }
        }
    }
}

