/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.DataTableCG;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.metadata.EFIDataModel;
import java.rmi.RemoteException;

public class ExternalTableCG
extends DataTableCG {
    private EFIDataModel m_EFIModel = null;
    private static WAdminResource bundle = WAdminResource.getBundle(ExternalTableCG.class);

    public void generateSASTable(CodegenRequest cgReq, String tableName) throws MdException, RemoteException {
        if (this.m_EFIModel == null) {
            this.setupModel();
        }
        ServerContext etServer = (ServerContext)this.m_EFIModel.getAppServerDC();
        ServerContext localServer = cgReq.getAppServerContext();
        if (etServer != null && !localServer.getFQID().equals(etServer.getFQID()) && this.m_EFIModel.isCreateView()) {
            this.m_EFIModel.setCreateView(false);
        }
        cgReq.genParameterDefaultValueCode((Root)this.getMetadataClass());
        cgReq.genTableDelete(tableName).addCommentLine(bundle.getString("ExternalTableCG.comment.msg.txt")).addSourceCode(this.m_EFIModel.getDataStep(tableName)).genRCSetCall("&syserr");
        boolean specialCharacters = this.m_EFIModel.isSpecialCharactersInColumnNamesEnabled();
        if (specialCharacters) {
            cgReq.setGlobalData("ValidVarName", "ANY");
        }
    }

    public DeployedComponent getHost(CodegenRequest cgReq) throws MdException, RemoteException {
        DeployedComponent dc;
        if (this.m_EFIModel == null) {
            this.setupModel();
        }
        if ((dc = this.m_EFIModel.getAppServerDC()) == null) {
            ServerContext defaultHost = cgReq.getAppServerContext();
            if (defaultHost == null) {
                throw new CodegenException(bundle.getString("ExternalTableCG.NoHost.msg.txt"));
            }
            return defaultHost;
        }
        return dc;
    }

    private void setupModel() throws MdException, RemoteException {
        ExternalTable eTable = (ExternalTable)this.getMetadataClass();
        EFIDataModel mModel = new EFIDataModel();
        mModel.setExternalTable(eTable);
        mModel.setPFDpopulatedStore(true);
        mModel.populateStore();
        this.m_EFIModel = mModel;
    }

    public EFIDataModel getModel() throws MdException, RemoteException {
        if (this.m_EFIModel == null) {
            this.setupModel();
        }
        return this.m_EFIModel;
    }

    public String getLoaderDataStep() throws MdException, RemoteException {
        return this.m_EFIModel.getLoaderDataStep().toString();
    }
}

