/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.workspace.DBMSNamesPropertyHandler;
import com.sas.workspace.ExpressionParser;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class DataValidationMetadataHandler {
    private static WAdminResource bundle = WAdminResource.getBundle(DataValidationMetadataHandler.class);
    protected ClassifierMap m_classifierMap;
    protected String m_validationType;
    protected PhysicalTable m_targetTable;
    protected List m_actionList;
    protected List m_metaActionList;
    protected List m_tableList;
    protected List m_metaTableList;
    protected String m_translatedYes = bundle.getString("DataValidationMetadataHandler.Yes.txt");
    protected String m_translatedNo = bundle.getString("DataValidationMetadataHandler.No.txt");
    private int m_columnIndex;
    private int m_columnNameIndex;
    private int m_actionIndex;
    private int m_changeIndex;
    private int m_expressionIndex;
    private int m_tableIndex;
    private int m_columnListIndex;
    private int m_lookupTableIndex;
    private int m_lookupTableNameIndex;
    private int m_lookupColumnIndex;
    private int m_lookupColumnNameIndex;
    private int m_blanksIndex;
    private int m_nameIndex;
    private int m_conditionIndex;
    private int[] m_assignIndex;
    private int[] m_exceptionIndex;
    private int[] m_customActionIndex;
    private int m_assignStringIndex;
    private int m_typeIndex;
    private int m_metaTypeIndex;
    private int m_transTableIndex;
    private int m_transFromIndex;
    private int m_transToIndex;
    private int m_transSetValueToFlagIndex;
    private int m_transSetValueToIndex;
    private int m_transExceptionIndex;
    private int m_numValues;
    private int m_numValues2;
    public static final String MOVE = "MOVE";
    public static final String CHANGE = "CHANGE";
    public static final String ABORT = "ABORT";
    public static final String MOVEALL = "MOVEALL";
    public static final String NOTHING = "NOTHING";
    public static final String SOURCE = "SOURCE";
    public static final String TARGET = "TARGET";
    public static final String MISSING = "Missing";
    public static final String INVALID = "Invalid";
    public static final String DUPLICATE = "Duplicate";
    public static final String CUSTOM = "Custom";
    public static final String NO = "No";
    public static final String YES = "Yes";
    public static final String EXPRESSION = "Expression";
    public static final String TRANSLATION = "Translation";
    public static final String BLANKS = "Blanks";
    public static final String ACTIONS = "Actions";
    public static final String ACTION = "Action";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String LOOKUP = "Lookup";
    public static final String TABLE = "Table";
    public static final String TOKENIZEDCONDITION = "TokenizedCondition";
    public static final String TRANSLATE = "Translate";
    public static final String EXCEPTION = "Exception";
    public static final String CONDITION = "Condition";
    public static final String SETVALUETO = "SetValueTo";
    public static final String TRANSLATEEXCEPTION = "TranslateException";

    public DataValidationMetadataHandler(ClassifierMap classifierMap, String validationType) {
        this(validationType);
        this.m_classifierMap = classifierMap;
    }

    public DataValidationMetadataHandler(String validationType) {
        this.m_validationType = validationType;
        if (validationType.equals(MISSING)) {
            this.m_metaActionList = new ArrayList(3);
            this.m_metaActionList.add(MOVE);
            this.m_metaActionList.add(CHANGE);
            this.m_metaActionList.add(ABORT);
            this.m_columnNameIndex = 0;
            this.m_actionIndex = 1;
            this.m_expressionIndex = 2;
            this.m_changeIndex = 3;
            this.m_columnIndex = 4;
            this.m_numValues = 5;
        } else if (validationType.equals(INVALID)) {
            this.m_metaActionList = new ArrayList(3);
            this.m_metaActionList.add(MOVE);
            this.m_metaActionList.add(CHANGE);
            this.m_metaActionList.add(ABORT);
            this.m_columnNameIndex = 0;
            this.m_lookupTableNameIndex = 1;
            this.m_lookupColumnNameIndex = 2;
            this.m_blanksIndex = 3;
            this.m_actionIndex = 4;
            this.m_expressionIndex = 5;
            this.m_changeIndex = 6;
            this.m_columnIndex = 7;
            this.m_lookupTableIndex = 8;
            this.m_lookupColumnIndex = 9;
            this.m_numValues = 10;
        } else if (validationType.equals(DUPLICATE)) {
            this.m_metaActionList = new ArrayList(3);
            this.m_metaActionList.add(MOVEALL);
            this.m_metaActionList.add(MOVE);
            this.m_metaActionList.add(ABORT);
            this.m_columnIndex = 0;
            this.m_tableIndex = 1;
            this.m_actionIndex = 2;
            this.m_columnListIndex = 3;
            this.m_numValues = 4;
            this.m_metaTableList = new ArrayList(2);
            this.m_metaTableList.add(SOURCE);
            this.m_metaTableList.add(TARGET);
            this.m_tableList = this.makeTableList();
        } else if (validationType.equals(CUSTOM)) {
            this.m_metaActionList = new ArrayList(3);
            this.m_metaActionList.add(NOTHING);
            this.m_metaActionList.add(MOVE);
            this.m_metaActionList.add(ABORT);
            this.m_nameIndex = 0;
            this.m_conditionIndex = 1;
            this.m_assignIndex = new int[]{2, 3};
            this.m_exceptionIndex = new int[]{4, 5};
            this.m_customActionIndex = new int[]{6, 7};
            this.m_numValues = 8;
        }
        if (this.m_validationType.equals(TRUE) || this.m_validationType.equals(FALSE) || this.m_validationType.equals(CUSTOM)) {
            this.m_columnNameIndex = 0;
            this.m_assignStringIndex = 1;
            this.m_typeIndex = 2;
            this.m_metaTypeIndex = 3;
            this.m_expressionIndex = 4;
            this.m_transTableIndex = 5;
            this.m_transFromIndex = 6;
            this.m_transToIndex = 7;
            this.m_transSetValueToFlagIndex = 8;
            this.m_transSetValueToIndex = 9;
            this.m_transExceptionIndex = 10;
            this.m_columnIndex = 11;
            if (!this.m_validationType.equals(CUSTOM)) {
                this.m_numValues = 12;
            }
            this.m_numValues2 = 12;
        }
        this.m_actionList = this.makeActionList();
    }

    public void setClassifierMap(ClassifierMap classifierMap) {
        this.m_classifierMap = classifierMap;
    }

    public void makeTargetTable() throws MdException, RemoteException {
        DataTable table;
        AssociationList tables;
        if (this.m_targetTable == null && (tables = this.m_classifierMap.getClassifierTargets()).size() > 0 && (table = (DataTable)tables.get(0)) instanceof PhysicalTable) {
            this.m_targetTable = (PhysicalTable)table;
        }
    }

    public List getEvents() throws MdException, RemoteException {
        AssociationList eventList = this.m_classifierMap.getTriggeredEvents();
        ArrayList<Event> events = new ArrayList<Event>();
        for (int i = 0; i < eventList.size(); ++i) {
            Event tempEvent = (Event)eventList.get(i);
            if (tempEvent == null || !tempEvent.getCondition().equalsIgnoreCase(this.m_validationType)) continue;
            events.add(tempEvent);
        }
        return events;
    }

    public PropertySet getPropertySet(Event event, String role) throws MdException, RemoteException {
        if (event == null) {
            return null;
        }
        AssociationList psList = event.getPropertySets();
        for (int i = 0; i < psList.size(); ++i) {
            PropertySet ps = (PropertySet)psList.get(i);
            if (!ps.getName().equalsIgnoreCase(ACTIONS) || !ps.getSetRole().equalsIgnoreCase(role)) continue;
            return ps;
        }
        return null;
    }

    public Property getProperty(PropertySet propSet) throws MdException, RemoteException {
        if (propSet == null) {
            return null;
        }
        AssociationList propList = propSet.getSetProperties();
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getName().equalsIgnoreCase(ACTION)) continue;
            return prop;
        }
        return null;
    }

    public FeatureMap getFeatureMap(Property prop) throws MdException, RemoteException {
        if (prop == null) {
            return null;
        }
        AssociationList fmList = prop.getTargetTransformations();
        for (int i = 0; i < fmList.size(); ++i) {
            FeatureMap fm;
            CMetadata cm = (CMetadata)fmList.get(i);
            if (!(cm instanceof FeatureMap) || !(fm = (FeatureMap)cm).getTransformRole().equalsIgnoreCase(this.m_validationType)) continue;
            return fm;
        }
        return null;
    }

    public List getFeatureMapList(Property prop) throws MdException, RemoteException {
        ArrayList<FeatureMap> fmList = new ArrayList<FeatureMap>();
        if (prop == null) {
            return fmList;
        }
        AssociationList targetList = prop.getTargetTransformations();
        for (int i = 0; i < targetList.size(); ++i) {
            FeatureMap fm;
            CMetadata cm = (CMetadata)targetList.get(i);
            if (!(cm instanceof FeatureMap) || !(fm = (FeatureMap)cm).getTransformRole().equalsIgnoreCase(this.m_validationType)) continue;
            fmList.add(fm);
        }
        return fmList;
    }

    public List getVariableList(AbstractTransformation trans) throws MdException, RemoteException {
        if (trans == null) {
            return null;
        }
        return trans.getSubstitutionVariables();
    }

    public TextStore getTextStore(AbstractTransformation trans) throws MdException, RemoteException {
        if (trans == null) {
            return null;
        }
        Text text = trans.getSourceCode();
        if (text instanceof TextStore) {
            return (TextStore)text;
        }
        return null;
    }

    public String getColumnName(FeatureMap fm) throws MdException, RemoteException {
        Column column;
        AssociationList colList = fm.getFeatureTargets();
        String colName = "";
        if (colList.size() == 1 && (column = (Column)colList.get(0)) != null) {
            colName = column.getSASColumnName();
        }
        return colName;
    }

    public Column getColumn(FeatureMap fm) throws MdException, RemoteException {
        AssociationList colList = fm.getFeatureTargets();
        Column column = null;
        if (colList.size() == 1) {
            column = (Column)colList.get(0);
        }
        return column;
    }

    public List getColumnList(FeatureMap fm) throws MdException, RemoteException {
        AssociationList colList = fm.getFeatureTargets();
        ArrayList columnList = new ArrayList(colList);
        return columnList;
    }

    public String getExpression(AbstractTransformation trans) throws MdException, RemoteException {
        TextStore text = this.getTextStore(trans);
        if (text == null) {
            return "";
        }
        String expression = "";
        boolean useQuotes = DBMSNamesPropertyHandler.needQuotes((DataTable)this.m_targetTable);
        expression = ExpressionParser.detokenizeString((String)text.getStoredText(), (AbstractTransformation)trans, (boolean)useQuotes);
        return expression;
    }

    public String getTablesProperty(FeatureMap fm) throws MdException, RemoteException {
        AssociationList propList = fm.getProperties();
        if (propList.size() <= 0) {
            return "";
        }
        Property tablesProperty = null;
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getPropertyRole().equalsIgnoreCase(TABLE)) continue;
            tablesProperty = prop;
            break;
        }
        if (tablesProperty == null) {
            return "";
        }
        String metaTable = tablesProperty.getDefaultValue();
        if (!metaTable.equals("")) {
            return this.getTable(metaTable);
        }
        return "";
    }

    public Column getLookupColumn(Event event) throws MdException, RemoteException {
        AssociationList transList = event.getSourceTransformations();
        if (transList.size() <= 0) {
            return null;
        }
        FeatureMap fm = null;
        for (int i = 0; i < transList.size(); ++i) {
            CMetadata trans = (CMetadata)transList.get(i);
            if (trans == null || !(trans instanceof FeatureMap) || !((FeatureMap)trans).getTransformRole().equalsIgnoreCase(LOOKUP)) continue;
            fm = (FeatureMap)trans;
            break;
        }
        if (fm == null) {
            return null;
        }
        AssociationList colList = fm.getFeatureSources();
        if (colList.size() <= 0) {
            return null;
        }
        Column column = (Column)colList.get(0);
        return column;
    }

    public PhysicalTable getLookupTable(Column column) throws MdException, RemoteException {
        if (column == null) {
            return null;
        }
        PhysicalTable table = (PhysicalTable)column.getTable();
        return table;
    }

    public String getBlanksProperty(FeatureMap fm) throws MdException, RemoteException {
        AssociationList propList = fm.getProperties();
        if (propList.size() <= 0) {
            return "";
        }
        Property blanksProperty = null;
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getPropertyRole().equalsIgnoreCase(BLANKS)) continue;
            blanksProperty = prop;
            break;
        }
        if (blanksProperty == null) {
            return "";
        }
        return blanksProperty.getDefaultValue();
    }

    public String getCondition(Event event) throws MdException, RemoteException {
        AssociationList transList = event.getSourceTransformations();
        if (transList.size() <= 0) {
            return null;
        }
        Transformation transform = null;
        for (int i = 0; i < transList.size(); ++i) {
            CMetadata trans = (CMetadata)transList.get(i);
            if (!(trans instanceof Transformation) || !((Transformation)trans).getTransformRole().equalsIgnoreCase(TOKENIZEDCONDITION)) continue;
            transform = (Transformation)trans;
            break;
        }
        String condition = this.getExpression((AbstractTransformation)transform);
        return condition;
    }

    public FeatureMap getTranslationFM(FeatureMap fm) throws MdException, RemoteException {
        if (fm == null) {
            return null;
        }
        AssociationList transList = fm.getTransformationSources();
        if (transList.size() <= 0) {
            return null;
        }
        for (int i = 0; i < transList.size(); ++i) {
            AbstractTransformation trans = (AbstractTransformation)transList.get(i);
            if (!trans.getTransformRole().equalsIgnoreCase(TRANSLATE) || !(trans instanceof FeatureMap)) continue;
            return (FeatureMap)trans;
        }
        return null;
    }

    public Column getTranslationFromColumn(FeatureMap fm) throws MdException, RemoteException {
        if (fm == null) {
            return null;
        }
        AssociationList sourceList = fm.getFeatureSources();
        if (sourceList.size() > 0) {
            return (Column)sourceList.get(0);
        }
        return null;
    }

    public Column getTranslationToColumn(FeatureMap fm) throws MdException, RemoteException {
        if (fm == null) {
            return null;
        }
        AssociationList targetList = fm.getFeatureTargets();
        if (targetList.size() > 0) {
            return (Column)targetList.get(0);
        }
        return null;
    }

    public boolean getExceptionProperty(Property actionProp) throws MdException, RemoteException {
        AssociationList propList = actionProp.getProperties();
        if (propList.size() <= 0) {
            return false;
        }
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getPropertyRole().equalsIgnoreCase(EXCEPTION)) continue;
            return prop.getDefaultValue().equalsIgnoreCase(YES);
        }
        return false;
    }

    public Property getTransSetValueToProperty(FeatureMap fm) throws MdException, RemoteException {
        AssociationList propList = fm.getProperties();
        if (propList.size() <= 0) {
            return null;
        }
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getPropertyRole().equalsIgnoreCase(SETVALUETO)) continue;
            return prop;
        }
        return null;
    }

    public boolean getTransSetValueToFlag(Property prop) throws MdException, RemoteException {
        if (prop == null) {
            return false;
        }
        AssociationList propList = prop.getProperties();
        if (propList.size() <= 0) {
            return false;
        }
        for (int i = 0; i < propList.size(); ++i) {
            Property setValueToProp = (Property)propList.get(i);
            if (!setValueToProp.getPropertyRole().equalsIgnoreCase(SETVALUETO)) continue;
            return prop.getDefaultValue().equalsIgnoreCase(YES);
        }
        return false;
    }

    public String getTransSetValueTo(Property prop) throws MdException, RemoteException {
        if (prop == null) {
            return "";
        }
        AssociationList propList = prop.getProperties();
        if (propList.size() <= 0) {
            return "";
        }
        for (int i = 0; i < propList.size(); ++i) {
            Property setToProp = (Property)propList.get(i);
            if (!setToProp.getPropertyRole().equalsIgnoreCase(SETVALUETO)) continue;
            return setToProp.getDefaultValue();
        }
        return "";
    }

    public boolean getTransException(FeatureMap fm) throws MdException, RemoteException {
        AssociationList propList = fm.getProperties();
        if (propList.size() <= 0) {
            return false;
        }
        for (int i = 0; i < propList.size(); ++i) {
            Property prop = (Property)propList.get(i);
            if (!prop.getPropertyRole().equalsIgnoreCase(TRANSLATEEXCEPTION)) continue;
            return prop.getDefaultValue().equalsIgnoreCase(YES);
        }
        return false;
    }

    public List getMetadataValues() throws MdException, RemoteException {
        this.makeTargetTable();
        ArrayList rows = new ArrayList();
        List eventList = this.getEvents();
        for (int i = 0; i < eventList.size(); ++i) {
            ArrayList<Object> rowValues;
            block22: {
                Event event;
                block20: {
                    FeatureMap fm;
                    block21: {
                        event = (Event)eventList.get(i);
                        rowValues = new ArrayList<Object>(this.m_numValues);
                        for (int j = 0; j < this.m_numValues; ++j) {
                            rowValues.add(null);
                        }
                        if (!this.m_validationType.equals(MISSING) && !this.m_validationType.equals(INVALID) && !this.m_validationType.equals(DUPLICATE)) break block20;
                        PropertySet actionPS = this.getPropertySet(event, TRUE);
                        Property actionProp = this.getProperty(actionPS);
                        fm = this.getFeatureMap(actionProp);
                        if (fm == null) continue;
                        String defValue = actionProp.getDefaultValue();
                        String action = this.getAction(defValue);
                        rowValues.set(this.m_actionIndex, action);
                        if (!this.m_validationType.equals(MISSING) && !this.m_validationType.equals(INVALID)) break block21;
                        Column column = this.getColumn(fm);
                        rowValues.set(this.m_columnIndex, column);
                        if (column == null) {
                            rowValues.set(this.m_columnNameIndex, null);
                        } else {
                            rowValues.set(this.m_columnNameIndex, column.getSASColumnName());
                        }
                        int change = this.getChangeAction();
                        rowValues.set(this.m_changeIndex, new Integer(change));
                        String expression = this.getExpression((AbstractTransformation)fm);
                        rowValues.set(this.m_expressionIndex, expression);
                        if (this.m_validationType.equals(INVALID)) {
                            Column lookupColumn = this.getLookupColumn(event);
                            PhysicalTable lookupTable = this.getLookupTable(lookupColumn);
                            rowValues.set(this.m_lookupTableIndex, lookupTable);
                            if (lookupTable == null) {
                                rowValues.set(this.m_lookupTableNameIndex, "");
                            } else {
                                rowValues.set(this.m_lookupTableNameIndex, lookupTable.getName());
                            }
                            rowValues.set(this.m_lookupColumnIndex, lookupColumn);
                            if (lookupColumn == null) {
                                rowValues.set(this.m_lookupColumnNameIndex, "");
                            } else {
                                rowValues.set(this.m_lookupColumnNameIndex, lookupColumn.getSASColumnName());
                            }
                            String blanks = this.getBlanksProperty(fm);
                            blanks = blanks.equalsIgnoreCase(YES) ? this.m_translatedYes : this.m_translatedNo;
                            rowValues.set(this.m_blanksIndex, blanks);
                        }
                        break block22;
                    }
                    if (!this.m_validationType.equals(DUPLICATE)) break block22;
                    List columnList = this.getColumnList(fm);
                    rowValues.set(this.m_columnListIndex, columnList);
                    String columnNames = this.getColumnNames(columnList);
                    rowValues.set(this.m_columnIndex, columnNames);
                    String table = this.getTablesProperty(fm);
                    rowValues.set(this.m_tableIndex, table);
                    break block22;
                }
                String name = event.getName();
                rowValues.set(this.m_nameIndex, name);
                String condition = this.getCondition(event);
                rowValues.set(this.m_conditionIndex, condition);
                for (int j = 0; j < 2; ++j) {
                    Property actionProp;
                    PropertySet actionPS;
                    if (j == 1) {
                        actionPS = this.getPropertySet(event, TRUE);
                        actionProp = this.getProperty(actionPS);
                    } else {
                        actionPS = this.getPropertySet(event, FALSE);
                        actionProp = this.getProperty(actionPS);
                    }
                    boolean exception = this.getExceptionProperty(actionProp);
                    rowValues.set(this.m_exceptionIndex[j], exception);
                    String defValue = actionProp.getDefaultValue();
                    String action = this.getAction(defValue);
                    rowValues.set(this.m_customActionIndex[j], action);
                    List fmList = this.getFeatureMapList(actionProp);
                    ArrayList assignList = new ArrayList(fmList.size());
                    for (int k = 0; k < fmList.size(); ++k) {
                        ArrayList<Object> assignRow = new ArrayList<Object>(this.m_numValues2);
                        for (int l = 0; l < this.m_numValues2; ++l) {
                            assignRow.add(null);
                        }
                        FeatureMap fm = (FeatureMap)fmList.get(k);
                        Column col = this.getColumn(fm);
                        assignRow.set(this.m_columnIndex, col);
                        if (col == null) {
                            assignRow.set(this.m_columnNameIndex, null);
                        } else {
                            assignRow.set(this.m_columnNameIndex, col.getSASColumnName());
                        }
                        String text = this.getExpression((AbstractTransformation)fm);
                        if (!text.equals("")) {
                            assignRow.set(this.m_expressionIndex, text);
                            assignRow.set(this.m_typeIndex, bundle.getString("DataValidationMetadataHandler.Expression.txt"));
                            assignRow.set(this.m_metaTypeIndex, EXPRESSION);
                            assignRow.set(this.m_assignStringIndex, text);
                        } else {
                            FeatureMap transFM = this.getTranslationFM(fm);
                            Column sourceColumn = this.getTranslationFromColumn(transFM);
                            Column targetColumn = this.getTranslationToColumn(transFM);
                            PhysicalTable table = null;
                            if (sourceColumn != null) {
                                table = (PhysicalTable)sourceColumn.getTable();
                            }
                            Property transSetValueToProp = this.getTransSetValueToProperty(transFM);
                            boolean transSetValueToFlag = this.getTransSetValueToFlag(transSetValueToProp);
                            String transSetValueTo = "";
                            if (transSetValueToFlag) {
                                transSetValueTo = this.getTransSetValueTo(transSetValueToProp);
                            }
                            boolean transExcpFlag = this.getTransException(transFM);
                            assignRow.set(this.m_transFromIndex, sourceColumn);
                            assignRow.set(this.m_transToIndex, targetColumn);
                            assignRow.set(this.m_transTableIndex, table);
                            assignRow.set(this.m_transSetValueToFlagIndex, transSetValueToFlag);
                            assignRow.set(this.m_transSetValueToIndex, transSetValueTo);
                            assignRow.set(this.m_transExceptionIndex, transExcpFlag);
                            assignRow.set(this.m_typeIndex, bundle.getString("DataValidationMetadataHandler.Translation.txt"));
                            assignRow.set(this.m_metaTypeIndex, TRANSLATION);
                            String assignString = this.makeAssignString(table, sourceColumn, targetColumn);
                            assignRow.set(this.m_assignStringIndex, assignString);
                        }
                        assignList.add(assignRow);
                    }
                    rowValues.set(this.m_assignIndex[j], assignList);
                }
            }
            rows.add(rowValues);
        }
        return rows;
    }

    public String getBlanksTranslatedValue(String value) {
        if (value.equals(YES)) {
            return this.m_translatedYes;
        }
        return this.m_translatedNo;
    }

    public String getBlanksMetadataValue(String value) {
        if (value.equalsIgnoreCase(this.m_translatedYes)) {
            return YES;
        }
        return NO;
    }

    public Root makeObject(String name, String objectType) throws RemoteException {
        Root object = (Root)Workspace.getMdFactory().createComplexMetadataObject((MdObjectStore)this.m_classifierMap.getObjectStore(), null, name, objectType, this.m_classifierMap.getRepositoryID(), null);
        return object;
    }

    public PropertySet makeActionPropertySet(String setRole, Root owner) throws RemoteException {
        PropertySet actionPS = (PropertySet)this.makeObject(ACTIONS, "PropertySet");
        actionPS.setSetRole(setRole);
        actionPS.setOwningObject(owner);
        return actionPS;
    }

    public Property makeProperty(String name, PropertyType propType) throws RemoteException {
        Property prop = (Property)this.makeObject(name, "Property");
        prop.setOwningType(propType);
        return prop;
    }

    public FeatureMap makeActionFeatureMap(Root owner, List columnList) throws MdException, RemoteException {
        FeatureMap fm = this.makeFeatureMap(this.m_validationType, owner);
        AssociationList colAssocList = new AssociationList("FeatureTargets");
        for (int j = 0; j < columnList.size(); ++j) {
            Column col = (Column)columnList.get(j);
            colAssocList.add((Object)col);
        }
        fm.setFeatureTargets(colAssocList);
        return fm;
    }

    public FeatureMap makeFeatureMap(String name, Root owner) throws MdException, RemoteException {
        FeatureMap fm = (FeatureMap)this.makeObject(this.m_validationType, "FeatureMap");
        fm.setTransformRole(name);
        if (owner.getTargetTransformations().size() > 0) {
            owner.getTargetTransformations().add((Object)fm);
        } else {
            AssociationList targetTrans = new AssociationList("TargetTransformations");
            targetTrans.add((Object)fm);
            owner.setTargetTransformations(targetTrans);
        }
        return fm;
    }

    public void makeExpression(String text, AssociationList colList, AbstractTransformation owner) throws MdException, RemoteException {
        if (text != null && text.length() > 0) {
            boolean useQuotes = DBMSNamesPropertyHandler.needQuotes((DataTable)this.m_targetTable);
            String expression = ExpressionParser.tokenizeString((String)text, (List)colList, (AbstractTransformation)owner, (boolean)useQuotes, (boolean)useQuotes);
            TextStore ts = (TextStore)this.makeObject(this.m_validationType, "TextStore");
            ts.setStoredText(expression);
            owner.setSourceCode((Text)ts);
        }
    }

    public void setMetadataValues(List rows) throws MdException, RemoteException {
        List eventList = this.getEvents();
        MdObjectStore store = (MdObjectStore)this.m_classifierMap.getObjectStore();
        String deleteTemplate = "<Event><PropertySets><PropertySet><SetProperties><Property><TargetTransformations><FeatureMap><SubstitutionVariables/><SourceCode/><Properties><Property><Properties><Property/></Properties></Property></Properties><TransformationSources><FeatureMap><Properties><Property><Properties><Property/></Properties></Property></Properties></FeatureMap></TransformationSources></FeatureMap></TargetTransformations><Properties><Property/></Properties></Property></SetProperties></PropertySet></PropertySets><SourceTransformations><FeatureMap><SubstitutionVariables/><SourceCode/><Properties><Property><Properties><Property/></Properties></Property></Properties></FeatureMap><Transformation><SubstitutionVariables/><SourceCode/><Properties><Property><Properties><Property/></Properties></Property></Properties></Transformation></SourceTransformations></Event>";
        for (int i = 0; i < eventList.size(); ++i) {
            Event event = (Event)eventList.get(i);
            store.removeObjectFromStore((CMetadata)event, deleteTemplate);
        }
        PropertyType propType = null;
        if (rows.size() > 0) {
            propType = (PropertyType)this.makeObject(this.m_validationType, "PropertyType");
            propType.setSQLType(12);
        }
        AssociationList targetColumnsList = this.m_targetTable.getColumns();
        for (int i = 0; i < rows.size(); ++i) {
            List rowValues = (List)rows.get(i);
            Event event = (Event)this.makeObject(this.m_validationType, "Event");
            event.setCondition(this.m_validationType);
            this.m_classifierMap.getTriggeredEvents().add((Object)event);
            if (this.m_validationType.equals(MISSING) || this.m_validationType.equals(INVALID) || this.m_validationType.equals(DUPLICATE)) {
                PropertySet actionPS = this.makeActionPropertySet(TRUE, (Root)event);
                Property prop = this.makeProperty(ACTION, propType);
                prop.setAssociatedPropertySet(actionPS);
                String action = (String)rowValues.get(this.m_actionIndex);
                String metaAction = this.getMetaAction(action);
                prop.setDefaultValue(metaAction);
                if (this.m_validationType.equals(MISSING) || this.m_validationType.equals(INVALID)) {
                    ArrayList<Column> columnList = new ArrayList<Column>(1);
                    Column column = (Column)rowValues.get(this.m_columnIndex);
                    if (column != null) {
                        columnList.add(column);
                    }
                    FeatureMap fm = this.makeActionFeatureMap((Root)prop, columnList);
                    String text = (String)rowValues.get(this.m_expressionIndex);
                    this.makeExpression(text, targetColumnsList, (AbstractTransformation)fm);
                    if (!this.m_validationType.equals(INVALID)) continue;
                    Property blanksProp = this.makeProperty(BLANKS, propType);
                    blanksProp.setAssociatedObject((Root)fm);
                    String blanksValue = (String)rowValues.get(this.m_blanksIndex);
                    if (blanksValue.equals("")) {
                        blanksValue = NO;
                    }
                    blanksValue = blanksValue.equals(this.m_translatedYes) ? YES : NO;
                    blanksProp.setDefaultValue(blanksValue);
                    blanksProp.setPropertyRole(BLANKS);
                    FeatureMap lookupFM = (FeatureMap)this.makeObject(LOOKUP, "FeatureMap");
                    lookupFM.setTransformRole(LOOKUP);
                    AssociationList sourceTrans = new AssociationList("SourceTransformations");
                    sourceTrans.add((Object)lookupFM);
                    event.setSourceTransformations(sourceTrans);
                    Column lookupColumn = (Column)rowValues.get(this.m_lookupColumnIndex);
                    if (lookupColumn == null) continue;
                    AssociationList featureSource = new AssociationList("FeatureSources");
                    featureSource.add((Object)lookupColumn);
                    lookupFM.setFeatureSources(featureSource);
                    continue;
                }
                if (!this.m_validationType.equals(DUPLICATE)) continue;
                ArrayList columnList = (ArrayList)rowValues.get(this.m_columnListIndex);
                if (columnList == null) {
                    columnList = new ArrayList();
                }
                FeatureMap fm = this.makeActionFeatureMap((Root)prop, columnList);
                Property tableProp = this.makeProperty(TABLE, propType);
                tableProp.setAssociatedObject((Root)fm);
                tableProp.setPropertyRole(TABLE);
                String table = (String)rowValues.get(this.m_tableIndex);
                String metaTable = this.getMetaTable(table);
                tableProp.setDefaultValue(metaTable);
                continue;
            }
            String name = (String)rowValues.get(this.m_nameIndex);
            event.setName(name);
            event.setEventRole(TOKENIZEDCONDITION);
            Transformation condition = (Transformation)this.makeObject(CONDITION, "Transformation");
            condition.setTransformRole(TOKENIZEDCONDITION);
            AssociationList sourceTrans = new AssociationList("SourceTransformations");
            sourceTrans.add((Object)condition);
            event.setSourceTransformations(sourceTrans);
            String text = (String)rowValues.get(this.m_conditionIndex);
            this.makeExpression(text, targetColumnsList, (AbstractTransformation)condition);
            for (int j = 0; j < 2; ++j) {
                String type = j == 1 ? TRUE : FALSE;
                PropertySet actPS = this.makeActionPropertySet(type, (Root)event);
                Property actProp = this.makeProperty(ACTION, propType);
                actProp.setAssociatedPropertySet(actPS);
                String action = (String)rowValues.get(this.m_customActionIndex[j]);
                String metaAction = this.getMetaAction(action);
                actProp.setDefaultValue(metaAction);
                Property excpProp = this.makeProperty(EXCEPTION, propType);
                excpProp.setAssociatedObject((Root)actProp);
                excpProp.setPropertyRole(EXCEPTION);
                boolean excpFlag = (Boolean)rowValues.get(this.m_exceptionIndex[j]);
                if (excpFlag) {
                    excpProp.setDefaultValue(YES);
                } else {
                    excpProp.setDefaultValue(NO);
                }
                List assignmentsList = (List)rowValues.get(this.m_assignIndex[j]);
                if (assignmentsList == null) continue;
                for (int k = 0; k < assignmentsList.size(); ++k) {
                    boolean setToFlag;
                    String assignType;
                    FeatureMap fm = this.makeFeatureMap(this.m_validationType, (Root)actProp);
                    List assignList = (List)assignmentsList.get(k);
                    Column column = (Column)assignList.get(this.m_columnIndex);
                    if (column != null) {
                        AssociationList featureTargets = new AssociationList("FeatureTargets");
                        featureTargets.add((Object)column);
                        fm.setFeatureTargets(featureTargets);
                    }
                    if ((assignType = (String)assignList.get(this.m_metaTypeIndex)).equalsIgnoreCase(EXPRESSION)) {
                        String expression = (String)assignList.get(this.m_expressionIndex);
                        this.makeExpression(expression, targetColumnsList, (AbstractTransformation)fm);
                        continue;
                    }
                    FeatureMap transFM = (FeatureMap)this.makeObject(TRANSLATE, "FeatureMap");
                    transFM.setTransformRole(TRANSLATE);
                    AssociationList transSource = new AssociationList("TransformationSources");
                    transSource.add((Object)transFM);
                    fm.setTransformationSources(transSource);
                    Column fromCol = (Column)assignList.get(this.m_transFromIndex);
                    Column toCol = (Column)assignList.get(this.m_transToIndex);
                    if (fromCol != null) {
                        AssociationList featureSources = new AssociationList("FeatureSources");
                        featureSources.add((Object)fromCol);
                        transFM.setFeatureSources(featureSources);
                    }
                    if (toCol != null) {
                        AssociationList featureTargets = new AssociationList("FeatureTargets");
                        featureTargets.add((Object)toCol);
                        transFM.setFeatureTargets(featureTargets);
                    }
                    String setValueToFlag = (setToFlag = ((Boolean)assignList.get(this.m_transSetValueToFlagIndex)).booleanValue()) ? YES : NO;
                    Property setValueToProperty = this.makeProperty(SETVALUETO, propType);
                    setValueToProperty.setAssociatedObject((Root)transFM);
                    setValueToProperty.setPropertyRole(SETVALUETO);
                    setValueToProperty.setDefaultValue(setValueToFlag);
                    if (setToFlag) {
                        String setValueTo = (String)assignList.get(this.m_transSetValueToIndex);
                        if (setValueTo == null) {
                            setValueTo = "";
                        }
                        Property setValueToStringProperty = this.makeProperty(SETVALUETO, propType);
                        setValueToStringProperty.setAssociatedObject((Root)setValueToProperty);
                        setValueToStringProperty.setPropertyRole(SETVALUETO);
                        setValueToStringProperty.setDefaultValue(setValueTo);
                    }
                    Property transExcpProp = this.makeProperty(TRANSLATEEXCEPTION, propType);
                    transExcpProp.setAssociatedObject((Root)transFM);
                    transExcpProp.setPropertyRole(TRANSLATEEXCEPTION);
                    boolean transExcpFlag = (Boolean)assignList.get(this.m_transExceptionIndex);
                    if (transExcpFlag) {
                        transExcpProp.setDefaultValue(YES);
                        continue;
                    }
                    transExcpProp.setDefaultValue(NO);
                }
            }
        }
    }

    public String getAction(String metaAction) {
        for (int i = 0; i < this.m_metaActionList.size(); ++i) {
            String listAction = (String)this.m_metaActionList.get(i);
            if (!listAction.equalsIgnoreCase(metaAction)) continue;
            return (String)this.m_actionList.get(i);
        }
        return "";
    }

    public String getMetaAction(String action) {
        for (int i = 0; i < this.m_actionList.size(); ++i) {
            String listAction = (String)this.m_actionList.get(i);
            if (!listAction.equalsIgnoreCase(action)) continue;
            return (String)this.m_metaActionList.get(i);
        }
        return "";
    }

    public int getChangeAction() {
        for (int i = 0; i < this.m_metaActionList.size(); ++i) {
            String listAction = (String)this.m_metaActionList.get(i);
            if (!listAction.equalsIgnoreCase(CHANGE)) continue;
            return i;
        }
        return -1;
    }

    public List makeActionList() {
        if (this.m_metaActionList == null) {
            return null;
        }
        ArrayList<String> actionList = new ArrayList<String>(this.m_metaActionList.size());
        for (int i = 0; i < this.m_metaActionList.size(); ++i) {
            actionList.add(bundle.getString("DataValidationMetadataHandler." + this.m_validationType + ".ActionList." + (String)this.m_metaActionList.get(i) + ".txt"));
        }
        return actionList;
    }

    public List makeTableList() {
        if (this.m_metaTableList == null) {
            return null;
        }
        ArrayList<String> tableList = new ArrayList<String>(this.m_metaTableList.size());
        for (int i = 0; i < this.m_metaTableList.size(); ++i) {
            tableList.add(bundle.getString("DataValidationMetadataHandler.Duplicate.TableList." + (String)this.m_metaTableList.get(i) + ".txt"));
        }
        return tableList;
    }

    public String getTable(String metaTable) {
        for (int i = 0; i < this.m_metaTableList.size(); ++i) {
            String listTable = (String)this.m_metaTableList.get(i);
            if (!listTable.equalsIgnoreCase(metaTable)) continue;
            return (String)this.m_tableList.get(i);
        }
        return "";
    }

    public String getMetaTable(String table) {
        for (int i = 0; i < this.m_tableList.size(); ++i) {
            String listTable = (String)this.m_tableList.get(i);
            if (!listTable.equalsIgnoreCase(table)) continue;
            return (String)this.m_metaTableList.get(i);
        }
        return "";
    }

    public String getColumnNames(List columnList) {
        return this.getColumnNames(columnList, true);
    }

    public String getColumnNames(List columnList, boolean commas) {
        StringBuffer colNames = new StringBuffer("");
        for (int i = 0; i < columnList.size(); ++i) {
            Column column = (Column)columnList.get(i);
            if (column == null) continue;
            if (colNames.length() > 1) {
                if (commas) {
                    colNames.append(",");
                }
                colNames.append(" ");
            }
            try {
                colNames.append(column.getSASColumnName());
                continue;
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return colNames.toString();
    }

    public List makeColumnList(PhysicalTable table) throws MdException, RemoteException {
        List<Object> columnList = null;
        if (table == null) {
            return columnList;
        }
        MdObjectStore store = (MdObjectStore)table.getObjectStore();
        store.setGoToServerForMetadata(true);
        Object[] columnArray = table.getColumns().toArray();
        Arrays.sort(columnArray, new cComparator());
        columnList = Arrays.asList(columnArray);
        store.setGoToServerForMetadata(false);
        return columnList;
    }

    public String makeAssignString(PhysicalTable table, Column fromColumn, Column toColumn) {
        if (table == null || fromColumn == null || toColumn == null) {
            return "";
        }
        try {
            return table.toString() + ": " + fromColumn.getSASColumnName() + "->" + toColumn.getSASColumnName();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return "";
        }
    }

    public ClassifierMap getClassifierMap() {
        return this.m_classifierMap;
    }

    public MdObjectStore getStore() throws RemoteException {
        MdObjectStore store = (MdObjectStore)this.m_classifierMap.getObjectStore();
        return store;
    }

    public PhysicalTable getTargetTable() {
        return this.m_targetTable;
    }

    public void setTargetTable(PhysicalTable targetTable) {
        this.m_targetTable = targetTable;
    }

    public List getActionList() {
        return this.m_actionList;
    }

    public List getMetaActionList() {
        return this.m_metaActionList;
    }

    public List getMetaTableList() {
        return this.m_metaTableList;
    }

    public List getTableList() {
        return this.m_tableList;
    }

    public int getActionIndex() {
        return this.m_actionIndex;
    }

    public int[] getAssignIndex() {
        return this.m_assignIndex;
    }

    public int getAssignStringIndex() {
        return this.m_assignStringIndex;
    }

    public int getBlanksIndex() {
        return this.m_blanksIndex;
    }

    public int getChangeIndex() {
        return this.m_changeIndex;
    }

    public int getColumnIndex() {
        return this.m_columnIndex;
    }

    public int getColumnNameIndex() {
        return this.m_columnNameIndex;
    }

    public int getColumnListIndex() {
        return this.m_columnListIndex;
    }

    public int getConditionIndex() {
        return this.m_conditionIndex;
    }

    public int[] getCustomActionIndex() {
        return this.m_customActionIndex;
    }

    public int[] getExceptionIndex() {
        return this.m_exceptionIndex;
    }

    public int getExpressionIndex() {
        return this.m_expressionIndex;
    }

    public int getLookupColumnIndex() {
        return this.m_lookupColumnIndex;
    }

    public int getLookupColumnNameIndex() {
        return this.m_lookupColumnNameIndex;
    }

    public int getLookupTableIndex() {
        return this.m_lookupTableIndex;
    }

    public int getLookupTableNameIndex() {
        return this.m_lookupTableNameIndex;
    }

    public int getNameIndex() {
        return this.m_nameIndex;
    }

    public int getTableIndex() {
        return this.m_tableIndex;
    }

    public int getTransFromIndex() {
        return this.m_transFromIndex;
    }

    public int getTransTableIndex() {
        return this.m_transTableIndex;
    }

    public int getTransToIndex() {
        return this.m_transToIndex;
    }

    public int getTypeIndex() {
        return this.m_typeIndex;
    }

    public int getMetaTypeIndex() {
        return this.m_metaTypeIndex;
    }

    public int getTransSetValueToIndex() {
        return this.m_transSetValueToIndex;
    }

    public int getTransSetValueToFlagIndex() {
        return this.m_transSetValueToFlagIndex;
    }

    public int getTransExceptionIndex() {
        return this.m_transExceptionIndex;
    }

    public int getNumValues() {
        return this.m_numValues;
    }

    public int getNumValues2() {
        return this.m_numValues2;
    }

    private class cComparator
    implements Comparator {
        private cComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }
}

