/*
 * Decompiled with CFR 0.152.
 */
package com.sas.codegen;

import com.sas.codegen.CodegenException;
import com.sas.codegen.CodegenRequest;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.Group;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.Repository;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class CodeConditionOptionsUtil {
    private static WAdminResource bundle = WAdminResource.getBundle(CodeConditionOptionsUtil.class);
    private static final String TRUE_ACTIONS = "True Actions";
    private static final String FALSE_ACTIONS = "False Actions";
    private static final String ACTIONS = "Actions";
    private static final String ACTION_EVENT = "Event";
    private static final String LIBREF = "Libref";
    private static final String EMAIL_ADDRESS = "Email Address";
    private static final String PATH_AND_FILE = "Path and File Name";
    private static final String DATASET_NAME = "Dataset Name";
    private static final String RETURN_CODE = "Return Code";
    private static final String TABLE_NAME = "Table Name (libref.table)";
    private static final String CUSTOM_CODE = "Custom Code";
    private static final String CUSTOM = "Custom";
    private static final String EMAIL = "Email";
    private static final String TEXTFILE = "Textfile";
    private static final String DATASET = "Dataset";
    private static final String JOB_STATUS = "JobStatus";
    private static final String SERVICE_COMPONENT = "ServiceComponent";
    private static final String LISTENER_TYPE = "ListenerType";
    private static final String SOFTWARE_COMPONENT = "SoftwareComponent";
    public static final String ABORT = "Abort";
    public static final String ABORT_ALL_PROCESSES = "AbortAllProcesses";
    public static final String ABORT_AFTER_LOOP = "AbortAfterLooping";
    public static final String CC_RC_SUCCESS = "Condition1";
    public static final String CC_RC_WARNING = "Condition2";
    public static final String CC_RC_ERROR = "Condition3";
    public static final String CC_DATA_MODIFIED = "Condition4";
    public static final String CC_TABLE_CREATED = "Condition5";
    public static final String CC_TABLE_DROPPED = "Condition6";
    public static final String CC_TABLE_TRUNCATED = "Condition8";
    public static final String CC_NOT_EXIST = "Condition9";
    public static final String CC_NO_METADATA_MATCH = "Condition10";
    public static final String CC_DATA_EXCEPTION = "Condition11";
    public static final String CC_JOB_STATUS = "Condition12";
    public static final String CC_PROCESS_STATS = "Condition13";

    private CodeConditionOptionsUtil() {
    }

    public static PropertySet getActionsPropertySet(Event oEvent, boolean bType) throws MdException, RemoteException {
        AssociationList alActionPropertySets = oEvent.getPropertySets();
        for (int iAction = 0; iAction < alActionPropertySets.size(); ++iAction) {
            PropertySet lActionPropertySet = (PropertySet)alActionPropertySets.get(iAction);
            if (bType && lActionPropertySet.getName().equals(TRUE_ACTIONS)) {
                return lActionPropertySet;
            }
            if (bType || !lActionPropertySet.getName().equals(FALSE_ACTIONS)) continue;
            return lActionPropertySet;
        }
        return null;
    }

    public static String getActionPropertyName(Property oAction, Property oActionOption) throws MdException, RemoteException {
        String sPropertyName = null;
        List lDefaultActions = null;
        lDefaultActions = CodeConditionOptionsUtil.getDefaultActions(oAction);
        for (int iDefaultAction = 0; iDefaultAction < lDefaultActions.size(); ++iDefaultAction) {
            Property oDefaultAction = (Property)lDefaultActions.get(iDefaultAction);
            if (!oDefaultAction.getPropertyName().equals(oAction.getPropertyName())) continue;
            AssociationList lDefaultActionOptions = oDefaultAction.getProperties();
            for (int iDefaultActionOption = 0; iDefaultActionOption < lDefaultActionOptions.size(); ++iDefaultActionOption) {
                Property oDefaultActionOption = (Property)lDefaultActionOptions.get(iDefaultActionOption);
                String oPropertyName = oActionOption.getPropertyName();
                if (!oDefaultActionOption.getPropertyName().equals(oPropertyName) && (oPropertyName.length() != 0 || !oDefaultActionOption.getName().equals(oActionOption.getName()))) continue;
                sPropertyName = oDefaultActionOption.getPropertyName();
                break;
            }
            if (sPropertyName != null) break;
        }
        return sPropertyName;
    }

    public static List getDefaultActions(Property oAction) throws MdException, RemoteException {
        AssociationList lActions = null;
        CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
        String sOptions = "<XMLSELECT Search=\"Group[@Name='Actions']\"/><TEMPLATES><Group Id=\"\" Name=\"\" Desc=\"\"><Members/><Properties/></Group></TEMPLATES>";
        List lGroups = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset(oAction.getObjectStore(), repos.getFQID(), "Group", 24972, sOptions);
        for (int iGroup = 0; iGroup < lGroups.size(); ++iGroup) {
            Group oGroup = (Group)lGroups.get(iGroup);
            if (!oGroup.getName().equals(ACTIONS)) continue;
            lActions = oGroup.getProperties();
        }
        return lActions;
    }

    public static String getActionMacroCall(Property oActionProperty) throws MdException, RemoteException {
        return CodeConditionOptionsUtil.getActionMacroCall(oActionProperty, null, "", null);
    }

    public static String getActionMacroCall(Property oActionProperty, AbstractTransformation mObject) throws MdException, RemoteException {
        return CodeConditionOptionsUtil.getActionMacroCall(oActionProperty, null, "", mObject);
    }

    public static String getActionMacroCall(Property oActionProperty, DataTable oDataTable, String sLibname) throws MdException, RemoteException {
        return CodeConditionOptionsUtil.getActionMacroCall(oActionProperty, oDataTable, sLibname, null);
    }

    public static String getActionMacroCall(Property oActionProperty, DataTable oDataTable, String sLibname, AbstractTransformation mObject) throws MdException, RemoteException {
        String indent2;
        String indent;
        StringBuffer code;
        Property oActionOption;
        int iAction;
        Repository[] reposArray = null;
        IOMI omiConnection = Workspace.getWorkspace().getCMRHandle();
        try {
            reposArray = Repository.getRepositories((IOMI)omiConnection);
        }
        catch (Exception ex) {
            throw new MdException((Throwable)ex);
        }
        String sReposId = oActionProperty.getRepositoryID();
        String sReposName = "";
        for (int iRepository = 0; iRepository < reposArray.length; ++iRepository) {
            Repository oRepository = reposArray[iRepository];
            String sId = oRepository.getFQID();
            if (sId.indexOf(sReposId) <= -1) continue;
            String sRepos = oRepository.getName();
            sReposName = sRepos.trim();
            break;
        }
        StringBuffer sbActionOptions = new StringBuffer();
        String sDate = "";
        AssociationList alActionOptions = oActionProperty.getProperties();
        SASCodeGeneration sasCode = new SASCodeGeneration();
        if (!oActionProperty.getDefaultValue().equals(ACTION_EVENT)) {
            String sLibref = "libref = ";
            String sAddress = "address = ";
            String sFileName = "filename = ";
            String sDataSet = "dataset = ";
            String sReturnCode = "returnCode = ";
            for (iAction = 0; iAction < alActionOptions.size(); ++iAction) {
                oActionOption = (Property)alActionOptions.get(iAction);
                String sPropertyName = oActionOption.getPropertyName();
                if (sPropertyName == null || sPropertyName.length() == 0) {
                    sPropertyName = CodeConditionOptionsUtil.getActionPropertyName(oActionProperty, oActionOption);
                }
                if (sbActionOptions.length() > 0) {
                    sbActionOptions.append("    ");
                }
                String actionValue = "%str(" + sasCode.escapeMacroValue(oActionOption.getDefaultValue()) + ")";
                if (sPropertyName != null) {
                    if (sPropertyName.equals(LIBREF)) {
                        sbActionOptions.append(sLibref).append(actionValue);
                    } else if (sPropertyName.equals(EMAIL_ADDRESS) && !oActionOption.getName().equals(oActionOption.getDesc())) {
                        sbActionOptions.append(sAddress).append(actionValue);
                    } else if (sPropertyName.equals(PATH_AND_FILE)) {
                        sbActionOptions.append(sFileName).append(actionValue);
                    } else if (sPropertyName.equals(DATASET_NAME)) {
                        sbActionOptions.append(sDataSet).append(actionValue);
                    } else if (sPropertyName.equals(RETURN_CODE)) {
                        sbActionOptions.append(sReturnCode).append(actionValue);
                    } else if (sPropertyName.equals(TABLE_NAME)) {
                        sbActionOptions.append(sFileName).append(actionValue);
                    } else if (sPropertyName.equals(CUSTOM_CODE) || sPropertyName.equals(CUSTOM)) {
                        sbActionOptions.append(oActionOption.getDefaultValue());
                    } else {
                        sbActionOptions.append(sPropertyName).append(" = ").append(actionValue);
                    }
                }
                if (iAction == alActionOptions.size() - 1) continue;
                sbActionOptions.append(", \n");
            }
        }
        String dateFormat = sasCode.isJobDateFormatNLS(mObject) ? "nldatm." : "datetime.";
        String sEventServer = null;
        if (oActionProperty.getDefaultValue().equals(EMAIL)) {
            code = new StringBuffer();
            indent = "   ";
            indent2 = indent + indent;
            code.append("%macro etls_sendEmail(address=, message=); \n\n").append(indent).append("filename sendMail email \"&address\" subject='ETL Process Status'; \n\n").append(sasCode.getNoSyntaxCheck(indent)).append("\n").append(indent).append("data _null_; \n").append(indent2).append("file sendMail; \n").append(indent2).append("dttm = put(datetime(),").append(dateFormat).append("); \n").append(indent2).append("put dttm \"&message.\"; \n").append(indent).append("run; \n\n").append(sasCode.getResetSyntaxCheck(indent)).append("%mend etls_sendEmail; \n").append("%etls_sendEmail \n").append("   (").append(sbActionOptions).append("); \n");
            return code.toString();
        }
        if (oActionProperty.getDefaultValue().equals(TEXTFILE)) {
            code = new StringBuffer();
            indent = "   ";
            indent2 = indent + indent;
            code.append("%macro etls_sendFile(directory=, filename=, message=); \n\n").append(indent).append("filename sendfile \"&directory.&filename\"; \n\n").append(sasCode.getNoSyntaxCheck(indent)).append("\n").append(indent).append("data _null_; \n").append(indent2).append("file sendFile; \n").append(indent2).append("dttm = put(datetime(),").append(dateFormat).append("); \n").append(indent2).append("put dttm \"&message.\"; \n").append(indent).append("run; \n\n").append(sasCode.getResetSyntaxCheck(indent)).append("%mend etls_sendFile; \n").append("%etls_sendFile \n").append("   (").append(sbActionOptions).append("); \n");
            return code.toString();
        }
        if (oActionProperty.getDefaultValue().equals(DATASET)) {
            code = new StringBuffer();
            indent = "   ";
            indent2 = indent + indent;
            code.append("%macro etls_sendData(libref=, dataset=, message=); \n\n").append(sasCode.getNoSyntaxCheck(indent)).append("\n").append(indent).append("data work.etls_tempData; \n").append(indent2).append("length message $80; \n").append(indent2).append("message = \"&message.\"; \n").append(indent2).append("datetime = put(datetime(),").append(dateFormat).append("); \n").append(indent).append("run; \n\n").append(sasCode.getObsMaxSet(indent)).append("\n").append(indent).append("proc append base=&libref..&dataset. data=work.etls_tempData force;").append(indent).append("run; \n\n").append(sasCode.getResetObs(indent)).append("\n").append(indent).append("proc datasets lib = work nolist; \n").append(indent2).append("delete etls_tempData; \n").append(indent).append("quit;\n\n").append(sasCode.getResetSyntaxCheck(indent)).append("%mend etls_sendData; \n").append("%etls_sendData \n").append("   (").append(sbActionOptions).append("); \n\n");
            return code.toString();
        }
        if (oActionProperty.getDefaultValue().equals(CUSTOM)) {
            return sbActionOptions + "\n";
        }
        if (oActionProperty.getDefaultValue().equals(JOB_STATUS)) {
            String dtFormat = sasCode.isJobDateFormatNLS(mObject) ? "nldatm18." : "datetime18.";
            StringBuffer code2 = new StringBuffer();
            String indent3 = "   ";
            String indent22 = indent3 + indent3;
            String indent32 = indent22 + indent3;
            code2.append("%macro etls_sendJobStatus(libref=, dataset=, metauser=); \n\n").append(sasCode.getNoSyntaxCheck(indent3)).append("\n").append(indent3).append("%local dsid etls_etvarnum etls_stvarnum etls_stfmt etls_etfmt; \n").append(indent3).append("%let dsid=%sysfunc(open(&libref..&dataset,i)); \n").append(indent3).append("%if &dsid %then \n").append(indent3).append("%do; \n").append(indent22).append("%let etls_stvarnum=%sysfunc(varnum(&dsid,STTIME)); \n").append(indent22).append("%if (&etls_stvarnum gt 0) %then \n").append(indent32).append("%let etls_stfmt=%sysfunc(varfmt(&dsid,&etls_stvarnum)); \n\n").append(indent22).append("%let etls_etvarnum=%sysfunc(varnum(&dsid,ENDTIME)); \n").append(indent22).append("%if (&etls_etvarnum gt 0) %then \n").append(indent32).append("%let etls_etfmt=%sysfunc(varfmt(&dsid,&etls_etvarnum)); \n\n").append(indent22).append("%let rc=%sysfunc(close(&dsid)); \n").append(indent3).append("%end; \n\n").append(indent3).append("%if (\"&etls_stfmt\" eq \"\") %then \n ").append(indent22).append("%let etls_stfmt = ").append(dtFormat).append("; \n").append(indent3).append("%if (\"&etls_etfmt\" eq \"\") %then \n").append(indent22).append("%let etls_etfmt = ").append(dtFormat).append("; \n\n").append(indent3).append("data work.etls_tempData; \n\n").append(indent22).append("attrib user length = $32 \n").append(indent22).append("            label = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.UserID.label.txt")).append("\"; \n").append(indent22).append("attrib rbefore length = 8 \n").append(indent22).append("               label = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.RBefore.label.txt")).append("\"; \n").append(indent22).append("attrib rafter length = 8 \n").append(indent22).append("            label = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.RAfter.label.txt")).append("\"; \n").append(indent22).append("attrib etl_table length = $32 \n").append(indent22).append("             label = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.TableName.label.txt")).append("\"; \n").append(indent22).append("attrib lib length = $32 \n").append(indent22).append("           label = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.Library.label.txt")).append("\"; \n").append(indent22).append("attrib jobname length = $80 \n").append(indent22).append("               label = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.JobName.label.txt")).append("\"; \n").append(indent22).append("attrib jobstat length = $80 \n").append(indent22).append("            label = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.JobStatus.label.txt")).append("\"; \n").append(indent22).append("attrib job_rc length = 8 \n").append(indent22).append("              label = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.JobReturnCode.label.txt")).append("\"; \n").append(indent22).append("attrib sttime length = 8 format = &etls_stfmt. \n").append(indent22).append("              label = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.JobStartTime.label.txt")).append("\"; \n").append(indent22).append("attrib endtime length = 8 format = &etls_etfmt. \n").append(indent22).append("               label = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.JobEndTime.label.txt")).append("\"; \n\n").append(indent22).append("user = \"&sysuserid\"; \n").append(indent22).append("rbefore = &etls_recordsBefore; \n").append(indent22).append("rafter = &etls_recordsAfter; \n").append(indent22).append("etl_table = \"&etls_table\"; \n").append(indent22).append("lib = \"&etls_lib\"; \n").append(indent22).append("jobname = \"&etls_jobName\"; \n").append(indent22).append("job_rc = &job_rc; \n\n").append(indent22).append("if job_rc = 0 then \n").append(indent22).append(indent3).append("jobstat = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.Successful.txt")).append("\"; \n").append(indent22).append("else if job_rc = 4 then \n").append(indent22).append(indent3).append("jobstat = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.Warning.txt")).append("\"; \n").append(indent22).append("else if job_rc > 4 then \n").append(indent22).append(indent3).append("jobstat = \"").append(bundle.getString("CodeConditionOptionsUtil.JobStatus.Error.txt")).append("\"; \n\n").append(indent22).append("sttime = \"&etls_startTime\"dt; \n").append(indent22).append("endtime = \"&etls_endTime\"dt; \n\n").append(indent3).append("run; \n\n").append(sasCode.getObsMaxSet(indent3)).append("\n").append(indent3).append("proc append base=&libref..&dataset data=work.etls_tempData force; \n").append(indent3).append("run; \n\n").append(sasCode.getResetObs(indent3)).append("\n").append(indent3).append("proc datasets lib = work nolist; \n").append(indent22).append("delete etls_tempData; \n").append(indent3).append("quit;\n\n").append(sasCode.getResetSyntaxCheck(indent3)).append("%mend etls_sendJobStatus; \n").append("%etls_sendJobStatus \n").append("   (").append(sbActionOptions).append("); \n\n");
            return code2.toString();
        }
        if (oActionProperty.getDefaultValue().equals(ACTION_EVENT)) {
            SoftwareComponent oSoftware = null;
            String sService = "";
            String sListenerType = "";
            for (iAction = 0; iAction < alActionOptions.size(); ++iAction) {
                oActionOption = (Property)alActionOptions.get(iAction);
                if (oActionOption.getPropertyRole().equals(LISTENER_TYPE)) {
                    sListenerType = oActionOption.getName();
                } else if (oActionOption.getPropertyRole().equals(SOFTWARE_COMPONENT)) {
                    CMetadata repos = Workspace.getWorkspace().getDefaultRepository();
                    String sOptions = "<XMLSELECT Search=\"SoftwareComponent[@Name= '" + oActionOption.getName() + "']\"/><TEMPLATES><SoftwareComponent Id=\"\" Name=\"\" Desc=\"\"><SoftwareTrees/></SoftwareComponent></TEMPLATES>";
                    MdObjectStore oStore = (MdObjectStore)oActionProperty.getObjectStore();
                    boolean bGoToServer = oStore.isGoToServerForMetadata();
                    oStore.setGoToServerForMetadata(true);
                    List lComponents = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)oStore, repos.getFQID(), SOFTWARE_COMPONENT, 8588, sOptions);
                    oStore.setGoToServerForMetadata(bGoToServer);
                    if (!lComponents.isEmpty()) {
                        oSoftware = (SoftwareComponent)lComponents.get(0);
                    }
                }
                if (oActionOption.getPropertyRole().equals(SERVICE_COMPONENT)) {
                    sService = oActionOption.getName();
                    continue;
                }
                if (!oActionOption.getPropertyRole().equals(ACTION_EVENT)) continue;
                sbActionOptions.append(oActionOption.getDefaultValue());
            }
            ServiceComponent oService = null;
            if (oSoftware != null) {
                AssociationList lSoftwareTrees = oSoftware.getSoftwareTrees();
                block5: for (int iSoftwareTree = 0; iSoftwareTree < lSoftwareTrees.size(); ++iSoftwareTree) {
                    Tree oTree = (Tree)lSoftwareTrees.get(iSoftwareTree);
                    AssociationList oMembers = oTree.getMembers();
                    for (int iMember = 0; iMember < oMembers.size(); ++iMember) {
                        DeployedComponent oComponent = (DeployedComponent)oMembers.get(iMember);
                        if (!(oComponent instanceof ServiceComponent) || !oComponent.getName().equals(sService)) continue;
                        oService = (ServiceComponent)oComponent;
                        continue block5;
                    }
                }
                AssociationList lInitProcesses = oService.getInitProcesses();
                int port = 0;
                String sHostName = null;
                for (int iInitProcess = 0; iInitProcess < lInitProcesses.size(); ++iInitProcess) {
                    Transformation oProcess = (Transformation)lInitProcesses.get(iInitProcess);
                    AssociationList lTransformationSources = oProcess.getTransformationSources();
                    for (int iTransformation = 0; iTransformation < lTransformationSources.size(); ++iTransformation) {
                        PropertySet oPropertySet = (PropertySet)lTransformationSources.get(iTransformation);
                        String role = oPropertySet.getSetRole();
                        if (!role.equals(sListenerType)) continue;
                        TCPIPConnection oListenerOwner = (TCPIPConnection)oPropertySet.getOwningObject();
                        sHostName = oListenerOwner.getHostName();
                        port = oListenerOwner.getPort();
                    }
                    sEventServer = "%let eventserver = http://" + sHostName + ":" + String.valueOf(port) + ";\n";
                }
                sbActionOptions.append(", \n").append("sentby = etlprocess, \n").append("eventserver = &eventserver");
                if (oDataTable != null) {
                    sbActionOptions.append(", \n").append("props=dataset lib repos chgdate , \n").append("vals=");
                    String sName = "";
                    if (oDataTable instanceof PhysicalTable) {
                        sName = ((PhysicalTable)oDataTable).getSASTableName();
                    }
                    sbActionOptions.append(sName + "##");
                    sbActionOptions.append(sLibname + "##");
                    sbActionOptions.append(sReposName + "##");
                    sbActionOptions.append("&chgdate.##");
                    sDate = "%let chgdate = %sysfunc(datetime()," + dateFormat + ");\n";
                } else {
                    sbActionOptions.append(", props= ,\n  vals=");
                }
                return sDate + sEventServer + "%sendEvnt(" + sbActionOptions + "); \n";
            }
            throw new CodegenException(bundle.getString("CodeConditionOptionsUtil.NoEventBroker.msg.txt"));
        }
        if (oActionProperty.getDefaultValue().equals(ABORT) || oActionProperty.getDefaultValue().equals(ABORT_ALL_PROCESSES) || oActionProperty.getDefaultValue().equals(ABORT_AFTER_LOOP)) {
            int index = sbActionOptions.indexOf("=");
            String returnCode = sbActionOptions.substring(index + 1);
            String abortCode = CodegenRequest.makeAbortJobCode(returnCode);
            return abortCode;
        }
        return "";
    }
}

