/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter.etl.expression;

import MITI.converter.etl.expression.AbstractExpressionAnalyzer;
import MITI.messages.MIRModelConverter.MBCONV;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRStatementNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HavingExpressionAnalyzer
extends AbstractExpressionAnalyzer {
    Map<MIRExpressionNode, MIRFeature> aggExpressions = new HashMap<MIRExpressionNode, MIRFeature>();
    Map<MIRExpressionNode, MIRFeature> aggregations = new HashMap<MIRExpressionNode, MIRFeature>();
    Map<MIRExpressionNode, MIRFeature> expressions = new HashMap<MIRExpressionNode, MIRFeature>();
    MIRExpression expression;

    public HavingExpressionAnalyzer(MIRDiModel mIRDiModel) {
        super(mIRDiModel);
    }

    public void parseHaving(MIRExpression mIRExpression) {
        this.expression = mIRExpression;
        if (mIRExpression == null) {
            return;
        }
        for (MIRStatementNode mIRStatementNode : mIRExpression.getStatementNodes()) {
            MIRElement mIRElement;
            MIRExpressionNode mIRExpressionNode = mIRStatementNode.getExpressionNodes().first();
            if (mIRExpressionNode.getElementType() != 115) continue;
            MIROperatorNode mIROperatorNode = (MIROperatorNode)mIRExpressionNode;
            MIRExpressionNode mIRExpressionNode2 = mIROperatorNode.getLeftExpressionNode();
            if (this.getIntermediateFeature(mIRExpressionNode2) == null && mIRExpressionNode2.getElementType() != 104 && mIRExpressionNode2.getElementType() != 111) {
                mIRElement = this.createIntermediateColumn(mIRExpressionNode2);
                this.aggregations.put(mIRExpressionNode2, (MIRFeature)mIRElement);
            }
            if (this.getIntermediateFeature((MIRExpressionNode)(mIRElement = mIROperatorNode.getLeftExpressionNode())) != null || ((MIRExpressionNode)mIRElement).getElementType() == 104 || ((MIRExpressionNode)mIRElement).getElementType() == 111) continue;
            MIRFeature mIRFeature = this.createIntermediateColumn((MIRExpressionNode)mIRElement);
            this.aggregations.put((MIRExpressionNode)mIRElement, mIRFeature);
        }
    }

    public MIRFeatureMap getHavingFeatureMap() {
        MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
        MIRExpression mIRExpression = (MIRExpression)this.expression.clone();
        mIRFeatureMap.addExpression(mIRExpression);
        for (MIRElement mIRElement : this.expression.getStatementNodes()) {
            MIRExpressionNode mIRExpressionNode = this.cloneExpressionNode((MIRExpressionNode)mIRElement);
            MIRStatementNode mIRStatementNode = (MIRStatementNode)mIRExpressionNode;
            if (mIRStatementNode != null) {
                mIRExpression.addStatementNode(mIRStatementNode);
                continue;
            }
            MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(this.expression.getElementType()));
        }
        for (MIRElement mIRElement : this.srcfeatures) {
            mIRFeatureMap.addSourceFeature((MIRFeature)mIRElement);
        }
        this.srcfeatures.clear();
        return mIRFeatureMap;
    }

    public Set<MIRFeatureMap> getAggExpressionFeatureMaps() {
        HashSet<MIRFeatureMap> hashSet = new HashSet<MIRFeatureMap>();
        for (Map.Entry<MIRExpressionNode, MIRFeature> entry : this.aggExpressions.entrySet()) {
            MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
            MIRExpression mIRExpression = new MIRExpression();
            MIRStatementNode mIRStatementNode = new MIRStatementNode();
            mIRExpression.addStatementNode(mIRStatementNode);
            mIRStatementNode.addExpressionNode(this.cloneExpressionNode(entry.getKey(), true));
            mIRFeatureMap.addExpression(mIRExpression);
            mIRFeatureMap.addDestinationFeature(entry.getValue());
            for (MIRFeature mIRFeature : this.srcfeatures) {
                mIRFeatureMap.addSourceFeature(mIRFeature);
            }
            this.srcfeatures.clear();
            hashSet.add(mIRFeatureMap);
        }
        return hashSet;
    }

    public Set<MIRFeatureMap> getAggFeatureMaps() {
        HashSet<MIRFeatureMap> hashSet = new HashSet<MIRFeatureMap>();
        for (Map.Entry<MIRExpressionNode, MIRFeature> entry : this.aggregations.entrySet()) {
            MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
            MIRExpression mIRExpression = new MIRExpression();
            MIRStatementNode mIRStatementNode = new MIRStatementNode();
            mIRExpression.addStatementNode(mIRStatementNode);
            mIRStatementNode.addExpressionNode(this.cloneExpressionNode(entry.getKey(), true));
            mIRFeatureMap.addExpression(mIRExpression);
            mIRFeatureMap.addDestinationFeature(entry.getValue());
            for (MIRFeature mIRFeature : this.srcfeatures) {
                mIRFeatureMap.addSourceFeature(mIRFeature);
            }
            this.srcfeatures.clear();
            hashSet.add(mIRFeatureMap);
        }
        return hashSet;
    }

    @Override
    protected MIRFeature getIntermediateFeature(MIRExpressionNode mIRExpressionNode) {
        MIRFeature mIRFeature = this.expressions.get(mIRExpressionNode);
        if (mIRFeature == null) {
            mIRFeature = this.aggregations.get(mIRExpressionNode);
        }
        if (mIRFeature == null) {
            mIRFeature = this.aggExpressions.get(mIRExpressionNode);
        }
        return mIRFeature;
    }
}

