/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter.etl.expression;

import MITI.converter.etl.expression.AbstractExpressionAnalyzer;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIRStatementNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GroupByExpressionAnalyzer
extends AbstractExpressionAnalyzer {
    Map<MIRExpressionNode, MIRFeature> aggregationExpressions = new HashMap<MIRExpressionNode, MIRFeature>();
    Map<MIRExpressionNode, MIRFeature> aggregations = new HashMap<MIRExpressionNode, MIRFeature>();
    Map<MIRExpressionNode, MIRFeature> expressions = new HashMap<MIRExpressionNode, MIRFeature>();
    Set<MIRFeature> temporaryFeatures = new HashSet<MIRFeature>();

    public void deleteTemporaryFeatures() {
        for (MIRFeature mIRFeature : this.temporaryFeatures) {
            mIRFeature.delete();
        }
    }

    public GroupByExpressionAnalyzer(MIRDiModel mIRDiModel) {
        super(mIRDiModel);
    }

    public boolean hasComplexExpression() {
        return this.aggregationExpressions.size() > 0 || this.expressions.size() > 0;
    }

    public void parse(MIRFeatureMap mIRFeatureMap) {
        MIRExpression mIRExpression = mIRFeatureMap.getExpression();
        if (mIRExpression == null) {
            return;
        }
        MIRFeature mIRFeature = mIRFeatureMap.getDestinationFeature();
        if (mIRFeature.getElementType() != 255) {
            return;
        }
        for (MIRStatementNode mIRStatementNode : mIRExpression.getStatementNodes()) {
            for (MIRExpressionNode mIRExpressionNode : mIRStatementNode.getExpressionNodes()) {
                Object object;
                Set<MIRExpressionNode> set = this.collectAggregations(mIRExpressionNode);
                if (set.size() == 0) {
                    this.expressions.put(mIRExpressionNode, mIRFeature);
                    continue;
                }
                if (set.size() == 1) {
                    MIRElement mIRElement;
                    MIRExpressionNode mIRExpressionNode2;
                    MIRExpressionNode mIRExpressionNode3 = set.iterator().next();
                    if (mIRExpressionNode3 == mIRExpressionNode) {
                        this.aggregations.put(mIRExpressionNode, mIRFeature);
                        mIRExpressionNode2 = (MIROperationNode)mIRExpressionNode3;
                        for (MIRExpressionNode mIRExpressionNode4 : ((MIROperationNode)mIRExpressionNode2).getExpressionNodes()) {
                            if (mIRExpressionNode4.getElementType() != 114 && mIRExpressionNode4.getElementType() != 115) continue;
                            mIRElement = this.createIntermediateColumn(mIRExpressionNode4);
                            this.expressions.put(mIRExpressionNode4, (MIRFeature)mIRElement);
                        }
                        continue;
                    }
                    mIRExpressionNode2 = (MIROperationNode)mIRExpressionNode3;
                    for (MIRExpressionNode mIRExpressionNode5 : ((MIROperationNode)mIRExpressionNode2).getExpressionNodes()) {
                        if (mIRExpressionNode5.getElementType() != 114 && mIRExpressionNode5.getElementType() != 115) continue;
                        mIRElement = this.createIntermediateColumn(mIRExpressionNode5);
                        this.expressions.put(mIRExpressionNode5, (MIRFeature)mIRElement);
                    }
                    object = this.createIntermediateColumn(mIRExpressionNode3);
                    this.aggregations.put(mIRExpressionNode3, (MIRFeature)object);
                    this.aggregationExpressions.put(mIRExpressionNode, mIRFeature);
                    continue;
                }
                for (MIRExpressionNode mIRExpressionNode2 : set) {
                    object = (MIROperationNode)mIRExpressionNode2;
                    for (MIRElement mIRElement : ((MIROperationNode)object).getExpressionNodes()) {
                        if (mIRElement.getElementType() != 114 && mIRElement.getElementType() != 115) continue;
                        MIRFeature mIRFeature2 = this.createIntermediateColumn((MIRExpressionNode)mIRElement);
                        this.expressions.put((MIRExpressionNode)mIRElement, mIRFeature2);
                    }
                    MIRFeature mIRFeature3 = this.createIntermediateColumn(mIRExpressionNode2);
                    this.aggregations.put(mIRExpressionNode2, mIRFeature3);
                }
                this.aggregationExpressions.put(mIRExpressionNode, mIRFeature);
            }
        }
    }

    public Set<AbstractExpressionAnalyzer.Stuff> getAggregationFeatureMaps() {
        HashSet<AbstractExpressionAnalyzer.Stuff> hashSet = new HashSet<AbstractExpressionAnalyzer.Stuff>();
        for (Map.Entry<MIRExpressionNode, MIRFeature> entry : this.aggregations.entrySet()) {
            AbstractExpressionAnalyzer.Stuff stuff = new AbstractExpressionAnalyzer.Stuff();
            stuff.destination = entry.getValue();
            MIRExpression mIRExpression = new MIRExpression();
            MIRStatementNode mIRStatementNode = new MIRStatementNode();
            mIRExpression.addStatementNode(mIRStatementNode);
            stuff.expression = mIRExpression;
            this.srcfeatures.clear();
            MIRExpressionNode mIRExpressionNode = this.cloneExpressionNode(entry.getKey(), true);
            mIRStatementNode.addExpressionNode(mIRExpressionNode);
            for (MIRFeature mIRFeature : this.srcfeatures) {
                stuff.sourceFeatures.add(mIRFeature);
            }
            hashSet.add(stuff);
        }
        return hashSet;
    }

    public Set<AbstractExpressionAnalyzer.Stuff> getExpressionMaps() {
        HashSet<AbstractExpressionAnalyzer.Stuff> hashSet = new HashSet<AbstractExpressionAnalyzer.Stuff>();
        for (Map.Entry<MIRExpressionNode, MIRFeature> entry : this.expressions.entrySet()) {
            AbstractExpressionAnalyzer.Stuff stuff = new AbstractExpressionAnalyzer.Stuff();
            stuff.destination = entry.getValue();
            MIRExpression mIRExpression = new MIRExpression();
            MIRStatementNode mIRStatementNode = new MIRStatementNode();
            mIRExpression.addStatementNode(mIRStatementNode);
            stuff.expression = mIRExpression;
            this.srcfeatures.clear();
            MIRExpressionNode mIRExpressionNode = this.cloneExpressionNode(entry.getKey(), true);
            if (mIRExpressionNode != null) {
                mIRStatementNode.addExpressionNode(mIRExpressionNode);
            }
            for (MIRFeature mIRFeature : this.srcfeatures) {
                stuff.sourceFeatures.add(mIRFeature);
            }
            hashSet.add(stuff);
        }
        return hashSet;
    }

    public Set<AbstractExpressionAnalyzer.Stuff> getAggExpressionMaps() {
        HashSet<AbstractExpressionAnalyzer.Stuff> hashSet = new HashSet<AbstractExpressionAnalyzer.Stuff>();
        for (Map.Entry<MIRExpressionNode, MIRFeature> entry : this.aggregationExpressions.entrySet()) {
            AbstractExpressionAnalyzer.Stuff stuff = new AbstractExpressionAnalyzer.Stuff();
            stuff.destination = entry.getValue();
            MIRExpression mIRExpression = new MIRExpression();
            MIRStatementNode mIRStatementNode = new MIRStatementNode();
            mIRExpression.addStatementNode(mIRStatementNode);
            stuff.expression = mIRExpression;
            this.srcfeatures.clear();
            MIRExpressionNode mIRExpressionNode = this.cloneExpressionNode(entry.getKey(), true);
            mIRStatementNode.addExpressionNode(mIRExpressionNode);
            for (MIRFeature mIRFeature : this.srcfeatures) {
                stuff.sourceFeatures.add(mIRFeature);
            }
            hashSet.add(stuff);
        }
        return hashSet;
    }

    @Override
    protected MIRFeature getIntermediateFeature(MIRExpressionNode mIRExpressionNode) {
        MIRFeature mIRFeature = this.expressions.get(mIRExpressionNode);
        if (mIRFeature == null) {
            mIRFeature = this.aggregations.get(mIRExpressionNode);
        }
        if (mIRFeature == null) {
            mIRFeature = this.aggregationExpressions.get(mIRExpressionNode);
        }
        return mIRFeature;
    }

    @Override
    protected MIRFeature createIntermediateColumn(MIRExpressionNode mIRExpressionNode) {
        MIRFeature mIRFeature = super.createIntermediateColumn(mIRExpressionNode);
        this.temporaryFeatures.add(mIRFeature);
        return mIRFeature;
    }
}

