/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter.etl.expression;

import MITI.MIRException;
import MITI.converter.etl.FeatureMapper;
import MITI.messages.MIRModelConverter.MBCONV;
import MITI.sdk.MIRBranchingNode;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConstantNode;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRPredicate;
import MITI.sdk.MIRPredicateNode;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRStatementNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpressionCopier {
    Set<MIRClassifier> sourceDataSets;
    FeatureMapper mapper;
    Map<String, MIRClassifier> originalClassifiersAliases = new HashMap<String, MIRClassifier>();

    public MIRExpression cloneExpression(MIRExpression mIRExpression, Set<MIRClassifier> set, FeatureMapper featureMapper) throws MIRException {
        MIRObject mIRObject;
        MIRElement mIRElement;
        this.sourceDataSets = set;
        this.mapper = featureMapper;
        MIRFeatureMap mIRFeatureMap = mIRExpression.getFeatureMap();
        if (mIRFeatureMap != null && (mIRElement = mIRFeatureMap.getClassifierMap()) != null) {
            for (MIRClassifier mIRElement2 : ((MIRClassifierMap)mIRElement).getSourceClassifiers()) {
                mIRObject = mIRElement2.getPropertyValue("alias");
                if (mIRObject == null || ((MIRPropertyValue)mIRObject).getValue().isEmpty()) continue;
                this.originalClassifiersAliases.put(((MIRPropertyValue)mIRObject).getValue(), mIRElement2);
            }
        }
        mIRElement = (MIRExpression)mIRExpression.clone();
        for (MIRStatementNode mIRStatementNode : mIRExpression.getStatementNodes()) {
            mIRObject = (MIRStatementNode)this.cloneExpressionNode(mIRStatementNode);
            if (mIRObject != null) {
                ((MIRExpression)mIRElement).addStatementNode((MIRStatementNode)mIRObject);
                continue;
            }
            MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIRExpression.getElementType()));
        }
        return mIRElement;
    }

    private MIRExpressionNode cloneExpressionNode(MIRExpressionNode mIRExpressionNode) throws MIRException {
        MIRExpressionNode mIRExpressionNode2 = null;
        if (mIRExpressionNode != null) {
            switch (mIRExpressionNode.getElementType()) {
                case 103: {
                    mIRExpressionNode2 = this.cloneBranchingNode((MIRBranchingNode)mIRExpressionNode);
                    break;
                }
                case 104: {
                    mIRExpressionNode2 = this.cloneConstantNode((MIRConstantNode)mIRExpressionNode);
                    break;
                }
                case 107: {
                    mIRExpressionNode2 = this.cloneDelimiterNode((MIRDelimiterNode)mIRExpressionNode);
                    break;
                }
                case 111: {
                    mIRExpressionNode2 = this.cloneElementNode((MIRElementNode)mIRExpressionNode);
                    break;
                }
                case 114: {
                    mIRExpressionNode2 = this.cloneOperationNode((MIROperationNode)mIRExpressionNode);
                    break;
                }
                case 115: {
                    mIRExpressionNode2 = this.cloneOperatorNode((MIROperatorNode)mIRExpressionNode);
                    break;
                }
                case 118: {
                    mIRExpressionNode2 = this.clonePredicateNode((MIRPredicateNode)mIRExpressionNode);
                    break;
                }
                case 339: {
                    MBCONV.WARN_EXPRESSION_CLONE_NODE_NOT_SUPPORTED.log(MIRElementType.getName(mIRExpressionNode.getElementType()));
                    break;
                }
                case 134: {
                    mIRExpressionNode2 = this.cloneStatementNode((MIRStatementNode)mIRExpressionNode);
                    break;
                }
                default: {
                    MBCONV.WARN_EXPRESSION_CLONE_NODE_NOT_SUPPORTED.log(MIRElementType.getName(mIRExpressionNode.getElementType()));
                }
            }
        }
        return mIRExpressionNode2;
    }

    protected MIRBranchingNode cloneBranchingNode(MIRBranchingNode mIRBranchingNode) throws MIRException {
        MIRBranchingNode mIRBranchingNode2 = new MIRBranchingNode();
        mIRBranchingNode2.setFrom(mIRBranchingNode);
        if (mIRBranchingNode.getConditionExpressionNode() != null) {
            mIRBranchingNode2.addConditionExpressionNode(this.cloneExpressionNode(mIRBranchingNode.getConditionExpressionNode()));
        }
        List<MIRExpressionNode> list = mIRBranchingNode.getExpressionNodeByPosition();
        for (int i = 0; i < list.size(); ++i) {
            mIRBranchingNode2.addExpressionNode(this.cloneExpressionNode(list.get(i)));
        }
        return mIRBranchingNode2;
    }

    protected MIRDelimiterNode cloneDelimiterNode(MIRDelimiterNode mIRDelimiterNode) throws MIRException {
        MIRDelimiterNode mIRDelimiterNode2 = new MIRDelimiterNode();
        mIRDelimiterNode2.setFrom(mIRDelimiterNode);
        List<MIRExpressionNode> list = mIRDelimiterNode.getExpressionNodeByPosition();
        for (int i = 0; i < list.size(); ++i) {
            mIRDelimiterNode2.addExpressionNode(this.cloneExpressionNode(list.get(i)));
        }
        if (mIRDelimiterNode.getConditionExpressionNode() != null) {
            mIRDelimiterNode2.addConditionExpressionNode(this.cloneExpressionNode(mIRDelimiterNode.getConditionExpressionNode()));
        }
        return mIRDelimiterNode2;
    }

    protected MIRPredicateNode clonePredicateNode(MIRPredicateNode mIRPredicateNode) throws MIRException {
        MIRPredicateNode mIRPredicateNode2 = new MIRPredicateNode();
        mIRPredicateNode2.setFrom(mIRPredicateNode);
        List<MIRPredicate> list = mIRPredicateNode.getPredicateByPosition();
        for (int i = 0; i < list.size(); ++i) {
            MIRPredicate mIRPredicate = new MIRPredicate();
            mIRPredicate.setFrom(list.get(i));
            mIRPredicateNode2.addPredicate(mIRPredicate);
        }
        if (mIRPredicateNode.getExpressionNode() != null) {
            mIRPredicateNode2.addExpressionNode(this.cloneExpressionNode(mIRPredicateNode.getExpressionNode()));
        }
        return mIRPredicateNode2;
    }

    private MIRStatementNode cloneStatementNode(MIRStatementNode mIRStatementNode) throws MIRException {
        MIRStatementNode mIRStatementNode2 = (MIRStatementNode)mIRStatementNode.clone();
        for (MIRExpressionNode mIRExpressionNode : mIRStatementNode.getExpressionNodes()) {
            MIRExpressionNode mIRExpressionNode2 = this.cloneExpressionNode(mIRExpressionNode);
            if (mIRExpressionNode2 != null) {
                mIRStatementNode2.addExpressionNode(mIRExpressionNode2);
                continue;
            }
            MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIRStatementNode.getElementType()));
        }
        return mIRStatementNode2;
    }

    private MIRConstantNode cloneConstantNode(MIRConstantNode mIRConstantNode) {
        MIRConstantNode mIRConstantNode2 = new MIRConstantNode();
        mIRConstantNode2.setFrom(mIRConstantNode);
        return mIRConstantNode2;
    }

    private MIRElementNode cloneElementNode(MIRElementNode mIRElementNode) throws MIRException {
        MIRObject mIRObject;
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        String string = "";
        String string2 = null;
        MIRElement mIRElement = null;
        if (list.size() > 1) {
            mIRObject = list.get(list.size() - 1);
            string = mIRObject.getName();
            mIRElement = ((MIRElementNamePart)mIRObject).getReferencedElement(string);
            string2 = list.get(list.size() - 2).getName();
        } else if (list.size() > 0) {
            mIRObject = list.get(0);
            string = mIRObject.getName();
            mIRElement = ((MIRElementNamePart)mIRObject).getReferencedElement(mIRObject.getName());
            if (mIRElement == null && ((MIRElementNamePart)mIRObject).getReferencedElementCount() > 0) {
                mIRElement = ((MIRElementNamePart)mIRObject).getReferencedElements().first();
            }
        }
        if (mIRElement == null && string2 != null && (mIRObject = this.originalClassifiersAliases.get(string2)) != null) {
            mIRElement = ((MIRClassifier)mIRObject).getFeature(string);
        }
        mIRObject = null;
        if (mIRElement != null) {
            mIRObject = new MIRElementNode();
            MIRClassifier mIRClassifier = null;
            MIRFeature mIRFeature = null;
            for (MIRClassifier mIRClassifier2 : this.sourceDataSets) {
                MIRFeature mIRFeature2 = this.mapper.getCopyOfOriginalFeature(mIRClassifier2, (MIRFeature)mIRElement);
                if (mIRFeature2 == null) continue;
                mIRClassifier = mIRClassifier2;
                mIRFeature = mIRFeature2;
                break;
            }
            if (this.sourceDataSets.size() == 1) {
                mIRClassifier = null;
            }
            if (mIRFeature != null) {
                mIRObject = this.createElementNode(mIRFeature, mIRClassifier);
            } else {
                mIRObject = new MIRElementNode();
                MIRElementNamePart mIRElementNamePart = new MIRElementNamePart();
                mIRElementNamePart.setPosition((short)0);
                mIRElementNamePart.setName(mIRElement.getName());
                ((MIRElementNode)mIRObject).addElementNamePart(mIRElementNamePart);
                mIRObject.setName(mIRElement.getName());
            }
        } else {
            mIRObject = new MIRElementNode();
            mIRObject.setName(mIRElementNode.getName());
            MIRElementNamePart mIRElementNamePart = new MIRElementNamePart();
            mIRElementNamePart.setPosition((short)0);
            mIRElementNamePart.setName(mIRElementNode.getName());
            ((MIRElementNode)mIRObject).addElementNamePart(mIRElementNamePart);
            MBCONV.CAN_NOT_GET_REFERENCED_ELEMENT.log(mIRElementNode.getName());
        }
        return mIRObject;
    }

    private MIRElementNode createElementNode(MIRFeature mIRFeature, MIRClassifier mIRClassifier) {
        MIRElementNode mIRElementNode = null;
        if (mIRFeature != null) {
            MIRElementNamePart mIRElementNamePart;
            mIRElementNode = new MIRElementNode();
            int n = 0;
            if (mIRClassifier != null) {
                mIRElementNamePart = new MIRElementNamePart();
                mIRElementNamePart.setPosition((short)n++);
                mIRElementNamePart.addReferencedElement(mIRClassifier);
                mIRElementNamePart.setName(mIRClassifier.getName());
                mIRElementNode.addElementNamePart(mIRElementNamePart);
            }
            mIRElementNamePart = new MIRElementNamePart();
            mIRElementNamePart.setPosition((short)n++);
            mIRElementNamePart.addReferencedElement(mIRFeature);
            String string = mIRFeature.getPhysicalName().isEmpty() ? mIRFeature.getName() : mIRFeature.getPhysicalName();
            mIRElementNamePart.setName(string);
            mIRElementNode.addElementNamePart(mIRElementNamePart);
            if (mIRClassifier != null) {
                mIRElementNode.setName(mIRClassifier.getName() + "." + string);
            } else {
                mIRElementNode.setName(string);
            }
        }
        return mIRElementNode;
    }

    private MIROperationNode cloneOperationNode(MIROperationNode mIROperationNode) throws MIRException {
        MIROperationNode mIROperationNode2 = new MIROperationNode();
        mIROperationNode2.setFrom(mIROperationNode);
        List<MIRExpressionNode> list = mIROperationNode.getExpressionNodeByPosition();
        for (int i = 0; i < list.size(); ++i) {
            MIRExpressionNode mIRExpressionNode = this.cloneExpressionNode(list.get(i));
            if (mIRExpressionNode != null) {
                mIROperationNode2.addExpressionNode(mIRExpressionNode);
                continue;
            }
            MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIROperationNode.getElementType()));
        }
        return mIROperationNode2;
    }

    private MIROperatorNode cloneOperatorNode(MIROperatorNode mIROperatorNode) throws MIRException {
        MIRExpressionNode mIRExpressionNode;
        MIROperatorNode mIROperatorNode2 = new MIROperatorNode();
        mIROperatorNode2.setFrom(mIROperatorNode);
        if (mIROperatorNode.getLeftExpressionNode() != null) {
            mIRExpressionNode = this.cloneExpressionNode(mIROperatorNode.getLeftExpressionNode());
            if (mIRExpressionNode != null) {
                mIROperatorNode2.addLeftExpressionNode(mIRExpressionNode);
            } else {
                MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIROperatorNode.getElementType()));
            }
        }
        if (mIROperatorNode.getRightExpressionNode() != null) {
            mIRExpressionNode = this.cloneExpressionNode(mIROperatorNode.getRightExpressionNode());
            if (mIRExpressionNode != null) {
                mIROperatorNode2.addRightExpressionNode(mIRExpressionNode);
            } else {
                MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIROperatorNode.getElementType()));
            }
        }
        if (mIROperatorNode.getConditionExpressionNode() != null) {
            mIRExpressionNode = this.cloneExpressionNode(this.cloneExpressionNode(mIROperatorNode.getConditionExpressionNode()));
            if (mIRExpressionNode != null) {
                mIROperatorNode2.addConditionExpressionNode(mIRExpressionNode);
            } else {
                MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIROperatorNode.getElementType()));
            }
        }
        return mIROperatorNode2;
    }
}

