/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter.etl.expression;

import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.expression.datatypes.MIRExpressionDataType;
import MITI.expression.datatypes.MIRExpressionDataTypeInfo;
import MITI.expression.functions.MIRFunctionMapping;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelConverter.MBCONV;
import MITI.sdk.MIRBaseType;
import MITI.sdk.MIRBaseTypeList;
import MITI.sdk.MIRBranchingNode;
import MITI.sdk.MIRConstantNode;
import MITI.sdk.MIRDelimiterNode;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIROperationNode;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRPredicate;
import MITI.sdk.MIRPredicateNode;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRTransformationDataAttribute;
import MITI.sdk.MIRTransformationDataSet;
import MITI.sdk.MIRType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractExpressionAnalyzer {
    MIRFunctionMapping mirFunctionMapping = new MIRFunctionMapping(0, 0);
    MIRDiModel model = null;
    protected Set<MIRFeature> srcfeatures = new HashSet<MIRFeature>();

    public AbstractExpressionAnalyzer(MIRDiModel mIRDiModel) {
        this.model = mIRDiModel;
    }

    protected Set<MIRExpressionNode> collectAggregations(MIRExpressionNode mIRExpressionNode) {
        HashSet<MIRExpressionNode> hashSet = new HashSet<MIRExpressionNode>();
        switch (mIRExpressionNode.getElementType()) {
            case 114: {
                MIROperationNode mIROperationNode = (MIROperationNode)mIRExpressionNode;
                if (this.mirFunctionMapping.isAggregation(mIRExpressionNode.getName(), 1) || this.mirFunctionMapping.isAggregation(mIRExpressionNode.getName(), 0)) {
                    hashSet.add(mIRExpressionNode);
                    return hashSet;
                }
                List<MIRExpressionNode> list = mIROperationNode.getExpressionNodeByPosition();
                for (int i = 0; i < list.size(); ++i) {
                    hashSet.addAll(this.collectAggregations(list.get(i)));
                }
                break;
            }
            case 115: {
                MIROperatorNode mIROperatorNode = (MIROperatorNode)mIRExpressionNode;
                if (mIROperatorNode.getLeftExpressionNode() != null) {
                    hashSet.addAll(this.collectAggregations(mIROperatorNode.getLeftExpressionNode()));
                }
                if (mIROperatorNode.getRightExpressionNode() == null) break;
                hashSet.addAll(this.collectAggregations(mIROperatorNode.getRightExpressionNode()));
                break;
            }
            case 134: {
                MIRStatementNode mIRStatementNode = (MIRStatementNode)mIRExpressionNode;
                for (MIRExpressionNode mIRExpressionNode2 : mIRStatementNode.getExpressionNodes()) {
                    hashSet.addAll(this.collectAggregations(mIRExpressionNode2));
                }
                break;
            }
        }
        return hashSet;
    }

    protected static MIRElement getReferencedElement(MIRElementNode mIRElementNode) {
        List<MIRElementNamePart> list = mIRElementNode.getElementNamePartByPosition();
        MIRElement mIRElement = null;
        if (list.size() > 1) {
            MIRElementNamePart mIRElementNamePart = list.get(1);
            mIRElement = mIRElementNamePart.getReferencedElement(mIRElementNamePart.getName());
        } else if (list.size() > 0) {
            MIRElementNamePart mIRElementNamePart = list.get(0);
            mIRElement = mIRElementNamePart.getReferencedElement(mIRElementNamePart.getName());
        }
        return mIRElement;
    }

    protected static MIRElementNode createElementNode(MIRFeature mIRFeature, MIRTransformationDataSet mIRTransformationDataSet) {
        MIRElementNode mIRElementNode = null;
        if (mIRFeature != null) {
            MIRElementNamePart mIRElementNamePart;
            mIRElementNode = new MIRElementNode();
            int n = 0;
            if (mIRTransformationDataSet != null) {
                mIRElementNamePart = new MIRElementNamePart();
                mIRElementNamePart.setPosition((short)n++);
                mIRElementNamePart.addReferencedElement(mIRTransformationDataSet);
                mIRElementNamePart.setName(mIRTransformationDataSet.getName());
                mIRElementNode.addElementNamePart(mIRElementNamePart);
            }
            mIRElementNamePart = new MIRElementNamePart();
            mIRElementNamePart.setPosition((short)n++);
            mIRElementNamePart.addReferencedElement(mIRFeature);
            mIRElementNamePart.setName(mIRFeature.getName());
            mIRElementNode.addElementNamePart(mIRElementNamePart);
            if (mIRTransformationDataSet != null) {
                mIRElementNode.setName(mIRTransformationDataSet.getName() + "." + mIRFeature.getName());
            } else {
                mIRElementNode.setName(mIRFeature.getName());
            }
        }
        return mIRElementNode;
    }

    protected MIRFeature createIntermediateColumn(MIRExpressionNode mIRExpressionNode) {
        if (mIRExpressionNode.getElementType() == 111) {
            return (MIRFeature)AbstractExpressionAnalyzer.getReferencedElement((MIRElementNode)mIRExpressionNode);
        }
        MIRTransformationDataAttribute mIRTransformationDataAttribute = new MIRTransformationDataAttribute();
        String string = AbstractExpressionAnalyzer.generateName(mIRExpressionNode);
        mIRTransformationDataAttribute.setName(string);
        MIRType mIRType = this.buildDataType(mIRExpressionNode.getDataType());
        if (mIRType == null) {
            MIRElementNode mIRElementNode;
            MIRElement mIRElement;
            BLIB.DBG_DEBUG.log(String.format("Getting type from one of the source features for '%s' feature", string));
            Set<MIRElementNode> set = AbstractExpressionAnalyzer.collectElementNodes(mIRExpressionNode);
            Iterator<MIRElementNode> iterator = set.iterator();
            while (iterator.hasNext() && ((mIRElement = AbstractExpressionAnalyzer.getReferencedElement(mIRElementNode = iterator.next())) == null || !mIRElement.isInstanceOf((short)77) || (mIRType = ((MIRFeature)mIRElement).getType()) == null)) {
            }
        }
        if (mIRType != null) {
            mIRTransformationDataAttribute.addType(mIRType);
        } else {
            MBCONV.CAN_NOT_SET_TYPE_FOR_INTERMEDIATE_COLUMN.log(mIRTransformationDataAttribute.getName());
        }
        return mIRTransformationDataAttribute;
    }

    protected MIRType buildDataType(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        MIRExpressionDataType mIRExpressionDataType = MIRExpressionDataType.deserialize(string);
        if (mIRExpressionDataType.getInfo().getName().equals(MIRExpressionDataTypeInfo.TYPE_UNDEFINED.getName())) {
            return MIRTypeLib.getUndefinedBaseType(this.model);
        }
        MIRDerivedType mIRDerivedType = new MIRDerivedType();
        mIRDerivedType.setName(mIRExpressionDataType.getDataTypeName());
        mIRDerivedType.setNativeDataType(mIRExpressionDataType.getInfo().getName());
        mIRDerivedType.setDataType(MIRBaseTypeList.getDataTypeName(mIRDerivedType.getNativeDataType()));
        mIRDerivedType.setLength(mIRExpressionDataType.getLength());
        mIRDerivedType.setScale(mIRExpressionDataType.getScale());
        this.model.addType(mIRDerivedType);
        MIRBaseType mIRBaseType = MIRTypeLib.getBaseType(this.model, mIRDerivedType.getNativeDataType());
        mIRBaseType.addDerivedType(mIRDerivedType);
        return mIRDerivedType;
    }

    protected static Set<MIRElementNode> collectElementNodes(MIRExpressionNode mIRExpressionNode) {
        HashSet<MIRElementNode> hashSet = new HashSet<MIRElementNode>();
        switch (mIRExpressionNode.getElementType()) {
            case 111: {
                hashSet.add((MIRElementNode)mIRExpressionNode);
                break;
            }
            case 114: {
                MIROperationNode mIROperationNode = (MIROperationNode)mIRExpressionNode;
                for (MIRExpressionNode mIRExpressionNode2 : mIROperationNode.getExpressionNodes()) {
                    hashSet.addAll(AbstractExpressionAnalyzer.collectElementNodes(mIRExpressionNode2));
                }
                break;
            }
            case 115: {
                MIROperatorNode mIROperatorNode = (MIROperatorNode)mIRExpressionNode;
                MIRExpressionNode mIRExpressionNode3 = mIROperatorNode.getLeftExpressionNode();
                MIRExpressionNode mIRExpressionNode4 = mIROperatorNode.getRightExpressionNode();
                hashSet.addAll(AbstractExpressionAnalyzer.collectElementNodes(mIRExpressionNode3));
                hashSet.addAll(AbstractExpressionAnalyzer.collectElementNodes(mIRExpressionNode4));
                break;
            }
            case 134: {
                MIRStatementNode mIRStatementNode = (MIRStatementNode)mIRExpressionNode;
                for (MIRExpressionNode mIRExpressionNode5 : mIRStatementNode.getExpressionNodes()) {
                    hashSet.addAll(AbstractExpressionAnalyzer.collectElementNodes(mIRExpressionNode5));
                }
                break;
            }
        }
        return hashSet;
    }

    protected static String generateName(MIRExpressionNode mIRExpressionNode) {
        String string = "";
        if (mIRExpressionNode != null) {
            switch (mIRExpressionNode.getElementType()) {
                case 104: {
                    string = string + mIRExpressionNode.getName();
                    break;
                }
                case 111: {
                    string = string + mIRExpressionNode.getName();
                    break;
                }
                case 114: {
                    string = string + mIRExpressionNode.getName();
                    MIROperationNode mIROperationNode = (MIROperationNode)mIRExpressionNode;
                    for (MIRExpressionNode mIRExpressionNode2 : mIROperationNode.getExpressionNodes()) {
                        string = string + "_" + AbstractExpressionAnalyzer.generateName(mIRExpressionNode2);
                    }
                    break;
                }
                case 115: {
                    MIROperatorNode mIROperatorNode = (MIROperatorNode)mIRExpressionNode;
                    MIRExpressionNode mIRExpressionNode3 = mIROperatorNode.getLeftExpressionNode();
                    MIRExpressionNode mIRExpressionNode4 = mIROperatorNode.getRightExpressionNode();
                    string = string + AbstractExpressionAnalyzer.generateName(mIRExpressionNode3);
                    string = string + "_";
                    string = string + AbstractExpressionAnalyzer.generateName(mIRExpressionNode4);
                    break;
                }
                case 134: {
                    MIRStatementNode mIRStatementNode = (MIRStatementNode)mIRExpressionNode;
                    for (MIRExpressionNode mIRExpressionNode5 : mIRStatementNode.getExpressionNodes()) {
                        if (string.isEmpty()) {
                            string = string + AbstractExpressionAnalyzer.generateName(mIRExpressionNode5);
                            continue;
                        }
                        string = string + "_" + AbstractExpressionAnalyzer.generateName(mIRExpressionNode5);
                    }
                    break;
                }
            }
        }
        return string;
    }

    protected MIRExpressionNode cloneExpressionNode(MIRExpressionNode mIRExpressionNode) {
        return this.cloneExpressionNode(mIRExpressionNode, false);
    }

    protected abstract MIRFeature getIntermediateFeature(MIRExpressionNode var1);

    protected MIRExpressionNode cloneExpressionNode(MIRExpressionNode mIRExpressionNode, boolean bl) {
        MIRExpressionNode mIRExpressionNode2 = null;
        MIRFeature mIRFeature = this.getIntermediateFeature(mIRExpressionNode);
        if (mIRFeature != null && !bl) {
            mIRExpressionNode2 = AbstractExpressionAnalyzer.createElementNode(mIRFeature, null);
            this.srcfeatures.add(mIRFeature);
        } else if (mIRExpressionNode != null) {
            switch (mIRExpressionNode.getElementType()) {
                case 103: {
                    mIRExpressionNode2 = this.cloneBranchingNode((MIRBranchingNode)mIRExpressionNode);
                    break;
                }
                case 104: {
                    mIRExpressionNode2 = this.cloneConstantNode((MIRConstantNode)mIRExpressionNode);
                    break;
                }
                case 107: {
                    mIRExpressionNode2 = this.cloneDelimiterNode((MIRDelimiterNode)mIRExpressionNode);
                    break;
                }
                case 111: {
                    mIRExpressionNode2 = this.cloneElementNode((MIRElementNode)mIRExpressionNode);
                    break;
                }
                case 114: {
                    mIRExpressionNode2 = this.cloneOperationNode((MIROperationNode)mIRExpressionNode);
                    break;
                }
                case 115: {
                    mIRExpressionNode2 = this.cloneOperatorNode((MIROperatorNode)mIRExpressionNode);
                    break;
                }
                case 118: {
                    mIRExpressionNode2 = this.clonePredicateNode((MIRPredicateNode)mIRExpressionNode);
                    break;
                }
                case 339: {
                    MBCONV.WARN_EXPRESSION_CLONE_NODE_NOT_SUPPORTED.log(MIRElementType.getName(mIRExpressionNode.getElementType()));
                    break;
                }
                case 134: {
                    mIRExpressionNode2 = this.cloneStatementNode((MIRStatementNode)mIRExpressionNode);
                    break;
                }
                default: {
                    MBCONV.WARN_EXPRESSION_CLONE_NODE_NOT_SUPPORTED.log(MIRElementType.getName(mIRExpressionNode.getElementType()));
                }
            }
        }
        return mIRExpressionNode2;
    }

    protected MIRBranchingNode cloneBranchingNode(MIRBranchingNode mIRBranchingNode) {
        MIRBranchingNode mIRBranchingNode2 = new MIRBranchingNode();
        mIRBranchingNode2.setFrom(mIRBranchingNode);
        if (mIRBranchingNode.getConditionExpressionNode() != null) {
            mIRBranchingNode2.addConditionExpressionNode(this.cloneExpressionNode(mIRBranchingNode.getConditionExpressionNode()));
        }
        List<MIRExpressionNode> list = mIRBranchingNode.getExpressionNodeByPosition();
        for (int i = 0; i < list.size(); ++i) {
            mIRBranchingNode2.addExpressionNode(this.cloneExpressionNode(list.get(i)));
        }
        return mIRBranchingNode2;
    }

    protected MIRDelimiterNode cloneDelimiterNode(MIRDelimiterNode mIRDelimiterNode) {
        MIRDelimiterNode mIRDelimiterNode2 = new MIRDelimiterNode();
        mIRDelimiterNode2.setFrom(mIRDelimiterNode);
        List<MIRExpressionNode> list = mIRDelimiterNode.getExpressionNodeByPosition();
        for (int i = 0; i < list.size(); ++i) {
            mIRDelimiterNode2.addExpressionNode(this.cloneExpressionNode(list.get(i)));
        }
        if (mIRDelimiterNode.getConditionExpressionNode() != null) {
            mIRDelimiterNode2.addConditionExpressionNode(this.cloneExpressionNode(mIRDelimiterNode.getConditionExpressionNode()));
        }
        return mIRDelimiterNode2;
    }

    protected MIRPredicateNode clonePredicateNode(MIRPredicateNode mIRPredicateNode) {
        MIRPredicateNode mIRPredicateNode2 = new MIRPredicateNode();
        mIRPredicateNode2.setFrom(mIRPredicateNode);
        List<MIRPredicate> list = mIRPredicateNode.getPredicateByPosition();
        for (int i = 0; i < list.size(); ++i) {
            MIRPredicate mIRPredicate = new MIRPredicate();
            mIRPredicate.setFrom(list.get(i));
            mIRPredicateNode2.addPredicate(mIRPredicate);
        }
        if (mIRPredicateNode.getExpressionNode() != null) {
            mIRPredicateNode2.addExpressionNode(this.cloneExpressionNode(mIRPredicateNode.getExpressionNode()));
        }
        return mIRPredicateNode2;
    }

    protected MIRStatementNode cloneStatementNode(MIRStatementNode mIRStatementNode) {
        MIRStatementNode mIRStatementNode2 = new MIRStatementNode();
        mIRStatementNode2.setFrom(mIRStatementNode);
        for (MIRExpressionNode mIRExpressionNode : mIRStatementNode.getExpressionNodes()) {
            MIRExpressionNode mIRExpressionNode2 = this.cloneExpressionNode(mIRExpressionNode);
            if (mIRExpressionNode2 != null) {
                mIRStatementNode2.addExpressionNode(mIRExpressionNode2);
                continue;
            }
            MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIRExpressionNode.getElementType()));
        }
        return mIRStatementNode2;
    }

    protected MIRConstantNode cloneConstantNode(MIRConstantNode mIRConstantNode) {
        MIRConstantNode mIRConstantNode2 = new MIRConstantNode();
        mIRConstantNode2.setFrom(mIRConstantNode);
        return mIRConstantNode2;
    }

    protected MIRElementNode cloneElementNode(MIRElementNode mIRElementNode) {
        MIRElement mIRElement = AbstractExpressionAnalyzer.getReferencedElement(mIRElementNode);
        MIRElementNode mIRElementNode2 = new MIRElementNode();
        mIRElementNode2.setFrom(mIRElementNode);
        if (mIRElement != null) {
            mIRElementNode2 = AbstractExpressionAnalyzer.createElementNode((MIRFeature)mIRElement, null);
            this.srcfeatures.add((MIRFeature)mIRElement);
        }
        return mIRElementNode2;
    }

    protected MIROperationNode cloneOperationNode(MIROperationNode mIROperationNode) {
        MIROperationNode mIROperationNode2 = new MIROperationNode();
        mIROperationNode2.setFrom(mIROperationNode);
        List<MIRExpressionNode> list = mIROperationNode.getExpressionNodeByPosition();
        for (int i = 0; i < list.size(); ++i) {
            MIRExpressionNode mIRExpressionNode = this.cloneExpressionNode(list.get(i));
            if (mIRExpressionNode != null) {
                mIROperationNode2.addExpressionNode(mIRExpressionNode);
                continue;
            }
            MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIROperationNode.getElementType()));
        }
        return mIROperationNode2;
    }

    protected MIROperatorNode cloneOperatorNode(MIROperatorNode mIROperatorNode) {
        MIRExpressionNode mIRExpressionNode;
        MIROperatorNode mIROperatorNode2 = new MIROperatorNode();
        mIROperatorNode2.setFrom(mIROperatorNode);
        if (mIROperatorNode.getLeftExpressionNode() != null) {
            mIRExpressionNode = this.cloneExpressionNode(mIROperatorNode.getLeftExpressionNode());
            if (mIRExpressionNode != null) {
                mIROperatorNode2.addLeftExpressionNode(mIRExpressionNode);
            } else {
                MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIROperatorNode.getElementType()));
            }
        }
        if (mIROperatorNode.getRightExpressionNode() != null) {
            mIRExpressionNode = this.cloneExpressionNode(mIROperatorNode.getRightExpressionNode());
            if (mIRExpressionNode != null) {
                mIROperatorNode2.addRightExpressionNode(mIRExpressionNode);
            } else {
                MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIROperatorNode.getElementType()));
            }
        }
        if (mIROperatorNode.getConditionExpressionNode() != null) {
            mIRExpressionNode = this.cloneExpressionNode(this.cloneExpressionNode(mIROperatorNode.getConditionExpressionNode()));
            if (mIRExpressionNode != null) {
                mIROperatorNode2.addConditionExpressionNode(mIRExpressionNode);
            } else {
                MBCONV.WARN_EXPRESSION_CLONE.log(MIRElementType.getName(mIROperatorNode.getElementType()));
            }
        }
        return mIROperatorNode2;
    }

    public class Stuff {
        public Set<MIRFeature> sourceFeatures = new HashSet<MIRFeature>();
        public MIRFeature destination;
        public MIRExpression expression;
    }
}

