/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter.etl;

import MITI.converter.etl.FeatureMapper;
import MITI.converter.etl.TableBlock;
import MITI.converter.etl.expression.AbstractExpressionAnalyzer;
import MITI.converter.etl.expression.GroupByExpressionAnalyzer;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelConverter.MBCONV;
import MITI.sdk.MIRAggregationTransformation;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRExpressionTransformation;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRTransformationDataSet;
import MITI.sdk.MIRType;
import MITI.sdk.util.ObjectCollector;
import java.util.HashSet;
import java.util.Set;

public class MIREtlModelProcessor {
    private MIRDiModel model;
    private FeatureMapper mapper = null;

    private MIREtlModelProcessor(MIRDiModel mIRDiModel) {
        this.model = mIRDiModel;
        this.mapper = new EtlFeatureMapper();
    }

    static void checkAggregations(MIRDiModel mIRDiModel) {
        Set<MIRAggregationTransformation> set = MIREtlModelProcessor.collectAllAggregations(mIRDiModel);
        for (MIRAggregationTransformation mIRAggregationTransformation : set) {
            MIRTransformationDataSet mIRTransformationDataSet = mIRAggregationTransformation.getOutputTransformationDataSet();
            MIRFeature mIRFeature = mIRTransformationDataSet.getFeature("GROUP BY CONDITION");
            if (mIRFeature == null) continue;
            MIRFeatureMap mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
            for (MIRFeature mIRFeature2 : mIRTransformationDataSet.getFeatures()) {
                MIRFeature mIRFeature3;
                MIRFeatureMap mIRFeatureMap2;
                if (mIRFeature2 == mIRFeature || (mIRFeatureMap2 = mIRFeature2.getDestinationOfFeatureMap()) == null || mIRFeatureMap2.getExpression() != null || (mIRFeature3 = mIRFeatureMap2.getSourceFeatures().first()) == null) continue;
                boolean bl = false;
                for (MIRFeature mIRFeature4 : mIRFeatureMap.getSourceFeatures()) {
                    if (mIRFeature4 != mIRFeature3) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                mIRFeatureMap.addSourceFeature(mIRFeature3);
            }
        }
    }

    public static void simplifyAggregation(MIRDiModel mIRDiModel) {
        MIREtlModelProcessor mIREtlModelProcessor = new MIREtlModelProcessor(mIRDiModel);
        Set<MIRAggregationTransformation> set = MIREtlModelProcessor.collectAllAggregations(mIRDiModel);
        for (MIRAggregationTransformation mIRAggregationTransformation : set) {
            MIRFeature mIRFeature;
            GroupByExpressionAnalyzer groupByExpressionAnalyzer = new GroupByExpressionAnalyzer(mIRDiModel);
            MIRClassifierMap mIRClassifierMap = mIRAggregationTransformation.getClassifierMaps().first();
            HashSet<MIRFeatureMap> hashSet = new HashSet<MIRFeatureMap>();
            for (MIRFeatureMap mIRFeatureMap : mIRClassifierMap.getFeatureMaps()) {
                mIRFeature = mIRFeatureMap.getDestinationFeature();
                if (mIRFeature != null && (mIRFeature.getSourceOfFeatureMapCount() > 0 || mIRFeature.getElementType() == 84)) {
                    groupByExpressionAnalyzer.parse(mIRFeatureMap);
                    continue;
                }
                hashSet.add(mIRFeatureMap);
            }
            for (MIRFeatureMap mIRFeatureMap : hashSet) {
                mIRFeature = mIRFeatureMap.getDestinationFeature();
                mIRFeatureMap.removeClassifierMap();
                if (mIRFeature != null) {
                    mIRFeature.removeClassifier();
                    mIRFeature.delete();
                }
                mIRFeatureMap.delete();
            }
            if (groupByExpressionAnalyzer.hasComplexExpression()) {
                mIREtlModelProcessor.processAggregation(mIRAggregationTransformation, groupByExpressionAnalyzer);
            }
            groupByExpressionAnalyzer.deleteTemporaryFeatures();
        }
        MIREtlModelProcessor.checkAggregations(mIRDiModel);
    }

    private static Set<MIRAggregationTransformation> collectAllAggregations(MIRDiModel mIRDiModel) {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{219});
        return objectCollector.collect(mIRDiModel);
    }

    private void rewire(MIRTransformationDataSet mIRTransformationDataSet, MIRTransformationDataSet mIRTransformationDataSet2) {
        if (mIRTransformationDataSet == mIRTransformationDataSet2) {
            return;
        }
        MIRClassifierMap mIRClassifierMap = mIRTransformationDataSet.getDestinationOfClassifierMap();
        if (mIRClassifierMap != null && mIRClassifierMap.getSourceClassifiers().size() > 0) {
            MIRTransformationDataSet mIRTransformationDataSet3 = (MIRTransformationDataSet)mIRClassifierMap.getSourceClassifiers().first();
            this.rewire(mIRTransformationDataSet3, mIRTransformationDataSet2);
            for (MIRFeature mIRFeature : mIRTransformationDataSet.getFeatures()) {
                if (mIRFeature.getDestinationOfFeatureMap() != null) continue;
                MIRFeature mIRFeature2 = this.getSourceFeatureFor(mIRFeature, mIRTransformationDataSet3, mIRTransformationDataSet2);
                if (mIRFeature2 != null) {
                    MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
                    mIRFeatureMap.addDestinationFeature(mIRFeature);
                    mIRClassifierMap.addFeatureMap(mIRFeatureMap);
                    mIRFeatureMap.addSourceFeature(mIRFeature2);
                    continue;
                }
                MBCONV.CAN_NOT_STITCH_FEATURE.log(mIRTransformationDataSet.getParent().getName(), mIRTransformationDataSet.getName(), mIRFeature.getName());
            }
        }
    }

    private MIRFeature getSourceFeatureFor(MIRFeature mIRFeature, MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2) {
        MIRClassifierMap mIRClassifierMap;
        MIRModelObject mIRModelObject = this.mapper.getCopyOfOriginalFeature(mIRClassifier, this.mapper.getOriginalFeatureFromCopy(mIRFeature));
        if (mIRModelObject == null && (mIRClassifierMap = mIRClassifier.getDestinationOfClassifierMap()) != null) {
            MIRModelObject mIRModelObject2;
            if (!mIRClassifierMap.getName().isEmpty()) {
                return null;
            }
            Object object = mIRClassifierMap.getSourceClassifiers().iterator();
            while (object.hasNext() && (mIRModelObject2 = (MIRClassifier)object.next()) != mIRClassifier2 && (mIRModelObject = this.getSourceFeatureFor(mIRFeature, (MIRClassifier)mIRModelObject2, mIRClassifier2)) == null) {
            }
            if (mIRModelObject != null) {
                object = this.mapper.getOriginalFeatureFromCopy((MIRFeature)mIRModelObject);
                mIRModelObject2 = this.mapper.getOrAdd((MIRFeature)object, mIRClassifier);
                MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
                mIRFeatureMap.addDestinationFeature((MIRFeature)mIRModelObject2);
                mIRFeatureMap.addSourceFeature((MIRFeature)mIRModelObject);
                mIRClassifierMap.addFeatureMap(mIRFeatureMap);
                mIRModelObject = mIRModelObject2;
            }
        }
        return mIRModelObject;
    }

    private void processAggregation(MIRAggregationTransformation mIRAggregationTransformation, GroupByExpressionAnalyzer groupByExpressionAnalyzer) {
        MIRFeature mIRFeature;
        Object object2;
        Object object3;
        MIRTransformationDataSet mIRTransformationDataSet;
        MIRAggregationTransformation mIRAggregationTransformation2 = this.createNewAggregationTransformation(mIRAggregationTransformation, groupByExpressionAnalyzer.getAggregationFeatureMaps());
        MIRTransformationDataSet mIRTransformationDataSet2 = mIRAggregationTransformation.getInputTransformationDataSet();
        MIRTransformationDataSet mIRTransformationDataSet3 = mIRAggregationTransformation.getOutputTransformationDataSet();
        MIRTransformationDataSet mIRTransformationDataSet4 = mIRAggregationTransformation2.getInputTransformationDataSet();
        MIRTransformationDataSet mIRTransformationDataSet5 = mIRTransformationDataSet = mIRAggregationTransformation2.getOutputTransformationDataSet();
        MIRTransformationDataSet mIRTransformationDataSet6 = mIRTransformationDataSet4;
        Set<AbstractExpressionAnalyzer.Stuff> set = groupByExpressionAnalyzer.getExpressionMaps();
        if (set.size() > 0) {
            object3 = this.createLeftExpressionTransformation(mIRAggregationTransformation, set);
            object2 = ((MIRExpressionTransformation)object3).getOutputTransformationDataSet();
            MIRClassifierMap object4 = new MIRClassifierMap();
            object4.addSourceClassifier((MIRClassifier)object2);
            object4.addDestinationClassifier(mIRTransformationDataSet4);
            this.model.addClassifierMap(object4);
            mIRTransformationDataSet6 = ((MIRExpressionTransformation)object3).getInputTransformationDataSet();
        } else {
            object3 = mIRTransformationDataSet2.getDestinationOfClassifierMap();
            for (MIRFeatureMap mIRFeatureMap : ((MIRClassifierMap)object3).getFeatureMaps()) {
                MIRFeature mIRFeature2 = mIRFeatureMap.getDestinationFeature();
                mIRFeature = this.mapper.getOrAdd(mIRFeature2, mIRTransformationDataSet4);
                mIRFeatureMap.removeDestinationFeature();
                mIRFeatureMap.addDestinationFeature(mIRFeature);
            }
            ((MIRClassifierMap)object3).removeDestinationClassifier();
            ((MIRClassifierMap)object3).addDestinationClassifier(mIRTransformationDataSet4);
        }
        object3 = groupByExpressionAnalyzer.getAggExpressionMaps();
        if (object3.size() > 0) {
            object2 = this.createRightExpressionTransformation(mIRAggregationTransformation, (Set<AbstractExpressionAnalyzer.Stuff>)object3);
            MIRTransformationDataSet mIRTransformationDataSet7 = ((MIRExpressionTransformation)object2).getInputTransformationDataSet();
            MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
            mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
            mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet7);
            this.model.addClassifierMap(mIRClassifierMap);
            mIRTransformationDataSet5 = ((MIRExpressionTransformation)object2).getOutputTransformationDataSet();
        } else {
            object2 = mIRTransformationDataSet3.getSourceOfClassifierMaps().first();
            for (MIRFeatureMap mIRFeatureMap : ((MIRClassifierMap)object2).getFeatureMaps()) {
                mIRFeature = mIRFeatureMap.getSourceFeatures().first();
                MIRFeature mIRFeature3 = this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet);
                mIRFeatureMap.removeSourceFeatures();
                mIRFeatureMap.addSourceFeature(mIRFeature3);
            }
            ((MIRClassifierMap)object2).removeSourceClassifiers();
            ((MIRClassifierMap)object2).addSourceClassifier(mIRTransformationDataSet);
        }
        this.rewire(mIRTransformationDataSet5, mIRTransformationDataSet6);
        mIRAggregationTransformation.delete();
        this.model.addTransformationUniqueName(mIRAggregationTransformation2);
    }

    private MIRAggregationTransformation createNewAggregationTransformation(MIRAggregationTransformation mIRAggregationTransformation, Set<AbstractExpressionAnalyzer.Stuff> set) {
        Object object;
        Object object2;
        MIRFeatureMap mIRFeatureMap2;
        Object object3;
        MIRAggregationTransformation mIRAggregationTransformation2 = this.createAggregationTransformation(mIRAggregationTransformation);
        MIRTransformationDataSet mIRTransformationDataSet = mIRAggregationTransformation2.getInputTransformationDataSet();
        MIRTransformationDataSet mIRTransformationDataSet2 = mIRAggregationTransformation2.getOutputTransformationDataSet();
        MIRClassifierMap mIRClassifierMap = mIRTransformationDataSet2.getDestinationOfClassifierMap();
        MIRTransformationDataSet mIRTransformationDataSet3 = mIRAggregationTransformation.getOutputTransformationDataSet();
        MIRFeature mIRFeature = mIRTransformationDataSet3.getFeature("GROUP BY CONDITION");
        if (mIRFeature != null) {
            object3 = new MIRCondition();
            ((MIRObject)object3).setName("GROUP BY CONDITION");
            mIRTransformationDataSet2.addFeature((MIRFeature)object3);
            MIRFeatureMap iterator = mIRFeature.getDestinationOfFeatureMap();
            if (iterator != null) {
                mIRFeatureMap2 = new MIRFeatureMap();
                mIRClassifierMap.addFeatureMap(mIRFeatureMap2);
                mIRFeatureMap2.addDestinationFeature((MIRFeature)object3);
                object2 = iterator.getSourceFeatures().iterator();
                while (object2.hasNext()) {
                    object = (MIRFeature)object2.next();
                    MIRFeature mIRFeature2 = this.mapper.getOrAdd((MIRFeature)object, mIRTransformationDataSet);
                    mIRFeatureMap2.addSourceFeature(mIRFeature2);
                }
            }
        } else {
            MBCONV.AGGREGATION_NO_CONDITION.log(mIRAggregationTransformation.getName());
        }
        for (AbstractExpressionAnalyzer.Stuff stuff : set) {
            BLIB.DBG_DEBUG.log("converting expression for " + stuff.destination.getName());
            mIRFeatureMap2 = new MIRFeatureMap();
            mIRClassifierMap.addFeatureMap(mIRFeatureMap2);
            object2 = this.mapper.getOrAdd(stuff.destination, mIRTransformationDataSet2);
            mIRFeatureMap2.addDestinationFeature((MIRFeature)object2);
            for (MIRFeature mIRFeature3 : stuff.sourceFeatures) {
                BLIB.DBG_DEBUG.log("->adding source feature" + mIRFeature3.getName());
                MIRFeature mIRFeature4 = this.mapper.getOrAdd(mIRFeature3, mIRTransformationDataSet);
                mIRFeatureMap2.addSourceFeature(mIRFeature4);
            }
            TableBlock.copyExpression(stuff.expression, mIRFeatureMap2, this.mapper);
        }
        object3 = mIRTransformationDataSet3.getDestinationOfClassifierMap();
        for (MIRFeatureMap mIRFeatureMap2 : ((MIRClassifierMap)object3).getFeatureMaps()) {
            if (mIRFeatureMap2.getExpression() != null || ((MIRFeature)(object2 = mIRFeatureMap2.getDestinationFeature())).getElementType() != 255) continue;
            object = this.mapper.getOrAdd((MIRFeature)object2, mIRTransformationDataSet2);
            MIRFeatureMap mIRFeatureMap3 = new MIRFeatureMap();
            mIRFeatureMap3.addDestinationFeature((MIRFeature)object);
            mIRClassifierMap.addFeatureMap(mIRFeatureMap3);
            for (MIRFeature mIRFeature5 : mIRFeatureMap2.getSourceFeatures()) {
                MIRFeature mIRFeature6 = this.mapper.getOrAdd(mIRFeature5, mIRTransformationDataSet);
                if (mIRFeature6 == null) continue;
                mIRFeatureMap3.addSourceFeature(mIRFeature6);
            }
        }
        return mIRAggregationTransformation2;
    }

    private MIRExpressionTransformation createRightExpressionTransformation(MIRAggregationTransformation mIRAggregationTransformation, Set<AbstractExpressionAnalyzer.Stuff> set) {
        MIRTransformationDataSet mIRTransformationDataSet;
        MIRTransformationDataSet mIRTransformationDataSet2 = mIRAggregationTransformation.getOutputTransformationDataSet();
        MIRClassifierMap mIRClassifierMap = null;
        if (mIRTransformationDataSet2.getSourceOfClassifierMapCount() > 0) {
            mIRClassifierMap = mIRTransformationDataSet2.getSourceOfClassifierMaps().first();
        }
        MIRExpressionTransformation mIRExpressionTransformation = this.createExpressionTransformation("right" + mIRAggregationTransformation.getName() + "_Expression");
        this.model.addTransformationUniqueName(mIRExpressionTransformation);
        if (mIRClassifierMap != null) {
            mIRTransformationDataSet = mIRExpressionTransformation.getOutputTransformationDataSet();
            for (MIRFeatureMap mIRElement2 : mIRClassifierMap.getFeatureMaps()) {
                MIRFeature mIRFeature = mIRElement2.getSourceFeatures().first();
                MIRFeature mIRFeature2 = this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet);
                mIRElement2.removeSourceFeatures();
                mIRElement2.addSourceFeature(mIRFeature2);
            }
            mIRClassifierMap.removeSourceClassifiers();
            mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        }
        mIRTransformationDataSet = mIRExpressionTransformation.getInputTransformationDataSet();
        MIRTransformationDataSet mIRTransformationDataSet3 = mIRExpressionTransformation.getOutputTransformationDataSet();
        MIRClassifierMap mIRClassifierMap2 = mIRExpressionTransformation.getClassifierMaps().first();
        for (AbstractExpressionAnalyzer.Stuff stuff : set) {
            MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
            mIRClassifierMap2.addFeatureMap(mIRFeatureMap);
            MIRFeature mIRFeature = this.mapper.getOrAdd(stuff.destination, mIRTransformationDataSet3);
            mIRFeatureMap.addDestinationFeature(mIRFeature);
            for (MIRFeature mIRFeature3 : stuff.sourceFeatures) {
                MIRFeature mIRFeature4 = this.mapper.getOrAdd(mIRFeature3, mIRTransformationDataSet);
                mIRFeatureMap.addSourceFeature(mIRFeature4);
            }
            TableBlock.copyExpression(stuff.expression, mIRFeatureMap, this.mapper);
            stuff.expression.delete();
        }
        return mIRExpressionTransformation;
    }

    private MIRExpressionTransformation createLeftExpressionTransformation(MIRAggregationTransformation mIRAggregationTransformation, Set<AbstractExpressionAnalyzer.Stuff> set) {
        MIRFeature mIRFeature;
        MIRElement mIRElement;
        MIRTransformationDataSet mIRTransformationDataSet = mIRAggregationTransformation.getInputTransformationDataSet();
        MIRClassifierMap mIRClassifierMap = mIRTransformationDataSet.getDestinationOfClassifierMap();
        MIRExpressionTransformation mIRExpressionTransformation = this.createExpressionTransformation("left" + mIRAggregationTransformation.getName() + "_Expression");
        this.model.addTransformationUniqueName(mIRExpressionTransformation);
        MIRTransformationDataSet mIRTransformationDataSet2 = mIRExpressionTransformation.getInputTransformationDataSet();
        MIRTransformationDataSet mIRTransformationDataSet3 = mIRExpressionTransformation.getOutputTransformationDataSet();
        MIRClassifierMap mIRClassifierMap2 = mIRExpressionTransformation.getClassifierMaps().first();
        if (mIRClassifierMap != null) {
            for (MIRFeatureMap object : mIRClassifierMap.getFeatureMaps()) {
                mIRElement = object.getDestinationFeature();
                object.removeDestinationFeature();
                mIRFeature = this.mapper.getOrAdd((MIRFeature)mIRElement, mIRTransformationDataSet2);
                object.addDestinationFeature(mIRFeature);
                if (((MIRFeature)mIRElement).getSourceOfFeatureMaps().stream().filter(mIRFeatureMap -> mIRFeatureMap.getExpression() == null).findFirst().orElse(null) == null) continue;
                MIRFeature mIRFeature2 = this.mapper.getOrAdd((MIRFeature)mIRElement, mIRTransformationDataSet3);
                MIRFeatureMap mIRFeatureMap2 = new MIRFeatureMap();
                mIRFeatureMap2.addDestinationFeature(mIRFeature2);
                mIRFeatureMap2.addSourceFeature(mIRFeature);
                mIRClassifierMap2.addFeatureMap(mIRFeatureMap2);
            }
            mIRClassifierMap.removeDestinationClassifier();
            mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet2);
        }
        for (AbstractExpressionAnalyzer.Stuff stuff : set) {
            mIRElement = new MIRFeatureMap();
            mIRClassifierMap2.addFeatureMap((MIRFeatureMap)mIRElement);
            mIRFeature = this.mapper.getOrAdd(stuff.destination, mIRTransformationDataSet3);
            ((MIRFeatureMap)mIRElement).addDestinationFeature(mIRFeature);
            for (MIRFeature mIRFeature3 : stuff.sourceFeatures) {
                MIRFeature mIRFeature4 = this.mapper.getOrAdd(mIRFeature3, mIRTransformationDataSet2);
                ((MIRFeatureMap)mIRElement).addSourceFeature(mIRFeature4);
            }
            TableBlock.copyExpression(stuff.expression, (MIRFeatureMap)mIRElement, this.mapper);
            stuff.expression.delete();
        }
        return mIRExpressionTransformation;
    }

    private MIRExpressionTransformation createExpressionTransformation(String string) {
        MIRExpressionTransformation mIRExpressionTransformation = new MIRExpressionTransformation();
        mIRExpressionTransformation.setName(string);
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRExpressionTransformation.addClassifierMap(mIRClassifierMap);
        MIRTransformationDataSet mIRTransformationDataSet = new MIRTransformationDataSet();
        mIRTransformationDataSet.setName("input");
        MIRTransformationDataSet mIRTransformationDataSet2 = new MIRTransformationDataSet();
        mIRTransformationDataSet2.setName("output");
        mIRExpressionTransformation.addInputTransformationDataSet(mIRTransformationDataSet);
        mIRExpressionTransformation.addOutputTransformationDataSet(mIRTransformationDataSet2);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet2);
        return mIRExpressionTransformation;
    }

    private MIRAggregationTransformation createAggregationTransformation(MIRAggregationTransformation mIRAggregationTransformation) {
        MIRAggregationTransformation mIRAggregationTransformation2 = new MIRAggregationTransformation();
        mIRAggregationTransformation2.setName(mIRAggregationTransformation.getName());
        mIRAggregationTransformation2.setNativeType(mIRAggregationTransformation.getNativeType());
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRAggregationTransformation2.addClassifierMap(mIRClassifierMap);
        MIRTransformationDataSet mIRTransformationDataSet = new MIRTransformationDataSet();
        mIRTransformationDataSet.setName("input");
        MIRTransformationDataSet mIRTransformationDataSet2 = new MIRTransformationDataSet();
        mIRTransformationDataSet2.setName("output");
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet2);
        mIRAggregationTransformation2.addInputTransformationDataSet(mIRTransformationDataSet);
        mIRAggregationTransformation2.addOutputTransformationDataSet(mIRTransformationDataSet2);
        return mIRAggregationTransformation2;
    }

    private class EtlFeatureMapper
    extends FeatureMapper {
        @Override
        protected MIRFeature copyFeature(MIRFeature mIRFeature, MIRFeature mIRFeature2) {
            mIRFeature2.setName(mIRFeature.getName());
            mIRFeature2.setPosition(mIRFeature.getPosition());
            MIRType mIRType = mIRFeature.getType();
            if (mIRType != null) {
                mIRFeature2.addType(mIRType);
            } else {
                MBCONV.FEATURE_DOES_NOT_HAVE_A_TYPE.log(mIRFeature.getName());
            }
            return mIRFeature2;
        }
    }
}

