/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter.etl;

import MITI.converter.etl.ETLContext;
import MITI.messages.MIRModelConverter.MBCONV;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRTransformationDataAttribute;
import MITI.sdk.MIRType;
import java.util.HashMap;
import java.util.Map;

public class FeatureMapper {
    Map<MIRFeature, MIRFeature> copyToOriginal = new HashMap<MIRFeature, MIRFeature>();
    Map<MIRClassifier, Map<MIRFeature, MIRFeature>> originalToCopy = new HashMap<MIRClassifier, Map<MIRFeature, MIRFeature>>();

    public MIRFeature getOriginalFeatureFromCopy(MIRFeature mIRFeature) {
        return this.copyToOriginal.get(mIRFeature);
    }

    public MIRFeature getCopyOfOriginalFeature(MIRClassifier mIRClassifier, MIRFeature mIRFeature) {
        Map<MIRFeature, MIRFeature> map = this.originalToCopy.get(mIRClassifier);
        if (map != null) {
            return map.get(mIRFeature);
        }
        return null;
    }

    public MIRFeature getOrAdd(MIRFeature mIRFeature, MIRClassifier mIRClassifier) {
        MIRFeature mIRFeature2;
        Map<MIRFeature, MIRFeature> map = this.originalToCopy.get(mIRClassifier);
        if (map == null) {
            map = new HashMap<MIRFeature, MIRFeature>();
            this.originalToCopy.put(mIRClassifier, map);
        }
        if ((mIRFeature2 = map.get(mIRFeature)) == null) {
            mIRFeature2 = this.copyFeature(mIRFeature, new MIRTransformationDataAttribute());
            mIRClassifier.addFeatureUniqueName(mIRFeature2);
            map.put(mIRFeature, mIRFeature2);
            this.copyToOriginal.put(mIRFeature2, mIRFeature);
        }
        return mIRFeature2;
    }

    protected MIRFeature copyFeature(MIRFeature mIRFeature, MIRFeature mIRFeature2) {
        mIRFeature2.setName(mIRFeature.getName());
        mIRFeature2.setPhysicalName(mIRFeature.getPhysicalName());
        MIRType mIRType = mIRFeature.getType();
        if (mIRType == null) {
            MBCONV.FEATURE_DOES_NOT_HAVE_A_TYPE.log(mIRFeature.getName());
            MIRDerivedType mIRDerivedType = ETLContext.derivedTypeMap.get(null);
            mIRFeature2.addType(mIRDerivedType);
        } else if (mIRType.getElementType() == 5) {
            MIRDerivedType mIRDerivedType = ETLContext.derivedTypeMap.get(mIRType);
            mIRFeature2.addType(mIRDerivedType);
        } else {
            MBCONV.COPY_FEATURE_NO_DERIVED_TYPE.log(mIRFeature.getName());
            MIRDerivedType mIRDerivedType = ETLContext.derivedTypeMap.get(null);
            mIRFeature2.addType(mIRDerivedType);
        }
        return mIRFeature2;
    }
}

