/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.converter.MIRFileSystemSummarizer;
import MITI.messages.MIRModelConverter.MBCONV;
import MITI.sdk.MIRAssociation;
import MITI.sdk.MIRAssociationRole;
import MITI.sdk.MIRCandidateKey;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRDate;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRDiagram;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRDirectoryStructureType;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRForeignKey;
import MITI.sdk.MIRKey;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROlapSchema;
import MITI.sdk.MIRPresentationElement;
import MITI.sdk.MIRSQLViewAssociation;
import MITI.sdk.MIRSQLViewEntity;
import MITI.sdk.MIRSequence;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoreType;
import MITI.sdk.MIRType;
import MITI.sdk.MIR_Object;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.util.ObjectCollector;
import MITI.util.file.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public abstract class MIRModelConverter {
    private static final String MITI_DLL_NAME = "TODO";
    private static final String MITI_VERSION = "TODO";
    private HashSet<Short> elementTypes = new HashSet();
    private HashSet<Byte> directoryStructureTypes = new HashSet();
    private HashSet<Byte> storeTypes = new HashSet();
    protected String subsetOptionValue;

    protected abstract String getName();

    protected abstract boolean convert(File var1) throws MIRException;

    protected boolean convertErModel(MIRStoreModel mIRStoreModel) throws MIRException {
        if (mIRStoreModel.getTypeCount() == 0) {
            ObjectCollector objectCollector = new ObjectCollector(new short[]{3});
            objectCollector.collect(mIRStoreModel);
            for (MIRNamespaceElement mIRNamespaceElement : objectCollector.getObjects()) {
                if (mIRNamespaceElement.getNamespace() == null) continue;
                mIRNamespaceElement.removeNamespace();
                mIRStoreModel.addType((MIRType)mIRNamespaceElement);
            }
        }
        for (MIRDataPackage mIRDataPackage : mIRStoreModel.getDataPackages()) {
            MIRNamespaceElement mIRNamespaceElement;
            if (mIRDataPackage.getNamespaceElementCount() == 0) continue;
            mIRNamespaceElement = new MIRDesignPackage();
            MIRModelConverter.copy(mIRDataPackage, mIRNamespaceElement);
            if (mIRNamespaceElement.getName().isEmpty()) {
                mIRNamespaceElement.setName("Default");
            }
            mIRStoreModel.addDesignPackageUniqueName((MIRDesignPackage)mIRNamespaceElement);
            HashSet<MIRNamespaceElement> hashSet = new HashSet<MIRNamespaceElement>();
            hashSet.addAll(mIRDataPackage.getNamespaceElements());
            for (MIRNamespaceElement mIRNamespaceElement2 : hashSet) {
                MIRModelObject mIRModelObject;
                MIRClassifier mIRClassifier;
                String string = mIRNamespaceElement2.getName();
                if (mIRNamespaceElement2.getElementType() != 68) {
                    if (mIRNamespaceElement2.getElementType() == 153) {
                        mIRDataPackage.removeNamespaceElement(mIRNamespaceElement2);
                        mIRStoreModel.addType((MIRSequence)mIRNamespaceElement2);
                    } else {
                        mIRDataPackage.removeNamespaceElement(mIRNamespaceElement2);
                        if (((MIRNamespace)mIRNamespaceElement).addNamespaceElementUniqueName(mIRNamespaceElement2) && mIRNamespaceElement2.getPhysicalName().isEmpty()) {
                            mIRNamespaceElement2.setPhysicalName(string);
                        }
                        mIRDataPackage.addImportedNamespaceElement(mIRNamespaceElement2);
                    }
                }
                if (mIRNamespaceElement2.getElementType() == 13) {
                    mIRClassifier = (MIRClass)mIRNamespaceElement2;
                    for (MIRKey mIRKey : ((MIRClass)mIRClassifier).getKeys()) {
                        if (mIRKey.getElementType() != 22) continue;
                        mIRModelObject = (MIRForeignKey)mIRKey;
                        MIRCandidateKey mIRCandidateKey = ((MIRForeignKey)mIRModelObject).getCandidateKey();
                        if (((MIRForeignKey)mIRModelObject).getAssociationRole() != null || mIRCandidateKey == null) continue;
                        MIRAssociation mIRAssociation = new MIRAssociation();
                        MIRAssociationRole mIRAssociationRole = new MIRAssociationRole();
                        mIRAssociationRole.setSource(true);
                        mIRAssociationRole.setMultiplicity("0..1");
                        mIRAssociationRole.addAssociatedClass(mIRCandidateKey.getAssociatedClass());
                        mIRAssociation.addAssociationRole(mIRAssociationRole);
                        MIRAssociationRole mIRAssociationRole2 = new MIRAssociationRole();
                        mIRAssociationRole2.addAssociatedClass(((MIRKey)mIRModelObject).getAssociatedClass());
                        mIRAssociationRole2.addForeignKey((MIRForeignKey)mIRModelObject);
                        mIRAssociation.addAssociationRole(mIRAssociationRole2);
                        MIRBridgeLib.setAggregationProperty(mIRAssociation);
                        if (mIRAssociation.getAggregation()) {
                            mIRAssociationRole2.setMultiplicity("1..*");
                        } else {
                            mIRAssociationRole2.setMultiplicity("0..*");
                        }
                        ((MIRNamespace)mIRNamespaceElement).addNamespaceElement(mIRAssociation);
                        while (mIRModelObject.getPresentationPresentationElementCount() > 0) {
                            MIRPresentationElement mIRPresentationElement = mIRModelObject.getPresentationPresentationElementIterator().next();
                            MIRDiagram mIRDiagram = mIRPresentationElement.getDiagram();
                            if (!mIRDiagram.containsModelElement(mIRAssociation)) {
                                mIRDiagram.addModelElement(mIRAssociation);
                            }
                            mIRPresentationElement.removeSubjectModelObject();
                            mIRPresentationElement.addSubjectModelObject(mIRAssociation);
                        }
                    }
                    continue;
                }
                if (mIRNamespaceElement2.getElementType() != 25 || (mIRClassifier = (MIRSQLViewEntity)mIRNamespaceElement2).getClassifierMap() == null || ((MIRSQLViewEntity)mIRClassifier).getDestinationOfSQLViewAssociationCount() != 0) continue;
                for (MIRClassifier mIRClassifier2 : mIRClassifier.getClassifierMap().getSourceClassifiers()) {
                    mIRModelObject = new MIRSQLViewAssociation();
                    ((MIRSQLViewEntity)mIRClassifier).addDestinationOfSQLViewAssociation((MIRSQLViewAssociation)mIRModelObject);
                    ((MIRSQLViewAssociation)mIRModelObject).addSourceClassifier(mIRClassifier2);
                    ((MIRNamespace)mIRNamespaceElement).addNamespaceElement((MIRNamespaceElement)mIRModelObject);
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run(File file) throws MIRException {
        MBCONV.CALLING_CONVERTER.log(this.getName());
        File file2 = MIRMixManager.getMultiModelFile(file);
        if (file2.exists()) {
            if (!this.elementTypes.contains((short)286)) {
                MBCONV.CONVERTING_TO_SINGLE_MODEL.log(new Object[0]);
                if (!this.convertDirectoryModel(file)) return false;
                FileUtil.delete(file2);
                file2 = MIRMixManager.getModelFile(file);
            }
        } else {
            file2 = MIRMixManager.getModelFile(file);
            if (!this.elementTypes.contains((short)2)) {
                MBCONV.CONVERTING_TO_MULTI_MODEL.log(new Object[0]);
                if (!this.convertStoreModel(file)) return false;
                FileUtil.delete(file2);
                file2 = MIRMixManager.getMultiModelFile(file);
            }
        }
        boolean bl = this.convert(file2);
        MBCONV.CONVERT_COMPLETE.log(this.getName());
        return bl;
    }

    protected void acceptsElement(short s) {
        if (MIRElementType.toString(s) == null) {
            throw new IllegalArgumentException("Invalid StoreType");
        }
        this.elementTypes.add(s);
    }

    protected void acceptsDirectoryStructure(byte by) {
        if (MIRDirectoryStructureType.toString(by) == null) {
            throw new IllegalArgumentException("Invalid DirectoryStructureType");
        }
        this.directoryStructureTypes.add(by);
    }

    protected void acceptsStore(byte by) {
        if (MIRStoreType.toString(by) == null) {
            throw new IllegalArgumentException("Invalid StoreType");
        }
        this.storeTypes.add(by);
    }

    protected boolean supports(MIRObject mIRObject) {
        if (this.elementTypes.contains(mIRObject.getElementType())) {
            if (mIRObject.getElementType() == 2) {
                MIRStoreModel mIRStoreModel = (MIRStoreModel)mIRObject;
                return this.storeTypes.contains(mIRStoreModel.getStoreType());
            }
            if (mIRObject.getElementType() == 286) {
                MIRDirectoryStructureModel mIRDirectoryStructureModel = (MIRDirectoryStructureModel)mIRObject;
                return this.directoryStructureTypes.contains(mIRDirectoryStructureModel.getType());
            }
        }
        return false;
    }

    protected boolean convertDirectoryModel(File file) throws MIRException {
        MIRMixManager mIRMixManager = new MIRMixManager(file);
        MIRDirectoryStructureModel mIRDirectoryStructureModel = mIRMixManager.loadDirectoryStructure();
        if (mIRDirectoryStructureModel.getType() == 3) {
            MIRFileSystemSummarizer mIRFileSystemSummarizer = new MIRFileSystemSummarizer();
            MIRStoreModel mIRStoreModel = mIRFileSystemSummarizer.run(mIRDirectoryStructureModel, mIRMixManager);
            File file2 = MIRMixManager.getModelFile(file);
            mIRMixManager.writeFile(file2, mIRStoreModel);
            return true;
        }
        int n = mIRDirectoryStructureModel.getConnectionStoreContentCount();
        ObjectCollector objectCollector = new ObjectCollector(new short[]{295});
        objectCollector.process(mIRDirectoryStructureModel);
        int n2 = objectCollector.getObjects().size();
        for (MIRStoreContent mIRStoreContent : objectCollector.getObjects()) {
            if (n2 != n && mIRStoreContent.getConnectionOfDirectoryStructureModel() != null) continue;
            File file3 = mIRMixManager.getFile(mIRStoreContent);
            File file4 = MIRMixManager.getModelFile(file);
            FileUtil.move(file3, file4);
            return true;
        }
        return false;
    }

    protected boolean convertStoreModel(File file) throws MIRException {
        File file2 = MIRMixManager.getModelFile(file);
        MIRDirectoryStructureModel mIRDirectoryStructureModel = new MIRDirectoryStructureModel();
        mIRDirectoryStructureModel.setName("Root");
        mIRDirectoryStructureModel.setType((byte)2);
        MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
        mIRMetadataOrigin.setBridgeName("TODO");
        mIRMetadataOrigin.setBridgeVersion("TODO");
        mIRDirectoryStructureModel.addMetadataOrigin(mIRMetadataOrigin);
        MIRStoreContent mIRStoreContent = new MIRStoreContent();
        mIRStoreContent.setName("Model");
        mIRStoreContent.setModelKey(file2.getAbsolutePath());
        mIRStoreContent.setLastModificationTime(new MIRDate(file2.lastModified()));
        mIRDirectoryStructureModel.addFolderContentUniqueName(mIRStoreContent);
        MIRMixManager mIRMixManager = new MIRMixManager(file);
        mIRMixManager.saveDirectoryStructure(mIRDirectoryStructureModel);
        File file3 = mIRMixManager.getFile(mIRStoreContent);
        FileUtil.move(file2, file3);
        return true;
    }

    protected boolean convertModelStoreType(MIRStoreModel mIRStoreModel, byte by) {
        if (mIRStoreModel.getStoreType() == by) {
            return false;
        }
        ArrayList<MIRStoreConnection> arrayList = new ArrayList<MIRStoreConnection>();
        for (MIRStoreConnection comparable : mIRStoreModel.getStoreConnections()) {
            if (comparable.getStoreType() != by || MIRModelConverter.getObjectCount(comparable) <= 0) continue;
            arrayList.add(comparable);
        }
        Object object = null;
        if (this.subsetOptionValue != null && !this.subsetOptionValue.isEmpty() && (object = MIRModelConverter.findConnectionByName(arrayList, this.subsetOptionValue)) == null) {
            MBCONV.CONNECTION_NOT_FOUND.log(this.subsetOptionValue);
        }
        if (object == null && arrayList.size() > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < arrayList.size(); ++i) {
                MIRStoreConnection mIRStoreConnection = (MIRStoreConnection)arrayList.get(i);
                if (i >= 1) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("'").append(mIRStoreConnection.getName()).append("'");
            }
            MBCONV.MULTIPLE_CONNECTIONS.log(mIRStoreModel.getName(), MIRStoreType.toString(by), stringBuffer.toString());
        }
        if (object == null) {
            object = MIRModelConverter.findLargestConnection(arrayList);
        }
        this.convertDataPackages(mIRStoreModel);
        mIRStoreModel.setStoreType(by);
        mIRStoreModel.setSystemMajorVersion(0);
        mIRStoreModel.setSystemMinorVersion(0);
        mIRStoreModel.setSystemReleaseVersion(0);
        mIRStoreModel.setSystemType("MIR");
        mIRStoreModel.setSystemTypeOld("");
        this.convertStoreConnection(mIRStoreModel, (MIRStoreConnection)object);
        if (!(object == null || ((MIRStoreConnection)object).getConnectionPackageCount() != 0 || ((MIRStoreConnection)object).getConnectionElementCount() != 0 || ((MIRStoreConnection)object).getConnectionClassifierCount() != 0 || ((MIRStoreConnection)object).getModel().getElementType() == 258 && ((MIRModelObject)object).getStereotype().equals("Empty"))) {
            ((MIR_Object)object).delete();
        }
        return true;
    }

    private static MIRStoreConnection findConnectionByName(Collection<MIRStoreConnection> collection, String string) {
        MIRStoreConnection mIRStoreConnection = null;
        for (MIRStoreConnection mIRStoreConnection2 : collection) {
            if (!mIRStoreConnection2.getName().equals(string)) continue;
            mIRStoreConnection = mIRStoreConnection2;
            break;
        }
        return mIRStoreConnection;
    }

    private static int getObjectCount(MIRStoreConnection mIRStoreConnection) {
        int n = 0;
        for (MIRConnectionPackage mIRConnectionPackage : mIRStoreConnection.getConnectionPackages()) {
            n += mIRConnectionPackage.getNamespaceElementCount() + mIRConnectionPackage.getImportedNamespaceElementCount();
        }
        return n;
    }

    private static MIRStoreConnection findLargestConnection(Collection<MIRStoreConnection> collection) {
        int n = 0;
        MIRStoreConnection mIRStoreConnection = null;
        for (MIRStoreConnection mIRStoreConnection2 : collection) {
            int n2 = MIRModelConverter.getObjectCount(mIRStoreConnection2);
            if (n2 <= n) continue;
            mIRStoreConnection = mIRStoreConnection2;
            n = n2;
        }
        return mIRStoreConnection;
    }

    private void convertDataPackages(MIRStoreModel mIRStoreModel) {
        if (mIRStoreModel.getDataPackageCount() > 0) {
            MIRDesignPackage mIRDesignPackage = new MIRDesignPackage();
            MIRModelConverter.copy(mIRStoreModel, mIRDesignPackage);
            MIRStoreConnection mIRStoreConnection = new MIRStoreConnection();
            MIRModelConverter.copy(mIRStoreModel, mIRStoreConnection);
            mIRStoreConnection.setStoreType(mIRStoreModel.getStoreType());
            mIRStoreModel.addStoreConnectionUniqueName(mIRStoreConnection);
            while (mIRStoreModel.getDataPackageCount() > 0) {
                MIRNamespaceElement mIRNamespaceElement;
                MIRDataPackage mIRDataPackage = mIRStoreModel.getDataPackages().first();
                MIRConnectionPackage mIRConnectionPackage = new MIRConnectionPackage();
                MIRModelConverter.copy(mIRDataPackage, mIRConnectionPackage);
                mIRStoreConnection.addConnectionPackage(mIRConnectionPackage);
                if (mIRDataPackage.getNamespaceElementCount() > 0) {
                    mIRNamespaceElement = new MIRDesignPackage();
                    MIRModelConverter.copy(mIRDataPackage, mIRNamespaceElement);
                    mIRDesignPackage.addNamespaceElementUniqueName(mIRNamespaceElement);
                    while (mIRDataPackage.getNamespaceElementCount() > 0) {
                        MIRNamespaceElement mIRNamespaceElement2 = mIRDataPackage.getNamespaceElements().first();
                        mIRDataPackage.removeNamespaceElement(mIRNamespaceElement2);
                        String string = mIRNamespaceElement2.getName();
                        if (((MIRNamespace)mIRNamespaceElement).addNamespaceElementUniqueName(mIRNamespaceElement2) && mIRNamespaceElement2.getPhysicalName().isEmpty()) {
                            mIRNamespaceElement2.setPhysicalName(string);
                        }
                        mIRConnectionPackage.addImportedNamespaceElement(mIRNamespaceElement2);
                    }
                }
                while (mIRDataPackage.getImportedNamespaceElementCount() > 0) {
                    mIRNamespaceElement = mIRDataPackage.getImportedNamespaceElements().first();
                    mIRDataPackage.removeImportedNamespaceElement(mIRNamespaceElement);
                    mIRConnectionPackage.addImportedNamespaceElement(mIRNamespaceElement);
                }
                mIRDataPackage.delete();
            }
            if (mIRDesignPackage.getNamespaceElementCount() > 0) {
                mIRStoreModel.addDesignPackageUniqueName(mIRDesignPackage);
            } else {
                mIRDesignPackage.delete();
            }
        }
    }

    private void convertStoreConnection(MIRStoreModel mIRStoreModel, MIRStoreConnection mIRStoreConnection) {
        if (mIRStoreConnection != null) {
            MBCONV.CONVERTING_MODEL_CONNECTION.log(mIRStoreModel.getName(), mIRStoreConnection.getName());
            MIRModelConverter.copy(mIRStoreConnection, mIRStoreModel);
            while (mIRStoreConnection.getConnectionPackageCount() > 0) {
                MIRConnectionPackage mIRConnectionPackage = mIRStoreConnection.getConnectionPackages().first();
                MIRDataPackage mIRDataPackage = null;
                if (mIRStoreConnection.getStoreType() == 0) {
                    mIRDataPackage = new MIRDatabaseSchema();
                } else if (mIRStoreConnection.getStoreType() == 1) {
                    mIRDataPackage = new MIROlapSchema();
                }
                if (mIRDataPackage != null) {
                    MIRNamespaceElement mIRNamespaceElement;
                    MIRModelConverter.copy(mIRConnectionPackage, mIRDataPackage);
                    mIRStoreModel.addDataPackage(mIRDataPackage);
                    while (mIRConnectionPackage.getNamespaceElementCount() > 0) {
                        mIRNamespaceElement = mIRConnectionPackage.getNamespaceElements().first();
                        mIRConnectionPackage.removeNamespaceElement(mIRNamespaceElement);
                        mIRDataPackage.addNamespaceElement(mIRNamespaceElement);
                    }
                    while (mIRConnectionPackage.getImportedNamespaceElementCount() > 0) {
                        mIRNamespaceElement = mIRConnectionPackage.getImportedNamespaceElements().first();
                        mIRConnectionPackage.removeImportedNamespaceElement(mIRNamespaceElement);
                        mIRDataPackage.addImportedNamespaceElement(mIRNamespaceElement);
                    }
                }
                mIRConnectionPackage.delete();
            }
        }
    }

    private static void copy(MIRElement mIRElement, MIRElement mIRElement2) {
        mIRElement2.setFrom(mIRElement);
        String string = "Converted from: " + mIRElement.getName() + " [" + MIRElementType.getName(mIRElement.getElementType()) + " to " + MIRElementType.getName(mIRElement2.getElementType()) + "] (" + mIRElement.getNativeId() + ")";
        mIRElement2.setNativeId(string);
    }

    public void setSubsetValue(String string) {
        this.subsetOptionValue = string;
    }
}

