/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRRelationalLib;
import MITI.bridges.bridgelib.MIRRolapLib;
import MITI.converter.MIRErModelConverter;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.util.ObjectCollector;
import java.io.File;

public class MIRErMultiModelConverter
extends MIRErModelConverter {
    private static final String NAME = "E/R Multi";

    public MIRErMultiModelConverter() {
        this.acceptsElement((short)286);
        this.acceptsDirectoryStructure((byte)3);
        this.acceptsDirectoryStructure((byte)0);
        this.acceptsDirectoryStructure((byte)2);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected boolean convert(File file) throws MIRException {
        MIRMixManager mIRMixManager = new MIRMixManager(file);
        MIRModel mIRModel = mIRMixManager.readFile(file);
        boolean bl = this.supports(mIRModel);
        if (bl) {
            if (((MIRObject)mIRModel).getElementType() == 286) {
                MIRDirectoryStructureModel mIRDirectoryStructureModel = (MIRDirectoryStructureModel)mIRModel;
                if (mIRDirectoryStructureModel.getType() == 3) {
                    ObjectCollector objectCollector = new ObjectCollector(new short[]{295});
                    objectCollector.collect(mIRDirectoryStructureModel);
                    for (MIRStoreContent mIRStoreContent : objectCollector.getObjects()) {
                        MIRStoreModel mIRStoreModel = (MIRStoreModel)mIRMixManager.loadModel(mIRStoreContent);
                        if (mIRStoreModel.getStoreType() == 2) {
                            MIRRelationalLib.processUMLClassTypes(mIRStoreModel, false);
                            this.convertErModel(mIRStoreModel);
                        }
                        mIRMixManager.saveModel(mIRStoreContent);
                        mIRStoreModel.delete();
                    }
                }
            } else if (((MIRObject)mIRModel).getElementType() == 2) {
                MIRStoreModel mIRStoreModel = (MIRStoreModel)mIRModel;
                if (mIRStoreModel.getStoreType() == 1 || mIRStoreModel.getStoreType() == 4) {
                    this.convertModelStoreType(mIRStoreModel, (byte)0);
                    MIRRolapLib mIRRolapLib = new MIRRolapLib();
                    mIRRolapLib.reverseEngineerROLAPModel(mIRStoreModel);
                } else if (mIRStoreModel.getStoreType() == 2) {
                    MIRRelationalLib.processUMLClassTypes(mIRStoreModel, false);
                }
                this.convertErModel(mIRStoreModel);
                mIRMixManager.writeFile(file, mIRStoreModel);
            }
        }
        mIRModel.delete();
        return bl;
    }
}

