/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.persist;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AggregateEntity;
import com.sas.entities.AttributeDescriptor;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeGroup;
import com.sas.entities.Entity;
import com.sas.entities.EntityInterface;
import com.sas.entities.persist.DOMDoc;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
public class EntityFactory {
    public EntityInterface createEntity() {
        return new Entity();
    }

    public AggregateEntity createAggregateEntity() {
        return new AggregateEntity();
    }

    public EntityInterface createEntityFromXMLString(String docString) {
        Entity entity = new Entity();
        try {
            byte[] xmlBytes = docString.getBytes("UTF-8");
            if (xmlBytes == null || xmlBytes.length == 0) {
                return null;
            }
            DOMDoc doc = new DOMDoc();
            doc.loadDocument(new ByteArrayInputStream(xmlBytes), false);
            Element rootElement = doc.getDocumentElement();
            AttributeGroup ag = (AttributeGroup)entity.getAttributeGroup();
            ArrayList attributeNames = new ArrayList();
            if (rootElement.getTagName().equals("entities")) {
                NodeList nl = rootElement.getElementsByTagName("*");
                int nodeLength = nl.getLength();
                for (int i = 0; i < nodeLength; ++i) {
                    Node attributeElement = nl.item(i);
                    String nodeName = attributeElement.getNodeName();
                    if (nodeName.equals("entity")) {
                        NamedNodeMap keyNodeMap = attributeElement.getAttributes();
                        if (keyNodeMap.getLength() <= 0) continue;
                        entity.setEntityKey(keyNodeMap.item(0).getNodeValue());
                        continue;
                    }
                    if (!nodeName.equals("entityAttribute") || !attributeElement.hasAttributes()) continue;
                    NamedNodeMap nodeMap = attributeElement.getAttributes();
                    String attributeDescriptorName = nodeMap.getNamedItem("name").getNodeValue();
                    if (!attributeDescriptorName.equals("entityKey")) {
                        AttributeDescriptor ad = new AttributeDescriptor(attributeDescriptorName);
                        int nodeMapLength = nodeMap.getLength();
                        for (int j = 0; j < nodeMapLength; ++j) {
                            Node attributeDescriptorNode = nodeMap.item(j);
                            String attrDescriptorName = attributeDescriptorNode.getNodeName();
                            if (attrDescriptorName.equals("attributeHasDefaultValueSet")) {
                                ad.setDefaultValueHasBeenSet(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attrDescriptorName.equals("expert")) {
                                ad.setExpert(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attrDescriptorName.equals("modifiable")) {
                                ad.setModifiable(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attrDescriptorName.equals("property")) {
                                ad.setProperty(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attrDescriptorName.equals("required")) {
                                ad.setRequired(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attrDescriptorName.equals("visible")) {
                                ad.setVisible(new Boolean(attributeDescriptorNode.getNodeValue()).booleanValue());
                                continue;
                            }
                            if (attrDescriptorName.equals("configurationXML")) {
                                ad.setConfigurationXML(attributeDescriptorNode.getNodeValue());
                                continue;
                            }
                            if (attrDescriptorName.equals("defaultValue")) {
                                if (!ad.isDefaultValueHasBeenSet()) continue;
                                ad.setDefault((Object)attributeDescriptorNode.getNodeValue());
                                continue;
                            }
                            if (!attrDescriptorName.equals("description")) continue;
                            ad.setDescription(null, attributeDescriptorNode.getNodeValue());
                        }
                        ag.addAttributeDescriptor((AttributeDescriptorInterface)ad, -1);
                        Object defaultValue = entity.getAttributeDescriptor(attributeDescriptorName).getDefault();
                        ((HashMap)entity.getDelegate()).put(attributeDescriptorName, defaultValue);
                        continue;
                    }
                    Node entityKeyNode = nodeMap.getNamedItem("entityKey");
                    entity.setEntityKey(entityKeyNode.getNodeValue());
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return entity;
    }
}

