/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.persist;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AggregateEntity;
import com.sas.entities.EntityAttr;
import com.sas.entities.EntityInterface;
import com.sas.entities.persist.DOMDoc;
import com.sas.entities.persist.RB;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope(value="ALL")
public class AggregateEntityPersistenceUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeXMLToString(AggregateEntity ae) {
        String xmlString = null;
        DOMDoc domDoc = new DOMDoc();
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        domDoc.newDocument(false);
        Element aggregate = domDoc.createElement("aggregateEntity");
        Attr aggregateName = domDoc.createAttribute("name");
        aggregateName.setValue(ae.getName());
        aggregate.setAttributeNode(aggregateName);
        domDoc.appendChild(aggregate);
        try {
            Element referenceEntities = domDoc.createElement("referenceEntities");
            aggregate.appendChild(referenceEntities);
            Map entities = ae.getEntities();
            Set keys = entities.keySet();
            for (EntityInterface entity : keys) {
                if (entity == null) continue;
                Element referenceEntity = domDoc.createElement("referenceEntity");
                Attr refEntityKey = domDoc.createAttribute("entityKey");
                String[] attrs = entity.listAttributeNames();
                for (int i = 0; i < attrs.length; ++i) {
                    String key = attrs[i];
                    if (!key.equals("entityKey")) continue;
                    refEntityKey.setValue((String)entity.getAttribute(key));
                    break;
                }
                referenceEntity.setAttributeNode(refEntityKey);
                Attr refEntityName = domDoc.createAttribute("name");
                refEntityName.setValue((String)entities.get(entity));
                referenceEntity.setAttributeNode(refEntityName);
                referenceEntities.appendChild(referenceEntity);
            }
            Element exposedAttrs = domDoc.createElement("exposedAttributes");
            aggregate.appendChild(exposedAttrs);
            Element attributeGroup = domDoc.createElement("attributeGroup");
            Attr attrGroupName = domDoc.createAttribute("name");
            attrGroupName.setValue(RB.getStringResource("groupNameNotYetImplemented.txt"));
            attributeGroup.setAttributeNode(attrGroupName);
            exposedAttrs.appendChild(attributeGroup);
            String[] attrKeys = ae.getEntityInterface().listAttributeNames();
            ArrayList attrmaps = null;
            for (int j = 0; j < attrKeys.length; ++j) {
                attrmaps = ae.getKeyList(attrKeys[j]);
                Element exposedAttribute = domDoc.createElement("exposedAttribute");
                Attr exposedAttrName = domDoc.createAttribute("name");
                exposedAttrName.setValue(attrKeys[j]);
                exposedAttribute.setAttributeNode(exposedAttrName);
                attributeGroup.appendChild(exposedAttribute);
                for (EntityAttr item : attrmaps) {
                    if (item == null) continue;
                    EntityInterface entity = item.getEntity();
                    String attrName = item.getAttrName();
                    Element attributeMap = domDoc.createElement("attributeMap");
                    Attr mapName = domDoc.createAttribute("attributeName");
                    mapName.setValue(attrName);
                    attributeMap.setAttributeNode(mapName);
                    Attr mapEntityKey = domDoc.createAttribute("entityKey");
                    String[] attrs = null;
                    if (entity == null) continue;
                    attrs = entity.listAttributeNames();
                    for (int i = 0; i < attrs.length; ++i) {
                        String key = attrs[i];
                        if (!key.equals("entityKey")) continue;
                        mapEntityKey.setValue((String)entity.getAttribute(key));
                        break;
                    }
                    attributeMap.setAttributeNode(mapEntityKey);
                    exposedAttribute.appendChild(attributeMap);
                }
            }
            domDoc.writeDocument(new OutputStreamWriter(bo), true);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        boolean validEncoding = true;
        try {
            xmlString = bo.toString("UTF-8");
            return validEncoding ? xmlString : bo.toString();
        }
        catch (UnsupportedEncodingException uee) {
            try {
                validEncoding = false;
                return validEncoding ? xmlString : bo.toString();
            }
            catch (Throwable throwable) {
                return validEncoding ? xmlString : bo.toString();
            }
        }
    }

    public static AggregateEntity createEntityFromXML(String docString) {
        AggregateEntity aggregate = new AggregateEntity();
        HashMap<String, String> entities = new HashMap<String, String>();
        try {
            byte[] xmlBytes = docString.getBytes("UTF-8");
            if (xmlBytes == null || xmlBytes.length == 0) {
                return null;
            }
            DOMDoc doc = new DOMDoc();
            doc.loadDocument(new ByteArrayInputStream(xmlBytes), false);
            Element rootElement = doc.getDocumentElement();
            String name = null;
            if (rootElement.getTagName().equals("aggregateEntity")) {
                NamedNodeMap aggregateMap = rootElement.getAttributes();
                String aggregateName = aggregateMap.getNamedItem("name").getNodeValue();
                aggregate.setName(aggregateName);
                NodeList nl = rootElement.getElementsByTagName("*");
                int nodeLength = nl.getLength();
                for (int i = 0; i < nodeLength; ++i) {
                    NamedNodeMap nodeMap;
                    Node attributeElement = nl.item(i);
                    String nodeName = attributeElement.getNodeName();
                    if (nodeName.equals("referenceEntity") && attributeElement.hasAttributes()) {
                        nodeMap = attributeElement.getAttributes();
                        String entityKey = nodeMap.getNamedItem("entityKey").getNodeValue();
                        String entityName = nodeMap.getNamedItem("name").getNodeValue();
                        entities.put(entityKey, entityName);
                        aggregate.addEntityKey(entityKey, entityName);
                        continue;
                    }
                    if (nodeName.equals("exposedAttribute") && attributeElement.hasAttributes()) {
                        nodeMap = attributeElement.getAttributes();
                        name = nodeMap.getNamedItem("name").getNodeValue();
                        continue;
                    }
                    if (!nodeName.equals("attributeMap") || !attributeElement.hasAttributes()) continue;
                    nodeMap = attributeElement.getAttributes();
                    String attributeName = nodeMap.getNamedItem("attributeName").getNodeValue();
                    String attrEntityKey = nodeMap.getNamedItem("entityKey").getNodeValue();
                    if (name == null) continue;
                    EntityAttr newItem = new EntityAttr(attrEntityKey, attributeName);
                    String attrEntityName = (String)entities.get(attrEntityKey);
                    newItem.setEntityName(attrEntityName);
                    aggregate.addToKeyList(name, newItem, -1);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return aggregate;
    }
}

