/*
 * Decompiled with CFR 0.152.
 */
package com.sas.entities.edit.visuals.swing;

import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.AttributeTypeUtility;
import com.sas.entities.RemoteEntityInterface;
import com.sas.entities.edit.visuals.AttributeValueEditorInterface;
import com.sas.entities.edit.visuals.ComboValueEditorInterface;
import com.sas.entities.edit.visuals.ListLabelsInterface;
import com.sas.entities.edit.visuals.swing.RB;
import com.sas.entities.persist.ConfigurationXMLPersistenceUtility;
import com.sas.entities.persist.ParsedConfigurationXMLObject;
import com.sas.swing.visuals.tableview.DefaultTableCellEditor;
import com.sas.swing.visuals.tableview.DefaultTableCellRenderer;
import com.sas.util.validators.ValidationInterface;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

@SASScope(value="ALL")
public class ComboValueEditor
extends DefaultTableCellEditor
implements AttributeValueEditorInterface,
ComboValueEditorInterface,
ListLabelsInterface {
    public static final String RB_KEY = "ComboValueEditor.";
    protected RemoteEntityInterface entity;
    protected String attributeName;
    protected DefaultComboBoxModel model;
    protected String noDefaultValueSetString;
    protected ParsedConfigurationXMLObject xmlObject;
    protected Map valueLabelMap;
    private List values;
    private int listSize;
    private AttributeDescriptorInterface adi;

    public ComboValueEditor() {
        this(null);
    }

    public ComboValueEditor(Locale locale) {
        super(new JComboBox());
        this.setLocale(locale);
        this.model = new DefaultComboBoxModel();
        this.noDefaultValueSetString = RB.getStringResource(RB_KEY, "attributeNotSet.pd.txt");
    }

    @Override
    public void setEditInfo(RemoteEntityInterface entity, String attributeName) {
        this.entity = entity;
        this.attributeName = attributeName;
        try {
            String configurationXML = null;
            this.adi = entity.getAttributeGroup().getAttributeDescriptor(attributeName, true);
            Object defaultValue = this.adi.getDefault();
            configurationXML = this.adi.getConfigurationXML();
            if (configurationXML != null) {
                this.xmlObject = ConfigurationXMLPersistenceUtility.createParsedConfigurationXMLObject(configurationXML);
                this.valueLabelMap = this.xmlObject.getEnumerationValuesLabelsMap(this.getLocale());
                this.values = this.xmlObject.getEnumerationTextLabels(this.getLocale());
                this.listSize = this.values.size();
                for (int i = 0; i < this.listSize; ++i) {
                    this.model.addElement(this.values.get(i));
                }
                if (defaultValue == null && entity.containsAttributeNamed(this.adi.getName()) && entity.getAttribute(this.adi.getName()) == null) {
                    this.model.insertElementAt(this.noDefaultValueSetString, 0);
                    this.valueLabelMap.put(this.noDefaultValueSetString, this.noDefaultValueSetString);
                }
            } else if (defaultValue != null) {
                this.model.addElement(defaultValue);
            }
            ((JComboBox)this.editorComponent).setModel(this.model);
            List validators = this.adi.getValidators("Java");
            if (validators != null && validators.size() > 0) {
                super.setValidator((ValidationInterface)validators.get(0));
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public Object getEditGUI() {
        return this;
    }

    @Override
    public Object getRendererGUI() {
        return new DefaultTableCellRenderer();
    }

    public String getNoDefaultValueSetString() {
        return this.noDefaultValueSetString;
    }

    public void setNoDefaultValueSetString(String noDefaultValueSetString) {
        if (noDefaultValueSetString != null) {
            this.noDefaultValueSetString = noDefaultValueSetString;
        }
    }

    protected Map getValuesAndLabelsMap(Locale locale) {
        if (this.xmlObject == null) {
            throw new IllegalStateException();
        }
        return this.xmlObject.getEnumerationValuesLabelsMap(locale);
    }

    @Override
    public String getLabelForValue(Object value, Locale locale) {
        Object returnValue = this.valueLabelMap.get(value);
        if (returnValue == null) {
            if (value != null) {
                int sqlType = this.adi.getType().getSQLType();
                if (AttributeTypeUtility.wrapperTypeHasStringArgConstructor((int)sqlType)) {
                    try {
                        Class[] stringArgsClass = new Class[]{String.class};
                        Class c = AttributeTypeUtility.getJavaClassToConstruct((int)sqlType, null);
                        Constructor stringArgsConstructor = c.getConstructor(stringArgsClass);
                        Object[] stringArgs = null;
                        Object o = null;
                        for (int i = 0; i < this.listSize; ++i) {
                            stringArgs = new Object[]{this.values.get(i).toString()};
                            o = stringArgsConstructor.newInstance(stringArgs);
                            if (!o.toString().equals(value.toString())) continue;
                            return this.values.get(i).toString();
                        }
                        return value.toString();
                    }
                    catch (Exception e) {
                        return value.toString();
                    }
                }
                return value.toString();
            }
            return null;
        }
        return this.valueLabelMap.get(value).toString();
    }

    @Override
    public Object getValueForLabel(String label) {
        String returnValue = label;
        if (this.valueLabelMap.containsValue(label)) {
            Set entrySet = this.valueLabelMap.entrySet();
            String valueName = null;
            String labelName = null;
            for (Map.Entry entry : entrySet) {
                valueName = (String)entry.getKey();
                labelName = (String)entry.getValue();
                if (!label.equals(labelName)) continue;
                returnValue = valueName;
                break;
            }
        }
        return returnValue;
    }
}

