/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class SetterInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private transient boolean instantiating;
    private transient List setters;
    private transient List setterNames;
    private transient Class[] setterTypes;

    public SetterInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, allowNonPublicClasses);
    }

    public SetterInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, false);
    }

    protected Constructor getGreediestSatisifableConstructor(List adapterInstantiationOrderTrackingList) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor constructor;
        try {
            constructor = this.getComponentImplementation().getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        catch (SecurityException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        if (this.setters == null) {
            this.initializeSetterAndTypeLists();
        }
        ArrayList<Object> matchingTypeList = new ArrayList<Object>(Collections.nCopies(this.setters.size(), null));
        HashSet<Integer> nonMatchingParameterPositions = new HashSet<Integer>();
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(this.setterTypes);
        for (int i = 0; i < currentParameters.length; ++i) {
            Parameter parameter = currentParameters[i];
            boolean failedDependency = true;
            for (int j = 0; j < this.setterTypes.length; ++j) {
                ComponentAdapter adapter;
                if (matchingTypeList.get(j) != null || (adapter = parameter.resolveAdapter(this.getContainer(), this.setterTypes[j])) == null || adapter.equals(this) || this.getComponentKey().equals(adapter.getComponentKey())) continue;
                matchingTypeList.set(j, adapter);
                failedDependency = false;
                break;
            }
            if (!failedDependency) continue;
            nonMatchingParameterPositions.add(new Integer(i));
        }
        HashSet<Class> unsatisfiableDependencyTypes = new HashSet<Class>();
        for (int i = 0; i < matchingTypeList.size(); ++i) {
            if (matchingTypeList.get(i) != null) continue;
            unsatisfiableDependencyTypes.add(this.setterTypes[i]);
        }
        if (unsatisfiableDependencyTypes.size() > 0) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiableDependencyTypes);
        }
        if (nonMatchingParameterPositions.size() > 0) {
            throw new PicoInitializationException("Following parameters do not match any of the setters for " + this.getComponentImplementation() + ": " + ((Object)nonMatchingParameterPositions).toString());
        }
        adapterInstantiationOrderTrackingList.addAll(matchingTypeList);
        return constructor;
    }

    protected Object instantiateComponent(List adapterInstantiationOrderTrackingList) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        try {
            Constructor constructor = this.getGreediestSatisifableConstructor(adapterInstantiationOrderTrackingList);
            if (this.instantiating) {
                throw new CyclicDependencyException(this.setterTypes);
            }
            this.instantiating = true;
            Object componentInstance = this.newInstance(constructor, null);
            for (int i = 0; i < this.setters.size(); ++i) {
                Method setter = (Method)this.setters.get(i);
                ComponentAdapter adapter = (ComponentAdapter)adapterInstantiationOrderTrackingList.get(i);
                setter.invoke(componentInstance, adapter.getComponentInstance());
            }
            Object object = componentInstance;
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new PicoInvocationTargetInitializationException(e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        finally {
            this.instantiating = false;
        }
    }

    private void initializeSetterAndTypeLists() {
        this.setters = new ArrayList();
        this.setterNames = new ArrayList();
        ArrayList typeList = new ArrayList();
        Method[] methods = this.getComponentImplementation().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            boolean isBeanStyle;
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) continue;
            String methodName = method.getName();
            boolean bl = isBeanStyle = methodName.length() >= 4 && methodName.startsWith("set") && Character.isUpperCase(methodName.charAt(3));
            if (!isBeanStyle) continue;
            String attribute = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            this.setters.add(method);
            this.setterNames.add(attribute);
            typeList.add(parameterTypes[0]);
        }
        this.setterTypes = typeList.toArray(new Class[0]);
    }
}

