/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.tree;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsActionContext;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.tree.ITransformationsTreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.visuals.tree.AbstractCategoryTree;
import java.util.List;

public class TransformationsTree
extends AbstractCategoryTree {
    private static final WAdminResource bundle = WAdminResource.getBundle(TransformationsTree.class);
    public static final String TRANSFORMATIONS_TREE_CONTEXT = "TransformationsTree";

    public TransformationsTree(ITransformationsTreeModel model) {
        super(model);
        this.setName(bundle.getString("TransformationsTree.Name.txt"));
        this.setIconDecorationsSupported(true);
        this.expandRoot();
        this.setLeadSelectionPath(this.getPathForRow(0));
    }

    @Override
    protected WsActionContextInterface createActionContext() {
        return new WsActionContext(TRANSFORMATIONS_TREE_CONTEXT, this);
    }

    @Override
    public void selectObjects(SimpleObject[] aSimpleObjects) {
        this.clearSelection();
        List lNodes = ((ITransformationsTreeModel)this.getModel()).findTransformationNodes(aSimpleObjects);
        for (int i = 0; i < lNodes.size(); ++i) {
            this.addSelectionPath(this.getPathFor((ITreeNode)lNodes.get(i)));
        }
        this.scrollPathToVisible(this.getLeadSelectionPath());
    }

    @Override
    public void refresh() {
        ((ITransformationsTreeModel)this.getModel()).refreshTransformations();
    }
}

