/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.tree;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.Folder;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.OpRequestUICancellableRunnable;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractApplicationFrameworkManager;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsAbstractOperation;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsLockManager;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.changemanagement.CMMetadataUtil;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.DecoratableIcon;
import com.sas.workspace.models.ISimpleObjectDecorator;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.tree.CategoryTreeNode;
import com.sas.workspace.models.tree.DropTargetResult;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode2;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.SimpleBrowseObjectTreeNode;
import com.sas.workspace.visuals.tree.BaseTreeUI;
import com.sas.workspace.visuals.tree.IBaseTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractBaseTree
extends JTree
implements IBaseTree,
ITreeModel.IconDecoratorListener {
    private static WAdminResource bundle = WAdminResource.getBundle(AbstractBaseTree.class);
    private static final String UICLASSID = "BaseTreeUI";
    private static final String ICON_DECORATION_OPTION_KEY = "Workspace.ShowIconDecorations";
    private Object[] m_aSelectedObjects = new Object[0];
    private boolean m_bContextMenusEnabled;
    private boolean m_bDraggingEnabled;
    private boolean m_bIconDecorationsSupported;
    private boolean m_bIconDecorationsEnabled;
    private boolean m_bListeningForSelectionChanges;
    private Action m_userDefaultAction;
    private cIconDecoratorThreadGroup m_decoratorGroup;
    private cAppDefaultsListener m_appDefaultsListener;
    private DragSource m_dragSource;
    private DropTarget m_dropTarget;
    private Color m_clrSelectionBackground;
    private Color m_clrSelectionForeground;
    private Color m_clrNonFocusSelectionBackground;
    private Color m_clrNonFocusSelectionForeground;
    protected WsActionContextInterface m_context;
    protected WsAbstractAction m_expandAction;
    protected WsAbstractAction m_collapseAction;
    protected WsAbstractAction m_expandAllAction;
    protected WsAbstractAction m_newFolderAction;
    protected WsAbstractAction m_renameAction;
    protected WsAbstractAction m_deleteAction;
    protected WsAbstractAction m_refreshAction;
    protected WsAbstractAction m_popupAction;
    protected WsAbstractAction m_defaultAction;
    protected WsAbstractAction m_propertiesAction;
    protected WsAbstractAction m_runAction;

    public AbstractBaseTree() {
        this((ITreeModel)null);
    }

    public AbstractBaseTree(ITreeModel model) {
        super(model);
        this.setEditable(true);
        this.setInvokesStopCellEditing(true);
        this.createActions();
        this.createKeyActionMappings();
        this.setContextMenusEnabled(true);
        this.setDraggingEnabled(true);
        this.m_appDefaultsListener = new cAppDefaultsListener();
        WorkspaceFile appDefaults = Workspace.getWorkspace().getAppDefaultsFile();
        appDefaults.addPropertyChangeListener(this.m_appDefaultsListener);
        this.setIconDecorationsEnabled(appDefaults.getPropertyBoolean(ICON_DECORATION_OPTION_KEY, true));
        this.setSelectionBackground(null);
        this.setSelectionForeground(null);
        this.setNonFocusSelectionBackground(null);
        this.setNonFocusSelectionForeground(null);
        this.m_context = this.createActionContext();
        this.addTreeExpansionListener(this.createExpansionListener());
        this.addTreeSelectionListener(this.createSelectionListener());
        this.m_bListeningForSelectionChanges = true;
        TreeCellRenderer renderer = this.createTreeCellRenderer();
        this.setCellRenderer(renderer);
        this.setCellEditor(this.createTreeCellEditor(renderer));
        this.m_dragSource = new DragSource();
        this.m_dragSource.createDefaultDragGestureRecognizer(this, 3, this.createDragGestureListener());
        this.m_dropTarget = new DropTarget(this, this.createDropTargetListener());
        this.m_dropTarget.setDefaultActions(3);
    }

    @Override
    public String getUIClassID() {
        if (UIManager.get(UICLASSID) == null) {
            UIManager.put(UICLASSID, BaseTreeUI.class.getName());
        }
        return UICLASSID;
    }

    @Override
    public void setModel(TreeModel model) {
        if (!(model instanceof ITreeModel)) {
            throw new IllegalArgumentException("The tree model must be an ITreeModel.");
        }
        ITreeModel oldModel = (ITreeModel)this.getModel();
        if (oldModel != null) {
            oldModel.removeIconDecoratorListener(this);
            oldModel.dispose();
        }
        super.setModel(model);
        ((ITreeModel)model).addIconDecoratorListener(this);
    }

    protected void createActions() {
        this.m_expandAction = new cExpandAction();
        this.m_collapseAction = new cCollapseAction();
        this.m_expandAllAction = new cExpandAllAction();
        this.m_newFolderAction = new cNewFolderAction();
        this.m_renameAction = new cRenameAction();
        this.m_deleteAction = new cDeleteAction();
        this.m_refreshAction = new cRefreshAction();
        this.m_popupAction = new cPopupAction();
        this.m_defaultAction = new cDefaultAction();
        WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
        if (actionsMgr != null) {
            this.m_propertiesAction = actionsMgr.getAction("Application:Properties");
            this.m_runAction = actionsMgr.getAction("Application:Run");
        }
    }

    protected abstract WsActionContextInterface createActionContext();

    protected void createKeyActionMappings() {
        this.getInputMap().put(KeyStroke.getKeyStroke(121, 64, false), "popup");
        this.getInputMap().put(KeyStroke.getKeyStroke(525, 0, false), "popup");
        this.getInputMap().put(KeyStroke.getKeyStroke(116, 0, false), "refresh");
        this.getInputMap().put(KeyStroke.getKeyStroke(67, 128, false), "copy");
        this.getInputMap().put(KeyStroke.getKeyStroke(86, 128, false), "paste");
        this.getInputMap().put(KeyStroke.getKeyStroke(155, 128, false), "copy");
        this.getInputMap().put(KeyStroke.getKeyStroke(155, 64, false), "paste");
        this.getInputMap().put(KeyStroke.getKeyStroke(155, 0, false), "rename");
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0, false), "delete");
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0, false), "default");
        this.getInputMap().put(KeyStroke.getKeyStroke(106, 0, false), "expandall");
        this.getActionMap().put("popup", this.m_popupAction);
        this.getActionMap().put("refresh", this.m_refreshAction);
        this.getActionMap().put("rename", this.m_renameAction);
        this.getActionMap().put("delete", this.m_deleteAction);
        this.getActionMap().put("default", this.m_defaultAction);
        this.getActionMap().put("expandall", this.m_expandAllAction);
        WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
        if (actionsMgr != null) {
            WsAbstractAction copyAction = actionsMgr.getAction("Common:Copy");
            WsAbstractAction pasteAction = actionsMgr.getAction("Common:Paste");
            WsAbstractAction pasteSpecialAction = actionsMgr.getAction("Common:PasteSpecial");
            this.getActionMap().put("copy", copyAction);
            this.getActionMap().put("paste", pasteAction);
            this.getActionMap().put("pastespecial", pasteSpecialAction);
        }
    }

    protected TreeExpansionListener createExpansionListener() {
        return new cExpansionListener();
    }

    protected TreeSelectionListener createSelectionListener() {
        return new cSelectionListener();
    }

    protected DragGestureListener createDragGestureListener() {
        return new cDragGestureListener();
    }

    protected DragSourceListener createDragSourceListener() {
        return null;
    }

    protected DropTargetListener createDropTargetListener() {
        return new cDropTargetListener();
    }

    protected TreeCellRenderer createTreeCellRenderer() {
        return new cTreeCellRenderer();
    }

    protected TreeCellEditor createTreeCellEditor(TreeCellRenderer renderer) {
        return new cTreeCellEditor(this, renderer);
    }

    @Override
    protected TreeModelListener createTreeModelListener() {
        return new cTreeModelHandler();
    }

    protected OpRequestUICancellableRunnable createDeleteOperation(IDataTreeNode[] aNodes, OpRequestUI opUI) {
        return new DeleteOperation(aNodes, opUI);
    }

    @Override
    public void dispose() {
        Workspace.getWorkspace().getAppDefaultsFile().removePropertyChangeListener(this.m_appDefaultsListener);
        if (this.m_decoratorGroup != null) {
            this.m_decoratorGroup.dispose();
        }
        ((ITreeModel)this.getModel()).removeIconDecoratorListener(this);
        ((ITreeModel)this.getModel()).dispose();
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        WsAbstractApplicationFrameworkManager frameworkMgr;
        WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
        if (actionsMgr != null) {
            actionsMgr.setSelectionProvider(bActive ? this : null);
        }
        if ((frameworkMgr = WsAbstractApplicationFrameworkManager.getInstance()) != null) {
            frameworkMgr.setSelectionProvider(bActive ? this : null);
        }
        this.m_expandAction.setActive(bActive);
        this.m_collapseAction.setActive(bActive);
        this.m_expandAllAction.setActive(bActive);
        this.m_newFolderAction.setActive(bActive);
        this.m_renameAction.setActive(bActive);
        this.m_deleteAction.setActive(bActive);
        this.m_refreshAction.setActive(bActive);
        this.m_popupAction.setActive(bActive);
        this.m_defaultAction.setActive(bActive);
        if (this.m_propertiesAction != null) {
            this.m_propertiesAction.setActive(bActive);
        }
        if (this.m_runAction != null) {
            this.m_runAction.setActive(bActive);
        }
    }

    protected void updateActions() {
        ITreeNode[] aSelectedNodes = this.getSelectedNodes();
        int iSelectedNodes = aSelectedNodes.length;
        boolean bNodesSelected = iSelectedNodes > 0;
        boolean bSingleNodeSelected = iSelectedNodes == 1;
        boolean bOnlyDataNodesSelected = bNodesSelected;
        boolean bOnlyFoldersSelected = bNodesSelected;
        boolean bFolderNodesAllExpanded = true;
        boolean bFolderNodesAllCollapsed = true;
        boolean bAllDataNodesRenameable = true;
        boolean bAllDataNodesDeleteable = true;
        for (int i = 0; i < iSelectedNodes; ++i) {
            ITreeNode node = aSelectedNodes[i];
            if (node instanceof IDataTreeNode) {
                bAllDataNodesRenameable &= ((IDataTreeNode)node).isRenameAllowed();
                bAllDataNodesDeleteable &= ((IDataTreeNode)node).isDeleteAllowed();
            } else {
                bOnlyDataNodesSelected = false;
            }
            if (node.isFolder()) {
                boolean bExpanded = this.isExpanded(this.getPathFor(node));
                bFolderNodesAllExpanded &= bExpanded;
                bFolderNodesAllCollapsed &= !bExpanded;
                continue;
            }
            bOnlyFoldersSelected = false;
        }
        this.m_expandAction.setEnabled(bOnlyFoldersSelected && bFolderNodesAllCollapsed);
        this.m_collapseAction.setEnabled(bOnlyFoldersSelected && bFolderNodesAllExpanded);
        this.m_newFolderAction.setEnabled(!bNodesSelected || bSingleNodeSelected && bOnlyFoldersSelected);
        this.m_renameAction.setEnabled(bSingleNodeSelected && bOnlyDataNodesSelected && bAllDataNodesRenameable);
        this.m_deleteAction.setEnabled(bOnlyDataNodesSelected && bAllDataNodesDeleteable);
        this.m_defaultAction.setEnabled(bSingleNodeSelected && (bOnlyFoldersSelected || bOnlyDataNodesSelected));
    }

    @Override
    public Action getUserDefaultAction() {
        return this.m_userDefaultAction;
    }

    @Override
    public void setUserDefaultAction(Action userDefaultAction) {
        this.m_userDefaultAction = userDefaultAction;
    }

    @Override
    public boolean isContextMenusEnabled() {
        return this.m_bContextMenusEnabled;
    }

    @Override
    public void setContextMenusEnabled(boolean bContextMenusEnabled) {
        this.m_bContextMenusEnabled = bContextMenusEnabled;
    }

    @Override
    public boolean isDraggingEnabled() {
        return this.m_bDraggingEnabled;
    }

    @Override
    public void setDraggingEnabled(boolean bDraggingEnabled) {
        this.m_bDraggingEnabled = bDraggingEnabled;
    }

    @Override
    public boolean isDroppingEnabled() {
        return this.m_dropTarget.isActive();
    }

    @Override
    public void setDroppingEnabled(boolean bDroppingEnabled) {
        this.m_dropTarget.setActive(bDroppingEnabled);
    }

    public boolean isIconDecorationsSupported() {
        return this.m_bIconDecorationsSupported;
    }

    public void setIconDecorationsSupported(boolean bIconDecorationsSupported) {
        this.m_bIconDecorationsSupported = bIconDecorationsSupported;
    }

    @Override
    public boolean isIconDecorationsEnabled() {
        return this.m_bIconDecorationsEnabled;
    }

    @Override
    public void setIconDecorationsEnabled(boolean bIconDecorationsEnabled) {
        this.m_bIconDecorationsEnabled = bIconDecorationsEnabled;
    }

    public void setSelectionBackground(Color clrSelectionBackground) {
        this.m_clrSelectionBackground = clrSelectionBackground == null ? UIManager.getColor("Tree.selectionBackground") : clrSelectionBackground;
        this.repaint();
    }

    public Color getSelectionBackground() {
        return this.m_clrSelectionBackground;
    }

    public void setSelectionForeground(Color clrSelectionForeground) {
        this.m_clrSelectionForeground = clrSelectionForeground == null ? UIManager.getColor("Tree.selectionForeground") : clrSelectionForeground;
        this.repaint();
    }

    public Color getSelectionForeground() {
        return this.m_clrSelectionForeground;
    }

    public void setNonFocusSelectionBackground(Color clrNonFocusSelectionBackground) {
        if (clrNonFocusSelectionBackground == null) {
            Color clrBackground = UIManager.getColor("Tree.background");
            int red = (SystemColor.controlShadow.getRed() + clrBackground.getRed()) / 2;
            int green = (SystemColor.controlShadow.getGreen() + clrBackground.getGreen()) / 2;
            int blue = (SystemColor.controlShadow.getBlue() + clrBackground.getBlue()) / 2;
            this.m_clrNonFocusSelectionBackground = new Color(red, green, blue);
        } else {
            this.m_clrNonFocusSelectionBackground = clrNonFocusSelectionBackground;
        }
        this.repaint();
    }

    public Color getNonFocusSelectionBackground() {
        return this.m_clrNonFocusSelectionBackground;
    }

    public void setNonFocusSelectionForeground(Color clrNonFocusSelectionForeground) {
        this.m_clrNonFocusSelectionForeground = clrNonFocusSelectionForeground == null ? this.getForeground() : clrNonFocusSelectionForeground;
        this.repaint();
    }

    public Color getNonFocusSelectionForeground() {
        return this.m_clrNonFocusSelectionForeground;
    }

    @Override
    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.add(WsSelectionChangedListener.class, lsnr);
    }

    @Override
    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        this.listenerList.remove(WsSelectionChangedListener.class, lsnr);
    }

    protected void updateStatusBar() {
        String sStatusText;
        block9: {
            sStatusText = "";
            ITreeNode[] aSelectedNodes = this.getSelectedNodes();
            int iSelectedNodes = aSelectedNodes.length;
            if (iSelectedNodes == 1) {
                if (aSelectedNodes[0] instanceof SimpleBrowseObjectTreeNode) {
                    try {
                        String sUserName;
                        SimpleBrowseObject oObject = ((SimpleBrowseObjectTreeNode)aSelectedNodes[0]).getSimpleBrowseObject();
                        String sObjectName = oObject.getName();
                        String sPublicType = oObject.getPublicType();
                        TypeDescriptorInterface typeInterface = Workspace.getWorkspace().getUserContext().getAuthServer().getTypeDescriptor(sPublicType);
                        String sPublicTypeForStatusText = sPublicType;
                        if (typeInterface != null) {
                            sPublicTypeForStatusText = typeInterface.getType();
                        }
                        if ((sUserName = CMMetadataUtil.getLockedByName(oObject)) != null) {
                            sStatusText = bundle.formatString("AbstractBaseTree.ObjectCheckedOutBy.fmt", sObjectName, sPublicTypeForStatusText, sUserName);
                            break block9;
                        }
                        sStatusText = bundle.formatString("AbstractBaseTree.ObjectNameAndPublicType.fmt", sObjectName, sPublicTypeForStatusText);
                    }
                    catch (MdException oObject) {
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException(ex);
                    }
                    catch (ServiceException e) {
                        Workspace.handleServiceException(e);
                    }
                }
            } else {
                sStatusText = bundle.formatString("AbstractBaseTree.NumberSelected.fmt", Integer.toString(iSelectedNodes));
            }
        }
        Workspace.getWorkspace().setStatusText(sStatusText);
    }

    @Override
    public void selectObjects(SimpleObject[] aSimpleObjects) {
        this.clearSelection();
        for (int i = 0; i < aSimpleObjects.length; ++i) {
            String sFQID = aSimpleObjects[i].getID();
            List lNodes = ((ITreeModel)this.getModel()).findNodes(sFQID);
            for (int j = 0; j < lNodes.size(); ++j) {
                this.addSelectionPath(this.getPathFor((ITreeNode)lNodes.get(j)));
            }
        }
        this.scrollPathToVisible(this.getLeadSelectionPath());
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.m_aSelectedObjects;
    }

    protected void setSelectedObjects(Object[] selectedObjects) {
        this.m_aSelectedObjects = selectedObjects;
    }

    @Override
    public ITreeNode getSelectedNode() {
        return (ITreeNode)this.getLastSelectedPathComponent();
    }

    @Override
    public ITreeNode[] getSelectedNodes() {
        TreePath[] aSelectedPaths = this.getSelectionPaths();
        int nSelectedPaths = aSelectedPaths == null ? 0 : aSelectedPaths.length;
        ITreeNode[] aSelectedNodes = new ITreeNode[nSelectedPaths];
        for (int iSelectedPath = 0; iSelectedPath < nSelectedPaths; ++iSelectedPath) {
            aSelectedNodes[iSelectedPath] = (ITreeNode)aSelectedPaths[iSelectedPath].getLastPathComponent();
        }
        return aSelectedNodes;
    }

    @Override
    public IDataTreeNode getSelectedDataNode() {
        ITreeNode node = this.getSelectedNode();
        return node instanceof IDataTreeNode ? (IDataTreeNode)node : null;
    }

    @Override
    public IDataTreeNode[] getSelectedDataNodes() {
        ITreeNode[] aNodes = this.getSelectedNodes();
        ArrayList<ITreeNode> lDataNodes = new ArrayList<ITreeNode>();
        for (int i = 0; i < aNodes.length; ++i) {
            if (!(aNodes[i] instanceof IDataTreeNode)) continue;
            lDataNodes.add(aNodes[i]);
        }
        return lDataNodes.toArray(new IDataTreeNode[lDataNodes.size()]);
    }

    @Override
    public boolean isListeningForSelectionChanges() {
        return this.m_bListeningForSelectionChanges;
    }

    @Override
    public void setListeningForSelectionChanges(boolean bListening) {
        this.m_bListeningForSelectionChanges = bListening;
    }

    protected void fireSelectionChangedEvent() {
        WsSelectionChangedListener[] aListeners = (WsSelectionChangedListener[])this.listenerList.getListeners(WsSelectionChangedListener.class);
        if (aListeners.length == 0) {
            return;
        }
        WsSelectionChangedEvent ev = new WsSelectionChangedEvent(this);
        for (int iListener = 0; iListener < aListeners.length; ++iListener) {
            aListeners[iListener].selectionChanged(ev);
        }
    }

    @Override
    public void decorateIcons(ITreeNode[] aNodes) {
        if (this.m_bIconDecorationsSupported && this.m_bIconDecorationsEnabled) {
            if (this.m_decoratorGroup == null) {
                this.m_decoratorGroup = new cIconDecoratorThreadGroup();
            }
            new cIconDecoratorThread(this.m_decoratorGroup, aNodes).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Window parent = SwingUtilities.getWindowAncestor(this);
        if (parent != null) {
            parent.setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            try {
                Class<?> cObjectConverter = Class.forName("com.sas.wadmin.app.ObjectConverter");
                Method mGetInstance = cObjectConverter.getDeclaredMethod("getInstance", null);
                Object oInstance = mGetInstance.invoke(null, null);
                Method mClearCache = cObjectConverter.getDeclaredMethod("clearObjectCache", null);
                mClearCache.invoke(oInstance, null);
            }
            catch (ClassNotFoundException cObjectConverter) {
            }
            catch (NoSuchMethodException cObjectConverter) {
            }
            catch (IllegalAccessException cObjectConverter) {
            }
            catch (InvocationTargetException ex) {
                Workspace.getDefaultLogger().error((Object)"Error clearing ObjectConverter cache on tree refresh:", ex.getCause());
            }
            ITreeModel model = (ITreeModel)this.getModel();
            ITreeNode nodeNewRoot = (ITreeNode)model.getRoot();
            ITreeNode nodeOldRoot = (ITreeNode)nodeNewRoot.clone();
            model.removeAllChildren(nodeNewRoot);
            nodeNewRoot.setPopulated(false);
            this.refreshNode(nodeNewRoot, nodeOldRoot);
            this.fireTreeExpanded(this.getPathFor(nodeNewRoot));
        }
        finally {
            if (parent != null) {
                parent.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    protected void refreshNode(ITreeNode nodeNew, ITreeNode nodeOld) {
        if (nodeOld.isExpanded()) {
            this.expandNode(nodeNew);
            int nOldChildren = nodeOld.getChildCount();
            int nNewChildren = nodeNew.getChildCount();
            block0: for (int iOldChild = 0; iOldChild < nOldChildren; ++iOldChild) {
                ITreeNode nodeOldChild = (ITreeNode)nodeOld.getChildAt(iOldChild);
                for (int iNewChild = 0; iNewChild < nNewChildren; ++iNewChild) {
                    ITreeNode nodeNewChild = (ITreeNode)nodeNew.getChildAt(iNewChild);
                    if (!nodeOldChild.equals(nodeNewChild)) continue;
                    this.refreshNode(nodeNewChild, nodeOldChild);
                    continue block0;
                }
            }
            this.expandPath(this.getPathFor(nodeNew));
        }
    }

    @Override
    public void expandRoot() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            this.fireTreeExpanded(new TreePath(this.treeModel.getRoot()));
        }
    }

    protected void expandNode(ITreeNode node) {
        boolean bNodePreviouslyPopulated = node.isPopulated();
        node.expand();
        node.setExpanded(true);
        if (this.m_bIconDecorationsSupported && this.m_bIconDecorationsEnabled && !bNodePreviouslyPopulated) {
            ArrayList<? extends TreeNode> lChildren = Collections.list(node.children());
            ITreeNode[] aChildren = new ITreeNode[lChildren.size()];
            aChildren = lChildren.toArray(aChildren);
            this.decorateIcons(aChildren);
        }
    }

    public void expandAll() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            this.expandAllUnderNode((ITreeNode)this.treeModel.getRoot());
        }
    }

    @Override
    public void expandAllUnderNode(ITreeNode node) {
        this.expandPath(this.getPathFor(node));
        int iChildren = node.getChildCount();
        for (int i = 0; i < iChildren; ++i) {
            ITreeNode child = (ITreeNode)node.getChildAt(i);
            if (!child.getAllowsChildren()) continue;
            this.expandAllUnderNode(child);
        }
    }

    protected void onExpand() {
        ITreeNode[] nodes = this.getSelectedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            this.expandPath(this.getPathFor(nodes[i]));
        }
    }

    protected void onCollapse() {
        ITreeNode[] nodes = this.getSelectedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            this.collapsePath(this.getPathFor(nodes[i]));
        }
    }

    protected void onExpandAll() {
        ITreeNode[] nodes = this.getSelectedNodes();
        if (nodes.length == 0) {
            this.expandAll();
        } else {
            for (int i = 0; i < nodes.length; ++i) {
                if (!nodes[i].isFolder()) continue;
                this.expandAllUnderNode(nodes[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNewFolder() {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "AbstractBaseTree:onNewFolder");
            try {
                Root mdParent;
                ITreeNode parentNode = this.getSelectedNode();
                if (parentNode != null && !(parentNode instanceof IDataTreeNode)) {
                    return;
                }
                this.expandPath(this.getSelectionPath());
                if (parentNode == null) {
                    parentNode = (ITreeNode)this.getModel().getRoot();
                    ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
                    mdParent = (Root)server.getRootFolder().getRepositoryEntity();
                } else {
                    SimpleObject simpleObject = (SimpleObject)((IDataTreeNode)parentNode).getData();
                    if (simpleObject == null) {
                        return;
                    }
                    mdParent = (Root)Workspace.getMdFactory().createComplexMetadataObject(store, simpleObject.getName(), simpleObject.getMetadataType(), simpleObject.getID());
                }
                Tree mdNewFolder = this.createNewFolder(mdParent, store);
                String sNewFolderID = mdNewFolder.getFQID();
                List lNodes = ((ITreeModel)this.getModel()).findNodes(sNewFolderID);
                for (int j = 0; j < lNodes.size(); ++j) {
                    this.setSelectionPath(this.getPathFor((ITreeNode)lNodes.get(j)));
                }
                this.startEditingAtPath(this.getLeadSelectionPath());
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage(ex, "Creating");
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    protected void onRename() {
        this.startEditingAtPath(this.getSelectionPath());
    }

    protected void onDelete() {
        int eAnswer;
        String sNames;
        this.cancelEditing();
        IDataTreeNode[] aNodes = this.getSelectedDataNodes();
        if (aNodes.length == 1) {
            sNames = aNodes[0].getName();
        } else if (aNodes.length == 2) {
            sNames = bundle.formatString("Common.TwoNames.fmt", aNodes[0].getName(), aNodes[1].getName());
        } else {
            int iNode;
            sNames = "";
            int nNodes = Math.min(aNodes.length, 20);
            for (iNode = 0; iNode < nNodes - 1; ++iNode) {
                sNames = bundle.formatString("Common.ConcatenateNames.fmt", sNames, aNodes[iNode].getName());
            }
            sNames = nNodes < aNodes.length ? bundle.formatString("Common.AndOthers.fmt", sNames) : bundle.formatString("Common.LastName.fmt", sNames, aNodes[iNode].getName());
        }
        String text = bundle.formatString("Common.ConfirmDelete.Text.txt", sNames);
        for (int i = 0; i < aNodes.length; ++i) {
            if (!aNodes[i].isFolder()) continue;
            text = text + "  " + bundle.getString("Common.RecursiveDelete.txt");
            break;
        }
        if ((eAnswer = MessageUtil.displayMessage(text, bundle.getString("Common.ConfirmDelete.Title.txt"), 1, 0)) == 0) {
            if (this.isAnyObjectInUse(aNodes, "Common.ObjectInUseNoDelete.Text.fmt")) {
                return;
            }
            OpRequestUI request = new OpRequestUI(Workspace.getWorkspace(), bundle.getString("AbstractBaseTree.DeleteProgressIndicator.MessagePrototype.txt"), bundle.getString("AbstractBaseTree.DeleteProgressIndicator.Title.txt"));
            request.setDelayBeforeProgressCancelDialog(200);
            request.executeWithCancel(this.createDeleteOperation(aNodes, request));
            Workspace.getDefaultLogger().debug("Finished waiting on delete");
        }
    }

    protected void onRefresh() {
        this.refresh();
    }

    protected void onPopup() {
        Point pt = this.isSelectionEmpty() ? this.getLocation() : this.getPathBounds(this.getLeadSelectionPath()).getLocation();
        this.onPopup(this, pt.x, pt.y);
    }

    protected void onPopup(Component component, int x, int y) {
        if (this.m_bContextMenusEnabled) {
            WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
            if (actionsMgr == null) {
                throw new IllegalStateException("An instance of WsAbstractApplicationActionsManager is required for context menu support.");
            }
            JPopupMenu popupMenu = actionsMgr.createPopupMenuFor(this.m_context);
            if (popupMenu != null && popupMenu.getComponentCount() > 0) {
                popupMenu.show(component, x, y);
            }
        }
    }

    protected void onDefault() {
        Object selectedObject = this.m_aSelectedObjects[0];
        if (selectedObject == null) {
            return;
        }
        if (selectedObject instanceof SimpleBrowseObject) {
            WsAbstractApplicationActionsManager actionsMgr = WsAbstractApplicationActionsManager.getInstance();
            if (actionsMgr != null) {
                actionsMgr.performDefaultActionFor(this, selectedObject, this.m_context);
            }
        } else if (this.getSelectedNode().isFolder()) {
            TreePath path = this.getSelectionPath();
            if (this.isExpanded(path)) {
                this.collapsePath(path);
            } else {
                this.expandPath(path);
            }
        }
    }

    protected void onDrop(Object[] aDroppedObjects, ITreeNode targetNode) {
        targetNode.drop(aDroppedObjects);
    }

    private Object[] getDraggedObjects(DropTargetDragEvent e) {
        DataFlavor[] aFlavors = e.getCurrentDataFlavors();
        for (int i = 0; i < aFlavors.length; ++i) {
            if (!(aFlavors[i] instanceof DNDObject.DNDObjectFlavor)) continue;
            return ((DNDObject.DNDObjectFlavor)aFlavors[i]).getData().getObjects().toArray();
        }
        return new Object[0];
    }

    private Object[] getDroppedObjects(DropTargetDropEvent e) {
        DataFlavor[] aFlavors = e.getCurrentDataFlavors();
        for (int i = 0; i < aFlavors.length; ++i) {
            if (!(aFlavors[i] instanceof DNDObject.DNDObjectFlavor)) continue;
            return ((DNDObject.DNDObjectFlavor)aFlavors[i]).getData().getObjects().toArray();
        }
        return new Object[0];
    }

    protected boolean isAnyObjectInUse(IDataTreeNode[] aNodes, String sMessageKey) {
        int nNodes = aNodes.length;
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            if (aNodes[iNode] == null) continue;
            IDataTreeNode node = aNodes[iNode];
            if (WsLockManager.getInstance().isLocked(node.getID())) {
                String message = bundle.formatString(sMessageKey, aNodes[iNode].getName());
                MessageUtil.displayMessage(message, 2);
                return true;
            }
            if (!node.isFolder()) continue;
            node.expand();
            ArrayList<? extends TreeNode> lChildren = Collections.list(node.children());
            IDataTreeNode[] aChildren = new IDataTreeNode[lChildren.size()];
            aChildren = lChildren.toArray(aChildren);
            if (!this.isAnyObjectInUse(aChildren, sMessageKey)) continue;
            return true;
        }
        return false;
    }

    protected TreePath getPathFor(ITreeNode node) {
        return new TreePath(((DefaultMutableTreeNode)((Object)node)).getPath());
    }

    private Tree createNewFolder(Root mdParent, MdObjectStore store) throws MdException, RemoteException {
        if (!(mdParent instanceof SoftwareComponent) && !(mdParent instanceof Tree)) {
            throw new IllegalArgumentException("Argument must be of type SoftwareComponent or Tree");
        }
        String sRepositoryID = Workspace.getWorkspace().isChangeManagementOn() ? Workspace.getWorkspace().getProjectRepositoryId() : mdParent.getRepositoryID();
        String sName = WsMetadataNameUtil.getUniqueNameForTypeInFolder(bundle.getString("AbstractBaseTree.Untitled.txt"), "Folder", mdParent);
        Tree mdNewFolder = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, sName, "Tree", sRepositoryID);
        mdNewFolder.setTreeType("BIP Folder");
        mdNewFolder.setPublicType("Folder");
        mdNewFolder.setUsageVersion(Folder.CURRENT_VERSION.encode());
        WsMetadataUtil.updateModifiedByFor((Root)mdNewFolder);
        if (mdParent instanceof SoftwareComponent) {
            mdNewFolder.getSoftwareComponents().add((Object)mdParent);
        } else {
            mdNewFolder.setParentTree((Tree)mdParent);
        }
        mdNewFolder.updateMetadataAll();
        return mdNewFolder;
    }

    private class cAppDefaultsListener
    implements PropertyChangeListener {
        private cAppDefaultsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (!AbstractBaseTree.this.isIconDecorationsSupported()) {
                return;
            }
            if (AbstractBaseTree.ICON_DECORATION_OPTION_KEY.equals(ev.getPropertyName())) {
                boolean bNewValue = (Boolean)ev.getNewValue();
                if (AbstractBaseTree.this.isIconDecorationsEnabled() != bNewValue) {
                    AbstractBaseTree.this.setIconDecorationsEnabled(bNewValue);
                    AbstractBaseTree.this.refresh();
                }
            }
        }
    }

    protected class cExpandAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public cExpandAction() {
            this.setMenuSupportId("Common:Expand");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractBaseTree.this.onExpand();
        }

        @Override
        public boolean isValidForContext(WsActionContextInterface context) {
            return this.isEnabled();
        }
    }

    protected class cCollapseAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public cCollapseAction() {
            this.setMenuSupportId("Common:Collapse");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractBaseTree.this.onCollapse();
        }

        @Override
        public boolean isValidForContext(WsActionContextInterface context) {
            return this.isEnabled();
        }
    }

    protected class cExpandAllAction
    extends WsAbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractBaseTree.this.onExpandAll();
        }
    }

    protected class cNewFolderAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public cNewFolderAction() {
            this.setMenuSupportId("Common:NewFolder");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractBaseTree.this.onNewFolder();
        }

        @Override
        public boolean isValidForContext(WsActionContextInterface context) {
            return this.isEnabled();
        }
    }

    protected class cRenameAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public cRenameAction() {
            this.setMenuSupportId("Common:Rename");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractBaseTree.this.onRename();
        }

        @Override
        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aSelectedObjects = context.getSelectedObjects();
            if (aSelectedObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aSelectedObjects.length; ++i) {
                if (aSelectedObjects[i] instanceof SimpleObject) continue;
                return false;
            }
            return true;
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public cDeleteAction() {
            this.setMenuSupportId("Common:Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractBaseTree.this.onDelete();
        }

        @Override
        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aSelectedObjects = context.getSelectedObjects();
            if (aSelectedObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aSelectedObjects.length; ++i) {
                if (aSelectedObjects[i] instanceof SimpleObject) continue;
                return false;
            }
            return true;
        }
    }

    protected class cRefreshAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public cRefreshAction() {
            this.setMenuSupportId("Common:Refresh");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractBaseTree.this.onRefresh();
        }

        @Override
        public boolean isValidForContext(WsActionContextInterface context) {
            return this.isEnabled();
        }
    }

    protected class cPopupAction
    extends WsAbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractBaseTree.this.onPopup();
        }
    }

    protected class cDefaultAction
    extends WsAbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractBaseTree.this.m_userDefaultAction != null && AbstractBaseTree.this.m_userDefaultAction.isEnabled()) {
                AbstractBaseTree.this.m_userDefaultAction.actionPerformed(e);
            } else {
                AbstractBaseTree.this.onDefault();
            }
        }
    }

    private class cExpansionListener
    implements TreeExpansionListener {
        private cExpansionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            Window parent = SwingUtilities.getWindowAncestor(AbstractBaseTree.this);
            if (parent != null) {
                parent.setCursor(Cursor.getPredefinedCursor(3));
            }
            try {
                ITreeNode node = (ITreeNode)e.getPath().getLastPathComponent();
                AbstractBaseTree.this.expandNode(node);
                AbstractBaseTree.this.updateActions();
            }
            finally {
                if (parent != null) {
                    parent.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            ITreeNode node = (ITreeNode)e.getPath().getLastPathComponent();
            node.setExpanded(false);
            AbstractBaseTree.this.updateActions();
        }
    }

    private class cSelectionListener
    implements TreeSelectionListener {
        private cSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!AbstractBaseTree.this.isListeningForSelectionChanges()) {
                return;
            }
            if (((ITreeModel)AbstractBaseTree.this.getModel()).isUpdateInProgress()) {
                return;
            }
            Window parent = SwingUtilities.getWindowAncestor(AbstractBaseTree.this);
            if (parent != null) {
                parent.setCursor(Cursor.getPredefinedCursor(3));
            }
            try {
                ITreeNode[] aNodes = AbstractBaseTree.this.getSelectedNodes();
                ArrayList<Object> lObjects = new ArrayList<Object>(aNodes.length);
                for (int iNode = 0; iNode < aNodes.length; ++iNode) {
                    Object object;
                    if (aNodes[iNode] instanceof IDataTreeNode) {
                        lObjects.add(((IDataTreeNode)aNodes[iNode]).getData());
                        continue;
                    }
                    if (!(aNodes[iNode] instanceof CategoryTreeNode) || (object = ((CategoryTreeNode)aNodes[iNode]).getCategoryObject()) == null) continue;
                    lObjects.add(object);
                }
                AbstractBaseTree.this.setSelectedObjects(lObjects.toArray(new Object[lObjects.size()]));
                if (lObjects.size() < 2) {
                    AbstractBaseTree.this.scrollPathToVisible(AbstractBaseTree.this.getSelectionPath());
                }
                AbstractBaseTree.this.updateActions();
                AbstractBaseTree.this.updateStatusBar();
                AbstractBaseTree.this.fireSelectionChangedEvent();
            }
            finally {
                if (parent != null) {
                    parent.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    protected class cDragGestureListener
    implements DragGestureListener {
        protected cDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent event) {
            if (!AbstractBaseTree.this.m_bDraggingEnabled) {
                return;
            }
            if (AbstractBaseTree.this.isEditing()) {
                return;
            }
            ITreeNode[] aSelectedNodes = AbstractBaseTree.this.getSelectedNodes();
            if (aSelectedNodes.length != 0) {
                DNDObject oDrag = new DNDObject();
                for (int i = 0; i < aSelectedNodes.length; ++i) {
                    if (!(aSelectedNodes[i] instanceof IDataTreeNode) || !aSelectedNodes[i].isValidDragSource()) {
                        return;
                    }
                    Object data = ((IDataTreeNode)aSelectedNodes[i]).getData();
                    if (data == null) continue;
                    oDrag.add(data);
                }
                AbstractBaseTree.this.m_dragSource.startDrag(event, null, oDrag, AbstractBaseTree.this.createDragSourceListener());
            }
        }
    }

    protected class cDropTargetListener
    implements DropTargetListener {
        protected TreePath[] m_aOriginalSelectedPaths;
        protected TreePath m_currentDragOverPath;

        protected cDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (!AbstractBaseTree.this.isEditable()) {
                e.rejectDrag();
                return;
            }
            this.m_aOriginalSelectedPaths = AbstractBaseTree.this.getSelectionPaths();
            Point pt = e.getLocation();
            TreePath path = AbstractBaseTree.this.getPathForLocation(pt.x, pt.y);
            if (!AbstractBaseTree.this.isPathSelected(path)) {
                AbstractBaseTree.this.setSelectionPath(path);
            }
            if (path == null) {
                e.rejectDrag();
            } else {
                ITreeNode node = AbstractBaseTree.this.getSelectedNode();
                DropTargetResult result = node.getIsValidDropTargetResult(AbstractBaseTree.this.getDraggedObjects(e));
                if (result.isValid()) {
                    e.acceptDrag(e.getSourceActions());
                } else {
                    String sReason = result.getReason();
                    if (sReason != null && sReason.length() > 0) {
                        Workspace.getWorkspace().setStatusText(sReason);
                    }
                    e.rejectDrag();
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            AbstractBaseTree.this.setSelectionPaths(this.m_aOriginalSelectedPaths);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            if (!AbstractBaseTree.this.isEditable()) {
                e.rejectDrag();
                return;
            }
            WsUIUtilities.autoscrollForDragEvent(e);
            Point pt = e.getLocation();
            TreePath path = AbstractBaseTree.this.getPathForLocation(pt.x, pt.y);
            if (!AbstractBaseTree.this.isPathSelected(path)) {
                AbstractBaseTree.this.setSelectionPath(path);
            }
            if (path == null) {
                e.rejectDrag();
                return;
            }
            if (path.equals(this.m_currentDragOverPath)) {
                return;
            }
            this.m_currentDragOverPath = path;
            ITreeNode node = AbstractBaseTree.this.getSelectedNode();
            DropTargetResult result = node.getIsValidDropTargetResult(AbstractBaseTree.this.getDraggedObjects(e));
            if (result.isValid()) {
                e.acceptDrag(e.getSourceActions());
            } else {
                String sReason = result.getReason();
                if (sReason != null && sReason.length() > 0) {
                    Workspace.getWorkspace().setStatusText(sReason);
                }
                e.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            if (!AbstractBaseTree.this.isEditable()) {
                e.rejectDrop();
                return;
            }
            Point pt = e.getLocation();
            TreePath path = AbstractBaseTree.this.getPathForLocation(pt.x, pt.y);
            if (!AbstractBaseTree.this.isPathSelected(path)) {
                AbstractBaseTree.this.setSelectionPath(path);
            }
            if (path == null) {
                e.rejectDrop();
            } else {
                ITreeNode node = AbstractBaseTree.this.getSelectedNode();
                if (node.isValidDropTarget()) {
                    Object[] aDroppedObjects = AbstractBaseTree.this.getDroppedObjects(e);
                    boolean bhasFolder = false;
                    for (int i = 0; i < aDroppedObjects.length; ++i) {
                        SimpleBrowseObject item = (SimpleBrowseObject)aDroppedObjects[i];
                        if (!item.isAFolder()) continue;
                        bhasFolder = true;
                        break;
                    }
                    if (bhasFolder) {
                        String sMessage = bundle.getString("AbstractBaseTree.DragToConfirm.Msg.txt");
                        String sTitle = bundle.getString("AbstractBaseTree.DragToConfirm.Title.txt");
                        int eAnswer = JOptionPane.showConfirmDialog(Workspace.getWorkspace(), sMessage, sTitle, 0, 2);
                        if (eAnswer == 1) {
                            e.rejectDrop();
                            return;
                        }
                    }
                    e.acceptDrop(e.getSourceActions());
                    AbstractBaseTree.this.onDrop(aDroppedObjects, node);
                    e.dropComplete(true);
                } else {
                    e.rejectDrop();
                }
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    private class cTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private cTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean bHasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, bHasFocus);
            this.setText(((ITreeNode)value).getName());
            this.setIcon(((ITreeNode)value).getIcon());
            this.setDisabledIcon(((ITreeNode)value).getIcon());
            return this;
        }
    }

    private class cTreeCellEditor
    extends DefaultTreeCellEditor {
        private WATextField m_txtEditor;

        public cTreeCellEditor(JTree atree, TreeCellRenderer arenderer) {
            super(atree, (DefaultTreeCellRenderer)arenderer);
        }

        @Override
        protected void determineOffset(JTree atree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (value instanceof ITreeNode) {
                this.editingIcon = ((ITreeNode)value).getIcon();
                this.offset = this.renderer.getIconTextGap();
                if (this.editingIcon != null) {
                    this.offset += this.editingIcon.getIconWidth();
                }
            } else {
                super.determineOffset(atree, value, isSelected, expanded, leaf, row);
            }
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (!AbstractBaseTree.this.isEditable()) {
                return false;
            }
            ITreeNode node = (ITreeNode)AbstractBaseTree.this.getLastSelectedPathComponent();
            if (node == null || !node.isEditable()) {
                return false;
            }
            if (!super.isCellEditable(e)) {
                return false;
            }
            if (node instanceof IDataTreeNode) {
                if (!((IDataTreeNode)node).isRenameAllowed()) {
                    return false;
                }
                if (node instanceof IDataTreeNode2 && !((IDataTreeNode2)node).isRenameAllowedMessage()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        protected TreeCellEditor createTreeCellEditor() {
            this.m_txtEditor = new WATextField();
            this.m_txtEditor.setMaxCharacters(60);
            this.m_txtEditor.setBorder(UIManager.getBorder("Tree.editorBorder"));
            DefaultCellEditor editor = new DefaultCellEditor(this.m_txtEditor){

                @Override
                public boolean stopCellEditing() {
                    TreePath path = AbstractBaseTree.this.getEditingPath();
                    ITreeNode node = (ITreeNode)path.getLastPathComponent();
                    if (node instanceof IDataTreeNode && !((IDataTreeNode)node).isValidName(cTreeCellEditor.this.m_txtEditor.getText())) {
                        return false;
                    }
                    boolean bEditingStopped = super.stopCellEditing();
                    if (bEditingStopped) {
                        AbstractBaseTree.this.setSelectionPath(path);
                        AbstractBaseTree.this.scrollPathToVisible(path);
                    }
                    return bEditingStopped;
                }
            };
            editor.setClickCountToStart(1);
            return editor;
        }
    }

    protected class cTreeModelHandler
    extends JTree.TreeModelHandler {
        protected cTreeModelHandler() {
            super(AbstractBaseTree.this);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (e.getChildIndices().length == 0 && e.getChildren().length == 0) {
                AbstractBaseTree.this.fireValueChanged(null);
            }
            super.treeNodesRemoved(e);
        }
    }

    private class DeleteOperation
    extends WsAbstractOperation {
        private OpRequestUI m_opUI;
        private IDataTreeNode[] m_aDeleteNodes;

        public DeleteOperation(IDataTreeNode[] aNodes, OpRequestUI opUI) {
            super(opUI);
            this.m_aDeleteNodes = aNodes;
            this.m_opUI = opUI;
        }

        @Override
        public void run() {
            AbstractBaseTree.this.cancelEditing();
            AbstractBaseTree.this.m_bListeningForSelectionChanges = false;
            try {
                Integer nNodes = new Integer(this.m_aDeleteNodes.length);
                for (int iNode = 0; iNode < this.m_aDeleteNodes.length; ++iNode) {
                    if (this.isOperationCancelled()) {
                        break;
                    }
                    this.m_opUI.setMessage(bundle.formatString("AbstractBaseTree.DeleteProgressIndicator.Message.fmt.txt", new Integer(iNode + 1), nNodes));
                    this.m_aDeleteNodes[iNode].delete();
                }
            }
            finally {
                AbstractBaseTree.this.m_bListeningForSelectionChanges = true;
                AbstractBaseTree.this.fireValueChanged(null);
            }
        }
    }

    private class cIconDecoratorThreadGroup
    extends ThreadGroup {
        public cIconDecoratorThreadGroup() {
            super(AbstractBaseTree.this.m_context.getType() + "IconDecoratorGroup");
            this.setMaxPriority(1);
        }

        public void dispose() {
            while (this.activeCount() > 0) {
                Thread[] aThreads = new Thread[this.activeCount()];
                this.enumerate(aThreads);
                for (int iThread = 0; iThread < aThreads.length; ++iThread) {
                    cIconDecoratorThread thread = (cIconDecoratorThread)aThreads[iThread];
                    if (!thread.isAlive()) continue;
                    try {
                        thread.kill();
                        thread.join();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.destroy();
        }
    }

    private class cIconDecoratorThread
    extends Thread {
        private ITreeNode[] m_aNodes;
        private boolean m_bKilled;

        public cIconDecoratorThread(ThreadGroup group, ITreeNode[] aNodes) {
            super(group, AbstractBaseTree.this.m_context.getType() + "IconDecorator");
            this.m_bKilled = false;
            this.m_aNodes = aNodes;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.m_aNodes.length; ++i) {
                if (this.m_bKilled) {
                    return;
                }
                if (!(this.m_aNodes[i] instanceof IDataTreeNode)) continue;
                final IDataTreeNode node = (IDataTreeNode)this.m_aNodes[i];
                Object data = node.getData();
                Icon icon = node.getIcon();
                if (!(data instanceof SimpleObject) || !(icon instanceof DecoratableIcon)) continue;
                ISimpleObjectDecorator decorator = WsAbstractIconFactory.getInstance().getIconDecorator();
                try {
                    if (!decorator.decorateIcon((DecoratableIcon)icon, (SimpleObject)data)) continue;
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ((ITreeModel)AbstractBaseTree.this.getModel()).nodeChanged(node);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                    continue;
                }
                catch (ServiceException ex) {
                    Workspace.getDefaultLogger().debug((Object)("Error decorating icon for " + data), ex);
                    continue;
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
            }
        }

        public void kill() {
            this.m_bKilled = true;
        }
    }
}

