/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.pfd;

import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.workspace.DNDObject;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.pfd.WsPFDPanel;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import com.sas.workspace.visuals.pfd.WsPFDSelectionEvent;
import com.sas.workspace.visuals.pfd.WsPFDSelectionListener;
import com.sas.workspace.visuals.pfd.WsPFDSelectionModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class WsPFDPanelUI
extends BasicPanelUI {
    private WsPFDPanel m_pfd;
    private DropTarget m_target;
    private MouseInputListener m_lsnrMouse;
    private DropTargetListener m_lsnrDropTarget;
    private PropertyChangeListener m_lsnrPropertyChange;
    private WsPFDSelectionListener m_lsnrSelection;

    public static ComponentUI createUI(JComponent pfd) {
        return new WsPFDPanelUI();
    }

    @Override
    public void installUI(JComponent cmp) {
        this.m_pfd = (WsPFDPanel)((Object)cmp);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
    }

    protected void installListeners() {
        this.m_lsnrMouse = this.createMouseInputListener();
        this.m_pfd.addMouseListener(this.m_lsnrMouse);
        this.m_pfd.addMouseMotionListener(this.m_lsnrMouse);
        this.m_lsnrDropTarget = this.createDropTargetListener();
        this.m_target = new DropTarget((Component)((Object)this.m_pfd), this.m_lsnrDropTarget);
        this.m_lsnrPropertyChange = this.createPropertyChangeListener();
        this.m_pfd.addPropertyChangeListener(this.m_lsnrPropertyChange);
        this.m_lsnrSelection = this.createDefaultSelectionListener();
        WsPFDSelectionModel mdlSelection = this.m_pfd.getSelectionModel();
        if (mdlSelection != null) {
            mdlSelection.addSelectionListener(this.m_lsnrSelection);
        }
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected DropTargetListener createDropTargetListener() {
        return new DropTargetHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected WsPFDSelectionListener createDefaultSelectionListener() {
        return new SelectionListener();
    }

    protected void installKeyboardActions() {
        InputMap mapKeys = this.m_pfd.getInputMap();
        mapKeys.put(KeyStroke.getKeyStroke(127, 0), "delete");
        mapKeys.put(KeyStroke.getKeyStroke(10, 0), "default");
        mapKeys.put(KeyStroke.getKeyStroke(121, 1), "popupMenu");
        mapKeys = this.m_pfd.getInputMap(1);
        mapKeys.put(KeyStroke.getKeyStroke(10, 0), "default");
        ActionMap mapActions = this.m_pfd.getActionMap();
        mapActions.put("delete", this.createDeleteAction());
        mapActions.put("default", this.createDefaultAction());
        mapActions.put("popupMenu", this.createPopupMenuAction());
    }

    protected Action createDeleteAction() {
        return new DeleteAction();
    }

    protected Action createDefaultAction() {
        return new DefaultAction();
    }

    protected Action createPopupMenuAction() {
        return new PopupMenuAction();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.m_pfd = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.m_pfd.removeMouseListener(this.m_lsnrMouse);
        this.m_pfd.removeMouseMotionListener(this.m_lsnrMouse);
        this.m_lsnrMouse = null;
        this.m_target.removeDropTargetListener(this.m_lsnrDropTarget);
        this.m_target.setComponent(null);
        this.m_target = null;
        this.m_lsnrDropTarget = null;
        this.m_pfd.removePropertyChangeListener(this.m_lsnrPropertyChange);
        this.m_lsnrPropertyChange = null;
        WsPFDSelectionModel mdlSelection = this.m_pfd.getSelectionModel();
        if (mdlSelection != null) {
            mdlSelection.removeSelectionListener(this.m_lsnrSelection);
        }
        this.m_lsnrSelection = null;
    }

    protected void uninstallKeyboardActions() {
        InputMap mapKeys = this.m_pfd.getInputMap();
        mapKeys.remove(KeyStroke.getKeyStroke(127, 0));
        mapKeys.remove(KeyStroke.getKeyStroke(10, 0));
        mapKeys.remove(KeyStroke.getKeyStroke(121, 1));
        ActionMap mapActions = this.m_pfd.getActionMap();
        mapActions.remove("delete");
        mapActions.remove("default");
        mapActions.remove("popupMenu");
    }

    private void triggerPopupMenu() {
        PFDPrimitive prim = this.m_pfd.getSelectionModel().getPrimaryPrimitive();
        if (prim == null) {
            this.triggerPopupMenu(this.m_pfd.getVisibleRect().getLocation());
        } else {
            this.triggerPopupMenu(prim.getLocation());
        }
    }

    private void triggerPopupMenu(Point pt) {
        if (!this.m_pfd.isPopupMenuEnabled()) {
            return;
        }
        WsPopupMenuRequestListener lsnr = this.m_pfd.getPopupMenuRequestListener();
        if (lsnr != null) {
            MouseEvent ev = new MouseEvent((Component)((Object)this.m_pfd), 501, 0L, 0, pt.x, pt.y, 1, true);
            lsnr.popupMenuRequested(ev);
        }
    }

    private void triggerDefaultAction() {
        PFDPrimitive primitive;
        Action actDefault = null;
        if (this.m_pfd.getSelectedPrimitivesCount() == 1 && (primitive = this.m_pfd.getPrimarySelectedPrimitive()) instanceof WsPFDPrimitive) {
            actDefault = ((WsPFDPrimitive)primitive).getDefaultAction();
        }
        if (actDefault == null) {
            actDefault = this.m_pfd.getDefaultAction();
        }
        if (actDefault != null && actDefault.isEnabled()) {
            actDefault.actionPerformed(new ActionEvent((Object)this.m_pfd, 0, "default"));
        }
    }

    private void triggerDeleteAction() {
        PFDPrimitive primitive;
        Action actDelete = null;
        if (this.m_pfd.getSelectedPrimitivesCount() == 1 && (primitive = this.m_pfd.getPrimarySelectedPrimitive()) instanceof WsPFDPrimitive) {
            actDelete = ((WsPFDPrimitive)primitive).getDeleteAction();
        }
        if (actDelete == null) {
            actDelete = this.m_pfd.getDeleteAction();
        }
        if (actDelete != null && actDelete.isEnabled()) {
            actDelete.actionPerformed(new ActionEvent((Object)this.m_pfd, 0, "delete"));
        }
    }

    protected WsPFDPanel getComponent() {
        return this.m_pfd;
    }

    protected class MouseInputHandler
    extends MouseInputAdapter {
        protected MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            WsPFDPanelUI.this.m_pfd.requestFocusInWindow();
            if (ev.isPopupTrigger()) {
                WsPFDPanelUI.this.triggerPopupMenu(ev.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (ev.isPopupTrigger()) {
                WsPFDPanelUI.this.triggerPopupMenu(ev.getPoint());
            } else if (ev.getClickCount() == 2) {
                WsPFDPanelUI.this.triggerDefaultAction();
            }
        }
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent ev) {
            List lDraggedObjects = this.getDraggedObjects(ev.getCurrentDataFlavors());
            if (this.isDropValid(ev.getLocation(), lDraggedObjects)) {
                ev.acceptDrag(ev.getDropAction());
            } else {
                ev.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent ev) {
            WsUIUtilities.autoscrollForDragEvent(ev);
            List lDraggedObjects = this.getDraggedObjects(ev.getCurrentDataFlavors());
            if (this.isDropValid(ev.getLocation(), lDraggedObjects)) {
                ev.acceptDrag(ev.getDropAction());
            } else {
                ev.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent ev) {
            List lDroppedObjects;
            Point ptDrop = ev.getLocation();
            if (this.isDropValid(ptDrop, lDroppedObjects = this.getDraggedObjects(ev.getCurrentDataFlavors()))) {
                if (this.drop(ptDrop, lDroppedObjects)) {
                    ev.acceptDrop(ev.getDropAction());
                } else {
                    ev.rejectDrop();
                }
            } else {
                ev.rejectDrop();
            }
        }

        protected boolean isDropValid(Point ptEvent, List lObjects) {
            if (!WsPFDPanelUI.this.m_pfd.isEditable()) {
                return false;
            }
            if (lObjects == null) {
                return false;
            }
            PFDPrimitive prim = WsPFDPanelUI.this.m_pfd.pickPrimitive(ptEvent.x, ptEvent.y);
            if (prim instanceof WsPFDPrimitive) {
                return WsPFDPanelUI.this.m_pfd.isDropValid((WsPFDPrimitive)prim, ptEvent, lObjects);
            }
            return WsPFDPanelUI.this.m_pfd.isDropValid(ptEvent, lObjects);
        }

        protected boolean drop(Point ptEvent, List lObjects) {
            if (!WsPFDPanelUI.this.m_pfd.isEditable()) {
                return false;
            }
            if (lObjects == null) {
                return false;
            }
            PFDPrimitive prim = WsPFDPanelUI.this.m_pfd.pickPrimitive(ptEvent.x, ptEvent.y);
            if (prim instanceof WsPFDPrimitive) {
                return WsPFDPanelUI.this.m_pfd.drop((WsPFDPrimitive)prim, ptEvent, lObjects);
            }
            return WsPFDPanelUI.this.m_pfd.drop(ptEvent, lObjects);
        }

        protected List getDraggedObjects(DataFlavor[] flavors) {
            for (int iFlavor = 0; iFlavor < flavors.length; ++iFlavor) {
                if (!(flavors[iFlavor] instanceof DNDObject.DNDObjectFlavor)) continue;
                DNDObject object = ((DNDObject.DNDObjectFlavor)flavors[iFlavor]).getData();
                return object.getObjects();
            }
            return null;
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String sProperty = ev.getPropertyName();
            if (sProperty.equals("SelectionModel")) {
                WsPFDSelectionModel mdlOld = (WsPFDSelectionModel)ev.getOldValue();
                WsPFDSelectionModel mdlNew = (WsPFDSelectionModel)ev.getNewValue();
                if (mdlOld != null) {
                    mdlOld.removeSelectionListener(WsPFDPanelUI.this.m_lsnrSelection);
                }
                if (mdlNew != null) {
                    mdlNew.addSelectionListener(WsPFDPanelUI.this.m_lsnrSelection);
                }
            }
        }
    }

    protected class SelectionListener
    implements WsPFDSelectionListener {
        protected SelectionListener() {
        }

        @Override
        public void selectionChanged(WsPFDSelectionEvent ev) {
            WsPFDSelectionModel mdl = (WsPFDSelectionModel)ev.getSource();
            if (mdl.getSelectionCount() == 1) {
                WsPFDPanelUI.this.m_pfd.setActivePrimitive(mdl.getPrimitives()[0]);
            } else {
                WsPFDPanelUI.this.m_pfd.setActivePrimitive(null);
            }
        }
    }

    protected class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsPFDPanelUI.this.triggerDeleteAction();
        }
    }

    protected class DefaultAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected DefaultAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsPFDPanelUI.this.triggerDefaultAction();
        }
    }

    protected class PopupMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        protected PopupMenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            WsPFDPanelUI.this.triggerPopupMenu();
        }
    }
}

