/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.objectselector;

import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATabbedPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.tree.CheckoutsTreeModel;
import com.sas.workspace.models.tree.FoldersTreeModel;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.InventoryTreeModel;
import com.sas.workspace.models.tree.TreeNodeComparator;
import com.sas.workspace.visuals.dualselector.SelectorPanel;
import com.sas.workspace.visuals.tree.CheckoutsTree;
import com.sas.workspace.visuals.tree.FoldersTree;
import com.sas.workspace.visuals.tree.IBaseTree;
import com.sas.workspace.visuals.tree.InventoryTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TabbedTreePanel
extends JPanel
implements SelectorPanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(TabbedTreePanel.class);
    private UserContextInterface m_userContext;
    private cMultiTreeTabbedPanel m_tabbedPanel;
    private IBaseTree[] m_aTrees;
    private boolean m_bShowColumnSortOption;
    private boolean m_bAllowMultiSelection;
    private List m_lSelectableParentTypes;
    private cSpecialColumnComparator m_columnComparator;
    private FoldersTree m_foldersTree;
    private InventoryTree m_inventoryTree;
    private CheckoutsTree m_checkoutsTree;

    public TabbedTreePanel(UserContextInterface userContext, boolean bShowColumnSortOption, boolean bAllowMultiSelection) {
        this.m_userContext = userContext;
        this.m_bShowColumnSortOption = bShowColumnSortOption;
        this.m_bAllowMultiSelection = bAllowMultiSelection;
        this.initialize();
    }

    protected WATabbedPanel getTabbedPanel() {
        return this.m_tabbedPanel;
    }

    protected void initialize() {
        if (WsAbstractIconFactory.getInstance() == null) {
            try {
                WsAbstractIconFactory iconFactory = new WsAbstractIconFactory(){};
                iconFactory.setServer(this.m_userContext.getAuthServer());
                WsAbstractIconFactory.setInstance(iconFactory);
            }
            catch (ServiceException iconFactory) {
            }
            catch (RemoteException iconFactory) {
                // empty catch block
            }
        }
        int iSelectionMode = this.m_bAllowMultiSelection ? 4 : 1;
        cDefaultFilter defaultFilter = new cDefaultFilter();
        FoldersTreeModel foldersTreeModel = new FoldersTreeModel(this.m_userContext);
        foldersTreeModel.setNodeFilter(defaultFilter);
        this.m_foldersTree = new FoldersTree(foldersTreeModel);
        this.m_foldersTree.setContextMenusEnabled(false);
        this.m_foldersTree.setDraggingEnabled(false);
        this.m_foldersTree.getSelectionModel().setSelectionMode(iSelectionMode);
        InventoryTreeModel inventoryTreeModel = new InventoryTreeModel(this.m_userContext);
        inventoryTreeModel.setCategoryFilter(defaultFilter);
        this.m_inventoryTree = new InventoryTree(inventoryTreeModel);
        this.m_inventoryTree.setContextMenusEnabled(false);
        this.m_inventoryTree.setDraggingEnabled(false);
        this.m_inventoryTree.getSelectionModel().setSelectionMode(iSelectionMode);
        Workspace workspace = Workspace.getWorkspace();
        if (workspace != null && workspace.isChangeManagementOn()) {
            CheckoutsTreeModel checkoutsTreeModel = new CheckoutsTreeModel(this.m_userContext);
            checkoutsTreeModel.setNodeFilter(defaultFilter);
            this.m_checkoutsTree = new CheckoutsTree(checkoutsTreeModel);
            this.m_checkoutsTree.setContextMenusEnabled(false);
            this.m_checkoutsTree.setDraggingEnabled(false);
            this.m_checkoutsTree.getSelectionModel().setSelectionMode(iSelectionMode);
            this.m_aTrees = new IBaseTree[]{this.m_foldersTree, this.m_inventoryTree, this.m_checkoutsTree};
        } else {
            this.m_aTrees = new IBaseTree[]{this.m_foldersTree, this.m_inventoryTree};
        }
        this.m_tabbedPanel = new cMultiTreeTabbedPanel(this.m_aTrees);
        this.setPreferredSize(new Dimension(450, 300));
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tabbedPanel, "Center");
        if (this.m_bShowColumnSortOption) {
            JCheckBox ckbSortColumns = WsUIUtilities.createCheckBox(bundle, "TabbedTreePanel.SortColumns", 5);
            ckbSortColumns.addActionListener(new cSortColumnsListener());
            this.m_columnComparator = new cSpecialColumnComparator();
            this.setTreeModelComparator(this.m_columnComparator);
            this.add((Component)ckbSortColumns, "South");
        }
    }

    public void setNodeFilter(ISimpleObjectFilter filter) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            ((ITreeModel)this.m_aTrees[i].getModel()).setNodeFilter(filter);
        }
    }

    public void setInventoryTypesFilter(IPublicTypeFilter filter) {
        ((InventoryTreeModel)this.m_inventoryTree.getModel()).setCategoryFilter(filter);
        if (this.m_checkoutsTree != null) {
            ((CheckoutsTreeModel)this.m_checkoutsTree.getModel()).setTopLevelTypeFilter(filter);
        }
    }

    public void setAdditionalHierarchyModel(ISimpleObjectHierarchyModel model) {
        ((FoldersTreeModel)this.m_foldersTree.getModel()).setAdditionalHierarchyModel(model);
        ((InventoryTreeModel)this.m_inventoryTree.getModel()).setHierarchyModel(model);
        if (this.m_checkoutsTree != null) {
            ((CheckoutsTreeModel)this.m_checkoutsTree.getModel()).setHierarchyModel(model);
        }
    }

    public void setSelectableParentTypes(String[] aSelectableParentTypes) {
        this.m_lSelectableParentTypes = Arrays.asList(aSelectableParentTypes);
    }

    public void setSelectedObjects(SimpleObject[] aSelectedObjects) {
        this.m_foldersTree.selectObjects(aSelectedObjects);
        if (this.m_checkoutsTree != null) {
            this.m_checkoutsTree.selectObjects(aSelectedObjects);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.m_lSelectableParentTypes == null || this.m_lSelectableParentTypes.isEmpty()) {
            return this.m_tabbedPanel.getSelectedTree().getSelectedObjects();
        }
        ArrayList<Object> lSelectedObjects = new ArrayList<Object>();
        IDataTreeNode[] nodes = this.m_tabbedPanel.getSelectedTree().getSelectedDataNodes();
        for (int iNode = 0; iNode < nodes.length; ++iNode) {
            IDataTreeNode node = nodes[iNode];
            if (node.getAllowsChildren() && this.m_lSelectableParentTypes.contains(node.getType())) {
                node.expand();
                Enumeration<? extends TreeNode> childNodes = node.children();
                while (childNodes.hasMoreElements()) {
                    IDataTreeNode childNode = (IDataTreeNode)childNodes.nextElement();
                    lSelectedObjects.add(childNode.getData());
                }
                continue;
            }
            lSelectedObjects.add(node.getData());
        }
        return lSelectedObjects.toArray();
    }

    public void setTreeModelComparator(Comparator cmp) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            ((ITreeModel)this.m_aTrees[i].getModel()).setNodeComparator(cmp);
        }
    }

    public void setEditable(boolean bEditable) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            ((JTree)((Object)this.m_aTrees[i])).setEnabled(bEditable);
        }
    }

    public void setDefaultAction(Action actDefault) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].setUserDefaultAction(actDefault);
        }
    }

    public IBaseTree getSelectedTree() {
        return this.m_tabbedPanel.getSelectedTree();
    }

    public void refreshTrees() {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].refresh();
        }
    }

    @Override
    public void clearSelection() {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].clearSelection();
        }
    }

    @Override
    public int getItemCount() {
        return ((JTree)((Object)this.getSelectedTree())).getRowCount();
    }

    @Override
    public int getSelectedItemsCount() {
        return this.getSelectedTree().getSelectedObjects().length;
    }

    @Override
    public int getLastSelectedIndex() {
        int[] aRows = ((JTree)((Object)this.getSelectedTree())).getSelectionRows();
        return aRows.length == 0 ? -1 : aRows[aRows.length - 1];
    }

    @Override
    public void setSelectedIndex(int index) {
        ((JTree)((Object)this.getSelectedTree())).setSelectionRow(index);
    }

    @Override
    public List getSelectedItems() {
        return new ArrayList<Object>(Arrays.asList(this.getSelectedObjects()));
    }

    @Override
    public List getAllItems() {
        TreeModel model = this.getSelectedTree().getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        return Collections.list(root.breadthFirstEnumeration());
    }

    @Override
    public List getAllMoveableItems() {
        return this.getAllItems();
    }

    @Override
    public void addItems(List newItems) {
        throw new UnsupportedOperationException("Adding items is not supported.");
    }

    @Override
    public void removeItems(List removeItems) {
        throw new UnsupportedOperationException("Removing items is not supported.");
    }

    @Override
    public boolean containsItem(Object item) {
        String sID;
        if (item instanceof SimpleObject && (sID = ((SimpleObject)item).getID()) != null) {
            ITreeModel model = (ITreeModel)this.getSelectedTree().getModel();
            List lNodes = model.findNodes(sID);
            return lNodes.size() > 0;
        }
        return false;
    }

    @Override
    public void addSelectionChangedListener(WsSelectionChangedListener lsnr) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].addSelectionChangedListener(lsnr);
        }
    }

    @Override
    public void removeSelectionChangedListener(WsSelectionChangedListener lsnr) {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].removeSelectionChangedListener(lsnr);
        }
    }

    public void dispose() {
        for (int i = 0; i < this.m_aTrees.length; ++i) {
            this.m_aTrees[i].dispose();
        }
    }

    private class cSpecialColumnComparator
    extends TreeNodeComparator {
        private boolean m_bSortColumns = false;

        private cSpecialColumnComparator() {
        }

        public void setSortColumns(boolean bSortColumns) {
            this.m_bSortColumns = bSortColumns;
        }

        @Override
        public int compare(Object first, Object second) {
            if (!this.m_bSortColumns && first instanceof IDataTreeNode && "Column".equals(((IDataTreeNode)first).getType()) && second instanceof IDataTreeNode && "Column".equals(((IDataTreeNode)second).getType())) {
                return 0;
            }
            return super.compare(first, second);
        }
    }

    private class cMultiTreeTabbedPanel
    extends WATabbedPanel {
        private IBaseTree[] m_aTheTrees;

        public cMultiTreeTabbedPanel(IBaseTree[] aTrees) {
            this.m_aTheTrees = aTrees;
            this.initialize();
        }

        @Override
        protected void initialize() {
            for (int i = 0; i < this.m_aTheTrees.length; ++i) {
                cTreeTab tab = new cTreeTab(this.m_aTheTrees[i]);
                this.addTab(tab);
            }
        }

        public IBaseTree getSelectedTree() {
            return ((cTreeTab)this.getSelectedTab()).m_tree;
        }

        private class cTreeTab
        extends WAPropertyTab {
            IBaseTree m_tree;

            public cTreeTab(IBaseTree tree) {
                this.m_tree = tree;
                this.setName(this.m_tree.getName());
                this.setLayout(new BorderLayout());
                this.add((Component)new JScrollPane((Component)((Object)this.m_tree)), "Center");
            }
        }
    }

    private class cDefaultFilter
    implements IPublicTypeFilter,
    ISimpleObjectFilter {
        private cDefaultFilter() {
        }

        @Override
        public boolean accept(String publicType) {
            return false;
        }

        @Override
        public boolean accept(SimpleObject simpleObject) {
            return false;
        }
    }

    private class cSortColumnsListener
    implements ActionListener {
        private cSortColumnsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedTreePanel.this.m_columnComparator.setSortColumns(((JCheckBox)e.getSource()).isSelected());
            TabbedTreePanel.this.refreshTrees();
        }
    }
}

