/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.dualselector;

import com.sas.beans.Util;
import com.sas.swing.models.ViewDefaultModel;
import com.sas.swing.visuals.dualselector.BaseDualSelector;
import com.sas.swing.visuals.dualselector.JTreeDualSelectorAdapter;
import com.sas.workspace.visuals.dualselector.JTableDualSelectorAdapter;
import com.sas.workspace.visuals.dualselector.SelectorTableModel;
import com.sas.workspace.visuals.dualselector.WsTreeDualSelectorAdapter;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableSelector
extends BaseDualSelector
implements TreeSelectionListener,
ListSelectionListener,
ViewDefaultModel {
    private static final long serialVersionUID = 1L;
    private boolean clearSelection;
    private boolean moveParentsOrChildren;
    private boolean parentNodesMoveable;
    private String rootTreeNodeName = "Root";
    private transient TreeModel sourceTreeModel;
    private transient TableModel targetTableModel;
    protected JTree sourceJTree;
    protected JTable targetJTable;
    protected DefaultMutableTreeNode rootNode;

    public TreeTableSelector(JTree tree, JTable table) {
        this.setDesignTime(Util.isDesignTime());
        this.targetMaximumCount = -1;
        this.dragAndDropEnabled = true;
        this.sourceAdapter = new WsTreeDualSelectorAdapter(tree, (JComponent)((Object)this));
        this.targetAdapter = new JTableDualSelectorAdapter(table, (JComponent)((Object)this));
        this.sourceJTree = (JTree)this.sourceAdapter.getComponent();
        this.targetJTable = (JTable)this.targetAdapter.getComponent();
        this.setParentNodesMoveable(false);
        this.initializeBaseDualSelector();
        this.sourceJTree.addMouseListener(this.sourceMouseListener);
        this.targetJTable.addMouseListener(this.targetMouseListener);
        if (this.getModel() == null) {
            this.setModel(tree.getModel());
        }
        if (this.getTargetModel() == null) {
            this.setTargetModel(table.getModel());
        }
        this.sourceAdapter.setSelectedIndex(1);
        this.initialized = true;
        this.ensureButtonsEnabled();
        this.addListeners();
        this.updateUI();
    }

    protected void addListeners() {
        super.addListeners();
        this.sourceJTree.removeTreeSelectionListener(this);
        this.sourceJTree.addTreeSelectionListener(this);
        this.targetJTable.getSelectionModel().removeListSelectionListener(this);
        this.targetJTable.getSelectionModel().addListSelectionListener(this);
    }

    public TreeCellRenderer getSourceCellRenderer() {
        return this.sourceJTree.getCellRenderer();
    }

    public void setSourceCellRenderer(TreeCellRenderer newValue) {
        TreeCellRenderer oldValue = this.sourceJTree.getCellRenderer();
        if (newValue == oldValue) {
            return;
        }
        this.sourceJTree.setCellRenderer(newValue);
        this.firePropertyChange("SourceTreeCellRenderer", oldValue, newValue);
    }

    public void setSourceRootVisible(boolean visible) {
        this.sourceJTree.setRootVisible(visible);
        if (!visible) {
            this.sourceJTree.setShowsRootHandles(true);
        }
    }

    public boolean isSourceRootVisible() {
        return this.sourceJTree.isRootVisible();
    }

    public void setParentNodesMoveable(boolean moveable) {
        this.parentNodesMoveable = moveable;
        ((JTreeDualSelectorAdapter)this.sourceAdapter).setParentNodesMoveable(moveable);
    }

    public boolean isParentNodesMoveable() {
        return this.parentNodesMoveable;
    }

    public void setParentOrChildrenMoveable(boolean nodes) {
        this.moveParentsOrChildren = nodes;
        if (this.moveParentsOrChildren) {
            ((JTreeDualSelectorAdapter)this.sourceAdapter).setParentNodesOnlyMoveable(true);
        } else {
            ((JTreeDualSelectorAdapter)this.sourceAdapter).setChildNodesOnlyMoveable(true);
        }
    }

    public boolean isParentsOrChildrenMoveable() {
        return this.moveParentsOrChildren;
    }

    public TreeModel getModel() {
        return this.sourceTreeModel;
    }

    public TableModel getTargetModel() {
        return this.targetTableModel;
    }

    public void setModel(TreeModel treeModel) {
        TreeModel oldModel = this.sourceTreeModel;
        if (treeModel != null) {
            this.sourceTreeModel = treeModel;
            if (this.sourceJTree != null) {
                this.sourceJTree.setModel(this.sourceTreeModel);
            }
        } else {
            this.rootNode = new DefaultMutableTreeNode(this.rootTreeNodeName);
            this.sourceTreeModel = new DefaultTreeModel(this.rootNode);
            if (this.sourceJTree != null) {
                this.sourceJTree.setModel(this.sourceTreeModel);
            }
        }
        if (this.sourceJTree.getRowCount() > 0) {
            this.sourceJTree.removeTreeSelectionListener(this);
            this.sourceJTree.setSelectionRow(0);
            this.sourceJTree.addTreeSelectionListener(this);
        }
        if (!(this.sourceTreeModel instanceof DefaultTreeModel)) {
            this.setCopyModeEnabled(true);
        }
        this.firePropertyChange("model", oldModel, this.sourceTreeModel);
    }

    public void setTargetModel(TableModel tableModel) throws IllegalArgumentException {
        TableModel oldModel;
        if (tableModel instanceof SelectorTableModel) {
            oldModel = this.targetTableModel;
            if (tableModel != null) {
                this.targetTableModel = tableModel;
            }
            if (this.targetJTable != null) {
                this.targetJTable.setModel(this.targetTableModel);
            } else {
                this.targetTableModel = new DefaultTableModel();
                if (this.targetJTable != null) {
                    this.targetJTable.setModel(this.targetTableModel);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.firePropertyChange("targetListModel", oldModel, this.targetTableModel);
    }

    public boolean isDefaultModelAttached() {
        return this.getModel() instanceof DefaultTreeModel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent ie) {
        Object source = ie.getSource();
        this.direction = ie.getNewLeadSelectionPath() == null || source != this.sourceJTree;
        if (ie.getNewLeadSelectionPath() != null && source == this.sourceJTree) {
            if (this.alternatingMultipleButtonStyle) {
                this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", false));
            }
            if (this.alternatingSingleButtonStyle) {
                this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", false));
            }
            this.ensureButtonsEnabled();
            this.clearSelection = true;
            try {
                this.targetJTable.getSelectionModel().clearSelection();
                this.direction = false;
            }
            finally {
                this.clearSelection = false;
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent ie) {
        this.direction = ie.getFirstIndex() >= 0;
        if (!this.clearSelection && ie.getFirstIndex() >= 0) {
            if (this.alternatingMultipleButtonStyle) {
                this.alternatingMultipleButton.setIcon(this.getAlternatingButtonIcon("alternatingMultipleButton", true));
            }
            if (this.alternatingSingleButtonStyle) {
                this.alternatingSingleButton.setIcon(this.getAlternatingButtonIcon("alternatingSingleButton", true));
            }
            this.ensureButtonsEnabled();
            this.clearSelection = true;
            try {
                this.sourceJTree.getSelectionModel().clearSelection();
                this.direction = true;
            }
            finally {
                this.clearSelection = false;
            }
        }
    }
}

