/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceUtil;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsTitledPageFormat;
import java.awt.BorderLayout;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class WsTextPropertyTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WsTextPropertyTab.class);
    private static final String FILENAMEKEY = "WsTextPropertyTab.LastFileName";
    private static final String REMOTEFILENAMEKEY = "WsTextPropertyTab.LastRemoteFileName";
    private WATextArea m_txt;
    private JScrollPane m_scr;
    private WsAbstractAction m_actOpen;
    private WsAbstractAction m_actOpenRemote;
    private WsAbstractAction m_actSave;
    private WsAbstractAction m_actSaveAs;
    private WsAbstractAction m_actSaveRemote;
    private WsAbstractAction m_actPrint;
    private WsAbstractAction m_actPageSetup;
    private WsAbstractAction m_actCut;
    private WsAbstractAction m_actCopy;
    private WsAbstractAction m_actPaste;
    private WsAbstractAction m_actSelectAll;
    private WsAbstractAction m_actClear;
    private boolean m_bOpenActionsEnabled;
    private boolean m_bSaveActionsEnabled;
    private boolean m_bRemoteActionsEnabled;
    private boolean m_bPrintActionsEnabled;
    private boolean m_bRemoteFile;
    private String m_sFileName;
    private String m_sPrintTitle;
    private PageFormat m_pageFormat;
    private String m_sLastFileNameKey;
    private String m_sLastRemoteFileNameKey;

    public WsTextPropertyTab() {
        this.initialize();
    }

    @Override
    protected void initialize() {
        this.createActions();
        this.initializeActionsAttributes();
        this.setLastFileNameKey(FILENAMEKEY);
        this.setLastRemoteFileNameKey(REMOTEFILENAMEKEY);
        this.m_txt = this.createTextComponent();
        this.m_scr = this.createScrollComponent();
        this.layoutComponents();
    }

    private void initializeActionsAttributes() {
        this.m_bOpenActionsEnabled = true;
        this.m_bSaveActionsEnabled = true;
        this.m_bRemoteActionsEnabled = true;
        this.m_bPrintActionsEnabled = true;
    }

    protected WATextArea createTextComponent() {
        WATextArea txt = new WATextArea();
        Font fnt = txt.getFont();
        txt.setFont(new Font("Monospaced", 0, fnt.getSize()));
        txt.setEditable(true);
        txt.setAutoSelect(false);
        txt.getAdapter().setSelectionVisibleWhenUnfocused(true);
        txt.getAdapter().setPrintable(true);
        txt.addCaretListener(new TextComponentSelectionListener());
        return txt;
    }

    protected WATextArea getTextComponent() {
        return this.m_txt;
    }

    protected JScrollPane createScrollComponent() {
        return new JScrollPane(this.m_txt);
    }

    protected void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.m_scr);
    }

    protected void createActions() {
        this.m_actOpen = this.createOpenAction();
        this.m_actOpenRemote = this.createOpenRemoteAction();
        this.m_actSave = this.createSaveAction();
        this.m_actSaveAs = this.createSaveAsAction();
        this.m_actSaveRemote = this.createSaveRemoteAction();
        this.m_actPrint = this.createPrintAction();
        this.m_actPageSetup = this.createPageSetupAction();
        this.m_actCut = this.createCutAction();
        this.m_actCopy = this.createCopyAction();
        this.m_actPaste = this.createPasteAction();
        this.m_actSelectAll = this.createSelectAllAction();
        this.m_actClear = this.createClearAction();
    }

    protected void updateActions() {
        boolean bSelected = this.m_txt.getSelectedText() != null;
        boolean bEditable = this.m_txt.isEditable();
        boolean bOpen = this.isOpenActionsEnabled();
        boolean bSave = this.isSaveActionsEnabled();
        boolean bRemote = this.isRemoteActionsEnabled();
        boolean bPrint = this.isPrintActionsEnabled();
        boolean bNotEmpty = this.m_txt.getText().length() > 0;
        this.m_actOpen.setEnabled(bOpen && bEditable);
        this.m_actOpenRemote.setEnabled(bOpen && bRemote && bEditable);
        this.m_actSave.setEnabled(bSave);
        this.m_actSaveAs.setEnabled(bSave);
        this.m_actSaveRemote.setEnabled(bSave && bRemote);
        this.m_actPrint.setEnabled(bPrint);
        this.m_actPageSetup.setEnabled(bPrint);
        this.m_actCut.setEnabled(bEditable && bSelected);
        this.m_actCopy.setEnabled(bSelected);
        this.m_actPaste.setEnabled(bEditable && this.isTextInClipboard());
        this.m_actSelectAll.setEnabled(bNotEmpty);
        this.m_actClear.setEnabled(bEditable && bNotEmpty);
    }

    private boolean isTextInClipboard() {
        Transferable xfer = Workspace.getWorkspace().getToolkit().getSystemClipboard().getContents(Workspace.getWorkspace());
        return xfer != null && xfer.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actOpen.setActive(bActive);
        this.m_actOpenRemote.setActive(bActive);
        this.m_actSave.setActive(bActive);
        this.m_actSaveAs.setActive(bActive);
        this.m_actSaveRemote.setActive(bActive);
        this.m_actPrint.setActive(bActive);
        this.m_actPageSetup.setActive(bActive);
        this.m_actCut.setActive(bActive);
        this.m_actCopy.setActive(bActive);
        this.m_actPaste.setActive(bActive);
        this.m_actSelectAll.setActive(bActive);
        this.m_actClear.setActive(bActive);
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_txt.setEditable(bEditable);
        this.updateActions();
    }

    public void setOpenActionsEnabled(boolean bEnabled) {
        if (this.m_bOpenActionsEnabled == bEnabled) {
            return;
        }
        this.m_bOpenActionsEnabled = bEnabled;
        this.updateActions();
    }

    public boolean isOpenActionsEnabled() {
        return this.m_bOpenActionsEnabled;
    }

    public void setSaveActionsEnabled(boolean bEnabled) {
        if (this.m_bSaveActionsEnabled == bEnabled) {
            return;
        }
        this.m_bSaveActionsEnabled = bEnabled;
        this.updateActions();
    }

    public boolean isSaveActionsEnabled() {
        return this.m_bSaveActionsEnabled;
    }

    public void setRemoteActionsEnabled(boolean bEnabled) {
        if (this.m_bRemoteActionsEnabled == bEnabled) {
            return;
        }
        this.m_bRemoteActionsEnabled = bEnabled;
        this.updateActions();
    }

    public boolean isRemoteActionsEnabled() {
        return this.m_bRemoteActionsEnabled;
    }

    public void setPrintActionsEnabled(boolean bEnabled) {
        if (this.m_bPrintActionsEnabled == bEnabled) {
            return;
        }
        this.m_bPrintActionsEnabled = bEnabled;
        this.updateActions();
    }

    public boolean isPrintActionsEnabled() {
        return this.m_bPrintActionsEnabled;
    }

    public void setFileName(String sFileName) {
        this.m_sFileName = sFileName;
    }

    public String getFileName() {
        return this.m_sFileName;
    }

    public void setRemoteFile(boolean bRemote) {
        this.m_bRemoteFile = bRemote;
    }

    public boolean isRemoteFile() {
        return this.m_bRemoteFile;
    }

    public void setPrintTitle(String sTitle) {
        this.m_sPrintTitle = sTitle;
        if (this.m_pageFormat instanceof WsTitledPageFormat) {
            this.m_pageFormat = null;
        }
    }

    public String getPrintTitle() {
        if (this.m_sPrintTitle != null) {
            return this.m_sPrintTitle;
        }
        if (this.m_sFileName != null) {
            return this.m_sFileName;
        }
        return bundle.getString("WsTextPropertyTab.Untitled.txt");
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.m_pageFormat = pageFormat;
    }

    public PageFormat getPageFormat() {
        if (this.m_pageFormat == null) {
            this.m_pageFormat = new WsTitledPageFormat(this.getPrintTitle());
        }
        return this.m_pageFormat;
    }

    public void setLastFileNameKey(String sKey) {
        this.m_sLastFileNameKey = sKey;
    }

    public String getLastFileNameKey() {
        return this.m_sLastFileNameKey;
    }

    public void setLastRemoteFileNameKey(String sKey) {
        this.m_sLastRemoteFileNameKey = sKey;
    }

    public String getLastRemoteFileNameKey() {
        return this.m_sLastRemoteFileNameKey;
    }

    public boolean open() {
        return true;
    }

    public boolean openRemote() {
        return true;
    }

    @Override
    public boolean save() {
        if (this.m_sFileName == null) {
            if (this.m_bRemoteFile && this.m_bRemoteActionsEnabled) {
                return this.saveRemote();
            }
            return this.saveAs();
        }
        if (this.m_bRemoteFile && this.m_bRemoteActionsEnabled) {
            return this.writeRemoteFile();
        }
        return this.writeFile();
    }

    public boolean saveAs() {
        File directory;
        File file;
        if (this.m_bRemoteFile && !(file = new File(this.m_sFileName)).exists() && !(directory = file.getParentFile()).exists()) {
            this.m_sFileName = null;
        }
        String sFileName = this.m_sFileName != null ? this.m_sFileName : Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(FILENAMEKEY, "");
        FileDialog dlgSaveAs = new FileDialog((Frame)Workspace.getWorkspace(), bundle.getString("WsTextPropertyTab.SaveTitle.txt"), 1);
        dlgSaveAs.setFile(sFileName);
        WorkspaceUtil.centerOver(dlgSaveAs, this);
        dlgSaveAs.setVisible(true);
        if (dlgSaveAs.getFile() == null) {
            return false;
        }
        this.m_bRemoteFile = true;
        this.m_sFileName = dlgSaveAs.getDirectory() + dlgSaveAs.getFile();
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(this.m_sLastFileNameKey, this.m_sFileName);
        return this.writeFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveRemote() {
        String sFileName = this.m_sFileName != null ? this.m_sFileName : Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(REMOTEFILENAMEKEY, "");
        WsAppServer srvr = WsAppServer.createDefaultAppServer();
        if (srvr == null) {
            return false;
        }
        try {
            if (!srvr.isFileBrowseEnabled()) {
                boolean bl = false;
                return bl;
            }
            if (sFileName.length() == 0 || !srvr.doesFileExist(srvr.getParentDirectory(sFileName))) {
                sFileName = "";
            }
            LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
            mapFileTypes.put(bundle.getString("WsTextPropertyTab.SASFileTypes.txt"), "SAS");
            mapFileTypes.put(bundle.getString("WsTextPropertyTab.AllFileTypes.txt"), "*");
            sFileName = srvr.promptForFilename(bundle.getString("WsTextPropertyTab.SaveRemote.Title.txt"), sFileName, mapFileTypes);
            if (sFileName == null || sFileName.length() == 0) {
                boolean bl = false;
                return bl;
            }
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(this.m_sLastRemoteFileNameKey, sFileName);
            this.m_sFileName = sFileName;
            this.m_bRemoteFile = true;
            boolean bl = this.writeRemoteFile();
            return bl;
        }
        catch (GenericError ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
            boolean bl = false;
            return bl;
        }
        catch (WsAppServerFailException ex) {
            MessageUtil.displayMessage(ex.getLocalizedMessage(), 0);
            boolean bl = false;
            return bl;
        }
        finally {
            srvr.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeRemoteFile() {
        WsAppServer srvr = WsAppServer.createDefaultAppServer();
        if (srvr == null) {
            return false;
        }
        try {
            srvr.writeFile(this.m_txt.getText(), this.m_sFileName);
            boolean bl = true;
            return bl;
        }
        catch (GenericError ex) {
            MessageUtil.displayMessage(bundle.formatString("WsTextPropertyTab.WriteError.fmt.txt", ex.getMessage()), 0);
            boolean bl = false;
            return bl;
        }
        catch (WsAppServerFailException ex) {
            MessageUtil.displayMessage(bundle.formatString("WsTextPropertyTab.WriteError.fmt.txt", ex.getMessage()), 0);
            boolean bl = false;
            return bl;
        }
        finally {
            srvr.dispose();
        }
    }

    private boolean writeFile() {
        try {
            FileOutputStream strm = new FileOutputStream(this.m_sFileName);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)strm, "UTF-8");
            writer.write(this.m_txt.getText());
            writer.close();
            this.setDataChanged(false);
            return true;
        }
        catch (IOException ex) {
            MessageUtil.displayMessage(bundle.formatString("WsTextPropertyTab.WriteError.fmt.txt", ex.getMessage()), 0);
            return false;
        }
    }

    public void showPageSetupDialog() {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        if (!Workspace.getWorkspace().isPrinterConnected(pjob)) {
            return;
        }
        this.m_pageFormat = pjob.pageDialog(this.getPageFormat());
    }

    public void print() {
        String sTitle = this.getPrintTitle();
        this.m_txt.getAdapter().setPrintTitle(sTitle);
        this.m_txt.getAdapter().print(this.getPageFormat());
    }

    protected WsAbstractAction createOpenAction() {
        return new cOpenAction();
    }

    protected WsAbstractAction createOpenRemoteAction() {
        return new cOpenRemoteAction();
    }

    protected WsAbstractAction createSaveAction() {
        return new cSaveAction();
    }

    protected WsAbstractAction createSaveAsAction() {
        return new cSaveAsAction();
    }

    protected WsAbstractAction createSaveRemoteAction() {
        return new cSaveRemoteAction();
    }

    protected WsAbstractAction createPageSetupAction() {
        return new cPageSetupAction();
    }

    protected WsAbstractAction createPrintAction() {
        return new cPrintAction();
    }

    protected WsAbstractAction createCutAction() {
        return new cCutAction();
    }

    protected WsAbstractAction createCopyAction() {
        return new cCopyAction();
    }

    protected WsAbstractAction createPasteAction() {
        return new cPasteAction();
    }

    protected WsAbstractAction createSelectAllAction() {
        return new cSelectAllAction();
    }

    protected WsAbstractAction createClearAction() {
        return new cClearAction();
    }

    private class TextComponentSelectionListener
    implements CaretListener {
        private TextComponentSelectionListener() {
        }

        @Override
        public void caretUpdate(CaretEvent ev) {
            WsTextPropertyTab.this.updateActions();
        }
    }

    protected class cOpenAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cOpenAction() {
            this.setMenuSupportId("open");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.open();
        }
    }

    protected class cOpenRemoteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cOpenRemoteAction() {
            this.setMenuSupportId("openremote");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.openRemote();
        }
    }

    protected class cSaveAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSaveAction() {
            this.setMenuSupportId("save");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.save();
        }
    }

    protected class cSaveAsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSaveAsAction() {
            this.setMenuSupportId("saveas");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.saveAs();
        }
    }

    protected class cSaveRemoteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSaveRemoteAction() {
            this.setMenuSupportId("saveremote");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.saveRemote();
        }
    }

    protected class cPageSetupAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPageSetupAction() {
            this.setMenuSupportId("pagesetup");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.showPageSetupDialog();
        }
    }

    protected class cPrintAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPrintAction() {
            this.setMenuSupportId("print");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.print();
        }
    }

    protected class cCutAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cCutAction() {
            this.setMenuSupportId("cut");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.m_txt.cut();
        }
    }

    protected class cCopyAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cCopyAction() {
            this.setMenuSupportId("copy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.m_txt.copy();
        }
    }

    protected class cPasteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cPasteAction() {
            this.setMenuSupportId("paste");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.m_txt.paste();
        }
    }

    protected class cSelectAllAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSelectAllAction() {
            this.setMenuSupportId("selectall");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.m_txt.selectAll();
        }
    }

    protected class cClearAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cClearAction() {
            this.setHidable(true);
            this.setMenuSupportId("clear");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsTextPropertyTab.this.m_txt.setText("");
        }
    }
}

