/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class WsSplashScreen
extends JWindow {
    private static final long serialVersionUID = 1L;
    private WAdminResource bundle = null;
    private Frame owningFrame = null;
    private cWindowListener windowListener = null;

    public WsSplashScreen(Class bundleLocation, String filename, Frame f) {
        super(f);
        boolean usingFrame = false;
        if (f != null) {
            this.owningFrame = f;
            usingFrame = true;
        } else {
            cStartedFrame frameStarter = new cStartedFrame();
            frameStarter.start();
        }
        this.bundle = WAdminResource.getBundle(bundleLocation);
        JLabel l = new JLabel(this.bundle.getImageIcon(filename));
        this.getContentPane().add((Component)l, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = l.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.windowListener = new cWindowListener();
        if (usingFrame) {
            this.owningFrame.addWindowListener(this.windowListener);
        }
        this.setVisible(true);
    }

    public class cWindowListener
    extends WindowAdapter {
        @Override
        public void windowActivated(WindowEvent e) {
            SwingUtilities.invokeLater(new cCloseSplash());
            WsSplashScreen.this.owningFrame.removeWindowListener(WsSplashScreen.this.windowListener);
        }
    }

    public class cStartedFrame
    extends Thread
    implements Runnable {
        boolean bpopulated = false;

        @Override
        public void run() {
            while (!this.bpopulated) {
                try {
                    cStartedFrame.sleep(100L);
                }
                catch (InterruptedException ie) {
                    MessageUtil.displayMessage(ie.getLocalizedMessage());
                    ie.printStackTrace();
                }
                if (Workspace.getWorkspace() == null) continue;
                WsSplashScreen.this.owningFrame = Workspace.getWorkspace();
                WsSplashScreen.this.owningFrame.addWindowListener(WsSplashScreen.this.windowListener);
                this.bpopulated = true;
            }
        }
    }

    public class cCloseSplash
    implements Runnable {
        @Override
        public void run() {
            WsSplashScreen.this.setVisible(false);
            WsSplashScreen.this.dispose();
        }
    }
}

