/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WAUndoable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WsGenericAttributesModel
extends WATableModel {
    private static final long serialVersionUID = 1L;
    boolean[] isColumnEditable = new boolean[]{false, true};
    private static WAdminResource bundle = WAdminResource.getBundle(WsGenericAttributesModel.class);
    public static final int NAME_COL = 0;
    public static final int VALUE_COL = 1;
    static final int TOTAL_COLS = 2;
    CMetadata m_metadata = null;
    private ArrayList orig_data = null;
    private ArrayList hidden_values = new ArrayList();
    private boolean modelEditable = true;

    public WsGenericAttributesModel(CMetadata inObject) {
        this.m_metadata = inObject;
        this.columnNames.add(bundle.getString("WsGenericGeneralTableModel.column.name.txt"));
        this.columnNames.add(bundle.getString("WsGenericGeneralTableModel.column.value.txt"));
        this.setupModel();
    }

    public WsGenericAttributesModel(CMetadata inObject, ArrayList hiddenAttrs) {
        this(inObject);
        this.hidden_values = hiddenAttrs;
    }

    public void setupModel() {
        try {
            Map attrs = this.m_metadata.getAttrs();
            Set attrnames = attrs.keySet();
            Iterator attrIter = attrnames.iterator();
            int count = 0;
            int rows = this.getRowCount();
            for (int i = rows - 1; i >= 0; --i) {
                this.deleteRow(i);
            }
            this.fireTableRowsDeleted(0, rows);
            while (attrIter.hasNext()) {
                String attrname = (String)attrIter.next();
                if (this.hidden_values != null && this.hidden_values.contains(attrname)) continue;
                String attrvalue = (String)attrs.get(attrname);
                if (attrname.equals("MetadataCreated") || attrname.equals("MetadataUpdated")) {
                    attrvalue = WsMetadataUtil.formatDate(attrvalue, null);
                }
                this.insertRow(attrname, attrvalue);
                ++count;
            }
            this.fireTableRowsInserted(0, count);
            this.orig_data = new ArrayList(this.data);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
    }

    public void setModelEditable(boolean bEditable) {
        this.modelEditable = bEditable;
    }

    public boolean getModelEditable() {
        return this.modelEditable;
    }

    public void cleanupModel() {
    }

    public ArrayList getOrigData() {
        return this.orig_data;
    }

    public void setHiddenAttrs(ArrayList hiddenAttrs) {
        this.hidden_values = hiddenAttrs;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Document.class;
            }
        }
        return Object.class;
    }

    @Override
    protected Object getDefaultObject(Class c, int col) {
        if (c == String.class) {
            if (col == 0) {
                return "" + this.instanceCount;
            }
            return "";
        }
        if (c == Document.class) {
            return " ";
        }
        return super.getDefaultObject(c, col);
    }

    public Object getRowValue(int row) {
        ArrayList m = (ArrayList)this.data.get(row);
        if (m != null) {
            return m.get(1);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        String value;
        if (!this.modelEditable) {
            return false;
        }
        boolean coledit = this.isColumnEditable[col];
        if (coledit && col == 1 && (value = (String)this.getValueAt(row, col - 1)) != null) {
            if (value.equalsIgnoreCase(bundle.getString("WsGenericGeneralTableModel.uneditablerow.FQID.notrans"))) {
                return false;
            }
            if (value.equalsIgnoreCase(bundle.getString("WsGenericGeneralTableModel.uneditablerow.Created.notrans"))) {
                return false;
            }
            if (value.equalsIgnoreCase(bundle.getString("WsGenericGeneralTableModel.uneditablerow.Updated.notrans"))) {
                return false;
            }
            if (value.equalsIgnoreCase(bundle.getString("WsGenericGeneralTableModel.uneditablerow.Id.notrans"))) {
                return false;
            }
            if (value.equalsIgnoreCase(bundle.getString("WsGenericGeneralTableModel.uneditablerow.MetadataCreated.notrans"))) {
                return false;
            }
            if (value.equalsIgnoreCase(bundle.getString("WsGenericGeneralTableModel.uneditablerow.MetadataUpdated.notrans"))) {
                return false;
            }
            if (value.equalsIgnoreCase(bundle.getString("WsGenericGeneralTableModel.uneditablerow.LockedBy.notrans"))) {
                return false;
            }
            if (value.equalsIgnoreCase(bundle.getString("WsGenericGeneralTableModel.uneditablerow.ChangeState.notrans"))) {
                return false;
            }
        }
        return coledit;
    }

    @Override
    public void setValueAt(Object aVal, int row, int col) {
        if (row < this.data.size()) {
            if (aVal instanceof ArrayList) {
                this.data.set(row, aVal);
            } else if (aVal instanceof String) {
                ArrayList m = (ArrayList)this.data.get(row);
                switch (col) {
                    case 0: {
                        m.set(0, aVal);
                        break;
                    }
                    case 1: {
                        m.set(1, aVal);
                    }
                }
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    public boolean insertRow(String name, String value) {
        ++this.instanceCount;
        ArrayList<String> m = new ArrayList<String>();
        m.add(name);
        m.add(value);
        this.data.add(m);
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        return true;
    }

    public WAUndoable undoableInsertRow(String name, String value) {
        ++this.instanceCount;
        ArrayList m = new ArrayList();
        this.data.add(m);
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
        WATableModel.UndoableInsertRow dui = new WATableModel.UndoableInsertRow(m, this.data.size() - 1);
        return dui;
    }
}

