/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.editor.CodeEditor;
import com.sas.editor.LogListHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerEvent;
import com.sas.workspace.WsAppServerEventListener;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsExternalDataPropertyTabInterface;
import com.sas.workspace.WsServerRequest;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.AppServerPanel;
import com.sas.workspace.visuals.SubmitType;
import com.sas.workspace.visuals.WsAbstractEditorPropertyTab;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class WsEditorPropertyTab
extends WsAbstractEditorPropertyTab
implements WsExternalDataPropertyTabInterface {
    private static final long serialVersionUID = 1L;
    public static final int REMOTE_FILE_OPEN = 0;
    public static final int REMOTE_FILE_SAVE = 1;
    public static final String DEFAULT_SERVER_ID = "AppServer.Default";
    private static WAdminResource bundle = WAdminResource.getBundle(WsEditorPropertyTab.class);
    private static final String RemoteFileNameKey = "WsEditorPropertyTab.LastRemoteFileName";
    private static final String RemoteDirectoryNameKey = "WsEditorPropertyTab.LastRemoteDirectoryName";
    private static final String RemoteAppServerIdKey = "WsEditorPropertyTab.LastRemoteAppServerId";
    private static final int FILE_LOCATION_NONE = 0;
    private static final int FILE_LOCATION_LOCAL = 1;
    private static final int FILE_LOCATION_REMOTE = 2;
    protected WsLogPropertyTab m_tabLog;
    protected WsLogPropertyTab m_tabOutput;
    protected boolean m_bSubmitVisible;
    private boolean m_bSubmitActive;
    private boolean m_bAppServerRefreshed;
    protected boolean m_bListeningForDefaultAppServerChanges;
    private int m_lastFileLocation;
    protected WsAbstractAction m_actEditorMenu;
    protected WsAbstractAction m_actSubmit;
    protected WsAbstractAction m_actTerminate;
    protected WsAbstractAction m_actKill;
    protected WsAbstractAction m_actSaveRemote;
    protected WsAbstractAction m_actOpenRemote;
    private JToolBar m_barEditor;
    protected WsAppServer m_WsAppServer;
    protected WsServerRequest m_WsServerRequest;
    protected SASCodeGeneration m_SASCodeGeneration;
    protected PropertyChangeListener m_lsnrAppDefaults = null;
    protected PropertyChangeListener m_lstnrServerRequest;
    protected WsAppServerEventListener m_lstnrWsAppServerEvent;

    public WsEditorPropertyTab() {
        super(0);
        WorkspaceFile wsFile = Workspace.getWorkspace().getWorkspaceFile();
        this.m_lsnrAppDefaults = new cAppDefaultsListener();
        wsFile.addPropertyChangeListener(this.m_lsnrAppDefaults);
        this.m_WsServerRequest = new WsServerRequest(null);
        this.m_lstnrServerRequest = this.createServerRequestDataChangedListener();
        this.m_WsServerRequest.addPropertyChangeListener(this.m_lstnrServerRequest);
        this.m_lstnrWsAppServerEvent = this.createWsAppServerEventListener();
        this.m_WsServerRequest.addcWsAppServerEventListener(this.m_lstnrWsAppServerEvent);
        this.m_bListeningForDefaultAppServerChanges = true;
        this.m_bSubmitActive = true;
        this.m_lastFileLocation = 0;
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        if (this.m_cmpEditor != null) {
            this.m_cmpEditor.getEditorPane().setEditable(bEditable);
        }
        this.m_actOpen.setEnabled(bEditable);
        this.m_actOpenRemote.setEnabled(bEditable);
        this.m_actCut.setEnabled(bEditable);
        this.m_actPaste.setEnabled(bEditable);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setSubmitActionVisible(true);
        if (this.isSubmitActionVisible()) {
            this.m_barEditor = this.createEditorToolBar();
        }
        this.listenForDataChangesTo((JTextComponent)this.m_txtEditor);
        this.m_cmpEditor.enableHelp(false);
        this.setHelpTopic(this.m_cmpEditor.getHelpTopic());
        this.setHelpProduct(this.m_cmpEditor.getHelpProduct());
    }

    @Override
    protected void layoutWidgets() {
        super.layoutWidgets();
        this.add((Component)this.m_barEditor, "North");
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_actOpen.setActive(bActive);
        this.m_actOpenRemote.setActive(bActive);
        this.m_actSave.setActive(bActive);
        this.m_actSaveAs.setActive(bActive);
        this.m_actSaveRemote.setActive(bActive);
        this.m_actPrint.setActive(bActive);
        this.m_actPageSetup.setActive(bActive);
        this.m_actUndo.setActive(bActive);
        this.m_actRedo.setActive(bActive);
        this.m_actCut.setActive(bActive);
        this.m_actCopy.setActive(bActive);
        this.m_actPaste.setActive(bActive);
        this.m_actSelectAll.setActive(bActive);
        this.m_actClear.setActive(bActive);
        this.m_actFindReplace.setActive(bActive);
        if (this.isSubmitActionVisible()) {
            this.m_actEditorMenu.setActive(bActive);
            this.m_actSubmit.setActive(bActive);
            SubmitType.getInstance().setActive(bActive);
            this.m_actTerminate.setActive(bActive);
            this.m_actKill.setActive(bActive);
            if (this.m_actSubmit.isEnabled()) {
                this.m_actTerminate.setEnabled(false);
                this.m_actKill.setEnabled(false);
            }
        }
        SubmitType.getInstance().setEnabled(bActive);
    }

    @Override
    public void saveSettingsAndCleanUp() {
        if (this.m_WsServerRequest != null) {
            this.m_WsServerRequest.termWsServerRequest();
            this.m_WsServerRequest = null;
            this.m_WsAppServer = null;
        }
        if (this.m_lsnrAppDefaults != null) {
            WorkspaceFile wsFile = Workspace.getWorkspace().getWorkspaceFile();
            wsFile.removePropertyChangeListener(this.m_lsnrAppDefaults);
            this.m_lsnrAppDefaults = null;
        }
        this.removeActionsFromKeymap();
        if (this.m_cmpEditor != null) {
            this.m_cmpEditor.cleanup();
            this.m_cmpEditor = null;
        }
    }

    public void setLogTab(WsLogPropertyTab tabLog) {
        this.m_tabLog = tabLog;
    }

    public WsLogPropertyTab getLogTab() {
        return this.m_tabLog;
    }

    public JToolBar getToolBar() {
        return this.m_barEditor;
    }

    public void setOutputTab(WsLogPropertyTab tabOutput) {
        this.m_tabOutput = tabOutput;
    }

    public void setAppServerRefreshed(boolean bAppServerRefreshed) {
        this.m_bAppServerRefreshed = bAppServerRefreshed;
    }

    public boolean getAppServerRefreshed() {
        return this.m_bAppServerRefreshed;
    }

    public WsLogPropertyTab getOutputTab() {
        return this.m_tabOutput;
    }

    public void setSubmitActionVisible(boolean bVisible) {
        this.m_bSubmitVisible = bVisible;
    }

    public boolean isSubmitActionVisible() {
        return this.m_bSubmitVisible;
    }

    public void setSubmitActionActive(boolean bActive) {
        this.m_bSubmitActive = bActive;
    }

    public boolean isSubmitActionActive() {
        return this.m_bSubmitActive;
    }

    public void setListenForDefaultAppServerChanges(boolean bListen) {
        this.m_bListeningForDefaultAppServerChanges = bListen;
    }

    public boolean isListeningForDefaultAppServerChanges() {
        return this.m_bListeningForDefaultAppServerChanges;
    }

    public void submitCode() {
        block17: {
            if (!this.validateData()) {
                return;
            }
            this.m_view.setListenForDefaultAppServerChanges(false);
            this.setListenForDefaultAppServerChanges(false);
            String defaultWsAppServerId = this.m_WsServerRequest.getDefaultWsAppServerId();
            String sSelectedSubmitType = SubmitType.getInstance().getSelectedSubmitType();
            try {
                if (this.m_WsServerRequest.getSubmitType() == null || this.m_WsServerRequest.getPropertyString("jobstatus").length() == 0 || this.m_WsServerRequest.getPropertyString("jobstatus").length() > 0 && defaultWsAppServerId.equals(this.m_WsAppServer.getServerContext().getId())) {
                    this.m_WsServerRequest.setSubmitType(sSelectedSubmitType);
                }
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException(re);
            }
            if (this.m_WsAppServer == null) {
                this.m_WsAppServer = this.m_WsServerRequest.getAppServer();
            } else {
                try {
                    int eAnswer;
                    if (defaultWsAppServerId == "" || defaultWsAppServerId.equals(this.m_WsAppServer.getServerContext().getId()) || (eAnswer = MessageUtil.displayMessage(bundle.getString("WsEditorPropertyTab.ChangeAppServerMessage.txt"), bundle.getString("WsEditorPropertyTab.ChangeAppServerTitle.txt"), 1, 0)) != 0) break block17;
                    try {
                        this.m_view.updateTitleWithDefaultAppServerChanges();
                    }
                    catch (MdException me) {
                        MessageUtil.displayMetadataExceptionMessage(me, "Accessing");
                    }
                    catch (RemoteException re) {
                        re.printStackTrace();
                    }
                    this.refreshAppServer();
                    if (!this.m_WsServerRequest.getSubmitType().equalsIgnoreCase(sSelectedSubmitType)) {
                        this.m_WsServerRequest.setSubmitType(sSelectedSubmitType);
                    }
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                }
            }
        }
        if (this.m_WsAppServer == null) {
            return;
        }
        WorkspaceFile defaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
        if (defaultsFile.getPropertyBoolean("Workspace.ClearLogBeforeSubmit", false)) {
            if (this.m_tabLog != null && this.m_view.isLogTabPresent()) {
                this.m_tabLog.clear();
            }
            if (this.m_tabOutput != null && this.m_view.isOutputTabPresent()) {
                this.m_tabOutput.clear();
            }
        }
        if (this.m_SASCodeGeneration == null) {
            this.m_SASCodeGeneration = new SASCodeGeneration();
        }
        this.submitCodeToAppServer(this.getSASCode());
    }

    protected String getSASCode() {
        String sSASCode = this.m_cmpEditor.getSelectedText();
        if (sSASCode == null || sSASCode.length() == 0) {
            sSASCode = this.m_cmpEditor.getText();
        }
        return sSASCode;
    }

    protected boolean submitCodeToAppServer(String sSASCode) {
        Workspace.getDefaultLogger().info("----- Submitting -----");
        String sSelectedSubmitType = this.m_WsServerRequest.getSubmitType();
        StringBuffer sbGridCode = new StringBuffer();
        try {
            StringBuffer prefixCode = this.m_SASCodeGeneration.getSubmitToGridPrefix((CMetadata)this.m_WsAppServer.getServerContext(), this.m_WsAppServer.getServerContext(), sSelectedSubmitType);
            if (prefixCode != null) {
                sbGridCode.append(prefixCode);
            }
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage(me, "Accessing");
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        if (sbGridCode.length() > 0) {
            sbGridCode.append("\n").append(sSASCode).append("\n").append(this.m_SASCodeGeneration.getSubmitToGridSuffix(this.m_WsAppServer.getServerContext(), sSelectedSubmitType));
            Workspace.getDefaultLogger().info(sbGridCode.toString());
            Workspace.getDefaultLogger().info("----------------------");
            this.m_WsServerRequest.setCodeToSubmit(sbGridCode.toString());
        } else {
            Workspace.getDefaultLogger().info(sSASCode);
            Workspace.getDefaultLogger().info("----------------------");
            this.m_WsServerRequest.setCodeToSubmit(sSASCode);
        }
        this.m_actSubmit.setEnabled(false);
        SubmitType.getInstance().setEnabled(false);
        this.setSubmitActionActive(false);
        this.m_actTerminate.setEnabled(true);
        this.m_actKill.setEnabled(true);
        this.m_WsServerRequest.startCodeSubmit();
        return true;
    }

    public PropertyChangeListener createServerRequestDataChangedListener() {
        return new cServerRequestDataChangedListener();
    }

    public WsAppServerEventListener createWsAppServerEventListener() {
        return new cWsAppServerEventListener();
    }

    protected void submitFinished(String sJobStatus) {
        Workspace work;
        block5: {
            work = Workspace.getWorkspace();
            this.setSubmitActionActive(true);
            this.m_actSubmit.setEnabled(true);
            SubmitType.getInstance().setEnabled(true);
            this.m_actTerminate.setEnabled(false);
            this.m_actKill.setEnabled(false);
            if (!sJobStatus.equals(WsServerRequest.JOBCANCELLED) && this.m_WsServerRequest.getPropertyInt("status") != 0) {
                String sError = bundle.getString("WsEditorPropertyTab.Msg.SubFail.txt") + " " + this.m_WsServerRequest.getMessage();
                Workspace.getDefaultLogger().error(sError);
                work.setStatusText(sError);
                work.getMessagesWindow().addMessage(sError);
                MessageUtil.displayMessage(sError, bundle.getString("Common.Error.txt"), 0);
            }
            try {
                LogListHolder hldrOutput;
                LogListHolder hldrLog;
                if (this.m_tabLog != null && this.m_view.isLogTabPresent() && (hldrLog = this.m_WsServerRequest.getLogText()) != null) {
                    this.m_tabLog.appendText(hldrLog);
                }
                if (this.m_tabOutput != null && this.m_view.isOutputTabPresent() && (hldrOutput = this.m_WsServerRequest.getOutputText()) != null) {
                    this.m_tabOutput.appendText(hldrOutput);
                }
            }
            catch (WsAppServerFailException e) {
                if (this.m_WsAppServer.isKilled()) break block5;
                MessageUtil.displayMessage(e.getMessage(), 0);
            }
        }
        work.clearStatusText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openRemoteFile() {
        WsAppServer appServer = null;
        try {
            String filename;
            if (this.hasDataChanged() && this.promptedSave() == 2) {
                boolean bl = false;
                return bl;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            appServer = WsAppServer.createDefaultAppServer();
            appServer.open();
            LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
            mapFileTypes.put(bundle.getString("WsEditorPropertyTab.SASFileTypes.txt"), "SAS");
            mapFileTypes.put(bundle.getString("WsEditorPropertyTab.AllFileTypes.txt"), "*");
            String initialPath = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(RemoteFileNameKey, "");
            if (initialPath.length() == 0 || !appServer.doesFileExist(appServer.getParentDirectory(initialPath))) {
                initialPath = "";
            }
            if ((filename = appServer.promptForFilename(bundle.getString("WsEditorPropertyTab.RemoteFileSelector.Open.Title.txt"), initialPath, mapFileTypes)) == null) {
                boolean bl = false;
                return bl;
            }
            String contents = appServer.readFile(filename);
            if (contents != null) {
                this.m_txtEditor.setText(contents);
                this.m_txtEditor.getCodeEditorDocument().setFilename(filename);
                this.setFileName(filename);
                this.setDataChanged(false);
                this.updateActions();
            }
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage(e.getLocalizedMessage(), this.getName(), 0);
            Workspace.getDefaultLogger().error((Object)"", e);
            boolean bl = false;
            return bl;
        }
        catch (GenericError ge) {
            MessageUtil.displayMessage(ge.getLocalizedMessage(), 0);
            boolean bl = false;
            return bl;
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
        return true;
    }

    @Override
    public boolean save() {
        if (!this.validateData()) {
            return false;
        }
        boolean result = false;
        if (this.m_bRealFileName) {
            if (this.m_lastFileLocation == 1) {
                result = super.save();
            } else if (this.m_lastFileLocation == 2) {
                result = this.saveRemoteFile(false);
                if (result) {
                    this.setDataChanged(false);
                    this.updateActions();
                }
            } else {
                result = this.saveAs();
            }
        } else {
            result = this.saveAs();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveRemoteFile(boolean prompt) {
        if (!this.validateData()) {
            return false;
        }
        WsAppServer appServer = null;
        try {
            String filename;
            int answer;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String initialPath = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(RemoteFileNameKey, "");
            String lastAppServerId = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString(RemoteAppServerIdKey, "");
            if (this.m_lastFileLocation == 2 && !lastAppServerId.equals(WsAppServer.getDefaultAppServerFQID())) {
                initialPath = "";
                if (!prompt) {
                    answer = MessageUtil.displayMessage(bundle.getString("WsEditorPropertyTab.SaveRemote.ChangeAppServerMessage.txt"), bundle.getString("WsEditorPropertyTab.SaveRemote.ChangeAppServerTitle.txt"), 2, 2);
                    if (answer) {
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        this.m_view.updateTitleWithDefaultAppServerChanges();
                    }
                    catch (MdException me) {
                        MessageUtil.displayMetadataExceptionMessage(me, "Accessing");
                    }
                    catch (RemoteException re) {
                        re.printStackTrace();
                    }
                    this.refreshAppServer();
                }
            }
            if ((appServer = WsAppServer.createDefaultAppServer()) == null) {
                MessageUtil.displayMessage(bundle.getString("WsEditorPropertyTab.Error.Message.txt"), 0);
                answer = 0;
                return answer != 0;
            }
            appServer.open();
            if (!appServer.isFileBrowseEnabled()) {
                answer = 0;
                return answer != 0;
            }
            if (this.m_bRealFileName && this.m_lastFileLocation == 2 && initialPath.length() != 0 && !prompt) {
                filename = this.getFileName();
            } else {
                if (initialPath.length() == 0 || !appServer.doesFileExist(appServer.getParentDirectory(initialPath))) {
                    initialPath = "";
                }
                LinkedHashMap<String, String> mapFileTypes = new LinkedHashMap<String, String>();
                mapFileTypes.put(bundle.getString("WsEditorPropertyTab.SASFileTypes.txt"), "SAS");
                mapFileTypes.put(bundle.getString("WsEditorPropertyTab.AllFileTypes.txt"), "*");
                filename = appServer.promptForFilename(bundle.getString("WsEditorPropertyTab.RemoteFileSelector.Save.Title.txt"), initialPath, mapFileTypes);
            }
            if (filename == null || filename.length() == 0) {
                boolean mapFileTypes = false;
                return mapFileTypes;
            }
            if (!filename.matches(".*[.]sas$")) {
                filename = filename + ".sas";
            }
            appServer.writeFile(this.m_txtEditor.getText(), filename);
            this.m_txtEditor.getCodeEditorDocument().setFilename(filename);
            this.setFileName(filename);
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(RemoteFileNameKey, filename);
            String directoryName = appServer.getParentDirectory(this.m_txtEditor.getCodeEditorDocument().getFilename());
            if (directoryName != null) {
                Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(RemoteDirectoryNameKey, directoryName);
            }
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyString(RemoteAppServerIdKey, appServer.getServerFQID());
            this.m_lastFileLocation = 2;
        }
        catch (WsAppServerFailException e) {
            MessageUtil.displayMessage(e.getLocalizedMessage(), this.getName(), 0);
            Workspace.getDefaultLogger().error((Object)"", e);
            boolean bl = false;
            return bl;
        }
        catch (GenericError ge) {
            MessageUtil.displayMessage(ge.getLocalizedMessage(), 0);
            boolean bl = false;
            return bl;
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveAs() {
        if (!this.validateData()) {
            return false;
        }
        boolean result = false;
        String filename = this.m_cmpEditor.getFilename();
        try {
            File directory;
            File file;
            if (this.m_lastFileLocation == 2 && !(file = new File(filename)).exists() && !(directory = file.getParentFile()).exists()) {
                this.m_cmpEditor.setFilename("");
            }
            if (result = super.saveAs()) {
                this.m_lastFileLocation = 1;
            }
        }
        finally {
            if (!result) {
                this.m_cmpEditor.setFilename(filename);
            }
        }
        return result;
    }

    @Override
    public boolean validateData() {
        if (!super.validateData()) {
            return false;
        }
        Integer returnVal = this.m_txtEditor.getCodeEditorDocument().validateLineLengths(255);
        if (returnVal != null) {
            int iLine = returnVal + 1;
            if (1 == SASCodeGeneration.displayLineLengthMessage(this.m_txtEditor.getCodeEditorDocument().getLine(returnVal.intValue()), iLine)) {
                int lineIndex = this.m_txtEditor.getCodeEditorDocument().getStartOffsetForLine(returnVal.intValue());
                if (lineIndex >= 0) {
                    this.m_txtEditor.setCaretPosition(lineIndex);
                    this.requestFocus();
                }
                return false;
            }
        }
        return true;
    }

    protected void refreshAppServer() {
        this.m_WsServerRequest.refreshWsAppServer();
        this.m_bAppServerRefreshed = true;
    }

    @Override
    protected CodeEditor createEditor() {
        Workspace frmMain = Workspace.getWorkspace();
        return new CodeEditor((Frame)frmMain, frmMain.getCodeEditorDefaults());
    }

    @Override
    protected void createActions() {
        this.m_actOpen = this.createOpenAction();
        this.m_actOpenRemote = this.createOpenRemoteAction();
        this.m_actSave = this.createSaveAction();
        this.m_actSaveAs = this.createSaveAsAction();
        this.m_actSaveRemote = this.createSaveRemoteAction();
        this.m_actPrint = this.createPrintAction();
        this.m_actPageSetup = this.createPageSetupAction();
        this.m_actUndo = this.createUndoAction();
        this.m_actRedo = this.createRedoAction();
        this.m_actCut = this.createCutAction();
        this.m_actCopy = this.createCopyAction();
        this.m_actPaste = this.createPasteAction();
        this.m_actSelectAll = this.createSelectAllAction();
        this.m_actClear = this.createClearAction();
        this.m_actFindReplace = this.createFindReplaceAction();
        this.m_actEditorMenu = this.createEditorMenuAction();
        this.m_actSubmit = this.createSubmitAction();
        this.m_actPopupMenu = this.createPopupMenuAction();
        this.m_actTerminate = this.createTerminateAction();
        this.m_actKill = this.createKillAction();
    }

    @Override
    protected void updateActions() {
        if (this.m_cmpEditor != null) {
            this.m_actUndo.setEnabled(this.m_cmpEditor.canUndo());
            this.m_actRedo.setEnabled(this.m_cmpEditor.canRedo());
            this.m_actCut.setEnabled(this.m_cmpEditor.canCut());
            this.m_actCopy.setEnabled(this.m_cmpEditor.canCopy());
            this.m_actPaste.setEnabled(this.m_cmpEditor.canPaste());
            this.m_actSelectAll.setEnabled(this.m_cmpEditor.canSelectAll());
            this.m_actClear.setEnabled(this.m_cmpEditor.canClearAll());
        }
        if (this.m_txtEditor != null) {
            this.m_actSubmit.setEnabled(this.m_txtEditor.getDocument().getLength() > 0 && this.m_bSubmitActive);
            this.m_actTerminate.setEnabled(this.m_txtEditor.getDocument().getLength() > 0 && !this.m_bSubmitActive);
            this.m_actKill.setEnabled(this.m_txtEditor.getDocument().getLength() > 0 && !this.m_bSubmitActive);
        }
    }

    @Override
    protected void addActionsToKeymap() {
        super.addActionsToKeymap();
        this.m_txtEditor.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(119, 0), this.m_actSubmit);
        this.m_txtEditor.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(90, 2), this.m_txtEditor.getActionMap().get("undo"));
        this.m_txtEditor.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(89, 2), this.m_txtEditor.getActionMap().get("redo"));
    }

    @Override
    protected void removeActionsFromKeymap() {
        super.removeActionsFromKeymap();
        this.m_txtEditor.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(119, 0));
        this.m_txtEditor.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(90, 2));
        this.m_txtEditor.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(89, 2));
    }

    private JToolBar createEditorToolBar() {
        JToolBar barEditor = WsUIUtilities.createToolBar();
        barEditor.add(WsUIUtilities.createFlatTextIconButton(this.m_actSubmit));
        barEditor.add(WsUIUtilities.createFlatTextIconButton(this.m_actKill));
        barEditor.setVisible(true);
        return barEditor;
    }

    protected WsAbstractAction createEditorMenuAction() {
        return new cEditorMenuAction();
    }

    protected WsAbstractAction createSubmitAction() {
        return new cSubmitAction();
    }

    protected WsAbstractAction createKillAction() {
        return new cKillAction();
    }

    protected WsAbstractAction createOpenRemoteAction() {
        return new cOpenRemoteAction();
    }

    protected WsAbstractAction createTerminateAction() {
        return new cTerminateAction();
    }

    protected WsAbstractAction createSaveRemoteAction() {
        return new cSaveRemoteAction();
    }

    protected WsAbstractAction getOpenRemoteAction() {
        return this.m_actOpenRemote;
    }

    protected WsAbstractAction getSaveRemoteAction() {
        return this.m_actSaveRemote;
    }

    @Override
    public boolean noSaveSaysDontWrite() {
        return false;
    }

    @Override
    public String getTabTypeName() {
        return this.m_sFileName;
    }

    protected class cAppDefaultsListener
    implements PropertyChangeListener {
        protected cAppDefaultsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (WsEditorPropertyTab.this.m_bListeningForDefaultAppServerChanges && e.getPropertyName().equals(AppServerPanel.DefaultServerId)) {
                WsEditorPropertyTab.this.refreshAppServer();
                WsEditorPropertyTab.this.setAppServerRefreshed(true);
            }
        }
    }

    protected class cServerRequestDataChangedListener
    implements PropertyChangeListener {
        protected cServerRequestDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equalsIgnoreCase(WsServerRequest.DISPOSED)) {
                WsEditorPropertyTab.this.m_WsServerRequest = null;
                WsEditorPropertyTab.this.m_WsAppServer = null;
                return;
            }
            if (e.getPropertyName().equalsIgnoreCase("jobstatus")) {
                try {
                    String sAppServerName = null;
                    if (WsEditorPropertyTab.this.m_WsServerRequest != null) {
                        sAppServerName = WsEditorPropertyTab.this.m_WsServerRequest.getWsAppServerName();
                    }
                    if (sAppServerName == null) {
                        sAppServerName = "";
                    }
                    WsEditorPropertyTab.this.m_view.updateTitleWithStatusChanges(e.getNewValue().toString(), WsEditorPropertyTab.this.m_txtEditor.getFilename(), sAppServerName);
                    if (e.getNewValue().equals(WsServerRequest.JOBABORTED) || e.getNewValue().equals(WsServerRequest.JOBERRORED) || e.getNewValue().equals(WsServerRequest.JOBKILLED) || e.getNewValue().equals(WsServerRequest.JOBTERMINATED) || e.getNewValue().equals(WsServerRequest.JOBSUCCESSFUL) || e.getNewValue().equals(WsServerRequest.JOBCANCELLED)) {
                        SwingUtilities.invokeLater(new cSubmitFinishRunnable((String)e.getNewValue()));
                    }
                }
                catch (MdException me) {
                    MessageUtil.displayMetadataExceptionMessage(me, "Accessing");
                }
                catch (RemoteException re) {
                    re.printStackTrace();
                }
            }
        }
    }

    protected class cWsAppServerEventListener
    implements WsAppServerEventListener {
        protected cWsAppServerEventListener() {
        }

        @Override
        public void eventHappened(WsAppServerEvent evt) {
            if (evt.getEventId() == 1) {
                SwingUtilities.invokeLater(new cGetLogRunnable(evt.getListText()));
            }
            if (evt.getEventId() == 2) {
                SwingUtilities.invokeLater(new cGetOutputRunnable(evt.getListText()));
            }
        }
    }

    protected class cEditorMenuAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cEditorMenuAction() {
            this.setMenuSupportId("editormenu");
            this.setHidable(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class cSubmitAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSubmitAction() {
            super(bundle, "WsEditorPropertyTab.Run", 32);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Run"));
            this.setMenuSupportId("Common:Run");
            this.setHidable(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WsEditorPropertyTab.this.isSubmitActionVisible()) {
                WsEditorPropertyTab.this.submitCode();
            }
        }
    }

    protected class cKillAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cKillAction() {
            super(bundle, "WsEditorPropertyTab.Stop", 32);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Stop"));
            this.setMenuSupportId("Common:Stop");
            this.setHidable(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsEditorPropertyTab.this.m_WsServerRequest.killWsAppServer();
        }
    }

    protected class cOpenRemoteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cOpenRemoteAction() {
            this.setMenuSupportId("openremote");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsEditorPropertyTab.this.openRemoteFile();
        }
    }

    protected class cTerminateAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cTerminateAction() {
            super(bundle, "WsEditorPropertyTab.Terminate", true);
            this.setMenuSupportId("terminatejob");
            this.setHidable(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WsEditorPropertyTab.this.m_WsServerRequest.terminateRunningSasCode();
        }
    }

    protected class cSaveRemoteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSaveRemoteAction() {
            this.setMenuSupportId("saveremote");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean result = false;
            result = WsEditorPropertyTab.this.saveRemoteFile(true);
            if (result) {
                WsEditorPropertyTab.this.setDataChanged(false);
                WsEditorPropertyTab.this.updateActions();
            }
        }
    }

    protected class cSubmitFinishRunnable
    implements Runnable {
        private String m_sJobStatus;

        public cSubmitFinishRunnable(String sJobStatus) {
            this.m_sJobStatus = sJobStatus;
        }

        @Override
        public void run() {
            WsEditorPropertyTab.this.submitFinished(this.m_sJobStatus);
        }
    }

    protected class cGetLogRunnable
    implements Runnable {
        private LogListHolder m_llhLog;

        public cGetLogRunnable(LogListHolder llhLog) {
            this.m_llhLog = llhLog;
        }

        @Override
        public void run() {
            if (WsEditorPropertyTab.this.m_tabLog != null && WsEditorPropertyTab.this.m_view.isLogTabPresent() && this.m_llhLog != null) {
                WsEditorPropertyTab.this.m_tabLog.appendText(this.m_llhLog);
            }
        }
    }

    protected class cGetOutputRunnable
    implements Runnable {
        private LogListHolder m_llhOut;

        public cGetOutputRunnable(LogListHolder llhOut) {
            this.m_llhOut = llhOut;
        }

        @Override
        public void run() {
            if (WsEditorPropertyTab.this.m_tabOutput != null && WsEditorPropertyTab.this.m_view.isOutputTabPresent() && this.m_llhOut != null) {
                WsEditorPropertyTab.this.m_tabOutput.appendText(this.m_llhOut);
            }
        }
    }
}

