/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.WATextPane;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.metadata.WsMetadataUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public class WizardFinishTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    JPanel contentPane;
    WATextPane m_textPane;
    private static WAdminResource bundle = WAdminResource.getBundle(WizardFinishTab.class);
    LimitedStyledDocument lsd;
    String newline = "\n";

    public WizardFinishTab() {
        super(bundle.getString("WizardFinishTab.SourceDesigner.Description.txt"));
        this._initialize();
        this.setHelpProduct("shared");
        this.setHelpTopic("wiz_finish_win");
    }

    public WizardFinishTab(String strDescription) {
        super(strDescription);
        this._initialize();
        this.setHelpProduct("shared");
        this.setHelpTopic("wiz_finish_win");
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            myParent.setCursor(Cursor.getPredefinedCursor(3));
            myParent.runFinish();
            String initString = (String)myParent.getWizardData("FINISHINFO");
            this.initDocument(initString);
            this.m_textPane.setCaretPosition(0);
            this.m_textPane.getAdapter().setPrintTitle(myParent.getTitle());
            myParent.setCursor(null);
        } else {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            Tree tree = (Tree)myParent.getWizardData("GROUP");
            if (tree != null) {
                WsMetadataUtil.setDefaultFolder(tree.getFQID());
            }
        }
        return true;
    }

    protected void _initialize() {
        this.lsd = new LimitedStyledDocument(10000);
        this.m_textPane = new WATextPane(this.lsd);
        this.m_textPane.setEnabled(true);
        this.m_textPane.setBehavior(2);
        this.m_textPane.setCaretPosition(0);
        this.m_textPane.setMargin(new Insets(5, 5, 5, 5));
        this.m_textPane.setAutoSelect(false);
        this.m_textPane.getAdapter().setPrintable(true);
        if (WAWizardDialog.isUsingNewStyle()) {
            this.m_textPane.setBackground(SystemColor.window);
        }
        Font fnt = this.m_textPane.getFont();
        fnt = new Font("Monospaced", fnt.getStyle(), fnt.getSize());
        this.m_textPane.setFont(fnt);
        this.m_textPane.setEditable(false);
        JScrollPane scrollPaneForText = new JScrollPane(this.m_textPane);
        if (!WAWizardDialog.isUsingNewStyle()) {
            scrollPaneForText.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        scrollPaneForText.setPreferredSize(new Dimension(200, 200));
        this.setLayout(new GridBagLayout());
        this.add((Component)scrollPaneForText, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setWizardPageType(2);
    }

    protected void initDocument(String initString) {
        try {
            this.lsd.insertString(this.lsd.getLength(), initString, null);
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert initial text.");
        }
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public void onBack() {
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        myParent.removeWizardData("FINISHINFO");
        int len = this.lsd.getLength();
        try {
            this.lsd.remove(0, len);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)"", e);
        }
    }

    class LimitedStyledDocument
    extends DefaultStyledDocument {
        private static final long serialVersionUID = 1L;
        int maxCharacters;

        public LimitedStyledDocument(int maxChars) {
            this.maxCharacters = maxChars;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            super.insertString(offs, str, a);
        }
    }
}

