/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAUndoManager;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.metadata.WsMetadataNameUtil;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.ResponsiblePartyTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;

public class WAGeneralPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(WAGeneralPanel.class);
    protected String m_strFeatureMessage;
    protected Root m_oMetadata;
    protected Tree m_oTree;
    protected Tree m_oOriginalTree;
    protected PathUrl m_pathUrl;
    protected String m_originalName;
    protected String m_originalFolderID;
    protected SoftwareComponent m_softwareComp;
    protected String m_resposIDFilter;
    protected JLabel m_lblName;
    protected WATextField m_txtName;
    protected JLabel m_lblDescription;
    protected JScrollPane m_scrDescription;
    protected WATextArea m_txtDescription;
    protected JButton m_btnAbout;
    protected JLabel m_lblRole;
    protected WAComboBox m_cmbRole;
    protected JLabel m_lblGroup;
    protected WATextField m_txtGroup;
    protected JButton m_btnGroup;
    protected JLabel m_lblResponsibleParties;
    protected WsTable m_tblResponsibleParties;
    protected ResponsiblePartyTableModel m_mdlResponsibleParties;
    protected JScrollPane m_scrResponsibleParties;
    protected JButton m_btnNew;
    protected JButton m_btnDelete;
    protected JPanel m_pnlButtons;
    protected boolean m_bShowRole;
    protected boolean m_bShowGroup;
    protected boolean m_bShowAbout;
    protected boolean m_bShowResponsibleParties;
    protected boolean m_bIsPhysicalTable;
    protected boolean m_bTreeChanged;
    private boolean m_bSelectFolderEnabled;
    private boolean m_bEnableNameValidation;
    private boolean m_bRootFolderSelectionEnabled;
    protected WsAbstractAction m_actAbout;
    protected WsAbstractAction m_actNew;
    protected WsAbstractAction m_actDelete;
    protected WsAbstractAction m_actGroup;

    public WAGeneralPanel(CMetadata oMetadata, String sFeatureMessage) {
        this(oMetadata, sFeatureMessage, false, false, true);
    }

    public WAGeneralPanel(String strFeatureMessage, boolean bShowAbout, boolean bShowRole, boolean bShowTable) {
        this(null, strFeatureMessage, bShowAbout, bShowRole, bShowTable);
    }

    public WAGeneralPanel(CMetadata oMetadata, String strFeatureMessage, boolean bShowAbout, boolean bShowRole, boolean bShowResponsibleParties) {
        this(oMetadata, strFeatureMessage, bShowAbout, bShowRole, bShowResponsibleParties, false);
    }

    public WAGeneralPanel(CMetadata oMetadata, String strFeatureMessage, boolean bShowAbout, boolean bShowRole, boolean bShowResponsibleParties, boolean bShowGroup) {
        this(oMetadata, strFeatureMessage, bShowAbout, bShowRole, bShowResponsibleParties, bShowGroup, null);
    }

    public WAGeneralPanel(CMetadata oMetadata, String strFeatureMessage, boolean bShowAbout, boolean bShowRole, boolean bShowResponsibleParties, boolean bShowGroup, Tree oDefaultTreeLocation) {
        this.m_oMetadata = (Root)oMetadata;
        this.m_strFeatureMessage = strFeatureMessage;
        if (this.m_oMetadata != null) {
            this.m_bIsPhysicalTable = this.m_oMetadata instanceof DataTable;
        }
        this.m_bShowAbout = bShowAbout;
        this.m_bShowRole = bShowRole;
        this.m_bShowResponsibleParties = bShowResponsibleParties;
        this.m_bShowGroup = bShowGroup;
        this.initialize();
        this.layoutWidgets();
        this.setHelpTopic("general_tab");
        this.setHelpProduct("shared");
        if (oDefaultTreeLocation != null) {
            this.m_oTree = oDefaultTreeLocation;
            if (bShowGroup) {
                this.setCustomTreePath(oDefaultTreeLocation);
            }
        }
        try {
            if (this.m_oMetadata != null) {
                this.m_originalName = this.m_oMetadata.getName();
                if (this.m_oTree != null) {
                    this.m_originalFolderID = this.m_oTree.getFQID();
                }
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
    }

    public void setSelectFolderEnabled(boolean bEnabled) {
        if (this.m_bSelectFolderEnabled == bEnabled) {
            return;
        }
        this.m_bSelectFolderEnabled = bEnabled;
        this.updateActions();
    }

    public boolean isSelectFolderEnabled() {
        return this.m_bSelectFolderEnabled;
    }

    public void setAllowRootFolderSelection(boolean bAllowRootFolder) {
        this.m_bRootFolderSelectionEnabled = bAllowRootFolder;
    }

    public void enableNameValidation(boolean bEnableNameValidation) {
        this.m_bEnableNameValidation = bEnableNameValidation;
    }

    public JTextComponent getNameComponent() {
        return this.m_txtName;
    }

    public JTextComponent getDescriptionComponent() {
        return this.m_txtDescription;
    }

    @Override
    public boolean validateData() {
        String newString = this.m_txtName.getText().trim();
        if (newString.length() == 0) {
            MessageUtil.displayMessage(bundle.getString("WAGeneralPropertyTab.noname.txt"), bundle.getString("WAGeneralPropertyTab.nameError.txt"), 0);
            this.m_txtName.requestFocus();
            return false;
        }
        if (this.m_bShowResponsibleParties && !this.m_tblResponsibleParties.stopCellEditing()) {
            return false;
        }
        if (this.m_bEnableNameValidation && this.m_bShowGroup && this.m_actGroup.isEnabled()) {
            if (!WsMetadataNameUtil.isNameValid(this.m_txtName.getText())) {
                this.m_txtName.requestFocus();
                return false;
            }
            try {
                if (!this.m_bSelectFolderEnabled) {
                    return true;
                }
                if (this.m_oMetadata != null) {
                    String objectType = this.m_oMetadata.getCMetadataType();
                    if (objectType == "TransformationStep" && objectType == "SyncStep") {
                        return true;
                    }
                    if (this.m_oTree == null) {
                        MessageUtil.displayMessage(bundle.getString("WAGeneralPanel.NoFolderError.txt"), 0);
                        return false;
                    }
                    if (this.m_oMetadata.isNewObject() || !this.m_oMetadata.getName().equals(newString) || this.m_bTreeChanged) {
                        if (this.m_originalName != null && this.m_originalName.equalsIgnoreCase(newString) && this.m_originalFolderID != null && this.m_originalFolderID.equals(this.m_oTree.getFQID())) {
                            return true;
                        }
                        if (!WsMetadataNameUtil.isNameUniqueInFolder(newString, this.getOwningTree(), ((PrimaryType)this.m_oMetadata).getPublicType())) {
                            MessageUtil.displayMessage(bundle.getString("WAGeneralPanel.DuplicateName.Message.txt"), bundle.getString("WAGeneralPanel.DuplicateName.Title.txt"), 0, -1);
                            return false;
                        }
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
        }
        return true;
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return true;
    }

    @Override
    public void setStorePopulated(boolean bStorePopulated) {
        super.setStorePopulated(bStorePopulated);
        if (!bStorePopulated && this.m_bShowResponsibleParties) {
            this.m_mdlResponsibleParties.setStorePopulated(bStorePopulated);
        }
    }

    @Override
    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_oMetadata == null) {
            return;
        }
        if (this.m_bShowResponsibleParties) {
            this.m_mdlResponsibleParties.setMetadata(this.m_oMetadata);
        }
        if (this.m_oMetadata.getFQID().indexOf(36) == -1) {
            if (this.m_bShowResponsibleParties) {
                this.m_mdlResponsibleParties.populateStore();
            }
            if (this.m_bShowGroup || this.m_bShowRole) {
                StringBuffer sbTemplate = new StringBuffer("<Templates>");
                Vector<String> vAssociations = new Vector<String>();
                if (this.m_bShowGroup) {
                    sbTemplate.append("<Tree><Groups/><ParentTree/></Tree>");
                    sbTemplate.append("<Group><SoftwareComponents/></Group>");
                    if (this.m_oMetadata.getCMetadataType().equals("Tree")) {
                        vAssociations.add("ParentTree");
                    } else {
                        vAssociations.add("Trees");
                    }
                }
                if (this.m_bShowRole) {
                    vAssociations.add("Roles");
                }
                sbTemplate.append("</Templates>");
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oMetadata, null, vAssociations, sbTemplate.toString(), 12);
            }
            if (!(this.m_bShowGroup || this.m_bShowRole || this.m_bShowResponsibleParties)) {
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.m_oMetadata, null, null, "", 8);
            }
        }
        this.setStorePopulated(true);
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        if (this.m_oMetadata != null) {
            this.m_txtName.setText(this.m_oMetadata.getName());
            this.m_txtDescription.setText(this.m_oMetadata.getDesc());
            this.m_originalName = this.m_oMetadata.getName();
        }
        if (this.m_bShowRole && this.m_oMetadata != null) {
            String choice;
            if (this.m_bIsPhysicalTable) {
                // empty if block
            }
            if ((choice = this.getWARole().getObjectRole()) == null) {
                this.m_cmbRole.setSelectedIndex(0);
            } else {
                this.m_cmbRole.setSelectedItem(choice);
            }
        }
        if (this.m_bShowGroup && this.m_oMetadata != null) {
            this.getCustomTree();
            if (this.m_oTree != null) {
                this.setCustomTreePath(this.m_oTree);
                this.m_originalFolderID = this.m_oTree.getFQID();
            } else if (this.m_softwareComp != null) {
                this.setSoftwareComponentPath(this.m_softwareComp);
            }
        }
        if (this.m_bShowResponsibleParties) {
            this.m_mdlResponsibleParties.moveDataToModel();
            this.updateActions();
        }
        this.setListeningForChanges(true);
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        if (this.m_oMetadata == null) {
            return;
        }
        String oldString = this.m_oMetadata.getName();
        String newString = this.m_txtName.getText().trim();
        if (!newString.equals(oldString)) {
            this.m_oMetadata.setName(newString);
        }
        oldString = this.m_oMetadata.getDesc();
        newString = this.m_txtDescription.getText().trim();
        if (!newString.equals(oldString)) {
            this.m_oMetadata.setDesc(newString);
        }
        if (this.m_bShowRole) {
            String role = this.m_cmbRole.getSelectedItem().toString();
            Role iRole = this.getWARole();
            oldString = iRole.getObjectRole();
            if (oldString == null || !oldString.equals(role)) {
                iRole.setObjectRole(role);
            }
        }
        if (this.m_bShowGroup && this.m_bTreeChanged) {
            if (this.m_oMetadata.getCMetadataType().equals("Tree")) {
                ((Tree)this.m_oMetadata).setParentTree(this.m_oTree);
            } else {
                AssociationList alTrees = this.m_oMetadata.getTrees(false);
                alTrees.add((Object)this.m_oTree);
                if (this.m_oOriginalTree != null) {
                    alTrees.remove((Object)this.m_oOriginalTree);
                }
                this.m_oOriginalTree = this.m_oTree;
            }
            this.m_bTreeChanged = false;
        }
        if (this.m_bShowResponsibleParties) {
            this.m_mdlResponsibleParties.moveDataToStore();
        }
        this.setDataChanged(false);
    }

    @Override
    public void setWAUndoManager(WAUndoManager mgrUndo) {
        super.setWAUndoManager(mgrUndo);
        if (this.m_bShowResponsibleParties) {
            this.m_tblResponsibleParties.setUndoManager(mgrUndo);
        }
    }

    protected void getCustomTree() throws MdException, RemoteException {
        block4: {
            block3: {
                if (this.m_oMetadata == null) {
                    return;
                }
                if (!this.m_oMetadata.getCMetadataType().equals("Tree")) break block3;
                this.m_oTree = this.m_oOriginalTree = ((Tree)this.m_oMetadata).getParentTree();
                if (this.m_oTree != null) break block4;
                AssociationList alSC = ((Tree)this.m_oMetadata).getSoftwareComponents();
                if (alSC.size() > 0) {
                    this.m_softwareComp = (SoftwareComponent)alSC.get(0);
                }
                this.m_bSelectFolderEnabled = false;
                break block4;
            }
            AssociationList lTrees = this.m_oMetadata.getTrees();
            for (int iTree = 0; iTree < lTrees.size(); ++iTree) {
                Tree oTree = (Tree)lTrees.get(iTree);
                if (!"Folder".equals(oTree.getPublicType())) continue;
                this.m_oTree = this.m_oOriginalTree = oTree;
                break;
            }
        }
    }

    public Tree getOwningTree() {
        return this.m_oTree;
    }

    public SoftwareComponent getOwningSoftwareComponent() {
        return this.m_softwareComp;
    }

    public PathUrl getOwningTreePathUrl() {
        return this.m_pathUrl;
    }

    public void setOwningTree(Tree tree) {
        this.setCustomTreePath(tree);
    }

    public void setNameField(String newName) {
        this.m_txtName.setText(newName);
    }

    public void setDescriptionField(String newDescription) {
        this.m_txtDescription.setText(newDescription);
    }

    public String getCustomTreePath() {
        return this.m_txtGroup.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCustomTreePath(Tree oTree) {
        String sPath = new String();
        try {
            ServerInterface authServer = Workspace.getWorkspace().getUserContext().getAuthServer();
            ChildServerInterface transaction = authServer.newChild(true);
            try {
                if (oTree != null) {
                    sPath = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)oTree.getObjectStore(), (PrimaryType)oTree, false);
                    String sPathWithType = Workspace.getMdFactory().getOMIUtil().getObjectPath((MdObjectStore)oTree.getObjectStore(), (PrimaryType)oTree, true);
                    this.m_pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)transaction, (String)sPathWithType);
                    this.m_oTree = oTree;
                }
            }
            finally {
                transaction.destroy();
            }
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage(mde, "Accessing");
        }
        this.m_txtGroup.setText(sPath);
        Dimension preferredSize = this.m_txtGroup.getPreferredSize();
        this.m_txtGroup.setPreferredSize(new Dimension(0, preferredSize.height));
    }

    protected void setSoftwareComponentPath(SoftwareComponent oSC) {
        String sPath = new String();
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            if (oSC != null && oSC.getPublicType().equals("RootFolder")) {
                sPath = server.getRootFolder().getPathUrl().getDisplayPath();
                this.m_softwareComp = oSC;
                this.m_pathUrl = server.getRootFolder().getPathUrl();
            }
        }
        catch (ServiceException e) {
            MessageUtil.displayServiceExceptionMessage(e);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        this.m_txtGroup.setText(sPath);
    }

    protected Role getWARole() {
        return null;
    }

    @Override
    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        if (this.m_bShowResponsibleParties) {
            this.m_actNew.setActive(bActive);
            this.m_actDelete.setActive(bActive);
        }
    }

    @Override
    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_txtName.setEditable(bEditable);
        this.m_txtDescription.setEditable(bEditable);
        if (this.m_bShowRole) {
            this.m_cmbRole.setEnabled(bEditable);
        }
        if (this.m_bShowResponsibleParties) {
            this.m_tblResponsibleParties.setEditable(bEditable);
        }
        this.updateActions();
    }

    public void onNew() {
        String[] saPersons = this.m_mdlResponsibleParties.getPersons();
        if (saPersons.length == 0) {
            MessageUtil.displayMessage(bundle.getString("WAGeneralPanel.NoPersonsError.txt"));
        } else {
            this.m_tblResponsibleParties.undoableInsertNewRowAfterLastSelectedRow();
        }
    }

    public void onDelete() {
        this.m_tblResponsibleParties.undoableDeleteSelectedRows();
    }

    public void onAbout() {
        MessageUtil.displayMessage("About object dialog", "About ...", 1);
    }

    @Override
    protected void initialize() {
        this.m_bSelectFolderEnabled = true;
        this.createActions();
        this.m_txtName = new WATextField();
        this.m_txtName.setMaxCharacters(60);
        this.m_txtName.setToolTipText(bundle.getString("GeneralProperties.Tooltip.Name.txt"));
        this.m_lblName = new JLabel(bundle.getString("GeneralProperties.Label.Name.txt"));
        this.m_lblName.setDisplayedMnemonic(bundle.getString("GeneralProperties.Label.Name.mnem").charAt(0));
        this.m_lblName.setLabelFor(this.m_txtName);
        this.listenForDataChangesTo(this.m_txtName);
        this.m_txtDescription = new WATextArea();
        this.m_txtDescription.setMaxCharacters(200);
        this.m_txtDescription.setLineWrap(true);
        this.m_txtDescription.setWrapStyleWord(true);
        this.m_txtDescription.setRows(5);
        this.m_txtDescription.setColumns(30);
        this.m_txtDescription.setToolTipText(bundle.getString("GeneralProperties.Tooltip.Desc.txt"));
        this.m_lblDescription = new JLabel(bundle.getString("GeneralProperties.Label.Desc.txt"));
        this.m_lblDescription.setDisplayedMnemonic(bundle.getString("GeneralProperties.Label.Desc.mnem").charAt(0));
        this.m_lblDescription.setLabelFor(this.m_txtDescription);
        this.m_scrDescription = new JScrollPane(this.m_txtDescription, 20, 31);
        WsUIUtilities.adjustScrollPanePreferredSize(this.m_scrDescription);
        this.listenForDataChangesTo(this.m_txtDescription);
        if (this.m_bShowRole) {
            this.m_cmbRole = new WAComboBox(true);
            this.m_cmbRole.setToolTipText(bundle.getString("GeneralProperties.Tooltip.Role.txt"));
            this.m_lblRole = new JLabel(bundle.getString("GeneralProperties.Label.Role.txt"));
            this.m_lblRole.setDisplayedMnemonic(bundle.getString("GeneralProperties.Label.Role.mnem").charAt(0));
            this.m_lblRole.setLabelFor(this.m_cmbRole);
            this.listenForDataChangesTo(this.m_cmbRole);
        }
        if (this.m_bShowGroup) {
            this.m_txtGroup = new WATextField();
            this.m_txtGroup.setBehavior(2);
            this.m_txtGroup.setToolTipText(bundle.getString("GeneralProperties.Tooltip.Group.txt"));
            this.m_lblGroup = new JLabel(bundle.getString("GeneralProperties.Label.Group.txt"));
            this.m_lblGroup.setDisplayedMnemonic(bundle.getString("GeneralProperties.Label.Group.mnem").charAt(0));
            this.m_lblGroup.setLabelFor(this.m_txtGroup);
            this.m_actGroup = this.createSelectGroupAction();
            this.m_btnGroup = WsUIUtilities.createTextButton(this.m_actGroup);
        }
        if (this.m_bShowResponsibleParties) {
            this.m_mdlResponsibleParties = new ResponsiblePartyTableModel();
            this.m_mdlResponsibleParties.addTableModelListener(this.createTableModelListener());
            this.m_tblResponsibleParties = new WsTable(this.m_mdlResponsibleParties);
            this.m_lblResponsibleParties = new JLabel(bundle.getString("GeneralProperties.Label.Responsible.txt"));
            this.m_lblResponsibleParties.setDisplayedMnemonic(bundle.getString("GeneralProperties.Label.Responsible.mnem").charAt(0));
            this.m_lblResponsibleParties.setLabelFor((Component)((Object)this.m_tblResponsibleParties));
            this.m_tblResponsibleParties.getTableHeader().setReorderingAllowed(false);
            this.m_tblResponsibleParties.setToolTipText(bundle.getString("GeneralProperties.Tooltip.Responsible.txt"));
            this.m_tblResponsibleParties.setRowHeaderVisible(false);
            this.m_tblResponsibleParties.setColumnHidingEnabled(false);
            this.m_tblResponsibleParties.setColumnHoldingEnabled(false);
            this.m_tblResponsibleParties.setAutoResizeMode(4);
            this.m_tblResponsibleParties.setUndoManager(this.getWAUndoManager());
            this.m_tblResponsibleParties.getSelectionModel().addListSelectionListener(this.createTableSelectionListener());
            this.m_tblResponsibleParties.setTablePopupMenuRequestListener(this.createTablePopupMenuRequestListener());
            this.m_tblResponsibleParties.setViewportPopupMenuRequestListener(this.createViewportPopupMenuRequestListener());
            WsUIUtilities.adjustPreferredScrollableViewportSize((JTable)((Object)this.m_tblResponsibleParties), 5);
            this.m_btnNew = WsUIUtilities.createTextButton(this.m_actNew);
            this.m_btnDelete = WsUIUtilities.createTextButton(this.m_actDelete);
            this.m_scrResponsibleParties = new JScrollPane((Component)((Object)this.m_tblResponsibleParties), 20, 31);
            WsUIUtilities.adjustScrollPanePreferredSize(this.m_scrResponsibleParties);
            this.m_scrResponsibleParties.setToolTipText(bundle.getString("GeneralProperties.Tooltip.Responsible.txt"));
            this.m_tblResponsibleParties.getActionMap().put(this.m_actDelete, this.m_actDelete);
            this.m_tblResponsibleParties.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.m_actDelete);
            this.m_pnlButtons = new JPanel();
        }
        if (this.m_bShowAbout) {
            this.m_btnAbout = WsUIUtilities.createTextButton(this.m_actAbout);
        }
    }

    @Override
    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_scrDescription.setMinimumSize(this.m_scrDescription.getPreferredSize());
        this.add((Component)this.m_lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_txtName, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.m_lblDescription, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_scrDescription, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        if (this.m_bShowRole) {
            this.add((Component)this.m_lblRole, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.m_cmbRole, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
        if (this.m_bShowGroup) {
            this.add((Component)this.m_lblGroup, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.m_txtGroup, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.m_btnGroup, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        }
        if (this.m_bShowResponsibleParties) {
            this.m_pnlButtons.setLayout(new WsButtonsLayout());
            this.m_pnlButtons.add(this.m_btnNew);
            this.m_pnlButtons.add(this.m_btnDelete);
            this.add((Component)this.m_lblResponsibleParties, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.m_scrResponsibleParties, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
            this.add((Component)this.m_pnlButtons, new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 0), 0, 0));
        } else {
            this.add((Component)new JPanel(), new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public int getMaxWidthOfLabels() {
        int iNameWidth = this.m_lblName.getPreferredSize().width;
        int iDescWidth = this.m_lblDescription.getPreferredSize().width;
        int iGroupWidth = this.m_lblGroup.getPreferredSize().width;
        return Math.max(Math.max(iNameWidth, iDescWidth), iGroupWidth);
    }

    public void setWidthOfLabels(int width) {
        this.m_lblName.setPreferredSize(new Dimension(width, this.m_lblName.getPreferredSize().height));
        this.m_lblDescription.setPreferredSize(new Dimension(width, this.m_lblDescription.getPreferredSize().height));
        this.m_lblGroup.setPreferredSize(new Dimension(width, this.m_lblGroup.getPreferredSize().height));
    }

    public void setMetadataObject(Root metadata) {
        this.m_oMetadata = metadata;
        try {
            if (this.m_oMetadata != null) {
                this.m_originalName = this.m_oMetadata.getName();
                if (this.m_bShowGroup && this.m_oMetadata != null) {
                    this.getCustomTree();
                    if (this.m_oTree != null) {
                        this.setCustomTreePath(this.m_oTree);
                        this.m_originalFolderID = this.m_oTree.getFQID();
                    } else if (this.m_softwareComp != null) {
                        this.setSoftwareComponentPath(this.m_softwareComp);
                    }
                }
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        catch (MdException mde) {
            MessageUtil.displayMetadataExceptionMessage(mde, "Accessing");
        }
    }

    public void setLocationFilterRepositoryID(String reposID) {
        this.m_resposIDFilter = reposID;
    }

    public String getLocationFilterRepositoryID() {
        return this.m_resposIDFilter;
    }

    protected ListSelectionListener createTableSelectionListener() {
        return new cTableSelectionListener();
    }

    protected TableModelListener createTableModelListener() {
        return new cTableModelListener();
    }

    protected WsPopupMenuRequestListener createTablePopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected WsPopupMenuRequestListener createViewportPopupMenuRequestListener() {
        return new cTablePopupMenuRequestListener();
    }

    protected void createActions() {
        if (this.m_bShowGroup) {
            this.m_actGroup = this.createSelectGroupAction();
        }
        if (this.m_bShowResponsibleParties) {
            this.m_actNew = this.createNewAction();
            this.m_actDelete = this.createDeleteAction();
        }
        if (this.m_bShowAbout) {
            this.m_btnAbout = WsUIUtilities.createTextButton(this.m_actAbout);
        }
    }

    protected void updateActions() {
        boolean bEditable = this.isEditable();
        if (this.m_bShowGroup) {
            this.m_actGroup.setEnabled(bEditable && this.m_bSelectFolderEnabled);
        }
        if (this.m_bShowResponsibleParties) {
            this.m_actNew.setEnabled(bEditable);
            this.m_actDelete.setEnabled(bEditable && this.m_tblResponsibleParties.getSelectedRowsFromSelectedCells().length > 0);
        }
    }

    protected WsAbstractAction createAboutAction() {
        return new cAboutAction();
    }

    protected WsAbstractAction createNewAction() {
        return new cNewAction();
    }

    protected WsAbstractAction createDeleteAction() {
        return new cDeleteAction();
    }

    protected WsAbstractAction createSelectGroupAction() {
        return new cSelectGroupAction();
    }

    private PathUrl getPath() {
        String sInitialPath = null;
        if (this.m_pathUrl != null) {
            sInitialPath = this.m_pathUrl.toString();
        }
        SimpleObjectImpl oSimple = null;
        try {
            if (this.m_oMetadata != null && this.m_oMetadata instanceof PrimaryType && !this.m_oMetadata.isNewObject()) {
                oSimple = new SimpleObjectImpl(this.m_oMetadata.getName(), this.m_oMetadata.getFQID(), this.m_oMetadata.getCMetadataType(), ((PrimaryType)this.m_oMetadata).getPublicType());
            }
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        SimpleObject[] aObjects = null;
        if (oSimple != null) {
            aObjects = new SimpleObject[]{oSimple};
        }
        if (this.m_bRootFolderSelectionEnabled) {
            return WsMetadataUtil.promptForPathUrl(sInitialPath, true, aObjects, this.m_resposIDFilter);
        }
        return WsMetadataUtil.promptForPathUrl(sInitialPath, false, aObjects, this.m_resposIDFilter);
    }

    class cTableSelectionListener
    implements ListSelectionListener {
        cTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            WAGeneralPanel.this.updateActions();
        }
    }

    class cTableModelListener
    implements TableModelListener {
        cTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (WAGeneralPanel.this.isListeningForChanges()) {
                WAGeneralPanel.this.setDataChanged(true);
            }
        }
    }

    public class cTablePopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        @Override
        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = new JPopupMenu();
            mnuPopup.add(new JMenuItem(WAGeneralPanel.this.m_actNew));
            mnuPopup.add(new JMenuItem(WAGeneralPanel.this.m_actDelete));
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    protected class cAboutAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cAboutAction() {
            super(bundle, "WAGeneralPanel.About");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WAGeneralPanel.this.onAbout();
        }
    }

    protected class cNewAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cNewAction() {
            super(bundle, "WAGeneralPanel.New", true);
            this.setMenuSupportId("new");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WAGeneralPanel.this.onNew();
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cDeleteAction() {
            super(bundle, "WAGeneralPanel.Delete", true);
            this.setMenuSupportId("delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WAGeneralPanel.this.onDelete();
        }
    }

    protected class cSelectGroupAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public cSelectGroupAction() {
            super(bundle, "WAGeneralPanel.SelectGroup");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                PathUrl pathurl = WAGeneralPanel.this.getPath();
                if (pathurl != null) {
                    WAGeneralPanel.this.m_pathUrl = pathurl;
                    WAGeneralPanel.this.m_txtGroup.setText(WAGeneralPanel.this.m_pathUrl.getDisplayPath());
                    MetadataInterface metadataObject = Workspace.getWorkspace().getInformationService().getObjectByPath(Workspace.getWorkspace().getUserContext(), WAGeneralPanel.this.m_pathUrl);
                    Root object = (Root)metadataObject.getRepositoryEntity();
                    if (object.getCMetadataType().equals("Tree")) {
                        WAGeneralPanel.this.m_oTree = (Tree)object;
                        WAGeneralPanel.this.m_softwareComp = null;
                    } else if (object.getCMetadataType().equals("SoftwareComponent")) {
                        WAGeneralPanel.this.m_softwareComp = (SoftwareComponent)object;
                        WAGeneralPanel.this.m_oTree = null;
                    }
                    WAGeneralPanel.this.setDataChanged(true);
                    WAGeneralPanel.this.m_bTreeChanged = true;
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            catch (ServiceException ex) {
                MessageUtil.displayServiceExceptionMessage(ex);
            }
        }
    }
}

