/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.plugins.PluginLoader;
import com.sas.workspace.AbstractDesigner;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Repository;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.plugins.MetadataExporterInterface;
import com.sas.workspace.plugins.MultipleNodeInterface;
import com.sas.workspace.visuals.MetadataImporter;
import com.sas.workspace.visuals.MetadataMIMBCheckBoxDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MetadataExporter
extends AbstractDesigner {
    private static final long serialVersionUID = 1L;
    public boolean m_noTypes;
    private static WAdminResource bundle = WAdminResource.getBundle(MetadataImporter.class);
    protected Repository m_repos;

    public MetadataExporter(Workspace workspace, String title, Repository repos) {
        this(workspace, title, repos, null);
    }

    public MetadataExporter(Workspace workspace, String title, CMetadata repos) {
        this(workspace, title, null, repos);
    }

    public MetadataExporter(Workspace workspace, CMetadata repos) {
        this(workspace, bundle.getString("MetadataExporter.Title.txt"), null, repos);
    }

    public MetadataExporter(Frame frame, String title) {
        super(frame, title);
        PluginLoader pluginLoader = Workspace.getWorkspace().getPluginLoader();
        pluginLoader.setParamTypes(null);
        ArrayList pluginDetails = pluginLoader.getPluginsDetailed("com.sas.workspace.plugins.MetadataExporterInterface");
        ArrayList plugins = pluginLoader.getValidPlugins(pluginDetails);
        ArrayList details = pluginLoader.getInvalidPlugins(pluginDetails);
        for (PluginLoader.PluginDetails detail : details) {
            if (!(detail.getException() instanceof NoClassDefFoundError)) continue;
            if (detail.getPluginName().equals("com.sas.CWMImport.MIExporter")) {
                boolean showMIMBwarning = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("MIMB.ShowWarning", true);
                if (!showMIMBwarning) continue;
                MetadataMIMBCheckBoxDialog m_ckbShowdlg = new MetadataMIMBCheckBoxDialog(Workspace.getWorkspace());
                m_ckbShowdlg.doShow(false);
                continue;
            }
            MessageUtil.displayMessage(bundle.formatString("MetadataCommon.PluginNotFound.txt", detail.getPluginName()), bundle.getString("MetadataCommon.NoClassDef.Title.txt"), 2);
        }
        if (plugins == null || plugins.size() <= 0) {
            MessageUtil.displayMessage(bundle.getString("MetadataExporter.NoTypesFound.txt"), bundle.getString("MetadataExporter.NoTypesFound.Title.txt"), 1);
            this.m_noTypes = true;
            return;
        }
        this.addWizardData("FINISHINFO", "");
        this.addWizardData("PARENT", this);
        this.m_wizardModel = new WATransitionWizardModel();
        this.setWizardModel(this.m_wizardModel);
        AbstractDesigner.cAbstractDesignerRootNode nodeRoot = new AbstractDesigner.cAbstractDesignerRootNode(bundle.getString("MetadataExporter.TreeTypes.RootNode.txt"), bundle.getString("MetadataExporter.TreeTypes.RootNode.txt"));
        this.m_treeModel = new AbstractDesigner.cAbstractDesignerTreeModel(nodeRoot);
        ImageIcon image = bundle.getImageIcon("MetadataExporter.SelectTab.image");
        this.addTab(bundle.getString("MetadataExporter.Title.txt"), "MetadataExporterSelectTab", new cSelectTab(bundle.getString("MetadataExporter.SelectTab.Title.txt"), "MetadataImporterSelectTab"), "wa_cwmexport_format.gif", image, false);
        ArrayList masterNameList = new ArrayList();
        for (int i = 0; i < plugins.size(); ++i) {
            MetadataExporterInterface plugin = (MetadataExporterInterface)plugins.get(i);
            plugin.setUseRepositoryPanel(false);
            if (!(plugin instanceof MultipleNodeInterface)) continue;
            MultipleNodeInterface inter = (MultipleNodeInterface)((Object)plugin);
            ArrayList m_displayNames = new ArrayList();
            m_displayNames = inter.getNames();
            Collections.sort(m_displayNames, Collator.getInstance());
            masterNameList.addAll(m_displayNames);
            for (int j = 0; j < m_displayNames.size(); ++j) {
                this.buildTree(this.m_treeModel, (String)m_displayNames.get(j), nodeRoot, plugin, false, true, j);
            }
        }
        if (masterNameList.size() == 0) {
            JOptionPane.showMessageDialog(Workspace.getWorkspace(), bundle.getString("MetadataExporter.NoTypesAvailable.txt"), bundle.getString("MetadataExporter.NoTypesAvailable.Title.txt"), 2);
            this.m_noTypes = true;
            return;
        }
        this.addWizardData("PLUGIN_NAMELIST", masterNameList);
        this.m_tree.expandPath(new TreePath(nodeRoot.getPath()));
        String[][] transitionList = new String[][]{{"MetadataExporterSelectTab", "NEXT", "temptab2"}};
        this.m_wizardModel.addTransitions(transitionList);
        this.m_tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu popMenu = new JPopupMenu();
                    JMenuItem menuItem = new JMenuItem(bundle.getString("Common.ShowDetail.txt"));
                    menuItem.setToolTipText(bundle.getString("Common.ShowDetail.ToolTip.txt"));
                    menuItem.setMnemonic(bundle.getString("Common.ShowDetail.mnem").charAt(0));
                    menuItem.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            Object nodetype = MetadataExporter.this.m_tree.getLastSelectedPathComponent();
                            String selectedNodeName = "";
                            if (nodetype instanceof AbstractDesigner.cAbstractDesignerPluginNode) {
                                AbstractDesigner.cAbstractDesignerPluginNode node = (AbstractDesigner.cAbstractDesignerPluginNode)nodetype;
                                MetadataExporterInterface plugin = (MetadataExporterInterface)node.getPlugin();
                                selectedNodeName = node.getNodeName();
                                String info = plugin.getInformation(selectedNodeName);
                                cGetInfoDialog infoBox = new cGetInfoDialog(info, selectedNodeName);
                                infoBox.setVisible(true);
                            } else {
                                MessageUtil.displayMessage(bundle.getString("MetadataCommon.ShowDetails.NoDetail.txt"), bundle.getString("MetadataExporter.Title.txt"), 1);
                            }
                        }
                    });
                    popMenu.add(menuItem);
                    JComponent source = (JComponent)e.getSource();
                    source.add(popMenu);
                    popMenu.show(source, e.getX(), e.getY());
                }
            }
        });
    }

    public MetadataExporter(Workspace workspace, String title, Repository repos, CMetadata cmRepos) {
        super((Frame)workspace, title);
        MetadataExporterInterface plugin;
        int i;
        CMetadata repository = null;
        if (repos != null) {
            try {
                repository = Workspace.getMdFactory().createSimpleMetadataObject(repos.getName(), "Environment", repos.getFQID());
                repository.setDesc(repos.getDesc());
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            this.m_repos = repos;
        } else {
            repository = cmRepos;
        }
        PluginLoader pluginLoader = workspace.getPluginLoader();
        pluginLoader.setParamTypes(null);
        ArrayList pluginDetails = pluginLoader.getPluginsDetailed("com.sas.workspace.plugins.MetadataExporterInterface");
        ArrayList plugins = pluginLoader.getValidPlugins(pluginDetails);
        ArrayList details = pluginLoader.getInvalidPlugins(pluginDetails);
        for (PluginLoader.PluginDetails detail : details) {
            if (!(detail.getException() instanceof NoClassDefFoundError)) continue;
            if (detail.getPluginName().equals("com.sas.CWMImport.MIExporter")) {
                boolean showMIMBwarning = Workspace.getWorkspace().getAppDefaultsFile().getPropertyBoolean("MIMB.ShowWarning", true);
                if (!showMIMBwarning) continue;
                MetadataMIMBCheckBoxDialog m_ckbShowdlg = new MetadataMIMBCheckBoxDialog(Workspace.getWorkspace());
                m_ckbShowdlg.doShow(false);
                continue;
            }
            MessageUtil.displayMessage(bundle.formatString("MetadataCommon.PluginNotFound.txt", detail.getPluginName()), bundle.getString("MetadataCommon.NoClassDef.Title.txt"), 2);
        }
        if (plugins == null || plugins.size() <= 0) {
            MessageUtil.displayMessage(bundle.getString("MetadataExporter.NoTypesFound.txt"), bundle.getString("MetadataExporter.NoTypesFound.Title.txt"), 1);
            this.m_noTypes = true;
            return;
        }
        this.addWizardData("REPOSITORY", repository);
        this.addWizardData("FINISHINFO", "");
        this.addWizardData("PARENT", this);
        this.m_wizardModel = new WATransitionWizardModel();
        this.setWizardModel(this.m_wizardModel);
        AbstractDesigner.cAbstractDesignerRootNode nodeRoot = new AbstractDesigner.cAbstractDesignerRootNode(bundle.getString("MetadataExporter.TreeTypes.RootNode.txt"), bundle.getString("MetadataExporter.TreeTypes.RootNode.txt"));
        this.m_treeModel = new AbstractDesigner.cAbstractDesignerTreeModel(nodeRoot);
        ImageIcon image = bundle.getImageIcon("MetadataExporter.SelectTab.image");
        this.addTab(bundle.getString("MetadataExporter.Title.txt"), "MetadataExporterSelectTab", new cSelectTab(bundle.getString("MetadataExporter.SelectTab.Title.txt"), "MetadataImporterSelectTab"), "wa_cwmexport_format.gif", image, false);
        ArrayList<String> masterNameList = new ArrayList<String>();
        for (i = 0; i < plugins.size(); ++i) {
            plugin = (MetadataExporterInterface)plugins.get(i);
            plugin.setUseRepositoryPanel(false);
            if (!(plugin instanceof MultipleNodeInterface)) continue;
            MultipleNodeInterface inter = (MultipleNodeInterface)((Object)plugin);
            ArrayList m_displayNames = new ArrayList();
            m_displayNames = inter.getNames();
            Collections.sort(m_displayNames, Collator.getInstance());
            masterNameList.addAll(m_displayNames);
            for (int j = 0; j < m_displayNames.size(); ++j) {
                this.buildTree(this.m_treeModel, (String)m_displayNames.get(j), nodeRoot, plugin, false, true, j);
            }
        }
        if (masterNameList.size() == 0) {
            for (i = 0; i < plugins.size(); ++i) {
                plugin = (MetadataExporterInterface)plugins.get(i);
                plugin.setUseRepositoryPanel(false);
                if (plugin instanceof MultipleNodeInterface) continue;
                String fixedName = plugin.getName();
                fixedName = fixedName.replace('.', ':');
                masterNameList.add(fixedName);
                this.buildTree(this.m_treeModel, plugin.getCategory(), nodeRoot, plugin, false, false);
            }
        }
        this.addWizardData("PLUGIN_NAMELIST", masterNameList);
        this.m_tree.expandPath(new TreePath(nodeRoot.getPath()));
        String[][] transitionList = new String[][]{{"MetadataExporterSelectTab", "NEXT", "temptab2"}};
        this.m_wizardModel.addTransitions(transitionList);
        this.m_tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu popMenu = new JPopupMenu();
                    JMenuItem menuItem = new JMenuItem(bundle.getString("Common.ShowDetail.txt"));
                    menuItem.setToolTipText(bundle.getString("Common.ShowDetail.ToolTip.txt"));
                    menuItem.setMnemonic(bundle.getString("Common.ShowDetail.mnem").charAt(0));
                    menuItem.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            Object nodetype = MetadataExporter.this.m_tree.getLastSelectedPathComponent();
                            String selectedNodeName = "";
                            if (nodetype instanceof AbstractDesigner.cAbstractDesignerPluginNode) {
                                AbstractDesigner.cAbstractDesignerPluginNode node = (AbstractDesigner.cAbstractDesignerPluginNode)nodetype;
                                MetadataExporterInterface plugin = (MetadataExporterInterface)node.getPlugin();
                                selectedNodeName = node.getNodeName();
                                String info = plugin.getInformation(selectedNodeName);
                                cGetInfoDialog infoBox = new cGetInfoDialog(info, selectedNodeName);
                                infoBox.setVisible(true);
                            } else {
                                MessageUtil.displayMessage(bundle.getString("MetadataCommon.ShowDetails.NoDetail.txt"), bundle.getString("MetadataExporter.Title.txt"), 1);
                            }
                        }
                    });
                    popMenu.add(menuItem);
                    JComponent source = (JComponent)e.getSource();
                    source.add(popMenu);
                    popMenu.show(source, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        this.getMainPanel().setPreferredSize(dimension);
    }

    protected class cSelectTab
    extends WsDescriptionWizardTab {
        private static final long serialVersionUID = 1L;
        protected String m_initialTab;

        public cSelectTab(String name, String initialTab) {
            super(name);
            this.m_initialTab = initialTab;
            this._initialize();
        }

        @Override
        public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
            return true;
        }

        public void _initialize() {
            this.setHelpProduct("export");
            this.setHelpTopic("exportwiz_1");
            MetadataExporter.this.m_tree = new AbstractDesigner.cAbstractDesignerTree(MetadataExporter.this.m_treeModel);
            MetadataExporter.this.m_tree.setToolTipText(bundle.getString("MetadataExporter.SelectType.ToolTip.txt"));
            JScrollPane treeScrollPane = new JScrollPane(MetadataExporter.this.m_tree);
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 12;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbl.setConstraints(treeScrollPane, gbc);
            this.add(treeScrollPane);
            JButton bntDet = new JButton(bundle.getString("Common.ShowDetail.txt"));
            bntDet.setMnemonic(bundle.getString("Common.ShowDetail.mnem").charAt(0));
            bntDet.setToolTipText(bundle.getString("Common.ShowDetail.ToolTip.txt"));
            bntDet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object nodetype = MetadataExporter.this.m_tree.getLastSelectedPathComponent();
                    if (nodetype instanceof AbstractDesigner.cAbstractDesignerPluginNode) {
                        AbstractDesigner.cAbstractDesignerPluginNode node = (AbstractDesigner.cAbstractDesignerPluginNode)nodetype;
                        MetadataExporterInterface plugin = (MetadataExporterInterface)node.getPlugin();
                        String selectedNodeName = node.getNodeName();
                        String info = plugin.getInformation(selectedNodeName);
                        cGetInfoDialog infoBox = new cGetInfoDialog(info, selectedNodeName);
                        infoBox.setVisible(true);
                    } else if (nodetype == null) {
                        MessageUtil.displayMessage(bundle.getString("MetadataExporter.ShowDetails.NotSelected.txt"), bundle.getString("MetadataExporter.Title.txt"), 1);
                    } else {
                        MessageUtil.displayMessage(bundle.getString("MetadataCommon.ShowDetails.NoDetail.txt"), bundle.getString("MetadataExporter.Title.txt"), 1);
                    }
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.anchor = 14;
            gbc.insets = new Insets(5, 5, 0, 0);
            gbl.setConstraints(bntDet, gbc);
            this.add(bntDet);
        }

        @Override
        public boolean validateData() {
            Object nodetype = MetadataExporter.this.m_tree.getLastSelectedPathComponent();
            if (nodetype instanceof AbstractDesigner.cAbstractDesignerPluginNode) {
                AbstractDesigner.cAbstractDesignerPluginNode node = (AbstractDesigner.cAbstractDesignerPluginNode)nodetype;
                MetadataExporterInterface plugin = (MetadataExporterInterface)node.getPlugin();
                this.setCursor(Cursor.getPredefinedCursor(3));
                MetadataExporter.this.m_wizardModel.removeTransition("MetadataExporterSelectTab", "NEXT");
                if (!MetadataExporter.this.m_wizardModel.isTransitionAlreadyAdded(plugin.getInitialTabName())) {
                    plugin.initializeWizard(MetadataExporter.this, MetadataExporter.this.m_wizardModel);
                    if (MetadataExporter.this.m_repos != null) {
                        plugin.setCMRHandle(MetadataExporter.this.m_repos.getOMIConnection());
                    }
                }
                MetadataExporter.this.replaceWizardData("PLUGIN", plugin);
                MetadataExporter.this.m_wizardModel.addTransition("MetadataExporterSelectTab", "NEXT", plugin.getInitialTabName());
                TreeNode parent = node.getParent();
                int index = parent.getIndex(node);
                MetadataExporter.this.replaceWizardData("NODEINDEX", new Integer(index));
                this.setCursor(null);
                return true;
            }
            MessageUtil.displayMessage(bundle.getString("MetadataExporter.Error.txt"), 0);
            return false;
        }
    }

    protected class cGetInfoDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected JPanel m_panel;
        protected JScrollPane m_scrollPane;
        protected JButton m_bOK;
        protected String m_info;
        protected String m_title;

        public cGetInfoDialog(String info, String title) {
            super(Workspace.getWorkspace(), bundle.getString("MetadataExporter.Title.txt"), true);
            this.setResizable(true);
            this.setDefaultCloseOperation(2);
            this.m_info = info;
            this.m_title = title;
            this.initialize();
            this.layoutWidgets();
            this.pack();
            this.center();
        }

        protected void initialize() {
            this.m_panel = new JPanel();
            this.m_panel.setPreferredSize(new Dimension(600, 375));
            this.m_bOK = new JButton(bundle.getString("Common.OK.txt"));
            this.m_bOK.addActionListener(this);
            this.m_scrollPane = new JScrollPane();
            this.m_scrollPane.setVerticalScrollBarPolicy(20);
            this.m_scrollPane.setBackground(SystemColor.control);
            this.m_scrollPane.getViewport().setBackground(SystemColor.control);
            this.m_scrollPane.setBorder(BorderFactory.createTitledBorder(null, this.m_title, 0, 0, null));
            this.m_scrollPane.setPreferredSize(new Dimension(590, 370));
            JTextArea text = new JTextArea(this.m_info);
            text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            text.setEditable(false);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            this.m_scrollPane.getViewport().add(text);
        }

        protected void layoutWidgets() {
            this.m_panel.setLayout(new GridBagLayout());
            this.m_panel.add((Component)this.m_scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
            this.m_panel.add((Component)this.m_bOK, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.setContentPane(this.m_panel);
        }

        private void center() {
            Dimension szDialog = this.getPreferredSize();
            Dimension szParent = this.getParent().getSize();
            Dimension szScreen = this.getToolkit().getScreenSize();
            Point ptParent = this.getParent().getLocation();
            int x = ptParent.x + (szParent.width - szDialog.width) / 2;
            int y = ptParent.y + (szParent.height - szDialog.height) / 2;
            x = Math.max(0, Math.min(x, szScreen.width - szDialog.width));
            y = Math.max(0, Math.min(y, szScreen.height - szDialog.height));
            this.setLocation(x, y);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.m_bOK) {
                this.dispose();
            }
        }
    }
}

