/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class GroupSelectorDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(GroupSelectorDialog.class);
    protected cTreePanel m_pnlTree;
    protected MdStore m_store;
    protected ArrayList m_arSelNodes;

    public GroupSelectorDialog() {
        super(Workspace.getWorkspace(), bundle.getString("GroupSelectorDialog.Title.txt"), true);
        this.setHelpProduct("wdb");
        this.setHelpTopic("select_group_win");
        this.m_pnlTree = new cTreePanel();
        this.setMainPanel(this.m_pnlTree);
    }

    public GroupSelectorDialog(CMetadata oMetadata) {
        this();
        this.m_arSelNodes = new ArrayList();
        this.m_arSelNodes.add(oMetadata);
    }

    public GroupSelectorDialog(Root[] aObjects) {
        this();
        this.m_arSelNodes = new ArrayList(aObjects.length);
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            this.m_arSelNodes.add(aObjects[iObject]);
        }
    }

    public GroupSelectorDialog(WsTreeNode[] selNodes) {
        this();
        this.m_arSelNodes = new ArrayList(selNodes.length);
        for (int iNode = 0; iNode < selNodes.length; ++iNode) {
            this.m_arSelNodes.add(selNodes[iNode].getMetadata());
        }
    }

    public void setSelectedTree(Tree oTree) {
        this.m_pnlTree.setSelectedTree(oTree);
    }

    public Tree getSelectedTree() {
        return this.m_pnlTree.getSelectedTree();
    }

    public void setStore(MdStore store) {
        this.m_store = store;
    }

    public void setRepository(String sRepository) {
        this.m_pnlTree.setRepository(sRepository);
    }

    @Override
    public void show() {
        this.m_pnlTree.initializeTree();
        super.show();
    }

    protected class cTreePanel
    extends WAPanel {
        private static final long serialVersionUID = 1L;
        private WorkspaceTree m_treeBrowse;
        private JScrollPane m_scrBrowse;
        private Tree m_oTree;

        public cTreePanel() {
            this.initialize();
            this.layoutWidgets();
        }

        protected void setSelectedTree(Tree tree) {
            this.m_oTree = tree;
        }

        protected void setRepository(String sRepository) {
            Vector<CMetadata> vRepository = new Vector<CMetadata>(1);
            List lRepositories = Workspace.getWorkspace().getSelectedRepositories();
            for (int iRepository = 0; iRepository < lRepositories.size(); ++iRepository) {
                CMetadata oRepository = (CMetadata)lRepositories.get(iRepository);
                try {
                    String sFQID = oRepository.getFQID();
                    if (!sRepository.equals(sFQID.substring(9, 17))) continue;
                    vRepository.add(oRepository);
                    break;
                }
                catch (RemoteException ex) {
                    Workspace.handleRemoteException(ex);
                }
            }
            if (vRepository.size() == 1) {
                this.m_treeBrowse.setVectorOfRepositories(vRepository);
            }
        }

        protected void initializeTree() {
            this.m_treeBrowse.initialize();
            this.m_treeBrowse.setListenForChanges(false);
            if (this.m_oTree != null) {
                try {
                    this.m_treeBrowse.setSelectedData((Root)this.m_oTree);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage(ex, "Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException(re);
                }
            }
            this.setDataChanged(false);
        }

        @Override
        protected void initialize() {
            this.m_treeBrowse = Workspace.getWorkspace().getBrowseTree();
            this.m_treeBrowse.setEditable(false);
            this.m_treeBrowse.setPopupMenusEnabled(false);
            this.m_treeBrowse.setAddingMemberNodes(false);
            this.m_treeBrowse.getSelectionModel().setSelectionMode(1);
            this.m_scrBrowse = new JScrollPane(this.m_treeBrowse);
            this.m_scrBrowse.setPreferredSize(new Dimension(300, 300));
            this.m_treeBrowse.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    cTreePanel.this.setDataChanged(true);
                }
            });
        }

        @Override
        protected void layoutWidgets() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_scrBrowse, "Center");
        }

        @Override
        public boolean doDataExchange(boolean bSaveToModel) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateData() {
            String sErrorMessage;
            block14: {
                sErrorMessage = null;
                WsTreeNode nodeTree = this.m_treeBrowse.getSelectedNode();
                if (nodeTree == null) {
                    sErrorMessage = bundle.getString("GroupSelectorDialog.NoGroupError.txt");
                } else if (nodeTree instanceof WsDataTreeNode) {
                    CMetadata oObject = ((WsDataTreeNode)nodeTree).getMetadata();
                    try {
                        if (oObject.getCMetadataType().equals("Tree")) {
                            if (GroupSelectorDialog.this.m_arSelNodes == null) break block14;
                            MdObjectStore store = Workspace.getMdFactory().createObjectStore();
                            try {
                                Tree oTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, null, oObject.getName(), oObject.getCMetadataType(), oObject.getId());
                                for (int i = 0; i < GroupSelectorDialog.this.m_arSelNodes.size(); ++i) {
                                    Root mdo = (Root)GroupSelectorDialog.this.m_arSelNodes.get(i);
                                    if (mdo.getFQID().equals(oTree.getFQID())) {
                                        sErrorMessage = bundle.getString("GroupSelectorDialog.SameNodeError.txt");
                                    }
                                    if (!mdo.getCMetadataType().equals("Tree")) continue;
                                    ArrayList lParents = this.m_treeBrowse.getAncestorTrees(oTree);
                                    for (int iParent = 0; iParent < lParents.size(); ++iParent) {
                                        Tree oParentTree = (Tree)lParents.get(iParent);
                                        if (!oParentTree.getFQID().equals(mdo.getFQID())) continue;
                                        sErrorMessage = bundle.getString("GroupSelectorDialog.ChildGroupError.txt");
                                    }
                                }
                                break block14;
                            }
                            finally {
                                store.dispose();
                            }
                        }
                        sErrorMessage = bundle.getString("GroupSelectorDialog.InvalidGroupError.txt");
                    }
                    catch (RemoteException ex) {
                        Workspace.handleRemoteException(ex);
                    }
                } else {
                    sErrorMessage = bundle.getString("GroupSelectorDialog.InvalidGroupError.txt");
                }
            }
            if (sErrorMessage != null) {
                MessageUtil.displayMessage(sErrorMessage, bundle.getString("GroupSelectorDialog.Title.txt"), 0);
                return false;
            }
            return true;
        }

        public Tree getSelectedTree() {
            CMetadata oTree = this.m_treeBrowse.getSelectedNode().getMetadata();
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            Tree tree = null;
            try {
                tree = (Tree)factory.createComplexMetadataObject((MdObjectStore)GroupSelectorDialog.this.m_store, oTree);
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException(ex);
            }
            return tree;
        }
    }
}

