/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WorkspaceTreeModel;
import com.sas.workspace.WsDataTreeNode;
import com.sas.workspace.WsTreeNode;
import com.sas.workspace.WsUIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

public class GroupPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(GroupPanel.class);
    private Tree m_groupTree;
    private CMetadata m_repository;
    private boolean m_onBack;
    protected WorkspaceTree m_treeBrowse;

    public GroupPanel() {
        this.initialize();
        this.layoutComponents();
    }

    @Override
    protected void initialize() {
        this.initializeGroupTree();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateData() {
        try {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            MdObjectStore store = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
            boolean bNewFolderWizard = myParent.getWizardData("NEWFOLDERWIZARD") != null;
            WsTreeNode nodeTree = this.m_treeBrowse.getSelectedNode();
            if (!(nodeTree instanceof WsDataTreeNode)) {
                MessageUtil.displayMessage(bundle.getString("GroupPanel.Error.NoFolderSelected.txt"), 0);
                this.m_treeBrowse.requestFocus();
                this.m_groupTree = null;
                return false;
            }
            CMetadata oObject = ((WsDataTreeNode)nodeTree).getMetadata();
            if (oObject.getCMetadataType().equals("Tree")) {
                this.m_groupTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, null, oObject.getName(), oObject.getCMetadataType(), oObject.getId());
                return true;
            }
            if (oObject.getCMetadataType().equals("Environment") && bNewFolderWizard) {
                this.m_groupTree = null;
                return true;
            }
            MessageUtil.displayMessage(bundle.getString("GroupPanel.Error.NoFolderSelected.txt"), 0);
            this.m_treeBrowse.requestFocus();
            this.m_groupTree = null;
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
            return false;
        }
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else if (!this.m_onBack) {
            this.populateStore();
            this.moveDataToView();
        }
        return true;
    }

    @Override
    public void populateStore() throws MdException {
    }

    @Override
    public void moveDataToView() throws MdException, RemoteException {
        String strDefaultID2;
        WorkspaceTreeModel treeModel = (WorkspaceTreeModel)this.m_treeBrowse.getModel();
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        this.m_groupTree = (Tree)myParent.getWizardData("GROUP");
        if (this.m_groupTree == null && (strDefaultID2 = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("LastSelectedTreeIDGroupPanel")).length() != 0) {
            MdObjectStore store = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
            this.m_groupTree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(store, "", "Tree", strDefaultID2);
        }
        if (this.m_groupTree != null) {
            try {
                this.m_treeBrowse.setSelectedData((Root)this.m_groupTree);
            }
            catch (MdException strDefaultID2) {}
        } else {
            ArrayList alist = treeModel.findNodes(this.m_repository);
            if (alist.size() > 0) {
                WsTreeNode selectNode = (WsTreeNode)alist.get(0);
                TreePath path = new TreePath(selectNode.getPath());
                this.m_treeBrowse.expandPath(path);
                this.m_treeBrowse.setSelectionPath(path);
            }
        }
    }

    @Override
    public void moveDataToStore() throws MdException, RemoteException {
        CMetadata cm;
        WsTreeNode treeNode = this.m_treeBrowse.getSelectedNode();
        if (treeNode != null && (cm = treeNode.getMetadata()) != null) {
            String nodeID = cm.getFQID();
            Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("LastSelectedTreeIDGroupPanel", nodeID);
        }
    }

    public void setOnBack(boolean back) {
        this.m_onBack = back;
    }

    public Tree getSelectedGroup() {
        return this.m_groupTree;
    }

    private void initializeGroupTree() {
        try {
            this.m_treeBrowse = Workspace.getWorkspace().getBrowseTree();
            Vector<CMetadata> vRepository = new Vector<CMetadata>(1);
            CMetadata foundationRepos = Workspace.getMdFactory().getOMIUtil().getFoundationRepository();
            vRepository.add(foundationRepos);
            this.m_treeBrowse.setVectorOfRepositories(vRepository);
            this.m_treeBrowse.initialize();
            this.m_treeBrowse.setEditable(false);
            this.m_treeBrowse.setPopupMenusEnabled(false);
            this.m_treeBrowse.setAddingMemberNodes(false);
            this.m_treeBrowse.getSelectionModel().setSelectionMode(1);
            this.m_treeBrowse.setListenForChanges(false);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
        }
    }

    protected void layoutComponents() {
        JLabel lblTree = WsUIUtilities.createLabelForComponent(this.m_treeBrowse, bundle.getString("GroupPanel.GroupParent.txt"));
        JScrollPane scrTree = new JScrollPane(this.m_treeBrowse);
        scrTree.setPreferredSize(new Dimension(200, 150));
        this.setLayout(new GridBagLayout());
        this.add((Component)lblTree, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)scrTree, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }
}

