/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.workspace.AppServer;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import com.sas.workspace.visuals.AppServerPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;

public class AppServerTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    AppServerPanel m_appPanel;
    AppServer m_appServer;
    private static WAdminResource bundle = WAdminResource.getBundle(AppServerTab.class);

    public AppServerTab() {
        super(bundle.getString("AppServerTab.Description.Simple.txt"));
        this._initialize();
    }

    @Override
    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        if (!bSaveToModel) {
            WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
            MdObjectStore myStore = (MdObjectStore)myParent.getWizardData("OBJECTSTORE");
            this.m_appServer.setStore(myStore);
            this.m_appPanel.doDataExchange(bSaveToModel);
        } else {
            boolean fChanges = this.m_appPanel.getChangeState();
            if (fChanges) {
                WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
                myParent.setMasterObject((CMetadata)this.m_appServer.getServerContext());
            }
        }
        return true;
    }

    public void _initialize() {
        this.m_appServer = new AppServer();
        this.m_appPanel = new AppServerPanel(this.m_appServer, false, false);
        this.m_appPanel.setWrite(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_appPanel, new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.setHelpTopic(this.m_appPanel.getHelpTopic());
    }

    public boolean validateDefaultServer() {
        if (Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("AppServer.Default").equals("")) {
            return false;
        }
        this.m_appPanel.setShowMessageBoxes(false);
        try {
            this.doDataExchange(false);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        boolean fValue = this.validateData();
        this.m_appPanel.setShowMessageBoxes(true);
        if (fValue) {
            this.saveSettingsAndCleanUp();
        }
        return fValue;
    }

    public void wizardSetupAppServer() {
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        myParent.addWizardData("AppServer", this.m_appServer);
    }

    @Override
    public boolean validateData() {
        boolean fDataOK = this.m_appPanel.validateData();
        if (fDataOK) {
            fDataOK = this.m_appPanel.test();
        }
        return fDataOK;
    }

    @Override
    public void onNext() {
        super.onNext();
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        myParent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.m_appPanel.doDataExchange(true);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        myParent.setCursor(null);
        myParent.addWizardData("AppServer", this.m_appServer);
    }

    @Override
    public void onBack() {
        super.onBack();
        WAWizardDialog myParent = (WAWizardDialog)this.getTopLevelAncestor();
        myParent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.m_appPanel.doDataExchange(false);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage(e, "Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException(re);
        }
        myParent.setCursor(null);
        myParent.removeWizardData("AppServer");
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_appPanel.saveSettingsAndCleanUp();
    }
}

